/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public class JetScopeSelectorUtil {
    public static final ScopeByNameSelector<ClassifierDescriptor> CLASSIFIER_DESCRIPTOR_SCOPE_SELECTOR = new ScopeByNameSelector<ClassifierDescriptor>(){

        @Override
        @Nullable
        public ClassifierDescriptor get(@NotNull JetScope scope, @NotNull Name name) {
            return scope.getClassifier(name);
        }
    };
    public static final ScopeByNameSelector<ClassDescriptor> NAMED_OBJECT_SCOPE_SELECTOR = new ScopeByNameSelector<ClassDescriptor>(){

        @Override
        @Nullable
        public ClassDescriptor get(@NotNull JetScope scope, @NotNull Name name) {
            return scope.getObjectDescriptor(name);
        }
    };
    public static final ScopeByNameSelector<NamespaceDescriptor> NAMESPACE_SCOPE_SELECTOR = new ScopeByNameSelector<NamespaceDescriptor>(){

        @Override
        @Nullable
        public NamespaceDescriptor get(@NotNull JetScope scope, @NotNull Name name) {
            return scope.getNamespace(name);
        }
    };
    public static final ScopeByNameMultiSelector<FunctionDescriptor> NAMED_FUNCTION_SCOPE_SELECTOR = new ScopeByNameMultiSelector<FunctionDescriptor>(){

        @Override
        @NotNull
        public Collection<FunctionDescriptor> get(@NotNull JetScope scope, @NotNull Name name) {
            return scope.getFunctions(name);
        }
    };
    public static final ScopeByNameMultiSelector<VariableDescriptor> NAMED_PROPERTIES_SCOPE_SELECTOR = new ScopeByNameMultiSelector<VariableDescriptor>(){

        @Override
        @NotNull
        public Collection<VariableDescriptor> get(@NotNull JetScope scope, @NotNull Name name) {
            return scope.getProperties(name);
        }
    };
    public static final ScopeDescriptorSelector<ClassDescriptor> OBJECTS_SCOPE_SELECTOR = new ScopeDescriptorSelector<ClassDescriptor>(){

        @Override
        @NotNull
        public Collection<ClassDescriptor> get(@NotNull JetScope scope) {
            return scope.getObjectDescriptors();
        }
    };
    public static final ScopeDescriptorSelector<DeclarationDescriptor> ALL_DESCRIPTORS_SCOPE_SELECTOR = new ScopeDescriptorSelector<DeclarationDescriptor>(){

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> get(@NotNull JetScope scope) {
            return scope.getAllDescriptors();
        }
    };

    private JetScopeSelectorUtil() {
    }

    @NotNull
    public static <D extends DeclarationDescriptor> Collection<D> collect(Collection<JetScope> scopes, ScopeByNameMultiSelector<D> selector, Name name) {
        HashSet<D> descriptors = Sets.newHashSet();
        for (JetScope scope : scopes) {
            descriptors.addAll(selector.get(scope, name));
        }
        return descriptors;
    }

    @NotNull
    public static <D extends DeclarationDescriptor> Collection<D> collect(Collection<JetScope> scopes, ScopeDescriptorSelector<D> selector) {
        HashSet<D> descriptors = Sets.newHashSet();
        for (JetScope scope : scopes) {
            descriptors.addAll(selector.get(scope));
        }
        return descriptors;
    }

    public static interface ScopeDescriptorSelector<D extends DeclarationDescriptor> {
        @NotNull
        public Collection<D> get(JetScope var1);
    }

    public static interface ScopeByNameMultiSelector<D extends DeclarationDescriptor> {
        @NotNull
        public Collection<D> get(JetScope var1, Name var2);
    }

    public static interface ScopeByNameSelector<D extends DeclarationDescriptor> {
        @Nullable
        public D get(@NotNull JetScope var1, @NotNull Name var2);
    }
}

