/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public class ChainedScope
implements JetScope {
    private final DeclarationDescriptor containingDeclaration;
    private final String debugName;
    private final JetScope[] scopeChain;
    private Collection<DeclarationDescriptor> allDescriptors;
    private List<ReceiverParameterDescriptor> implicitReceiverHierarchy;

    public ChainedScope(DeclarationDescriptor containingDeclaration, JetScope ... scopes) {
        this(containingDeclaration, "Untitled chained scope", scopes);
    }

    public ChainedScope(DeclarationDescriptor containingDeclaration, String debugName, JetScope ... scopes) {
        this.containingDeclaration = containingDeclaration;
        this.scopeChain = (JetScope[])scopes.clone();
        this.debugName = debugName;
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        for (JetScope scope : this.scopeChain) {
            ClassifierDescriptor classifier = scope.getClassifier(name);
            if (classifier == null) continue;
            return classifier;
        }
        return null;
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
        for (JetScope scope : this.scopeChain) {
            ClassDescriptor objectDescriptor = scope.getObjectDescriptor(name);
            if (objectDescriptor == null) continue;
            return objectDescriptor;
        }
        return null;
    }

    @NotNull
    public Set<ClassDescriptor> getObjectDescriptors() {
        HashSet<ClassDescriptor> objectDescriptors = Sets.newHashSet();
        for (JetScope scope : this.scopeChain) {
            objectDescriptors.addAll(scope.getObjectDescriptors());
        }
        return objectDescriptors;
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        for (JetScope jetScope : this.scopeChain) {
            NamespaceDescriptor namespace = jetScope.getNamespace(name);
            if (namespace == null) continue;
            return namespace;
        }
        return null;
    }

    @NotNull
    public Set<VariableDescriptor> getProperties(@NotNull Name name) {
        LinkedHashSet<VariableDescriptor> properties = Sets.newLinkedHashSet();
        for (JetScope jetScope : this.scopeChain) {
            properties.addAll(jetScope.getProperties(name));
        }
        return properties;
    }

    @Override
    public VariableDescriptor getLocalVariable(@NotNull Name name) {
        for (JetScope jetScope : this.scopeChain) {
            VariableDescriptor variable = jetScope.getLocalVariable(name);
            if (variable == null) continue;
            return variable;
        }
        return null;
    }

    @NotNull
    public Set<FunctionDescriptor> getFunctions(@NotNull Name name) {
        if (this.scopeChain.length == 0) {
            return Collections.emptySet();
        }
        LinkedHashSet<FunctionDescriptor> result = Sets.newLinkedHashSet();
        for (JetScope jetScope : this.scopeChain) {
            result.addAll(jetScope.getFunctions(name));
        }
        return result;
    }

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        if (this.implicitReceiverHierarchy == null) {
            this.implicitReceiverHierarchy = Lists.newArrayList();
            for (JetScope jetScope : this.scopeChain) {
                this.implicitReceiverHierarchy.addAll(jetScope.getImplicitReceiversHierarchy());
            }
        }
        return this.implicitReceiverHierarchy;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.containingDeclaration;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull LabelName labelName) {
        for (JetScope jetScope : this.scopeChain) {
            Collection<DeclarationDescriptor> declarationsByLabel = jetScope.getDeclarationsByLabel(labelName);
            if (declarationsByLabel.isEmpty()) continue;
            return declarationsByLabel;
        }
        return Collections.emptyList();
    }

    @Override
    public PropertyDescriptor getPropertyByFieldReference(@NotNull Name fieldName) {
        for (JetScope jetScope : this.scopeChain) {
            PropertyDescriptor propertyByFieldReference = jetScope.getPropertyByFieldReference(fieldName);
            if (propertyByFieldReference == null) continue;
            return propertyByFieldReference;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        if (this.allDescriptors == null) {
            this.allDescriptors = Sets.newHashSet();
            for (JetScope scope : this.scopeChain) {
                this.allDescriptors.addAll(scope.getAllDescriptors());
            }
        }
        return this.allDescriptors;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.debugName;
    }
}

