/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.name.Name;

class ImportsProvider {
    private final List<JetImportDirective> importDirectives;
    private ListMultimap<Name, JetImportDirective> nameToDirectives = null;
    private List<JetImportDirective> allUnderImports = null;
    private boolean indexed;

    public ImportsProvider(List<JetImportDirective> importDirectives) {
        this.importDirectives = importDirectives;
    }

    @NotNull
    public List<JetImportDirective> getImports(@NotNull Name name) {
        this.createIndex();
        return this.nameToDirectives.containsKey(name) ? this.nameToDirectives.get(name) : this.allUnderImports;
    }

    @NotNull
    public List<JetImportDirective> getAllImports() {
        return this.importDirectives;
    }

    private void createIndex() {
        if (this.indexed) {
            return;
        }
        ImmutableListMultimap.Builder namesToRelativeImportsBuilder = ImmutableListMultimap.builder();
        HashSet<Name> processedAliases = Sets.newHashSet();
        ArrayList<JetImportDirective> processedAllUnderImports = Lists.newArrayList();
        for (JetImportDirective anImport : this.importDirectives) {
            ImportPath path = JetPsiUtil.getImportPath(anImport);
            if (path == null) continue;
            if (path.isAllUnder()) {
                processedAllUnderImports.add(anImport);
                for (Name aliasName : processedAliases) {
                    namesToRelativeImportsBuilder.put(aliasName, anImport);
                }
                continue;
            }
            Name aliasName = path.getImportedName();
            assert (aliasName != null);
            if (!processedAliases.contains(aliasName)) {
                processedAliases.add(aliasName);
                namesToRelativeImportsBuilder.putAll(aliasName, processedAllUnderImports);
            }
            namesToRelativeImportsBuilder.put(aliasName, anImport);
        }
        this.allUnderImports = ImmutableList.copyOf(processedAllUnderImports);
        this.nameToDirectives = namesToRelativeImportsBuilder.build();
        this.indexed = true;
    }
}

