/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RawTypesCheck {
    private static boolean isPartiallyRawType(@NotNull PsiType type) {
        return type.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visitPrimitiveType(PsiPrimitiveType primitiveType) {
                return false;
            }

            @Override
            @Nullable
            public Boolean visitClassType(PsiClassType classType) {
                if (classType.isRaw()) {
                    return true;
                }
                for (PsiType argument : classType.getParameters()) {
                    if (!argument.accept(this).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return arrayType.getComponentType().accept(this);
            }

            @Override
            @Nullable
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                return bound == null ? false : bound.accept(this);
            }

            @Override
            @Nullable
            public Boolean visitType(PsiType type) {
                throw new IllegalStateException(type.getClass().getSimpleName() + " is unexpected");
            }
        });
    }

    private static boolean hasRawTypesInSignature(@NotNull PsiMethod method) {
        PsiType returnType = method.getReturnType();
        if (returnType != null && RawTypesCheck.isPartiallyRawType(returnType)) {
            return true;
        }
        for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
            if (!RawTypesCheck.isPartiallyRawType(psiParameter.getType())) continue;
            return true;
        }
        for (PsiModifierListOwner psiModifierListOwner : method.getTypeParameters()) {
            for (PsiClassType upperBound : psiModifierListOwner.getExtendsList().getReferencedTypes()) {
                if (!RawTypesCheck.isPartiallyRawType(upperBound)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean hasRawTypesInHierarchicalSignature(@NotNull PsiMethod method) {
        if (method.hasModifierProperty("static")) {
            return false;
        }
        if (RawTypesCheck.hasRawTypesInSignature(method)) {
            return true;
        }
        for (HierarchicalMethodSignature superSignature : method.getHierarchicalMethodSignature().getSuperSignatures()) {
            PsiMethod superMethod = superSignature.getMethod();
            if (!superSignature.isRaw() && !RawTypesCheck.typeParameterIsErased(method, superMethod) && !RawTypesCheck.hasRawTypesInSignature(superMethod)) continue;
            return true;
        }
        return false;
    }

    private static boolean typeParameterIsErased(@NotNull PsiMethod a, @NotNull PsiMethod b) {
        return a.getTypeParameters().length != b.getTypeParameters().length;
    }

    private RawTypesCheck() {
    }
}

