/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.intellij.psi.PsiClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.kt.JetClassObjectAnnotation;
import org.jetbrains.jet.lang.resolve.java.provider.ClassPsiDeclarationProvider;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaClassResolver;
import org.jetbrains.jet.lang.resolve.name.FqName;

public final class JavaInnerClassResolver {
    private JavaClassResolver classResolver;

    public void setClassResolver(JavaClassResolver classResolver) {
        this.classResolver = classResolver;
    }

    @NotNull
    public List<ClassDescriptor> resolveInnerClasses(@NotNull ClassPsiDeclarationProvider declarationProvider) {
        if (declarationProvider.isStaticMembers()) {
            return Collections.emptyList();
        }
        return this.resolveInnerClasses(declarationProvider.getPsiClass());
    }

    @NotNull
    private List<ClassDescriptor> resolveInnerClasses(@NotNull PsiClass psiClass) {
        PsiClass[] innerPsiClasses = psiClass.getInnerClasses();
        ArrayList<ClassDescriptor> result = new ArrayList<ClassDescriptor>(innerPsiClasses.length);
        for (PsiClass innerPsiClass : innerPsiClasses) {
            if (JavaInnerClassResolver.shouldBeIgnored(innerPsiClass)) continue;
            ClassDescriptor classDescriptor = this.resolveInnerClass(innerPsiClass);
            result.add(classDescriptor);
        }
        return result;
    }

    private static boolean shouldBeIgnored(PsiClass innerPsiClass) {
        return JetClassObjectAnnotation.get(innerPsiClass).isDefined();
    }

    @NotNull
    private ClassDescriptor resolveInnerClass(@NotNull PsiClass innerPsiClass) {
        String name = innerPsiClass.getQualifiedName();
        assert (name != null) : "Inner class has no qualified name";
        ClassDescriptor classDescriptor = this.classResolver.resolveClass(new FqName(name), DescriptorSearchRule.IGNORE_IF_FOUND_IN_KOTLIN);
        assert (classDescriptor != null) : "Couldn't resolve class " + name;
        return classDescriptor;
    }
}

