/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.autocasts;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.autocasts.AutoCastReceiver;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValue;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValueFactory;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValueVisitor;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ScriptReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ThisReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.jet.lang.types.JetType;

public class AutoCastUtils {
    private AutoCastUtils() {
    }

    public static List<ReceiverValue> getAutoCastVariants(final @NotNull BindingContext bindingContext, final @NotNull DataFlowInfo dataFlowInfo, @NotNull ReceiverValue receiverToCast) {
        return receiverToCast.accept(new ReceiverValueVisitor<List<ReceiverValue>, Object>(){

            @Override
            public List<ReceiverValue> visitNoReceiver(ReceiverValue noReceiver, Object data) {
                return Collections.emptyList();
            }

            @Override
            public List<ReceiverValue> visitTransientReceiver(TransientReceiver receiver, Object data) {
                return Collections.emptyList();
            }

            @Override
            public List<ReceiverValue> visitExtensionReceiver(ExtensionReceiver receiver, Object data) {
                return AutoCastUtils.castThis(dataFlowInfo, receiver);
            }

            @Override
            public List<ReceiverValue> visitClassReceiver(ClassReceiver receiver, Object data) {
                return AutoCastUtils.castThis(dataFlowInfo, receiver);
            }

            @Override
            public List<ReceiverValue> visitScriptReceiver(ScriptReceiver receiver, Object data) {
                return Collections.emptyList();
            }

            @Override
            public List<ReceiverValue> visitExpressionReceiver(ExpressionReceiver receiver, Object data) {
                DataFlowValue dataFlowValue = DataFlowValueFactory.INSTANCE.createDataFlowValue(receiver.getExpression(), receiver.getType(), bindingContext);
                ArrayList<ReceiverValue> result = Lists.newArrayList();
                for (JetType possibleType : dataFlowInfo.getPossibleTypes(dataFlowValue)) {
                    result.add(new AutoCastReceiver(receiver, possibleType, dataFlowValue.isStableIdentifier()));
                }
                return result;
            }
        }, null);
    }

    private static List<ReceiverValue> castThis(@NotNull DataFlowInfo dataFlowInfo, @NotNull ThisReceiver receiver) {
        assert (receiver.exists());
        ArrayList<ReceiverValue> result = Lists.newArrayList();
        for (JetType possibleType : dataFlowInfo.getPossibleTypes(DataFlowValueFactory.INSTANCE.createDataFlowValue(receiver))) {
            result.add(new AutoCastReceiver(receiver, possibleType, true));
        }
        return result;
    }

    public static void recordAutoCastIfNecessary(ReceiverValue receiver, @NotNull BindingTrace trace) {
        if (receiver instanceof AutoCastReceiver) {
            AutoCastReceiver autoCastReceiver = (AutoCastReceiver)receiver;
            ReceiverValue original = autoCastReceiver.getOriginal();
            if (original instanceof ExpressionReceiver) {
                ExpressionReceiver expressionReceiver = (ExpressionReceiver)original;
                if (autoCastReceiver.canCast()) {
                    trace.record(BindingContext.AUTOCAST, expressionReceiver.getExpression(), autoCastReceiver.getType());
                    trace.record(BindingContext.EXPRESSION_TYPE, expressionReceiver.getExpression(), autoCastReceiver.getType());
                } else {
                    trace.report(Errors.AUTOCAST_IMPOSSIBLE.on(expressionReceiver.getExpression(), autoCastReceiver.getType(), expressionReceiver.getExpression().getText()));
                }
            } else assert (autoCastReceiver.canCast()) : "A non-expression receiver must always be autocastabe: " + original;
        }
    }
}

