/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.impl.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.CallKey;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetProjectionKind;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.ObservableBindingTrace;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.CallTransformer;
import org.jetbrains.jet.lang.resolve.calls.ValueArgumentsToParametersMapper;
import org.jetbrains.jet.lang.resolve.calls.autocasts.AutoCastServiceImpl;
import org.jetbrains.jet.lang.resolve.calls.autocasts.AutoCastUtils;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValue;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValueFactory;
import org.jetbrains.jet.lang.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.jet.lang.resolve.calls.context.ResolveMode;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemWithPriorities;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.jet.lang.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.results.ResolutionDebugInfo;
import org.jetbrains.jet.lang.resolve.calls.results.ResolutionStatus;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionTask;
import org.jetbrains.jet.lang.resolve.calls.tasks.TaskPrioritizer;
import org.jetbrains.jet.lang.resolve.calls.util.ExpressionAsFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class CandidateResolver {
    @NotNull
    private ArgumentTypeResolver argumentTypeResolver;

    public void setArgumentTypeResolver(@NotNull ArgumentTypeResolver argumentTypeResolver) {
        this.argumentTypeResolver = argumentTypeResolver;
    }

    public <D extends CallableDescriptor, F extends D> void performResolutionForCandidateCall(@NotNull CallCandidateResolutionContext<D> context, @NotNull ResolutionTask<D, F> task) {
        List<JetTypeProjection> jetTypeArguments;
        LinkedHashSet<ValueArgument> unmappedArguments;
        ValueArgumentsToParametersMapper.Status argumentMappingStatus;
        ProgressIndicatorProvider.checkCanceled();
        ResolvedCallImpl candidateCall = context.candidateCall;
        Object candidate = candidateCall.getCandidateDescriptor();
        candidateCall.addStatus(CandidateResolver.checkReceiverTypeError(context.candidateCall));
        if (ErrorUtils.isError(candidate)) {
            candidateCall.addStatus(ResolutionStatus.SUCCESS);
            this.argumentTypeResolver.checkTypesWithNoCallee(context.toBasic());
            return;
        }
        if (!CandidateResolver.checkOuterClassMemberIsAccessible(context)) {
            candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            return;
        }
        DeclarationDescriptorWithVisibility invisibleMember = Visibilities.findInvisibleMember(candidate, context.scope.getContainingDeclaration());
        if (invisibleMember != null) {
            candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            context.tracing.invisibleMember(context.trace, invisibleMember);
            return;
        }
        if (task.checkArguments == CheckValueArgumentsMode.ENABLED && !(argumentMappingStatus = ValueArgumentsToParametersMapper.mapValueArgumentsToParameters(context.call, context.tracing, candidateCall, unmappedArguments = Sets.newLinkedHashSet())).isSuccess()) {
            if (argumentMappingStatus == ValueArgumentsToParametersMapper.Status.STRONG_ERROR) {
                candidateCall.addStatus(ResolutionStatus.RECEIVER_PRESENCE_ERROR);
            } else {
                candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            }
            if (argumentMappingStatus == ValueArgumentsToParametersMapper.Status.ERROR && candidate.getTypeParameters().isEmpty() || argumentMappingStatus == ValueArgumentsToParametersMapper.Status.STRONG_ERROR) {
                this.argumentTypeResolver.checkTypesWithNoCallee(context.toBasic());
                return;
            }
            candidateCall.setUnmappedArguments(unmappedArguments);
        }
        if ((jetTypeArguments = context.call.getTypeArguments()).isEmpty()) {
            if (!candidate.getTypeParameters().isEmpty()) {
                ResolutionStatus status = this.inferTypeArguments(context);
                candidateCall.addStatus(status);
            } else {
                candidateCall.addStatus(this.checkAllValueArguments(context, (CallResolverUtil.ResolveArgumentsMode)CallResolverUtil.ResolveArgumentsMode.SKIP_FUNCTION_ARGUMENTS).status);
            }
        } else {
            ArrayList<JetType> typeArguments = new ArrayList<JetType>();
            for (JetTypeProjection projection : jetTypeArguments) {
                if (projection.getProjectionKind() != JetProjectionKind.NONE) {
                    context.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(projection));
                }
                typeArguments.add(this.argumentTypeResolver.resolveTypeRefWithDefault(projection.getTypeReference(), context.scope, context.trace, ErrorUtils.createErrorType("Star projection in a call")));
            }
            int expectedTypeArgumentCount = candidate.getTypeParameters().size();
            if (expectedTypeArgumentCount == jetTypeArguments.size()) {
                CandidateResolver.checkGenericBoundsInAFunctionCall(jetTypeArguments, typeArguments, candidate, context.trace);
                Map<TypeConstructor, TypeProjection> substitutionContext = FunctionDescriptorUtil.createSubstitutionContext((FunctionDescriptor)candidate, typeArguments);
                TypeSubstitutor substitutor = TypeSubstitutor.create(substitutionContext);
                candidateCall.setResultingSubstitutor(substitutor);
                List<TypeParameterDescriptor> typeParameters = candidateCall.getCandidateDescriptor().getTypeParameters();
                for (int i = 0; i < typeParameters.size(); ++i) {
                    TypeParameterDescriptor typeParameterDescriptor = typeParameters.get(i);
                    candidateCall.recordTypeArgument(typeParameterDescriptor, (JetType)typeArguments.get(i));
                }
                candidateCall.addStatus(this.checkAllValueArguments(context, (CallResolverUtil.ResolveArgumentsMode)CallResolverUtil.ResolveArgumentsMode.SKIP_FUNCTION_ARGUMENTS).status);
            } else {
                candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
                context.tracing.wrongNumberOfTypeArguments(context.trace, expectedTypeArgumentCount);
            }
        }
        task.performAdvancedChecks(candidate, context.trace, context.tracing);
        JetSuperExpression superExpression = TaskPrioritizer.getReceiverSuper(candidateCall.getReceiverArgument());
        if (superExpression != null) {
            context.trace.report(Errors.SUPER_IS_NOT_AN_EXPRESSION.on(superExpression, superExpression.getText()));
            candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
        }
        AutoCastUtils.recordAutoCastIfNecessary(candidateCall.getReceiverArgument(), candidateCall.getTrace());
        AutoCastUtils.recordAutoCastIfNecessary(candidateCall.getThisObject(), candidateCall.getTrace());
    }

    private static boolean checkOuterClassMemberIsAccessible(@NotNull CallCandidateResolutionContext<?> context) {
        if (context.call.getExplicitReceiver().exists()) {
            return true;
        }
        ClassDescriptor candidateThis = CandidateResolver.getDeclaringClass(context.candidateCall.getCandidateDescriptor());
        if (candidateThis == null || candidateThis.getKind().isObject()) {
            return true;
        }
        return DescriptorResolver.checkHasOuterClassInstance(context.scope, context.trace, context.call.getCallElement(), candidateThis);
    }

    @Nullable
    private static ClassDescriptor getDeclaringClass(@NotNull CallableDescriptor candidate) {
        ReceiverParameterDescriptor expectedThis = candidate.getExpectedThisObject();
        if (expectedThis == null) {
            return null;
        }
        DeclarationDescriptor descriptor = expectedThis.getContainingDeclaration();
        return descriptor instanceof ClassDescriptor ? (ClassDescriptor)descriptor : null;
    }

    public <D extends CallableDescriptor> void completeTypeInferenceDependentOnFunctionLiteralsForCall(CallCandidateResolutionContext<D> context) {
        ResolvedCallImpl resolvedCall = context.candidateCall;
        ConstraintSystem constraintSystem = resolvedCall.getConstraintSystem();
        if (!resolvedCall.hasIncompleteTypeParameters() || constraintSystem == null) {
            return;
        }
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : resolvedCall.getValueArguments().entrySet()) {
            ResolvedValueArgument resolvedValueArgument = entry.getValue();
            ValueParameterDescriptor valueParameterDescriptor = entry.getKey();
            for (ValueArgument valueArgument : resolvedValueArgument.getArguments()) {
                if (!(valueArgument.getArgumentExpression() instanceof JetFunctionLiteralExpression)) continue;
                this.addConstraintForFunctionLiteral(valueArgument, valueParameterDescriptor, constraintSystem, context);
            }
        }
        resolvedCall.setResultingSubstitutor(constraintSystem.getResultingSubstitutor());
    }

    @Nullable
    public <D extends CallableDescriptor> JetType completeTypeInferenceDependentOnExpectedTypeForCall(@NotNull CallCandidateResolutionContext<D> context, boolean isInnerCall) {
        PsiElement callElement;
        ResolvedCallImpl resolvedCall = context.candidateCall;
        assert (resolvedCall.hasIncompleteTypeParameters());
        Object descriptor = resolvedCall.getCandidateDescriptor();
        ConstraintSystem constraintSystem = resolvedCall.getConstraintSystem();
        assert (constraintSystem != null);
        constraintSystem.addSupertypeConstraint(context.expectedType, descriptor.getReturnType(), ConstraintPosition.EXPECTED_TYPE_POSITION);
        ConstraintSystemCompleter constraintSystemCompleter = context.trace.get(BindingContext.CONSTRAINT_SYSTEM_COMPLETER, context.call.getCalleeExpression());
        if (constraintSystemCompleter != null) {
            ConstraintSystemImpl backup = (ConstraintSystemImpl)constraintSystem.copy();
            constraintSystemCompleter.completeConstraintSystem(constraintSystem, resolvedCall);
            if (constraintSystem.hasTypeConstructorMismatchAt(ConstraintPosition.FROM_COMPLETER) || constraintSystem.hasContradiction() && !backup.hasContradiction()) {
                constraintSystem = backup;
                resolvedCall.setConstraintSystem(backup);
            }
        }
        if (constraintSystem.hasContradiction()) {
            return this.reportInferenceError(context);
        }
        boolean boundsAreSatisfied = ConstraintsUtil.checkBoundsAreSatisfied(constraintSystem, true);
        if (!boundsAreSatisfied || constraintSystem.hasUnknownParameters()) {
            ConstraintSystemImpl copy = (ConstraintSystemImpl)constraintSystem.copy();
            copy.processDeclaredBoundConstraints();
            boolean bl = boundsAreSatisfied = copy.isSuccessful() && ConstraintsUtil.checkBoundsAreSatisfied(copy, true);
            if (boundsAreSatisfied) {
                constraintSystem = copy;
                resolvedCall.setConstraintSystem(constraintSystem);
            }
        }
        if (!constraintSystem.isSuccessful()) {
            return this.reportInferenceError(context);
        }
        if (!boundsAreSatisfied) {
            context.tracing.upperBoundViolated(context.trace, InferenceErrorData.create(resolvedCall.getCandidateDescriptor(), constraintSystem));
        }
        resolvedCall.setResultingSubstitutor(constraintSystem.getResultingSubstitutor());
        this.completeNestedCallsInference(context);
        this.checkAllValueArguments(context, context.trace, CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        resolvedCall.setHasUnknownTypeParameters(false);
        ResolutionStatus status = resolvedCall.getStatus();
        if (status == ResolutionStatus.UNKNOWN_STATUS || status == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) {
            resolvedCall.setStatusToSuccess();
        }
        JetType returnType = resolvedCall.getResultingDescriptor().getReturnType();
        if (isInnerCall && (callElement = context.call.getCallElement()) instanceof JetCallExpression) {
            DataFlowUtils.checkType(returnType, (JetCallExpression)callElement, context, context.dataFlowInfo);
        }
        return returnType;
    }

    private <D extends CallableDescriptor> JetType reportInferenceError(@NotNull CallCandidateResolutionContext<D> context) {
        ResolvedCallImpl resolvedCall = context.candidateCall;
        ConstraintSystem constraintSystem = resolvedCall.getConstraintSystem();
        resolvedCall.setResultingSubstitutor(constraintSystem.getResultingSubstitutor());
        this.completeNestedCallsInference(context);
        List<JetType> argumentTypes = this.checkValueArgumentTypes(context, resolvedCall, (BindingTrace)context.trace, (CallResolverUtil.ResolveArgumentsMode)CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS).argumentTypes;
        JetType receiverType = resolvedCall.getReceiverArgument().exists() ? resolvedCall.getReceiverArgument().getType() : null;
        InferenceErrorData.ExtendedInferenceErrorData errorData = InferenceErrorData.create(resolvedCall.getCandidateDescriptor(), constraintSystem, argumentTypes, receiverType, context.expectedType);
        context.tracing.typeInferenceFailed(context.trace, errorData);
        resolvedCall.addStatus(ResolutionStatus.OTHER_ERROR);
        if (!CallResolverUtil.hasInferredReturnType(resolvedCall)) {
            return null;
        }
        return resolvedCall.getResultingDescriptor().getReturnType();
    }

    @Nullable
    public <D extends CallableDescriptor> JetType completeNestedCallsInference(@NotNull CallCandidateResolutionContext<D> context) {
        ResolvedCallImpl resolvedCall = context.candidateCall;
        ConstraintSystem constraintSystem = context.candidateCall.getConstraintSystem();
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : resolvedCall.getValueArguments().entrySet()) {
            ValueParameterDescriptor parameterDescriptor = entry.getKey();
            ResolvedValueArgument resolvedArgument = entry.getValue();
            for (ValueArgument argument : resolvedArgument.getArguments()) {
                JetType type;
                JetType expectedType;
                JetExpression expression = argument.getArgumentExpression();
                if (expression == null) continue;
                JetType effectiveExpectedType = CandidateResolver.getEffectiveExpectedType(parameterDescriptor, argument);
                JetType jetType = expectedType = constraintSystem != null ? constraintSystem.getCurrentSubstitutor().substitute(effectiveExpectedType, Variance.INVARIANT) : effectiveExpectedType;
                JetVisitor<JetExpression, Void> selectorExpressionFinder = new JetVisitor<JetExpression, Void>(){

                    @Override
                    public JetExpression visitQualifiedExpression(JetQualifiedExpression expression, Void data) {
                        JetExpression selector = expression.getSelectorExpression();
                        return selector != null ? selector.accept(this, null) : null;
                    }

                    @Override
                    public JetExpression visitCallExpression(JetCallExpression expression, Void data) {
                        return expression;
                    }

                    @Override
                    public JetExpression visitSimpleNameExpression(JetSimpleNameExpression expression, Void data) {
                        return expression;
                    }

                    @Override
                    public JetExpression visitJetElement(JetElement element, Void data) {
                        return null;
                    }
                };
                JetExpression selectorExpression = expression.accept(selectorExpressionFinder, null);
                if (selectorExpression == null) continue;
                if (selectorExpression instanceof JetSimpleNameExpression) {
                    if (!(expression instanceof JetQualifiedExpression)) continue;
                    JetType type2 = context.trace.get(BindingContext.EXPRESSION_TYPE, selectorExpression);
                    DataFlowUtils.checkType(type2, expression, context.replaceExpectedType(expectedType));
                    continue;
                }
                CallCandidateResolutionContext<FunctionDescriptor> storedContextForArgument = context.resolutionResultsCache.getDeferredComputation(CallKey.create(Call.CallType.DEFAULT, selectorExpression));
                if (storedContextForArgument == null) continue;
                CallCandidateResolutionContext contextForArgument = (CallCandidateResolutionContext)((CallCandidateResolutionContext)storedContextForArgument.replaceResolveMode(ResolveMode.TOP_LEVEL_CALL).replaceBindingTrace(context.trace)).replaceExpectedType(expectedType);
                if (contextForArgument.candidateCall.hasIncompleteTypeParameters()) {
                    type = this.completeTypeInferenceDependentOnExpectedTypeForCall(contextForArgument, true);
                } else {
                    type = this.completeNestedCallsInference(contextForArgument);
                    this.checkValueArgumentTypes(contextForArgument);
                }
                DataFlowUtils.checkType(type, expression, contextForArgument);
            }
        }
        CandidateResolver.recordReferenceForInvokeFunction(context);
        return resolvedCall.getResultingDescriptor().getReturnType();
    }

    private static <D extends CallableDescriptor> void recordReferenceForInvokeFunction(CallCandidateResolutionContext<D> context) {
        PsiElement callElement = context.call.getCallElement();
        if (!(callElement instanceof JetCallExpression)) {
            return;
        }
        JetCallExpression callExpression = (JetCallExpression)callElement;
        Object resultingDescriptor = context.candidateCall.getResultingDescriptor();
        if (BindingContextUtils.isCallExpressionWithValidReference(callExpression, context.trace.getBindingContext())) {
            context.trace.record(BindingContext.EXPRESSION_TYPE, callExpression, resultingDescriptor.getReturnType());
            context.trace.record(BindingContext.REFERENCE_TARGET, callExpression, resultingDescriptor);
        }
    }

    private <D extends CallableDescriptor> void addConstraintForFunctionLiteral(@NotNull ValueArgument valueArgument, @NotNull ValueParameterDescriptor valueParameterDescriptor, @NotNull ConstraintSystem constraintSystem, @NotNull CallCandidateResolutionContext<D> context) {
        boolean hasExpectedReturnType;
        JetExpression argumentExpression = valueArgument.getArgumentExpression();
        assert (argumentExpression instanceof JetFunctionLiteralExpression);
        JetType effectiveExpectedType = CandidateResolver.getEffectiveExpectedType(valueParameterDescriptor, valueArgument);
        JetType expectedType = constraintSystem.getCurrentSubstitutor().substitute(effectiveExpectedType, Variance.INVARIANT);
        if (expectedType == null || !KotlinBuiltIns.getInstance().isFunctionOrExtensionFunctionType(expectedType) || CallResolverUtil.hasUnknownFunctionParameter(expectedType)) {
            return;
        }
        boolean bl = hasExpectedReturnType = !CallResolverUtil.hasUnknownReturnType(expectedType);
        if (hasExpectedReturnType) {
            TemporaryBindingTrace traceToResolveFunctionLiteral = TemporaryBindingTrace.create(context.trace, "trace to resolve function literal with expected return type", argumentExpression);
            JetElement statementExpression = JetPsiUtil.getLastStatementInABlock(((JetFunctionLiteralExpression)argumentExpression).getBodyExpression());
            if (statementExpression == null) {
                return;
            }
            boolean[] mismatch = new boolean[1];
            ObservableBindingTrace errorInterceptingTrace = ExpressionTypingUtils.makeTraceInterceptingTypeMismatch(traceToResolveFunctionLiteral, statementExpression, mismatch);
            CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)((CallCandidateResolutionContext)context.replaceBindingTrace(errorInterceptingTrace)).replaceExpectedType(expectedType);
            JetType type = this.argumentTypeResolver.getFunctionLiteralTypeInfo((JetFunctionLiteralExpression)argumentExpression, newContext, CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS).getType();
            if (!mismatch[0]) {
                constraintSystem.addSubtypeConstraint(type, effectiveExpectedType, ConstraintPosition.getValueParameterPosition(valueParameterDescriptor.getIndex()));
                traceToResolveFunctionLiteral.commit();
                return;
            }
        }
        JetType expectedTypeWithoutReturnType = hasExpectedReturnType ? CallResolverUtil.replaceReturnTypeByUnknown(expectedType) : expectedType;
        CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)context.replaceExpectedType(expectedTypeWithoutReturnType);
        JetType type = this.argumentTypeResolver.getFunctionLiteralTypeInfo((JetFunctionLiteralExpression)argumentExpression, newContext, CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS).getType();
        constraintSystem.addSubtypeConstraint(type, effectiveExpectedType, ConstraintPosition.getValueParameterPosition(valueParameterDescriptor.getIndex()));
    }

    private <D extends CallableDescriptor> ResolutionStatus inferTypeArguments(CallCandidateResolutionContext<D> context) {
        ResolvedCallImpl candidateCall = context.candidateCall;
        final Object candidate = candidateCall.getCandidateDescriptor();
        context.trace.get(ResolutionDebugInfo.RESOLUTION_DEBUG_INFO, context.call.getCallElement());
        ConstraintSystemImpl constraintSystem = new ConstraintSystemImpl();
        Object candidateWithFreshVariables = FunctionDescriptorUtil.alphaConvertTypeParameters(candidate);
        for (TypeParameterDescriptor typeParameterDescriptor : candidateWithFreshVariables.getTypeParameters()) {
            constraintSystem.registerTypeVariable(typeParameterDescriptor, Variance.INVARIANT);
        }
        TypeSubstitutor substituteDontCare = ConstraintSystemWithPriorities.makeConstantSubstitutor(candidateWithFreshVariables.getTypeParameters(), CallResolverUtil.DONT_CARE);
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : candidateCall.getValueArguments().entrySet()) {
            ResolvedValueArgument resolvedValueArgument = entry.getValue();
            ValueParameterDescriptor valueParameterDescriptor = candidateWithFreshVariables.getValueParameters().get(entry.getKey().getIndex());
            for (ValueArgument valueArgument : resolvedValueArgument.getArguments()) {
                boolean[] isErrorType = new boolean[1];
                this.addConstraintForValueArgument(valueArgument, valueParameterDescriptor, substituteDontCare, constraintSystem, context, isErrorType, CallResolverUtil.ResolveArgumentsMode.SKIP_FUNCTION_ARGUMENTS);
                if (!isErrorType[0]) continue;
                candidateCall.argumentHasNoType();
            }
        }
        ReceiverValue receiverArgument = candidateCall.getReceiverArgument();
        ReceiverParameterDescriptor receiverParameter = candidateWithFreshVariables.getReceiverParameter();
        if (receiverArgument.exists() && receiverParameter != null) {
            JetType receiverType = context.candidateCall.isSafeCall() ? TypeUtils.makeNotNullable(receiverArgument.getType()) : receiverArgument.getType();
            constraintSystem.addSubtypeConstraint(receiverType, receiverParameter.getType(), ConstraintPosition.RECEIVER_POSITION);
        }
        ConstraintSystem constraintSystemWithRightTypeParameters = constraintSystem.replaceTypeVariables(new Function<TypeParameterDescriptor, TypeParameterDescriptor>(){

            @Override
            public TypeParameterDescriptor apply(@Nullable TypeParameterDescriptor typeParameterDescriptor) {
                assert (typeParameterDescriptor != null);
                return candidate.getTypeParameters().get(typeParameterDescriptor.getIndex());
            }
        });
        candidateCall.setConstraintSystem(constraintSystemWithRightTypeParameters);
        boolean hasContradiction = constraintSystem.hasContradiction();
        boolean boundsAreSatisfied = ConstraintsUtil.checkBoundsAreSatisfied(constraintSystem, false);
        candidateCall.setHasUnknownTypeParameters(true);
        if (!hasContradiction && boundsAreSatisfied) {
            return ResolutionStatus.INCOMPLETE_TYPE_INFERENCE;
        }
        ValueArgumentsCheckingResult checkingResult = this.checkAllValueArguments(context, CallResolverUtil.ResolveArgumentsMode.SKIP_FUNCTION_ARGUMENTS);
        ResolutionStatus argumentsStatus = checkingResult.status;
        return ResolutionStatus.OTHER_ERROR.combine(argumentsStatus);
    }

    private void addConstraintForValueArgument(@NotNull ValueArgument valueArgument, @NotNull ValueParameterDescriptor valueParameterDescriptor, @NotNull TypeSubstitutor substitutor, @NotNull ConstraintSystem constraintSystem, @NotNull CallCandidateResolutionContext<?> context, @Nullable boolean[] isErrorType, @NotNull CallResolverUtil.ResolveArgumentsMode resolveFunctionArgumentBodies) {
        JetType effectiveExpectedType = CandidateResolver.getEffectiveExpectedType(valueParameterDescriptor, valueArgument);
        JetExpression argumentExpression = valueArgument.getArgumentExpression();
        TemporaryBindingTrace traceToResolveArgument = TemporaryBindingTrace.create(context.trace, "transient trace to resolve argument", argumentExpression);
        JetType expectedType = substitutor.substitute(effectiveExpectedType, Variance.INVARIANT);
        CallResolutionContext newContext = (CallResolutionContext)((CallCandidateResolutionContext)context.replaceBindingTrace(traceToResolveArgument)).replaceExpectedType(expectedType);
        JetTypeInfo typeInfoForCall = this.argumentTypeResolver.getArgumentTypeInfo(argumentExpression, newContext, resolveFunctionArgumentBodies, traceToResolveArgument);
        JetType type = typeInfoForCall.getType();
        constraintSystem.addSubtypeConstraint(type, effectiveExpectedType, ConstraintPosition.getValueParameterPosition(valueParameterDescriptor.getIndex()));
        if (isErrorType != null) {
            isErrorType[0] = type == null || ErrorUtils.isErrorType(type);
        }
    }

    private <D extends CallableDescriptor> ValueArgumentsCheckingResult checkAllValueArguments(@NotNull CallCandidateResolutionContext<D> context, @NotNull CallResolverUtil.ResolveArgumentsMode resolveFunctionArgumentBodies) {
        return this.checkAllValueArguments(context, context.candidateCall.getTrace(), resolveFunctionArgumentBodies);
    }

    private <D extends CallableDescriptor> ValueArgumentsCheckingResult checkAllValueArguments(@NotNull CallCandidateResolutionContext<D> context, @NotNull BindingTrace trace, @NotNull CallResolverUtil.ResolveArgumentsMode resolveFunctionArgumentBodies) {
        ValueArgumentsCheckingResult checkingResult = this.checkValueArgumentTypes(context, context.candidateCall, trace, resolveFunctionArgumentBodies);
        ResolutionStatus resultStatus = checkingResult.status;
        resultStatus = resultStatus.combine(CandidateResolver.checkReceiver(context, trace, false));
        return new ValueArgumentsCheckingResult(resultStatus, checkingResult.argumentTypes);
    }

    private static <D extends CallableDescriptor> ResolutionStatus checkReceiver(@NotNull CallCandidateResolutionContext<D> context, @NotNull BindingTrace trace, boolean checkOnlyReceiverTypeError) {
        ResolutionStatus resultStatus = ResolutionStatus.SUCCESS;
        ResolvedCallImpl candidateCall = context.candidateCall;
        resultStatus = resultStatus.combine(CandidateResolver.checkReceiverTypeError(candidateCall));
        resultStatus = resultStatus.combine(CandidateResolver.checkReceiver(context, candidateCall, trace, candidateCall.getResultingDescriptor().getReceiverParameter(), candidateCall.getReceiverArgument(), candidateCall.getExplicitReceiverKind().isReceiver(), false));
        resultStatus = resultStatus.combine(CandidateResolver.checkReceiver(context, candidateCall, trace, candidateCall.getResultingDescriptor().getExpectedThisObject(), candidateCall.getThisObject(), candidateCall.getExplicitReceiverKind().isThisObject(), context.call instanceof CallTransformer.CallForImplicitInvoke));
        return resultStatus;
    }

    public <D extends CallableDescriptor> ValueArgumentsCheckingResult checkValueArgumentTypes(@NotNull CallCandidateResolutionContext<D> context) {
        return this.checkValueArgumentTypes(context, context.candidateCall, context.trace, CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
    }

    private <D extends CallableDescriptor, C extends CallResolutionContext<C>> ValueArgumentsCheckingResult checkValueArgumentTypes(@NotNull CallResolutionContext<C> context, @NotNull ResolvedCallImpl<D> candidateCall, @NotNull BindingTrace trace, @NotNull CallResolverUtil.ResolveArgumentsMode resolveFunctionArgumentBodies) {
        ResolutionStatus resultStatus = ResolutionStatus.SUCCESS;
        ArrayList<JetType> argumentTypes = Lists.newArrayList();
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : candidateCall.getValueArguments().entrySet()) {
            ValueParameterDescriptor parameterDescriptor = entry.getKey();
            ResolvedValueArgument resolvedArgument = entry.getValue();
            for (ValueArgument argument : resolvedArgument.getArguments()) {
                JetType resultingType;
                JetExpression expression = argument.getArgumentExpression();
                if (expression == null) continue;
                JetType expectedType = CandidateResolver.getEffectiveExpectedType(parameterDescriptor, argument);
                if (TypeUtils.dependsOnTypeParameters(expectedType, candidateCall.getCandidateDescriptor().getTypeParameters())) {
                    expectedType = TypeUtils.NO_EXPECTED_TYPE;
                }
                CallResolutionContext newContext = (CallResolutionContext)((CallResolutionContext)((CallResolutionContext)context.replaceDataFlowInfo(candidateCall.getDataFlowInfo())).replaceBindingTrace(trace)).replaceExpectedType(expectedType);
                JetTypeInfo typeInfoForCall = this.argumentTypeResolver.getArgumentTypeInfo(expression, newContext, resolveFunctionArgumentBodies, null);
                JetType type = typeInfoForCall.getType();
                candidateCall.addDataFlowInfo(typeInfoForCall.getDataFlowInfo());
                if (type == null || ErrorUtils.isErrorType(type) && type != CallResolverUtil.PLACEHOLDER_FUNCTION_TYPE) {
                    candidateCall.argumentHasNoType();
                    argumentTypes.add(type);
                    continue;
                }
                if (expectedType == TypeUtils.NO_EXPECTED_TYPE || ArgumentTypeResolver.isSubtypeOfForArgumentType(type, expectedType)) {
                    resultingType = type;
                } else {
                    resultingType = CandidateResolver.autocastValueArgumentTypeIfPossible(expression, expectedType, type, trace, candidateCall.getDataFlowInfo());
                    if (resultingType == null) {
                        resultingType = type;
                        resultStatus = ResolutionStatus.OTHER_ERROR;
                    }
                }
                argumentTypes.add(resultingType);
            }
        }
        return new ValueArgumentsCheckingResult(resultStatus, argumentTypes);
    }

    @Nullable
    private static JetType autocastValueArgumentTypeIfPossible(@NotNull JetExpression expression, @NotNull JetType expectedType, @NotNull JetType actualType, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        ExpressionReceiver receiverToCast = new ExpressionReceiver(expression, actualType);
        List<ReceiverValue> variants = AutoCastUtils.getAutoCastVariants(trace.getBindingContext(), dataFlowInfo, receiverToCast);
        for (ReceiverValue receiverValue : variants) {
            JetType possibleType = receiverValue.getType();
            if (!ArgumentTypeResolver.isSubtypeOfForArgumentType(possibleType, expectedType)) continue;
            return possibleType;
        }
        return null;
    }

    private static <D extends CallableDescriptor> ResolutionStatus checkReceiverTypeError(@NotNull ResolvedCall<D> candidateCall) {
        JetType receiverArgumentType;
        ReceiverParameterDescriptor receiverParameterDescriptor;
        D candidateDescriptor = candidateCall.getCandidateDescriptor();
        if (candidateDescriptor instanceof ExpressionAsFunctionDescriptor) {
            return ResolutionStatus.SUCCESS;
        }
        ReceiverParameterDescriptor receiverDescriptor = candidateDescriptor.getReceiverParameter();
        ReceiverParameterDescriptor expectedThisObjectDescriptor = candidateDescriptor.getExpectedThisObject();
        if (receiverDescriptor != null && candidateCall.getReceiverArgument().exists()) {
            receiverParameterDescriptor = receiverDescriptor;
            receiverArgumentType = candidateCall.getReceiverArgument().getType();
        } else if (expectedThisObjectDescriptor != null && candidateCall.getThisObject().exists()) {
            receiverParameterDescriptor = expectedThisObjectDescriptor;
            receiverArgumentType = candidateCall.getThisObject().getType();
        } else {
            return ResolutionStatus.SUCCESS;
        }
        JetType effectiveReceiverArgumentType = TypeUtils.makeNotNullable(receiverArgumentType);
        JetType erasedReceiverType = CallResolverUtil.getErasedReceiverType(receiverParameterDescriptor, candidateDescriptor);
        if (!JetTypeChecker.INSTANCE.isSubtypeOf(effectiveReceiverArgumentType, erasedReceiverType)) {
            return ResolutionStatus.RECEIVER_TYPE_ERROR;
        }
        return ResolutionStatus.SUCCESS;
    }

    private static <D extends CallableDescriptor> ResolutionStatus checkReceiver(@NotNull CallCandidateResolutionContext<D> context, @NotNull ResolvedCall<D> candidateCall, @NotNull BindingTrace trace, @Nullable ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, boolean isExplicitReceiver, boolean implicitInvokeCheck) {
        if (receiverParameter == null || !receiverArgument.exists()) {
            return ResolutionStatus.SUCCESS;
        }
        JetType receiverArgumentType = receiverArgument.getType();
        JetType effectiveReceiverArgumentType = TypeUtils.makeNotNullable(receiverArgumentType);
        D candidateDescriptor = candidateCall.getCandidateDescriptor();
        if (!ArgumentTypeResolver.isSubtypeOfForArgumentType(effectiveReceiverArgumentType, receiverParameter.getType()) && !TypeUtils.dependsOnTypeParameters(receiverParameter.getType(), candidateDescriptor.getTypeParameters())) {
            context.tracing.wrongReceiverType(trace, receiverParameter, receiverArgument);
            return ResolutionStatus.OTHER_ERROR;
        }
        BindingContext bindingContext = trace.getBindingContext();
        boolean safeAccess = isExplicitReceiver && !implicitInvokeCheck && candidateCall.isSafeCall();
        AutoCastServiceImpl autoCastService = new AutoCastServiceImpl(context.dataFlowInfo, bindingContext);
        if (!(safeAccess || receiverParameter.getType().isNullable() || autoCastService.isNotNull(receiverArgument))) {
            context.tracing.unsafeCall(trace, receiverArgumentType, implicitInvokeCheck);
            return ResolutionStatus.UNSAFE_CALL_ERROR;
        }
        DataFlowValue receiverValue = DataFlowValueFactory.INSTANCE.createDataFlowValue(receiverArgument, bindingContext);
        if (safeAccess && !context.dataFlowInfo.getNullability(receiverValue).canBeNull()) {
            context.tracing.unnecessarySafeCall(trace, receiverArgumentType);
        }
        return ResolutionStatus.SUCCESS;
    }

    @NotNull
    private static JetType getEffectiveExpectedType(ValueParameterDescriptor parameterDescriptor, ValueArgument argument) {
        if (argument.getSpreadElement() != null) {
            if (parameterDescriptor.getVarargElementType() == null) {
                return CallResolverUtil.DONT_CARE;
            }
            return parameterDescriptor.getType();
        }
        if (argument.isNamed()) {
            return parameterDescriptor.getType();
        }
        JetType varargElementType = parameterDescriptor.getVarargElementType();
        if (varargElementType == null) {
            return parameterDescriptor.getType();
        }
        return varargElementType;
    }

    private static void checkGenericBoundsInAFunctionCall(@NotNull List<JetTypeProjection> jetTypeArguments, @NotNull List<JetType> typeArguments, @NotNull CallableDescriptor functionDescriptor, @NotNull BindingTrace trace) {
        HashMap<TypeConstructor, TypeProjection> context = Maps.newHashMap();
        List<TypeParameterDescriptor> typeParameters = functionDescriptor.getOriginal().getTypeParameters();
        int typeParametersSize = typeParameters.size();
        for (int i = 0; i < typeParametersSize; ++i) {
            TypeParameterDescriptor typeParameter = typeParameters.get(i);
            JetType typeArgument = typeArguments.get(i);
            context.put(typeParameter.getTypeConstructor(), new TypeProjection(typeArgument));
        }
        TypeSubstitutor substitutor = TypeSubstitutor.create(context);
        int typeParametersSize2 = typeParameters.size();
        for (int i = 0; i < typeParametersSize2; ++i) {
            TypeParameterDescriptor typeParameterDescriptor = typeParameters.get(i);
            JetType typeArgument = typeArguments.get(i);
            JetTypeReference typeReference = jetTypeArguments.get(i).getTypeReference();
            if (typeReference == null) continue;
            DescriptorResolver.checkBounds(typeReference, typeArgument, typeParameterDescriptor, substitutor, trace);
        }
    }

    private static class ValueArgumentsCheckingResult {
        public final List<JetType> argumentTypes;
        public final ResolutionStatus status;

        private ValueArgumentsCheckingResult(@NotNull ResolutionStatus status, @NotNull List<JetType> argumentTypes) {
            this.status = status;
            this.argumentTypes = argumentTypes;
        }
    }
}

