/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.state;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.codegen.AccessorForFunctionDescriptor;
import org.jetbrains.jet.codegen.AccessorForPropertyDescriptor;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.FunctionTypesUtil;
import org.jetbrains.jet.codegen.NamespaceCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.PropertyCodegen;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.binding.BindingTraceAware;
import org.jetbrains.jet.codegen.binding.CalculatedClosure;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.signature.BothSignatureWriter;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterKind;
import org.jetbrains.jet.codegen.signature.JvmMethodParameterSignature;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.codegen.signature.JvmPropertyAccessorSignature;
import org.jetbrains.jet.codegen.state.JetTypeMapperMode;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperCall;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.JavaBindingContext;
import org.jetbrains.jet.lang.resolve.java.JavaNamespaceKind;
import org.jetbrains.jet.lang.resolve.java.JavaToKotlinClassMap;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.KotlinToJavaTypesMap;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.CommonSupertypes;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.IntersectionTypeConstructor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class JetTypeMapper
extends BindingTraceAware {
    private final boolean mapBuiltinsToJava;
    private final ClassBuilderMode classBuilderMode;

    public JetTypeMapper(BindingTrace bindingTrace, boolean mapBuiltinsToJava, ClassBuilderMode mode) {
        super(bindingTrace);
        this.mapBuiltinsToJava = mapBuiltinsToJava;
        this.classBuilderMode = mode;
    }

    @NotNull
    public JvmClassName getOwner(DeclarationDescriptor descriptor, OwnerKind kind, boolean isInsideModule) {
        JetTypeMapperMode mapTypeMode = JetTypeMapper.ownerKindToMapTypeMode(kind);
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration instanceof NamespaceDescriptor) {
            return this.jvmClassNameForNamespace((NamespaceDescriptor)containingDeclaration, descriptor, isInsideModule);
        }
        if (containingDeclaration instanceof ClassDescriptor) {
            Type asmType;
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            if (classDescriptor.getKind() == ClassKind.OBJECT) {
                mapTypeMode = JetTypeMapperMode.IMPL;
            }
            if ((asmType = this.mapType(classDescriptor.getDefaultType(), mapTypeMode)).getSort() != 10) {
                throw new IllegalStateException();
            }
            return JvmClassName.byType(asmType);
        }
        if (containingDeclaration instanceof ScriptDescriptor) {
            return CodegenBinding.classNameForScriptDescriptor(this.bindingContext, (ScriptDescriptor)containingDeclaration);
        }
        throw new UnsupportedOperationException("don't know how to generate owner for parent " + containingDeclaration);
    }

    private static JetTypeMapperMode ownerKindToMapTypeMode(OwnerKind kind) {
        if (kind == OwnerKind.IMPLEMENTATION || kind == OwnerKind.NAMESPACE || kind instanceof OwnerKind.StaticDelegateKind) {
            return JetTypeMapperMode.IMPL;
        }
        if (kind == OwnerKind.TRAIT_IMPL) {
            return JetTypeMapperMode.TRAIT_IMPL;
        }
        throw new IllegalStateException("must not call this method with kind = " + kind);
    }

    @NotNull
    private JavaNamespaceKind getNsKind(@NotNull NamespaceDescriptor ns) {
        JavaNamespaceKind javaNamespaceKind = this.bindingContext.get(JavaBindingContext.JAVA_NAMESPACE_KIND, ns);
        Boolean src = this.bindingContext.get(BindingContext.NAMESPACE_IS_SRC, ns);
        if (javaNamespaceKind == null && src == null) {
            throw new IllegalStateException("unknown namespace origin: " + ns);
        }
        if (javaNamespaceKind != null) {
            if (javaNamespaceKind == JavaNamespaceKind.CLASS_STATICS && src != null) {
                throw new IllegalStateException("conflicting namespace " + ns + ": it is both java statics and from src");
            }
            return javaNamespaceKind;
        }
        return JavaNamespaceKind.PROPER;
    }

    @NotNull
    private JvmClassName jvmClassNameForNamespace(@NotNull NamespaceDescriptor namespace, @NotNull DeclarationDescriptor descriptor, boolean insideModule) {
        StringBuilder r = new StringBuilder();
        List<DeclarationDescriptor> path = DescriptorUtils.getPathWithoutRootNsAndModule(namespace);
        for (DeclarationDescriptor pathElement : path) {
            NamespaceDescriptor ns = (NamespaceDescriptor)pathElement;
            if (r.length() > 0) {
                JavaNamespaceKind nsKind = this.getNsKind((NamespaceDescriptor)ns.getContainingDeclaration());
                if (nsKind == JavaNamespaceKind.PROPER) {
                    r.append("/");
                } else if (nsKind == JavaNamespaceKind.CLASS_STATICS) {
                    r.append("$");
                }
            }
            r.append(ns.getName());
        }
        if (this.getNsKind(namespace) == JavaNamespaceKind.PROPER) {
            if (r.length() > 0) {
                r.append("/");
            }
            JetFile file = BindingContextUtils.getContainingFile(this.bindingContext, descriptor);
            if (insideModule && file != null) {
                String internalName = NamespaceCodegen.getNamespacePartInternalName(file);
                r.append(internalName.substring(r.length()));
            } else {
                r.append(PackageClassUtils.getPackageClassName(namespace.getFqName()));
            }
        }
        if (r.length() == 0) {
            throw new IllegalStateException("internal error: failed to generate classname for " + namespace);
        }
        return JvmClassName.byInternalName(r.toString());
    }

    @NotNull
    public Type mapReturnType(@NotNull JetType jetType) {
        return this.mapReturnType(jetType, null);
    }

    @NotNull
    private Type mapReturnType(@NotNull JetType jetType, @Nullable BothSignatureWriter signatureVisitor) {
        if (((Object)jetType).equals(KotlinBuiltIns.getInstance().getUnitType())) {
            if (signatureVisitor != null) {
                signatureVisitor.writeAsmType(Type.VOID_TYPE, false);
            }
            return Type.VOID_TYPE;
        }
        if (((Object)jetType).equals(KotlinBuiltIns.getInstance().getNothingType())) {
            if (signatureVisitor != null) {
                signatureVisitor.writeNothing(false);
            }
            return Type.VOID_TYPE;
        }
        if (((Object)jetType).equals(KotlinBuiltIns.getInstance().getNullableNothingType())) {
            if (signatureVisitor != null) {
                signatureVisitor.writeNothing(true);
            }
            return AsmTypeConstants.OBJECT_TYPE;
        }
        return this.mapType(jetType, signatureVisitor, JetTypeMapperMode.VALUE, Variance.OUT_VARIANCE);
    }

    @NotNull
    public Type mapType(@NotNull JetType jetType, @NotNull JetTypeMapperMode kind) {
        return this.mapType(jetType, null, kind);
    }

    @NotNull
    public Type mapType(@NotNull JetType jetType) {
        return this.mapType(jetType, null, JetTypeMapperMode.VALUE);
    }

    @NotNull
    public Type mapType(@NotNull VariableDescriptor variableDescriptor) {
        return this.mapType(variableDescriptor.getType(), null, JetTypeMapperMode.VALUE);
    }

    @NotNull
    public Type mapType(@NotNull ClassifierDescriptor classifierDescriptor) {
        return this.mapType(classifierDescriptor.getDefaultType());
    }

    @NotNull
    public Type mapType(@NotNull JetType jetType, @Nullable BothSignatureWriter signatureVisitor, @NotNull JetTypeMapperMode kind) {
        return this.mapType(jetType, signatureVisitor, kind, Variance.INVARIANT);
    }

    @NotNull
    public Type mapType(@NotNull JetType jetType, @Nullable BothSignatureWriter signatureVisitor, @NotNull JetTypeMapperMode kind, @NotNull Variance howThisTypeIsUsed) {
        Type known = null;
        ClassifierDescriptor descriptor = jetType.getConstructor().getDeclarationDescriptor();
        if (this.mapBuiltinsToJava && descriptor instanceof ClassDescriptor) {
            known = KotlinToJavaTypesMap.getInstance().getJavaAnalog(jetType);
        }
        if (known != null) {
            if (kind == JetTypeMapperMode.VALUE) {
                return this.mapKnownAsmType(jetType, known, signatureVisitor, howThisTypeIsUsed);
            }
            if (kind == JetTypeMapperMode.TYPE_PARAMETER) {
                return this.mapKnownAsmType(jetType, AsmUtil.boxType(known), signatureVisitor, howThisTypeIsUsed);
            }
            if (kind == JetTypeMapperMode.TRAIT_IMPL) {
                throw new IllegalStateException("TRAIT_IMPL is not possible for " + jetType);
            }
            if (kind == JetTypeMapperMode.IMPL) {
                if (this.mapBuiltinsToJava) {
                    // empty if block
                }
                return this.mapKnownAsmType(jetType, known, signatureVisitor, howThisTypeIsUsed);
            }
            throw new IllegalStateException("unknown kind: " + (Object)((Object)kind));
        }
        TypeConstructor constructor = jetType.getConstructor();
        if (constructor instanceof IntersectionTypeConstructor) {
            jetType = CommonSupertypes.commonSupertype(new ArrayList<JetType>(constructor.getSupertypes()));
        }
        if (descriptor == null) {
            throw new UnsupportedOperationException("no descriptor for type constructor of " + jetType);
        }
        if (ErrorUtils.isError(descriptor)) {
            if (this.classBuilderMode != ClassBuilderMode.SIGNATURES) {
                throw new IllegalStateException(this.generateErrorMessageForErrorType(descriptor));
            }
            Type asmType = Type.getObjectType("error/NonExistentClass");
            if (signatureVisitor != null) {
                signatureVisitor.writeAsmType(asmType, true);
            }
            this.checkValidType(asmType);
            return asmType;
        }
        if (this.mapBuiltinsToJava && descriptor instanceof ClassDescriptor && KotlinBuiltIns.getInstance().isArray(jetType)) {
            if (jetType.getArguments().size() != 1) {
                throw new UnsupportedOperationException("arrays must have one type argument");
            }
            TypeProjection memberProjection = jetType.getArguments().get(0);
            JetType memberType = memberProjection.getType();
            if (signatureVisitor != null) {
                signatureVisitor.writeArrayType(jetType.isNullable(), memberProjection.getProjectionKind());
                this.mapType(memberType, signatureVisitor, JetTypeMapperMode.TYPE_PARAMETER);
                signatureVisitor.writeArrayEnd();
            }
            Type r = !JetTypeMapper.isGenericsArray(jetType) ? Type.getType("[" + AsmUtil.boxType(this.mapType(memberType, kind)).getDescriptor()) : AsmTypeConstants.JAVA_ARRAY_GENERIC_TYPE;
            this.checkValidType(r);
            return r;
        }
        if (descriptor instanceof ClassDescriptor) {
            JvmClassName name = CodegenBinding.getJvmInternalName(this.bindingTrace, descriptor);
            Type asmType = kind == JetTypeMapperMode.TRAIT_IMPL ? Type.getObjectType(name.getInternalName() + "$$TImpl") : name.getAsmType();
            boolean forceReal = KotlinToJavaTypesMap.getInstance().isForceReal(name);
            this.writeGenericType(signatureVisitor, asmType, jetType, forceReal, howThisTypeIsUsed);
            this.checkValidType(asmType);
            return asmType;
        }
        if (descriptor instanceof TypeParameterDescriptor) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)descriptor;
            Type type = this.mapType(typeParameterDescriptor.getUpperBoundsAsType(), kind);
            if (signatureVisitor != null) {
                signatureVisitor.writeTypeVariable(typeParameterDescriptor.getName(), jetType.isNullable(), type);
            }
            this.checkValidType(type);
            return type;
        }
        throw new UnsupportedOperationException("Unknown type " + jetType);
    }

    private String generateErrorMessageForErrorType(@NotNull DeclarationDescriptor descriptor) {
        DeclarationDescriptor containingDeclaration;
        PsiElement declarationElement = BindingContextUtils.descriptorToDeclaration(this.bindingContext, descriptor);
        PsiElement parentDeclarationElement = null;
        if (declarationElement != null && (containingDeclaration = descriptor.getContainingDeclaration()) != null) {
            parentDeclarationElement = BindingContextUtils.descriptorToDeclaration(this.bindingContext, containingDeclaration);
        }
        return String.format("Error types are not allowed when classBuilderMode = %s. For declaration %s:%s in %s:%s", new Object[]{this.classBuilderMode, declarationElement, declarationElement != null ? declarationElement.getText() : "null", parentDeclarationElement, parentDeclarationElement != null ? parentDeclarationElement.getText() : "null"});
    }

    private void writeGenericType(BothSignatureWriter signatureVisitor, Type asmType, JetType jetType, boolean forceReal, Variance howThisTypeIsUsed) {
        if (signatureVisitor != null) {
            String kotlinTypeName = JetTypeMapper.getKotlinTypeNameForSignature(jetType, asmType);
            signatureVisitor.writeClassBegin(asmType.getInternalName(), jetType.isNullable(), forceReal, kotlinTypeName);
            List<TypeProjection> arguments = jetType.getArguments();
            for (TypeParameterDescriptor parameter : jetType.getConstructor().getParameters()) {
                TypeProjection argument = arguments.get(parameter.getIndex());
                Variance projectionKindForKotlin = argument.getProjectionKind();
                Variance projectionKindForJava = JetTypeMapper.getEffectiveVariance(parameter.getVariance(), projectionKindForKotlin, howThisTypeIsUsed);
                signatureVisitor.writeTypeArgument(projectionKindForKotlin, projectionKindForJava);
                this.mapType(argument.getType(), signatureVisitor, JetTypeMapperMode.TYPE_PARAMETER);
                signatureVisitor.writeTypeArgumentEnd();
            }
            signatureVisitor.writeClassEnd();
        }
    }

    private static Variance getEffectiveVariance(Variance parameterVariance, Variance projectionKind, Variance howThisTypeIsUsed) {
        if (howThisTypeIsUsed == Variance.OUT_VARIANCE) {
            return projectionKind;
        }
        if (parameterVariance == Variance.INVARIANT) {
            return projectionKind;
        }
        if (projectionKind == Variance.INVARIANT) {
            return parameterVariance;
        }
        if (parameterVariance == projectionKind) {
            return parameterVariance;
        }
        return Variance.OUT_VARIANCE;
    }

    private Type mapKnownAsmType(JetType jetType, Type asmType, @Nullable BothSignatureWriter signatureVisitor, @NotNull Variance howThisTypeIsUsed) {
        if (signatureVisitor != null) {
            if (jetType.getArguments().isEmpty()) {
                String kotlinTypeName = JetTypeMapper.getKotlinTypeNameForSignature(jetType, asmType);
                signatureVisitor.writeAsmType(asmType, jetType.isNullable(), kotlinTypeName);
            } else {
                this.writeGenericType(signatureVisitor, asmType, jetType, false, howThisTypeIsUsed);
            }
        }
        this.checkValidType(asmType);
        return asmType;
    }

    @Nullable
    private static String getKotlinTypeNameForSignature(@NotNull JetType jetType, @NotNull Type asmType) {
        ClassifierDescriptor descriptor = jetType.getConstructor().getDeclarationDescriptor();
        if (descriptor == null) {
            return null;
        }
        if (asmType.getSort() != 10) {
            return null;
        }
        JvmClassName jvmClassName = JvmClassName.byType(asmType);
        if (JavaToKotlinClassMap.getInstance().mapPlatformClass(jvmClassName.getFqName()).size() > 1) {
            return JvmClassName.byClassDescriptor(descriptor).getSignatureName();
        }
        return null;
    }

    private void checkValidType(@NotNull Type type) {
        String descriptor;
        if (!this.mapBuiltinsToJava && !(descriptor = type.getDescriptor()).equals("Ljava/lang/Object;") && descriptor.startsWith("Ljava/")) {
            throw new IllegalStateException("builtins must not reference java.* classes: " + descriptor);
        }
    }

    @NotNull
    public CallableMethod mapToCallableMethod(@NotNull FunctionDescriptor functionDescriptor, boolean superCall, boolean isInsideClass, boolean isInsideModule, OwnerKind kind) {
        JvmClassName thisClass;
        int invokeOpcode;
        JvmClassName ownerForDefaultImpl;
        JvmClassName owner;
        JvmClassName ownerForDefaultParam;
        DeclarationDescriptor functionParent = functionDescriptor.getOriginal().getContainingDeclaration();
        functionDescriptor = CodegenUtil.unwrapFakeOverride(functionDescriptor);
        JvmMethodSignature descriptor = this.mapSignature(functionDescriptor.getOriginal(), true, kind);
        if (functionParent instanceof NamespaceDescriptor) {
            assert (!superCall);
            ownerForDefaultImpl = ownerForDefaultParam = (owner = this.jvmClassNameForNamespace((NamespaceDescriptor)functionParent, functionDescriptor, isInsideModule));
            invokeOpcode = 184;
            thisClass = null;
        } else if (functionDescriptor instanceof ConstructorDescriptor) {
            assert (!superCall);
            ClassDescriptor containingClass = (ClassDescriptor)functionParent;
            ownerForDefaultImpl = ownerForDefaultParam = (owner = JvmClassName.byType(this.mapType(containingClass.getDefaultType(), JetTypeMapperMode.IMPL)));
            invokeOpcode = 183;
            thisClass = null;
        } else if (functionParent instanceof ScriptDescriptor) {
            ownerForDefaultParam = ownerForDefaultImpl = CodegenBinding.classNameForScriptDescriptor(this.bindingContext, (ScriptDescriptor)functionParent);
            owner = ownerForDefaultImpl;
            thisClass = ownerForDefaultImpl;
            invokeOpcode = 182;
        } else if (functionParent instanceof ClassDescriptor) {
            FunctionDescriptor declarationFunctionDescriptor = JetTypeMapper.findAnyDeclaration(functionDescriptor);
            ClassDescriptor currentOwner = (ClassDescriptor)functionParent;
            ClassDescriptor declarationOwner = (ClassDescriptor)declarationFunctionDescriptor.getContainingDeclaration();
            boolean originalIsInterface = CodegenUtil.isInterface(declarationOwner);
            boolean currentIsInterface = CodegenUtil.isInterface(currentOwner);
            boolean isAccessor = JetTypeMapper.isAccessor(functionDescriptor);
            ClassDescriptor receiver = currentIsInterface && !originalIsInterface ? declarationOwner : currentOwner;
            boolean isInterface = originalIsInterface && currentIsInterface;
            Type type = this.mapType(receiver.getDefaultType(), JetTypeMapperMode.TYPE_PARAMETER);
            owner = JvmClassName.byType(type);
            ClassDescriptor declarationOwnerForDefault = (ClassDescriptor)JetTypeMapper.findBaseDeclaration(functionDescriptor).getContainingDeclaration();
            ownerForDefaultParam = JvmClassName.byType(this.mapType(declarationOwnerForDefault.getDefaultType(), JetTypeMapperMode.TYPE_PARAMETER));
            ownerForDefaultImpl = JvmClassName.byInternalName(ownerForDefaultParam.getInternalName() + (CodegenUtil.isInterface(declarationOwnerForDefault) ? "$$TImpl" : ""));
            if (isInterface) {
                invokeOpcode = superCall ? 184 : 185;
            } else if (isAccessor) {
                invokeOpcode = 184;
            } else {
                boolean isPrivateFunInvocation = isInsideClass && functionDescriptor.getVisibility() == Visibilities.PRIVATE;
                int n = invokeOpcode = superCall || isPrivateFunInvocation ? 183 : 182;
            }
            if (isInterface && superCall) {
                descriptor = this.mapSignature(functionDescriptor, false, OwnerKind.TRAIT_IMPL);
                owner = JvmClassName.byInternalName(owner.getInternalName() + "$$TImpl");
            }
            thisClass = JvmClassName.byType(this.mapType(receiver.getDefaultType()));
        } else {
            throw new UnsupportedOperationException("unknown function parent");
        }
        ReceiverParameterDescriptor receiverParameter = functionDescriptor.getOriginal().getReceiverParameter();
        Type receiverParameterType = receiverParameter != null ? this.mapType(receiverParameter.getType()) : null;
        return new CallableMethod(owner, ownerForDefaultImpl, ownerForDefaultParam, descriptor, invokeOpcode, thisClass, receiverParameterType, null);
    }

    public static boolean isAccessor(@NotNull CallableMemberDescriptor descriptor) {
        return descriptor instanceof AccessorForFunctionDescriptor || descriptor instanceof AccessorForPropertyDescriptor || descriptor instanceof AccessorForPropertyDescriptor.Getter || descriptor instanceof AccessorForPropertyDescriptor.Setter;
    }

    @NotNull
    private static FunctionDescriptor findAnyDeclaration(@NotNull FunctionDescriptor function) {
        if (function.getKind() == CallableMemberDescriptor.Kind.DECLARATION) {
            return function;
        }
        return JetTypeMapper.findBaseDeclaration(function);
    }

    @NotNull
    private static FunctionDescriptor findBaseDeclaration(@NotNull FunctionDescriptor function) {
        if (function.getOverriddenDescriptors().isEmpty()) {
            return function;
        }
        return JetTypeMapper.findBaseDeclaration(function.getOverriddenDescriptors().iterator().next());
    }

    @NotNull
    public JvmMethodSignature mapSignature(@NotNull FunctionDescriptor f, boolean needGenericSignature, @NotNull OwnerKind kind) {
        String name = f.getName().asString();
        if (f instanceof PropertyAccessorDescriptor) {
            boolean isGetter = f instanceof PropertyGetterDescriptor;
            name = JetTypeMapper.getPropertyAccessorName(((PropertyAccessorDescriptor)f).getCorrespondingProperty(), isGetter);
        }
        return this.mapSignature(name, f, needGenericSignature, kind);
    }

    @NotNull
    public JvmMethodSignature mapSignature(@NotNull Name functionName, @NotNull FunctionDescriptor f) {
        return this.mapSignature(functionName.asString(), f, false, OwnerKind.IMPLEMENTATION);
    }

    @NotNull
    public JvmMethodSignature mapSignature(@NotNull FunctionDescriptor f) {
        return this.mapSignature(f.getName(), f);
    }

    @NotNull
    private JvmMethodSignature mapSignature(@NotNull String methodName, @NotNull FunctionDescriptor f, boolean needGenericSignature, @NotNull OwnerKind kind) {
        if (kind == OwnerKind.TRAIT_IMPL) {
            needGenericSignature = false;
        }
        BothSignatureWriter signatureVisitor = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, needGenericSignature);
        this.writeFormalTypeParameters(f.getTypeParameters(), signatureVisitor);
        signatureVisitor.writeParametersStart();
        this.writeThisIfNeeded(f, kind, signatureVisitor);
        this.writeReceiverIfNeeded(f.getReceiverParameter(), signatureVisitor);
        for (ValueParameterDescriptor parameter : f.getValueParameters()) {
            this.writeParameter(signatureVisitor, parameter.getType());
        }
        signatureVisitor.writeParametersEnd();
        if (f instanceof ConstructorDescriptor) {
            signatureVisitor.writeVoidReturn();
        } else {
            signatureVisitor.writeReturnType();
            JetType returnType = f.getReturnType();
            assert (returnType != null) : "Function " + f + " has no return type";
            this.mapReturnType(returnType, signatureVisitor);
            signatureVisitor.writeReturnTypeEnd();
        }
        return signatureVisitor.makeJvmMethodSignature(methodName);
    }

    @Nullable
    public String mapFieldSignature(@NotNull JetType backingFieldType) {
        BothSignatureWriter signatureVisitor = new BothSignatureWriter(BothSignatureWriter.Mode.TYPE, true);
        signatureVisitor.writeFieldTypeStart();
        this.mapType(backingFieldType, signatureVisitor, JetTypeMapperMode.VALUE);
        signatureVisitor.writeFieldTypeEnd();
        return signatureVisitor.makeJavaGenericSignature();
    }

    private void writeThisIfNeeded(@NotNull CallableMemberDescriptor descriptor, @NotNull OwnerKind kind, @NotNull BothSignatureWriter signatureVisitor) {
        if (kind == OwnerKind.TRAIT_IMPL) {
            ClassDescriptor containingDeclaration = (ClassDescriptor)descriptor.getContainingDeclaration();
            Type type = AsmUtil.getTraitImplThisParameterType(containingDeclaration, this);
            signatureVisitor.writeParameterType(JvmMethodParameterKind.THIS);
            signatureVisitor.writeAsmType(type, false);
            signatureVisitor.writeParameterTypeEnd();
        } else {
            this.writeThisForAccessorIfNeeded(descriptor, signatureVisitor);
        }
    }

    private void writeThisForAccessorIfNeeded(@NotNull CallableMemberDescriptor descriptor, @NotNull BothSignatureWriter signatureVisitor) {
        if (JetTypeMapper.isAccessor(descriptor) && descriptor.getExpectedThisObject() != null) {
            signatureVisitor.writeParameterType(JvmMethodParameterKind.THIS);
            this.mapType(((ClassifierDescriptor)descriptor.getContainingDeclaration()).getDefaultType(), signatureVisitor, JetTypeMapperMode.VALUE);
            signatureVisitor.writeParameterTypeEnd();
        }
    }

    public void writeFormalTypeParameters(List<TypeParameterDescriptor> typeParameters, BothSignatureWriter signatureVisitor) {
        if (signatureVisitor == null) {
            return;
        }
        signatureVisitor.writeFormalTypeParametersStart();
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
            this.writeFormalTypeParameter(typeParameterDescriptor, signatureVisitor);
        }
        signatureVisitor.writeFormalTypeParametersEnd();
    }

    private void writeFormalTypeParameter(TypeParameterDescriptor typeParameterDescriptor, BothSignatureWriter signatureVisitor) {
        signatureVisitor.writeFormalTypeParameter(typeParameterDescriptor.getName().asString(), typeParameterDescriptor.getVariance(), typeParameterDescriptor.isReified());
        signatureVisitor.writeClassBound();
        for (JetType jetType : typeParameterDescriptor.getUpperBounds()) {
            if (!(jetType.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) || CodegenUtil.isInterface(jetType)) continue;
            this.mapType(jetType, signatureVisitor, JetTypeMapperMode.TYPE_PARAMETER);
            break;
        }
        signatureVisitor.writeClassBoundEnd();
        for (JetType jetType : typeParameterDescriptor.getUpperBounds()) {
            if (jetType.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor && CodegenUtil.isInterface(jetType)) {
                signatureVisitor.writeInterfaceBound();
                this.mapType(jetType, signatureVisitor, JetTypeMapperMode.TYPE_PARAMETER);
                signatureVisitor.writeInterfaceBoundEnd();
            }
            if (!(jetType.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor)) continue;
            signatureVisitor.writeInterfaceBound();
            this.mapType(jetType, signatureVisitor, JetTypeMapperMode.TYPE_PARAMETER);
            signatureVisitor.writeInterfaceBoundEnd();
        }
        signatureVisitor.writeFormalTypeParameterEnd();
    }

    private void writeReceiverIfNeeded(@Nullable ReceiverParameterDescriptor receiver, BothSignatureWriter signatureWriter) {
        if (receiver != null) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.RECEIVER);
            this.mapType(receiver.getType(), signatureWriter, JetTypeMapperMode.VALUE);
            signatureWriter.writeParameterTypeEnd();
        }
    }

    @NotNull
    public static String getPropertyAccessorName(@NotNull PropertyDescriptor descriptor, boolean isGetter) {
        boolean isAnnotation;
        DeclarationDescriptor parentDescriptor = descriptor.getContainingDeclaration();
        boolean bl = isAnnotation = parentDescriptor instanceof ClassDescriptor && ((ClassDescriptor)parentDescriptor).getKind() == ClassKind.ANNOTATION_CLASS;
        return isAnnotation ? descriptor.getName().asString() : (isGetter ? PropertyCodegen.getterName(descriptor.getName()) : PropertyCodegen.setterName(descriptor.getName()));
    }

    @NotNull
    public JvmPropertyAccessorSignature mapGetterSignature(PropertyDescriptor descriptor, OwnerKind kind) {
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, true);
        this.writeFormalTypeParameters(descriptor.getTypeParameters(), signatureWriter);
        signatureWriter.writeParametersStart();
        this.writeThisIfNeeded(descriptor, kind, signatureWriter);
        this.writeReceiverIfNeeded(descriptor.getReceiverParameter(), signatureWriter);
        signatureWriter.writeParametersEnd();
        signatureWriter.writeReturnType();
        this.mapType(descriptor.getType(), signatureWriter, JetTypeMapperMode.VALUE, Variance.OUT_VARIANCE);
        signatureWriter.writeReturnTypeEnd();
        String name = JetTypeMapper.getPropertyAccessorName(descriptor, true);
        return signatureWriter.makeJvmPropertyAccessorSignature(name, true);
    }

    @NotNull
    public JvmPropertyAccessorSignature mapSetterSignature(PropertyDescriptor descriptor, OwnerKind kind) {
        assert (descriptor.isVar());
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, true);
        this.writeFormalTypeParameters(descriptor.getTypeParameters(), signatureWriter);
        signatureWriter.writeParametersStart();
        this.writeThisIfNeeded(descriptor, kind, signatureWriter);
        this.writeReceiverIfNeeded(descriptor.getReceiverParameter(), signatureWriter);
        this.writeParameter(signatureWriter, descriptor.getType());
        signatureWriter.writeParametersEnd();
        signatureWriter.writeVoidReturn();
        String name = JetTypeMapper.getPropertyAccessorName(descriptor, false);
        return signatureWriter.makeJvmPropertyAccessorSignature(name, false);
    }

    private void writeParameter(@NotNull BothSignatureWriter signatureWriter, @NotNull JetType outType) {
        signatureWriter.writeParameterType(JvmMethodParameterKind.VALUE);
        this.mapType(outType, signatureWriter, JetTypeMapperMode.VALUE);
        signatureWriter.writeParameterTypeEnd();
    }

    @NotNull
    public JvmMethodSignature mapConstructorSignature(@NotNull ConstructorDescriptor descriptor) {
        return this.mapConstructorSignature(descriptor, this.bindingContext.get(CodegenBinding.CLOSURE, descriptor.getContainingDeclaration()));
    }

    @NotNull
    public JvmMethodSignature mapConstructorSignature(@NotNull ConstructorDescriptor descriptor, @Nullable CalculatedClosure closure) {
        ClassifierDescriptor captureReceiver;
        ClassDescriptor captureThis;
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, true);
        this.writeFormalTypeParameters(Collections.<TypeParameterDescriptor>emptyList(), signatureWriter);
        signatureWriter.writeParametersStart();
        ClassDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        ClassDescriptor classDescriptor = captureThis = closure != null ? closure.getCaptureThis() : null;
        if (captureThis != null) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.OUTER);
            this.mapType(captureThis.getDefaultType(), signatureWriter, JetTypeMapperMode.VALUE);
            signatureWriter.writeParameterTypeEnd();
        }
        ClassifierDescriptor classifierDescriptor = captureReceiver = closure != null ? closure.getCaptureReceiver() : null;
        if (captureReceiver != null) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.RECEIVER);
            this.mapType(captureReceiver.getDefaultType(), signatureWriter, JetTypeMapperMode.VALUE);
            signatureWriter.writeParameterTypeEnd();
        }
        if (containingDeclaration.getKind() == ClassKind.ENUM_CLASS || containingDeclaration.getKind() == ClassKind.ENUM_ENTRY) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.ENUM_NAME);
            this.mapType(KotlinBuiltIns.getInstance().getStringType(), signatureWriter, JetTypeMapperMode.VALUE);
            signatureWriter.writeParameterTypeEnd();
            signatureWriter.writeParameterType(JvmMethodParameterKind.ENUM_ORDINAL);
            this.mapType(KotlinBuiltIns.getInstance().getIntType(), signatureWriter, JetTypeMapperMode.VALUE);
            signatureWriter.writeParameterTypeEnd();
        }
        if (closure != null) {
            DeclarationDescriptor declarationDescriptor;
            for (Map.Entry entry : closure.getCaptureVariables().entrySet()) {
                DeclarationDescriptor variableDescriptor = (DeclarationDescriptor)entry.getKey();
                Type type = null;
                if (variableDescriptor instanceof VariableDescriptor && !(variableDescriptor instanceof PropertyDescriptor)) {
                    Type sharedVarType = this.getSharedVarType(variableDescriptor);
                    if (sharedVarType == null) {
                        sharedVarType = this.mapType(((VariableDescriptor)variableDescriptor).getType());
                    }
                    type = sharedVarType;
                } else if (CodegenBinding.isLocalNamedFun(variableDescriptor)) {
                    type = CodegenBinding.classNameForAnonymousClass(this.bindingContext, (FunctionDescriptor)variableDescriptor).getAsmType();
                }
                if (type == null) continue;
                signatureWriter.writeParameterType(JvmMethodParameterKind.SHARED_VAR);
                signatureWriter.writeAsmType(type, false);
                signatureWriter.writeParameterTypeEnd();
            }
            JetDelegatorToSuperCall superCall = closure.getSuperCall();
            if (superCall != null && (declarationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, superCall.getCalleeExpression().getConstructorReferenceExpression())) instanceof ConstructorDescriptor) {
                List<JvmMethodParameterSignature> types;
                ConstructorDescriptor superConstructor = (ConstructorDescriptor)declarationDescriptor;
                if (CodegenBinding.isObjectLiteral(this.bindingContext, descriptor.getContainingDeclaration()) && (types = this.mapConstructorSignature(superConstructor).getKotlinParameterTypes()) != null) {
                    for (JvmMethodParameterSignature type : types) {
                        signatureWriter.writeParameterType(JvmMethodParameterKind.SUPER_CALL_PARAM);
                        signatureWriter.writeAsmType(type.getAsmType(), false);
                        signatureWriter.writeParameterTypeEnd();
                    }
                }
            }
        }
        for (ValueParameterDescriptor valueParameterDescriptor : descriptor.getOriginal().getValueParameters()) {
            this.writeParameter(signatureWriter, valueParameterDescriptor.getType());
        }
        signatureWriter.writeParametersEnd();
        signatureWriter.writeVoidReturn();
        return signatureWriter.makeJvmMethodSignature("<init>");
    }

    @NotNull
    public JvmMethodSignature mapScriptSignature(@NotNull ScriptDescriptor script, @NotNull List<ScriptDescriptor> importedScripts) {
        BothSignatureWriter signatureWriter = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD, false);
        this.writeFormalTypeParameters(Collections.<TypeParameterDescriptor>emptyList(), signatureWriter);
        signatureWriter.writeParametersStart();
        for (ScriptDescriptor importedScript : importedScripts) {
            signatureWriter.writeParameterType(JvmMethodParameterKind.VALUE);
            ClassDescriptor descriptor = this.bindingContext.get(CodegenBinding.CLASS_FOR_SCRIPT, importedScript);
            assert (descriptor != null);
            this.mapType(descriptor.getDefaultType(), signatureWriter, JetTypeMapperMode.VALUE);
            signatureWriter.writeParameterTypeEnd();
        }
        for (ValueParameterDescriptor valueParameter : script.getValueParameters()) {
            this.writeParameter(signatureWriter, valueParameter.getType());
        }
        signatureWriter.writeParametersEnd();
        signatureWriter.writeVoidReturn();
        return signatureWriter.makeJvmMethodSignature("<init>");
    }

    @NotNull
    public CallableMethod mapToCallableMethod(@NotNull ConstructorDescriptor descriptor) {
        return this.mapToCallableMethod(descriptor, this.bindingContext.get(CodegenBinding.CLOSURE, descriptor.getContainingDeclaration()));
    }

    @NotNull
    public CallableMethod mapToCallableMethod(@NotNull ConstructorDescriptor descriptor, @Nullable CalculatedClosure closure) {
        JvmMethodSignature method = this.mapConstructorSignature(descriptor, closure);
        JetType defaultType = descriptor.getContainingDeclaration().getDefaultType();
        Type mapped = this.mapType(defaultType, JetTypeMapperMode.IMPL);
        if (mapped.getSort() != 10) {
            throw new IllegalStateException("type must have been mapped to object: " + defaultType + ", actual: " + mapped);
        }
        JvmClassName owner = JvmClassName.byType(mapped);
        return new CallableMethod(owner, owner, owner, method, 183, null, null, null);
    }

    private static boolean isGenericsArray(JetType type) {
        return KotlinBuiltIns.getInstance().isArray(type) && type.getArguments().get(0).getType().getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor;
    }

    public Type getSharedVarType(DeclarationDescriptor descriptor) {
        if (descriptor instanceof PropertyDescriptor) {
            return StackValue.sharedTypeForType(this.mapType(((PropertyDescriptor)descriptor).getReceiverParameter().getType()));
        }
        if (descriptor instanceof SimpleFunctionDescriptor && descriptor.getContainingDeclaration() instanceof FunctionDescriptor) {
            return CodegenBinding.classNameForAnonymousClass(this.bindingContext, (FunctionDescriptor)descriptor).getAsmType();
        }
        if (descriptor instanceof FunctionDescriptor) {
            return StackValue.sharedTypeForType(this.mapType(((FunctionDescriptor)descriptor).getReceiverParameter().getType()));
        }
        if (descriptor instanceof VariableDescriptor && CodegenBinding.isVarCapturedInClosure(this.bindingContext, descriptor)) {
            JetType outType = ((VariableDescriptor)descriptor).getType();
            return StackValue.sharedTypeForType(this.mapType(outType));
        }
        return null;
    }

    @NotNull
    public CallableMethod mapToFunctionInvokeCallableMethod(@NotNull FunctionDescriptor fd) {
        JvmMethodSignature descriptor = CodegenUtil.erasedInvokeSignature(fd);
        JvmClassName owner = FunctionTypesUtil.getFunctionTraitClassName(fd);
        ReceiverParameterDescriptor receiverParameter = fd.getOriginal().getReceiverParameter();
        Type receiverParameterType = receiverParameter != null ? this.mapType(receiverParameter.getType()) : null;
        return new CallableMethod(owner, null, null, descriptor, 185, owner, receiverParameterType, owner.getAsmType());
    }

    @NotNull
    public Type expressionType(JetExpression expr) {
        JetType type = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, expr);
        return this.asmTypeOrVoid(type);
    }

    @NotNull
    private Type asmTypeOrVoid(@Nullable JetType type) {
        return type == null ? Type.VOID_TYPE : this.mapType(type);
    }
}

