/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;

public class CompilationException
extends RuntimeException {
    private final PsiElement element;

    public CompilationException(@NotNull String message, @Nullable Throwable cause, @NotNull PsiElement element) {
        super(message, cause);
        this.element = element;
    }

    @NotNull
    public PsiElement getElement() {
        return this.element;
    }

    private String where() {
        Throwable cause = this.getCause();
        Throwable throwable = cause != null ? cause : this;
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        if (stackTrace != null && stackTrace.length > 0) {
            return stackTrace[0].getFileName() + ":" + stackTrace[0].getLineNumber();
        }
        return "unknown";
    }

    @Override
    public String getMessage() {
        return ApplicationManager.getApplication().runReadAction(new Computable<String>(){

            @Override
            public String compute() {
                StringBuilder message = new StringBuilder("Back-end (JVM) Internal error: ").append(CompilationException.super.getMessage()).append("\n");
                Throwable cause = CompilationException.this.getCause();
                if (cause != null) {
                    String causeMessage = cause.getMessage();
                    message.append("Cause: ").append(causeMessage == null ? cause.toString() : causeMessage).append("\n");
                }
                message.append("File being compiled and position: ").append(DiagnosticUtils.atLocation(CompilationException.this.element)).append("\n");
                message.append("PsiElement: ").append(CompilationException.this.element.getText()).append("\n");
                message.append("The root cause was thrown at: ").append(CompilationException.this.where());
                return message.toString();
            }
        });
    }
}

