/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class StringRef {
    public static final StringRef[] EMPTY_ARRAY = new StringRef[0];
    private int id;
    private String name;
    private final AbstractStringEnumerator store;

    private StringRef(String name) {
        this.name = name;
        this.id = -1;
        this.store = null;
    }

    private StringRef(int id, AbstractStringEnumerator store) {
        this.id = id;
        this.store = store;
        this.name = null;
    }

    public String getString() {
        String name = this.name;
        if (name == null) {
            try {
                this.name = name = this.store.valueOf(this.id);
            }
            catch (IOException e) {
                this.store.markCorrupted();
                throw new RuntimeException(e);
            }
        }
        return name;
    }

    public String toString() {
        return this.getString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object that) {
        return that == this || that instanceof StringRef && this.toString().equals(that.toString());
    }

    public static String toString(@Nullable StringRef ref) {
        return ref != null ? ref.getString() : null;
    }

    public static StringRef fromString(@Nullable String source) {
        return source == null ? null : new StringRef(source);
    }

    public static StringRef fromStream(DataInput in, AbstractStringEnumerator store) throws IOException {
        int nameId = DataInputOutputUtil.readINT(in);
        return nameId != 0 ? new StringRef(nameId, store) : null;
    }

    public static StringRef[] createArray(int count) {
        return count == 0 ? EMPTY_ARRAY : new StringRef[count];
    }
}

