/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.util.ArrayFactory;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.LockFreeCopyOnWriteArrayList;
import com.intellij.util.containers.SequenceIterator;
import com.intellij.util.containers.Stack;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerUtil
extends ContainerUtilRt {
    @NotNull
    public static <K, V> HashMap<K, V> newHashMap() {
        HashMap hashMap = ContainerUtilRt.newHashMap();
        if (hashMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.newHashMap must not return null");
        }
        return hashMap;
    }

    @NotNull
    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        TreeMap treeMap = ContainerUtilRt.newTreeMap();
        if (treeMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.newTreeMap must not return null");
        }
        return treeMap;
    }

    @NotNull
    public static <T> TObjectHashingStrategy<T> canonicalStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.CANONICAL;
        if (tObjectHashingStrategy == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.canonicalStrategy must not return null");
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    public static <T> TObjectHashingStrategy<T> identityStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.IDENTITY;
        if (tObjectHashingStrategy == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.identityStrategy must not return null");
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    public static <T> ArrayList<T> newArrayList() {
        ArrayList arrayList = ContainerUtilRt.newArrayList();
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.newArrayList must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static <E> ArrayList<E> newArrayList(@NotNull Iterable<? extends E> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.newArrayList must not be null");
        }
        ArrayList<? extends E> arrayList = ContainerUtilRt.newArrayList(iterable);
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.newArrayList must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static <T> ArrayList<T> newArrayListWithExpectedSize(int size) {
        ArrayList arrayList = ContainerUtilRt.newArrayListWithExpectedSize(size);
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.newArrayListWithExpectedSize must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        ArrayList arrayList = ContainerUtilRt.newArrayListWithCapacity(size);
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.newArrayListWithCapacity must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static <T> List<T> newArrayList(final @NotNull T[] elements, final int start, final int end) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.newArrayList must not be null");
        }
        if (start < 0 || start > end || end > elements.length) {
            throw new IllegalArgumentException("start:" + start + " end:" + end + " length:" + elements.length);
        }
        AbstractList abstractList = new AbstractList<T>(){
            private final int size;
            {
                this.size = end - start;
            }

            @Override
            public T get(int index) {
                if (index < 0 || index >= this.size) {
                    throw new IndexOutOfBoundsException("index:" + index + " size:" + this.size);
                }
                return elements[start + index];
            }

            @Override
            public int size() {
                return this.size;
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.newArrayList must not return null");
        }
        return abstractList;
    }

    @NotNull
    public static <T> HashSet<T> newHashSet() {
        HashSet hashSet = ContainerUtilRt.newHashSet();
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.newHashSet must not return null");
        }
        return hashSet;
    }

    @NotNull
    public static <T> HashSet<T> newHashSet(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.newHashSet must not be null");
        }
        HashSet<T> hashSet = ContainerUtilRt.newHashSet(elements);
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.newHashSet must not return null");
        }
        return hashSet;
    }

    @NotNull
    public static <T> THashSet<T> newTroveSet(T ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.newTroveSet must not be null");
        }
        THashSet<T> tHashSet = ContainerUtil.newTroveSet(Arrays.asList(elements));
        if (tHashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.newTroveSet must not return null");
        }
        return tHashSet;
    }

    @NotNull
    public static <T> THashSet<T> newTroveSet(@NotNull Collection<T> elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.newTroveSet must not be null");
        }
        THashSet<T> tHashSet = new THashSet<T>(elements);
        if (tHashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.newTroveSet must not return null");
        }
        return tHashSet;
    }

    @NotNull
    public static <K> THashSet<K> newIdentityTroveSet() {
        THashSet tHashSet = new THashSet(ContainerUtil.identityStrategy());
        if (tHashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.newIdentityTroveSet must not return null");
        }
        return tHashSet;
    }

    @NotNull
    public static <K, V> THashMap<K, V> newIdentityTroveMap() {
        THashMap tHashMap = new THashMap(ContainerUtil.identityStrategy());
        if (tHashMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.newIdentityTroveMap must not return null");
        }
        return tHashMap;
    }

    @NotNull
    public static <E> List<E> reverse(final @NotNull List<E> elements) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.reverse must not be null");
        }
        AbstractList abstractList = new AbstractList<E>(){

            @Override
            public E get(int index) {
                return elements.get(elements.size() - 1 - index);
            }

            @Override
            public int size() {
                return elements.size();
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.reverse must not return null");
        }
        return abstractList;
    }

    public static <T> void addAll(@NotNull Collection<T> collection, @NotNull Iterable<? extends T> appendix) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.addAll must not be null");
        }
        if (appendix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.addAll must not be null");
        }
        ContainerUtil.addAll(collection, appendix.iterator());
    }

    public static <T> void addAll(@NotNull Collection<T> collection, @NotNull Iterator<? extends T> iterator) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.addAll must not be null");
        }
        if (iterator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.addAll must not be null");
        }
        while (iterator.hasNext()) {
            T o = iterator.next();
            collection.add(o);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <T> List<T> collect(@NotNull Iterator<T> iterator) {
        List list;
        if (iterator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.collect must not be null");
        }
        if (!iterator.hasNext()) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.collect must not return null");
            return list;
        }
        ArrayList list2 = new ArrayList();
        ContainerUtil.addAll(list2, iterator);
        list = list2;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.collect must not return null");
    }

    public static <T> boolean process(@NotNull Iterable<? extends T> iterable, @NotNull Processor<T> processor) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.process must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.process must not be null");
        }
        for (T t : iterable) {
            if (processor.process(t)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static <T, V extends T> V find(@NotNull Iterable<V> iterable, @NotNull Condition<T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.find must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.find must not be null");
        }
        return ContainerUtil.find(iterable.iterator(), condition);
    }

    @Nullable
    public static <T, V extends T> V find(@NotNull Iterator<V> iterator, @NotNull Condition<T> condition) {
        if (iterator == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.find must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.find must not be null");
        }
        while (iterator.hasNext()) {
            V value = iterator.next();
            if (!condition.value(value)) continue;
            return value;
        }
        return null;
    }

    @NotNull
    public static <T, V> V[] map2Array(@NotNull T[] array, @NotNull Class<? extends V> aClass, @NotNull Function<T, V> mapper) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        V[] VArray = ContainerUtil.map2Array(Arrays.asList(array), aClass, mapper);
        if (VArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.map2Array must not return null");
        }
        return VArray;
    }

    @NotNull
    public static <T, V> V[] map2Array(@NotNull Collection<? extends T> collection, @NotNull Class<? extends V> aClass, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        List<V> list = ContainerUtil.map2List(collection, mapper);
        Object[] objectArray = list.toArray((Object[])Array.newInstance(aClass, list.size()));
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.map2Array must not return null");
        }
        return objectArray;
    }

    @NotNull
    public static <T, V> V[] map2Array(@NotNull Collection<? extends T> collection, @NotNull V[] to, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2Array must not be null");
        }
        V[] VArray = ContainerUtil.map2List(collection, mapper).toArray(to);
        if (VArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.map2Array must not return null");
        }
        return VArray;
    }

    @NotNull
    public static <T> List<T> findAll(@NotNull T[] collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findAll must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findAll must not be null");
        }
        SmartList<T> result = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result.add(t);
        }
        SmartList<T> smartList = result;
        if (smartList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.findAll must not return null");
        }
        return smartList;
    }

    @NotNull
    public static <T> List<T> filter(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.filter must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.filter must not be null");
        }
        List<? super T> list = ContainerUtil.findAll(collection, condition);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.filter must not return null");
        }
        return list;
    }

    @NotNull
    public static <T> List<T> findAll(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findAll must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.findAll must not be null");
        }
        SmartList<T> result = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result.add(t);
        }
        SmartList<T> smartList = result;
        if (smartList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.findAll must not return null");
        }
        return smartList;
    }

    public static <E> void swapElements(@NotNull List<E> list, int index1, int index2) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.swapElements must not be null");
        }
        E e1 = list.get(index1);
        E e2 = list.get(index2);
        list.set(index1, e2);
        list.set(index2, e1);
    }

    @NotNull
    public static <T, A extends T, C extends Collection<T>> C addAll(@NotNull C collection, A ... elements) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.addAll must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.addAll must not be null");
        }
        for (A element : elements) {
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.addAll must not return null");
        }
        return c;
    }

    @NotNull
    public static <T> List<T> concat(final @NotNull List<? extends T> list1, final @NotNull List<? extends T> list2) {
        if (list1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concat must not be null");
        }
        if (list2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concat must not be null");
        }
        final int size1 = list1.size();
        final int size = size1 + list2.size();
        AbstractList abstractList = new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index < size1) {
                    return list1.get(index);
                }
                return list2.get(index - size1);
            }

            @Override
            public int size() {
                return size;
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.concat must not return null");
        }
        return abstractList;
    }

    @NotNull
    public static <T> Iterable<T> concat(final Iterable<? extends T> ... iterables) {
        if (iterables == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concat must not be null");
        }
        Iterable iterable = new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                Iterator[] iterators = new Iterator[iterables.length];
                for (Iterable iterable : iterables) {
                    iterators[i] = iterable.iterator();
                }
                return ContainerUtil.concatIterators(iterators);
            }
        };
        if (iterable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.concat must not return null");
        }
        return iterable;
    }

    @NotNull
    public static <T> Iterator<T> concatIterators(Iterator<T> ... iterators) {
        if (iterators == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concatIterators must not be null");
        }
        SequenceIterator<T> sequenceIterator = new SequenceIterator<T>(iterators);
        if (sequenceIterator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.concatIterators must not return null");
        }
        return sequenceIterator;
    }

    @NotNull
    public static <T> Iterable<T> concat(final T[] ... iterables) {
        if (iterables == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.concat must not be null");
        }
        Iterable iterable = new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                Iterator[] iterators = new Iterator[iterables.length];
                for (Object[] iterable : iterables) {
                    iterators[i] = Arrays.asList(iterable).iterator();
                }
                return ContainerUtil.concatIterators(iterators);
            }
        };
        if (iterable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.concat must not return null");
        }
        return iterable;
    }

    @NotNull
    public static <T> T[] toArray(@Nullable Collection<T> c, @NotNull ArrayFactory<T> factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.toArray must not be null");
        }
        T[] TArray = c != null ? c.toArray(factory.create(c.size())) : factory.create(0);
        if (TArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.toArray must not return null");
        }
        return TArray;
    }

    @NotNull
    public static <T, V> List<V> map(@NotNull Collection<? extends T> iterable, @NotNull Function<T, V> mapping) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map must not be null");
        }
        if (mapping == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map must not be null");
        }
        ArrayList<V> result = new ArrayList<V>(iterable.size());
        for (T t : iterable) {
            result.add(mapping.fun(t));
        }
        ArrayList<V> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.map must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static <T, V> List<V> mapNotNull(@NotNull T[] array, @NotNull Function<T, V> mapping) {
        if (array == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.mapNotNull must not be null");
        }
        if (mapping == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.mapNotNull must not be null");
        }
        List<V> list = ContainerUtil.mapNotNull(Arrays.asList(array), mapping);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.mapNotNull must not return null");
        }
        return list;
    }

    @NotNull
    public static <T, V> List<V> mapNotNull(@NotNull Collection<? extends T> iterable, @NotNull Function<T, V> mapping) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.mapNotNull must not be null");
        }
        if (mapping == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.mapNotNull must not be null");
        }
        ArrayList<V> result = new ArrayList<V>(iterable.size());
        for (T t : iterable) {
            V o = mapping.fun(t);
            if (o == null) continue;
            result.add(o);
        }
        ArrayList<V> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.mapNotNull must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static <T, V> List<V> map(@NotNull T[] arr, @NotNull Function<T, V> mapping) {
        if (arr == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map must not be null");
        }
        if (mapping == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map must not be null");
        }
        ArrayList<V> result = new ArrayList<V>(arr.length);
        for (T t : arr) {
            result.add(mapping.fun(t));
        }
        ArrayList<V> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.map must not return null");
        }
        return arrayList;
    }

    public static <T, V> V getOrCreate(@NotNull Map<T, V> result, T key, @NotNull Factory<V> factory) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.getOrCreate must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.getOrCreate must not be null");
        }
        V value = result.get(key);
        if (value == null) {
            value = factory.create();
            result.put(key, value);
        }
        return value;
    }

    public static <T> boolean exists(@NotNull Iterable<T> iterable, @NotNull Condition<T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.exists must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.exists must not be null");
        }
        return ContainerUtil.or(iterable, condition);
    }

    public static <T> boolean or(@NotNull Iterable<T> iterable, @NotNull Condition<T> condition) {
        if (iterable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.or must not be null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.or must not be null");
        }
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> void quickSort(@NotNull List<T> list, @NotNull Comparator<? super T> comparator) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.quickSort must not be null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.quickSort must not be null");
        }
        ContainerUtil.quickSort(list, comparator, 0, list.size());
    }

    private static <T> void quickSort(@NotNull List<T> x, @NotNull Comparator<? super T> comparator, int off, int len) {
        int c;
        int a;
        if (x == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.quickSort must not be null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.quickSort must not be null");
        }
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comparator.compare(x.get(j), x.get(j - 1)) < 0; --j) {
                    ContainerUtil.swapElements(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ContainerUtil.med3(x, comparator, l, l + s, l + 2 * s);
                m = ContainerUtil.med3(x, comparator, m - s, m, m + s);
                n = ContainerUtil.med3(x, comparator, n - 2 * s, n - s, n);
            }
            m = ContainerUtil.med3(x, comparator, l, m, n);
        }
        T v = x.get(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && comparator.compare(x.get(b), v) <= 0) {
                if (comparator.compare(x.get(b), v) == 0) {
                    ContainerUtil.swapElements(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(v, x.get(c)) <= 0) {
                if (comparator.compare(x.get(c), v) == 0) {
                    ContainerUtil.swapElements(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ContainerUtil.swapElements(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ContainerUtil.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ContainerUtil.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            ContainerUtil.quickSort(x, comparator, off, s);
        }
        if ((s = d - c) > 1) {
            ContainerUtil.quickSort(x, comparator, n - s, s);
        }
    }

    private static <T> int med3(@NotNull List<T> x, Comparator<? super T> comparator, int a, int b, int c) {
        if (x == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.med3 must not be null");
        }
        return comparator.compare(x.get(a), x.get(b)) < 0 ? (comparator.compare(x.get(b), x.get(c)) < 0 ? b : (comparator.compare(x.get(a), x.get(c)) < 0 ? c : a)) : (comparator.compare(x.get(c), x.get(b)) < 0 ? b : (comparator.compare(x.get(c), x.get(a)) < 0 ? c : a));
    }

    private static <T> void vecswap(List<T> x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ContainerUtil.swapElements(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    @NotNull
    public static <E> List<E> flatten(@NotNull Iterable<? extends Collection<E>> collections) {
        if (collections == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.flatten must not be null");
        }
        ArrayList<E> result = new ArrayList<E>();
        for (Collection<E> list : collections) {
            result.addAll(list);
        }
        ArrayList<E> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.flatten must not return null");
        }
        return arrayList;
    }

    @NotNull
    public static <T> Stack<T> newStack() {
        Stack stack = ContainerUtilRt.newStack();
        if (stack == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.newStack must not return null");
        }
        return stack;
    }

    @NotNull
    public static <T> List<T> emptyList() {
        List list = ContainerUtilRt.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.emptyList must not return null");
        }
        return list;
    }

    @NotNull
    public static <T> CopyOnWriteArrayList<T> createEmptyCOWList() {
        CopyOnWriteArrayList copyOnWriteArrayList = ContainerUtilRt.createEmptyCOWList();
        if (copyOnWriteArrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.createEmptyCOWList must not return null");
        }
        return copyOnWriteArrayList;
    }

    @NotNull
    public static <T> List<T> createLockFreeCopyOnWriteList() {
        LockFreeCopyOnWriteArrayList lockFreeCopyOnWriteArrayList = new LockFreeCopyOnWriteArrayList();
        if (lockFreeCopyOnWriteArrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.createLockFreeCopyOnWriteList must not return null");
        }
        return lockFreeCopyOnWriteArrayList;
    }

    public static <T> void addIfNotNull(@Nullable T element, @NotNull Collection<T> result) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.addIfNotNull must not be null");
        }
        ContainerUtilRt.addIfNotNull(element, result);
    }

    public static <T> void addIfNotNull(@NotNull Collection<T> result, @Nullable T element) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.addIfNotNull must not be null");
        }
        ContainerUtilRt.addIfNotNull(result, element);
    }

    @NotNull
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<T, V> mapper) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2List must not be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.map2List must not be null");
        }
        List<V> list = ContainerUtilRt.map2List(collection, mapper);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.map2List must not return null");
        }
        return list;
    }

    @NotNull
    public static <T> T[] toArray(@NotNull Collection<T> c, @NotNull T[] sample) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.toArray must not be null");
        }
        if (sample == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.toArray must not be null");
        }
        T[] TArray = ContainerUtilRt.toArray(c, sample);
        if (TArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.toArray must not return null");
        }
        return TArray;
    }

    @NotNull
    public static <T> T[] copyAndClear(@NotNull Collection<T> collection, @NotNull ArrayFactory<T> factory, boolean clear) {
        if (collection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.copyAndClear must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ContainerUtil.copyAndClear must not be null");
        }
        int size = collection.size();
        T[] a = factory.create(size);
        if (size > 0) {
            a = collection.toArray(a);
            if (clear) {
                collection.clear();
            }
        }
        if (a == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ContainerUtil.copyAndClear must not return null");
        }
        return a;
    }
}

