/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

abstract class ConcurrentRefHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<Key<K, V>, V> myMap;
    private static final Key NULL_KEY = new Key(){

        public Object get() {
            return null;
        }

        public Object getValue() {
            return null;
        }
    };
    protected final ReferenceQueue<K> myReferenceQueue = new ReferenceQueue();
    private static final ThreadLocal<HardKey> myHardKey = new ThreadLocal<HardKey>(){

        @Override
        protected HardKey initialValue() {
            return new HardKey<Object, Object>(null, null);
        }
    };
    private Set<Map.Entry<K, V>> entrySet = null;

    protected abstract Key<K, V> createKey(@NotNull K var1, V var2);

    private void processQueue() {
        Key wk;
        while ((wk = (Key)((Object)this.myReferenceQueue.poll())) != null) {
            Object value = wk.getValue();
            this.myMap.remove(wk, value);
        }
    }

    public ConcurrentRefHashMap() {
        this.myMap = new ConcurrentHashMap<Key<K, V>, V>();
    }

    public ConcurrentRefHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, TObjectHashingStrategy<Key<K, V>> hashingStrategy) {
        this.myMap = new ConcurrentHashMap<Key<Key<K, V>, V>, V>(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return this.myMap.containsKey(NULL_KEY);
        }
        HardKey<Object, V> hardKey = ConcurrentRefHashMap.createHardKey(key);
        boolean result = this.myMap.containsKey(hardKey);
        ConcurrentRefHashMap.releaseHardKey(hardKey);
        return result;
    }

    private static <K, V> HardKey<K, V> createHardKey(K key) {
        HardKey hardKey = myHardKey.get();
        hardKey.setKey(key);
        return hardKey;
    }

    private static void releaseHardKey(HardKey key) {
        key.setKey(null);
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            return this.myMap.get(NULL_KEY);
        }
        HardKey<Object, V> hardKey = ConcurrentRefHashMap.createHardKey(key);
        Object result = this.myMap.get(hardKey);
        ConcurrentRefHashMap.releaseHardKey(hardKey);
        return result;
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        Key<K, V> weakKey = key == null ? NULL_KEY : this.createKey(key, value);
        return this.myMap.put(weakKey, value);
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        if (key == null) {
            return this.myMap.remove(NULL_KEY);
        }
        HardKey<Object, V> hardKey = ConcurrentRefHashMap.createHardKey(key);
        Object result = this.myMap.remove(hardKey);
        ConcurrentRefHashMap.releaseHardKey(hardKey);
        return result;
    }

    @Override
    public void clear() {
        this.processQueue();
        this.myMap.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public V putIfAbsent(@NotNull K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentRefHashMap.putIfAbsent must not be null");
        }
        this.processQueue();
        return this.myMap.putIfAbsent(this.createKey(key, value), value);
    }

    @Override
    public boolean remove(@NotNull Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentRefHashMap.remove must not be null");
        }
        this.processQueue();
        return this.myMap.remove(this.createKey(key, value), value);
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentRefHashMap.replace must not be null");
        }
        if (oldValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ConcurrentRefHashMap.replace must not be null");
        }
        if (newValue == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ConcurrentRefHashMap.replace must not be null");
        }
        this.processQueue();
        return this.myMap.replace(this.createKey(key, oldValue), oldValue, newValue);
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentRefHashMap.replace must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ConcurrentRefHashMap.replace must not be null");
        }
        this.processQueue();
        return this.myMap.replace(this.createKey(key, value), value);
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        Set<Map.Entry<Key<K, V>, V>> hashEntrySet;

        private EntrySet() {
            this.hashEntrySet = ConcurrentRefHashMap.this.myMap.entrySet();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                Iterator<Map.Entry<Key<K, V>, V>> hashIterator;
                Entry<K, V> next;
                {
                    this.hashIterator = EntrySet.this.hashEntrySet.iterator();
                    this.next = null;
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = this.hashIterator.next();
                        Key wk = ent.getKey();
                        Object k = null;
                        if (wk != null) {
                            Object k2 = wk.get();
                            k = k2;
                            if (k2 == null) continue;
                        }
                        this.next = new Entry(ent, k);
                        return true;
                    }
                    return false;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Entry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        @Override
        public boolean remove(Object o) {
            boolean toRemove;
            ConcurrentRefHashMap.this.processQueue();
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object ev = e.getValue();
            HardKey key = ConcurrentRefHashMap.createHardKey(o);
            Object hv = ConcurrentRefHashMap.this.myMap.get(key);
            boolean bl = hv == null ? ev == null && ConcurrentRefHashMap.this.myMap.containsKey(key) : (toRemove = hv.equals(ev));
            if (toRemove) {
                ConcurrentRefHashMap.this.myMap.remove(key);
            }
            ConcurrentRefHashMap.releaseHardKey(key);
            return toRemove;
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Map.Entry entry : this.hashEntrySet) {
                Object v;
                Map.Entry ent = entry;
                Key wk = ent.getKey();
                if (wk == null) continue;
                h += wk.hashCode() ^ ((v = ent.getValue()) == null ? 0 : v.hashCode());
            }
            return h;
        }
    }

    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<?, V> ent;
        private final K key;

        Entry(Map.Entry<?, V> ent, K key) {
            this.ent = ent;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.ent.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.ent.setValue(value);
        }

        private static boolean valEquals(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Entry.valEquals(this.key, e.getKey()) && Entry.valEquals(this.getValue(), e.getValue());
        }

        @Override
        public int hashCode() {
            V v = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }
    }

    private static class HardKey<K, V>
    implements Key<K, V> {
        private K myKey;
        private int myHash;
        private final V value;

        public HardKey(K key, V value) {
            this.value = value;
            this.setKey(key);
        }

        private void setKey(K key) {
            this.myKey = key;
            this.myHash = key != null ? key.hashCode() : 0;
        }

        @Override
        public K get() {
            return this.myKey;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            K t = this.get();
            Object u = ((Key)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.myHash;
        }
    }

    public static interface Key<K, V> {
        public K get();

        public V getValue();
    }
}

