/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InheritanceUtil {
    private InheritanceUtil() {
    }

    public static boolean isInheritor(@NotNull PsiClass candidateClass, @NotNull PsiClass baseClass, boolean checkDeep) {
        if (candidateClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.isInheritor must not be null");
        }
        if (baseClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.isInheritor must not be null");
        }
        return candidateClass.isInheritor(baseClass, checkDeep);
    }

    public static boolean isInheritorOrSelf(@Nullable PsiClass aClass, @Nullable PsiClass baseClass, boolean checkDeep) {
        if (aClass == null || baseClass == null) {
            return false;
        }
        PsiManager manager = aClass.getManager();
        return manager.areElementsEquivalent(baseClass, aClass) || aClass.isInheritor(baseClass, checkDeep);
    }

    public static boolean isCorrectDescendant(@Nullable PsiClass aClass, @Nullable PsiClass baseClass, boolean checkDeep) {
        return InheritanceUtil.isInheritorOrSelf(aClass, baseClass, checkDeep);
    }

    public static boolean processSupers(@Nullable PsiClass aClass, boolean includeSelf, @NotNull Processor<PsiClass> superProcessor) {
        if (superProcessor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.processSupers must not be null");
        }
        if (aClass == null) {
            return true;
        }
        if (includeSelf && !superProcessor.process(aClass)) {
            return false;
        }
        return InheritanceUtil.processSupers(aClass, superProcessor, new THashSet<PsiClass>());
    }

    private static boolean processSupers(@NotNull PsiClass aClass, @NotNull Processor<PsiClass> superProcessor, @NotNull Set<PsiClass> visited) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.processSupers must not be null");
        }
        if (superProcessor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.processSupers must not be null");
        }
        if (visited == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.processSupers must not be null");
        }
        if (!visited.add(aClass)) {
            return true;
        }
        for (PsiClass intf : aClass.getInterfaces()) {
            if (superProcessor.process(intf) && InheritanceUtil.processSupers(intf, superProcessor, visited)) continue;
            return false;
        }
        PsiClass superClass = aClass.getSuperClass();
        return superClass == null || superProcessor.process(superClass) && InheritanceUtil.processSupers(superClass, superProcessor, visited);
    }

    public static boolean isInheritor(@Nullable PsiType type, @NotNull @NonNls String baseClassName) {
        if (baseClassName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.isInheritor must not be null");
        }
        if (type instanceof PsiClassType) {
            return InheritanceUtil.isInheritor(((PsiClassType)type).resolve(), baseClassName);
        }
        return false;
    }

    public static boolean isInheritor(@Nullable PsiClass psiClass, @NotNull String baseClassName) {
        if (baseClassName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.isInheritor must not be null");
        }
        return InheritanceUtil.isInheritor(psiClass, false, baseClassName);
    }

    public static boolean isInheritor(@Nullable PsiClass psiClass, boolean strict, @NotNull String baseClassName) {
        if (baseClassName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.isInheritor must not be null");
        }
        if (psiClass == null) {
            return false;
        }
        PsiClass base = JavaPsiFacade.getInstance(psiClass.getProject()).findClass(baseClassName, psiClass.getResolveScope());
        if (base == null) {
            return false;
        }
        return strict ? psiClass.isInheritor(base, true) : InheritanceUtil.isInheritorOrSelf(psiClass, base, true);
    }

    public static void getSuperClasses(@NotNull PsiClass aClass, @NotNull Set<PsiClass> results, boolean includeNonProject) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.getSuperClasses must not be null");
        }
        if (results == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.getSuperClasses must not be null");
        }
        InheritanceUtil.getSuperClassesOfList(aClass.getSuperTypes(), results, includeNonProject, new THashSet<PsiClass>(), aClass.getManager());
    }

    public static LinkedHashSet<PsiClass> getSuperClasses(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.getSuperClasses must not be null");
        }
        LinkedHashSet<PsiClass> result = new LinkedHashSet<PsiClass>();
        InheritanceUtil.getSuperClasses(aClass, result, true);
        return result;
    }

    private static void getSuperClassesOfList(@NotNull PsiClassType[] types, @NotNull Set<PsiClass> results, boolean includeNonProject, @NotNull Set<PsiClass> visited, @NotNull PsiManager manager) {
        if (types == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.getSuperClassesOfList must not be null");
        }
        if (results == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.getSuperClassesOfList must not be null");
        }
        if (visited == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.getSuperClassesOfList must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/psi/util/InheritanceUtil.getSuperClassesOfList must not be null");
        }
        for (PsiClassType type : types) {
            PsiClass resolved = type.resolve();
            if (resolved == null || !visited.add(resolved)) continue;
            if (includeNonProject || manager.isInProject(resolved)) {
                results.add(resolved);
            }
            InheritanceUtil.getSuperClassesOfList(resolved.getSuperTypes(), results, includeNonProject, visited, manager);
        }
    }
}

