/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContextUtil {
    public static final Key<SmartPsiElementPointer> INJECTED_IN_ELEMENT = Key.create("injectedIn");
    public static final Key<PsiFile> CONTAINING_FILE_KEY = Key.create("CONTAINING_FILE_KEY");

    private FileContextUtil() {
    }

    @Nullable
    public static PsiElement getFileContext(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/FileContextUtil.getFileContext must not be null");
        }
        SmartPsiElementPointer pointer = file.getUserData(INJECTED_IN_ELEMENT);
        return pointer == null ? null : (PsiElement)pointer.getElement();
    }

    @Nullable
    public static PsiFile getContextFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/FileContextUtil.getContextFile must not be null");
        }
        if (!element.isValid()) {
            return null;
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return null;
        }
        PsiElement context = file.getContext();
        if (context == null) {
            return file;
        }
        return FileContextUtil.getContextFile(context);
    }
}

