/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.source.ClassInnerStuffCache;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassImpl
extends JavaStubPsiElement<PsiClassStub<?>>
implements Queryable,
PsiQualifiedNamedElement,
PsiExtensibleClass {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiClassImpl");
    private final ClassInnerStuffCache myInnersCache = new ClassInnerStuffCache(this);
    private volatile PsiMethod myValuesMethod;
    private volatile PsiMethod myValueOfMethod;
    private volatile String myCachedName;

    public PsiClassImpl(PsiClassStub stub) {
        this(stub, (IStubElementType)JavaStubElementTypes.CLASS);
    }

    protected PsiClassImpl(PsiClassStub stub, IStubElementType type) {
        super(stub, type);
        this.addTrace(null);
    }

    public PsiClassImpl(ASTNode node) {
        super(node);
        this.addTrace(null);
    }

    private void addTrace(@Nullable PsiClassStub stub) {
        if (ourTraceStubAstBinding) {
            String creationTrace = "Creation thread: " + Thread.currentThread() + "\n" + DebugUtil.currentStackTrace();
            if (stub != null) {
                String stubTrace;
                creationTrace = creationTrace + "\nfrom stub " + stub + "@" + System.identityHashCode(stub) + "\n";
                if (stub instanceof UserDataHolder && (stubTrace = (String)((UserDataHolder)((Object)stub)).getUserData(CREATION_TRACE)) != null) {
                    creationTrace = creationTrace + stubTrace;
                }
            }
            this.putUserData(CREATION_TRACE, creationTrace);
        }
    }

    @Override
    public void subtreeChanged() {
        this.dropCaches();
        super.subtreeChanged();
    }

    private void dropCaches() {
        this.myInnersCache.dropCaches();
        this.myCachedName = null;
        this.myValueOfMethod = null;
        this.myValuesMethod = null;
    }

    @Override
    protected Object clone() {
        PsiClassImpl clone = (PsiClassImpl)super.clone();
        clone.dropCaches();
        return clone;
    }

    @Override
    public PsiElement getParent() {
        StubElement parentStub;
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub != null && ((parentStub = stub.getParentStub()) instanceof PsiFileStub || parentStub instanceof PsiClassStub)) {
            return parentStub.getPsi();
        }
        return SharedImplUtil.getParent(this.getNode());
    }

    @Override
    public PsiElement getOriginalElement() {
        JavaPsiImplementationHelper helper = JavaPsiImplementationHelper.getInstance(this.getProject());
        if (helper != null) {
            return helper.getOriginalClass(this);
        }
        return this;
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.getNode must not return null");
        }
        return compositeElement;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return (PsiIdentifier)this.getNode().findChildByRoleAsPsiElement(9);
    }

    @Override
    public PsiElement getScope() {
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub != null) {
            return stub.getParentStub().getPsi();
        }
        CompositeElement treeElement = this.getNode();
        for (ASTNode parent = treeElement.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            if (!(parent.getElementType() instanceof IStubElementType)) continue;
            return parent.getPsi();
        }
        return this.getContainingFile();
    }

    @Override
    public String getName() {
        PsiIdentifier identifier;
        String name = this.myCachedName;
        if (name != null) {
            return name;
        }
        PsiClassStub stub = (PsiClassStub)this.getStub();
        name = stub == null ? ((identifier = this.getNameIdentifier()) == null ? null : identifier.getText()) : stub.getName();
        this.myCachedName = name;
        return name;
    }

    @Override
    public String getQualifiedName() {
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub != null) {
            return stub.getQualifiedName();
        }
        PsiElement parent = this.getParent();
        if (parent instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)parent).getPackageName();
            if (packageName.isEmpty()) {
                return this.getName();
            }
            return packageName + "." + this.getName();
        }
        if (parent instanceof PsiClass) {
            String parentQName = ((PsiClass)parent).getQualifiedName();
            if (parentQName == null) {
                return null;
            }
            return parentQName + "." + this.getName();
        }
        return null;
    }

    @Override
    public PsiModifierList getModifierList() {
        return this.getRequiredStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiClassImpl.hasModifierProperty must not be null");
        }
        PsiModifierList modlist = this.getModifierList();
        return modlist != null && modlist.hasModifierProperty(name);
    }

    @Override
    public PsiReferenceList getExtendsList() {
        return this.getStubOrPsiChild(JavaStubElementTypes.EXTENDS_LIST);
    }

    @Override
    public PsiReferenceList getImplementsList() {
        return this.getStubOrPsiChild(JavaStubElementTypes.IMPLEMENTS_LIST);
    }

    @Override
    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getExtendsListTypes(this);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.getExtendsListTypes must not return null");
        }
        return psiClassTypeArray;
    }

    @Override
    @NotNull
    public PsiClassType[] getImplementsListTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getImplementsListTypes(this);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.getImplementsListTypes must not return null");
        }
        return psiClassTypeArray;
    }

    @Override
    public PsiClass getSuperClass() {
        return PsiClassImplUtil.getSuperClass(this);
    }

    @Override
    public PsiClass[] getInterfaces() {
        return PsiClassImplUtil.getInterfaces(this);
    }

    @Override
    @NotNull
    public PsiClass[] getSupers() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getSupers(this);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.getSupers must not return null");
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiClassType[] getSuperTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getSuperTypes(this);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.getSuperTypes must not return null");
        }
        return psiClassTypeArray;
    }

    @Override
    @Nullable
    public PsiClass getContainingClass() {
        Object parent;
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub != null) {
            for (parent = stub.getParentStub(); parent != null && !(parent instanceof PsiClassStub); parent = parent.getParentStub()) {
            }
            if (parent != null) {
                return (PsiClass)((PsiClassStub)parent).getPsi();
            }
        }
        if ((parent = this.getParent()) instanceof PsiClassLevelDeclarationStatement) {
            return PsiTreeUtil.getParentOfType((PsiElement)this, PsiSyntheticClass.class);
        }
        return parent instanceof PsiClass ? (PsiClass)parent : null;
    }

    @Override
    public PsiElement getContext() {
        PsiClass cc = this.getContainingClass();
        return cc != null ? cc : super.getContext();
    }

    @Override
    @NotNull
    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        Collection<HierarchicalMethodSignature> collection = PsiSuperMethodImplUtil.getVisibleSignatures(this);
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.getVisibleSignatures must not return null");
        }
        return collection;
    }

    @Override
    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = this.myInnersCache.getFields();
        if (psiFieldArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.getFields must not return null");
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getMethods();
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.getMethods must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getConstructors();
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.getConstructors must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] psiClassArray = this.myInnersCache.getInnerClasses();
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.getInnerClasses must not return null");
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public List<PsiField> getOwnFields() {
        List<PsiElement> list = Arrays.asList(this.getStubOrPsiChildren(Constants.FIELD_BIT_SET, PsiField.ARRAY_FACTORY));
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.getOwnFields must not return null");
        }
        return list;
    }

    @Override
    @NotNull
    public List<PsiMethod> getOwnMethods() {
        List<PsiElement> list = Arrays.asList(this.getStubOrPsiChildren(Constants.METHOD_BIT_SET, PsiMethod.ARRAY_FACTORY));
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.getOwnMethods must not return null");
        }
        return list;
    }

    @Override
    @NotNull
    public List<PsiClass> getOwnInnerClasses() {
        List<PsiElement> list = Arrays.asList(this.getStubOrPsiChildren(JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY));
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.getOwnInnerClasses must not return null");
        }
        return list;
    }

    @Override
    @NotNull
    public PsiClassInitializer[] getInitializers() {
        PsiClassInitializer[] psiClassInitializerArray = (PsiClassInitializer[])this.getStubOrPsiChildren(JavaStubElementTypes.CLASS_INITIALIZER, PsiClassInitializer.ARRAY_FACTORY);
        if (psiClassInitializerArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.getInitializers must not return null");
        }
        return psiClassInitializerArray;
    }

    @Override
    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = PsiImplUtil.getTypeParameters(this);
        if (psiTypeParameterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.getTypeParameters must not return null");
        }
        return psiTypeParameterArray;
    }

    @Override
    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = PsiClassImplUtil.getAllFields(this);
        if (psiFieldArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.getAllFields must not return null");
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getAllMethods() {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.getAllMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.getAllMethods must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiClass[] getAllInnerClasses() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getAllInnerClasses(this);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.getAllInnerClasses must not return null");
        }
        return psiClassArray;
    }

    @Override
    public PsiField findFieldByName(String name, boolean checkBases) {
        return this.myInnersCache.findFieldByName(name, checkBases);
    }

    @Override
    public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
        return PsiClassImplUtil.findMethodBySignature(this, patternMethod, checkBases);
    }

    @Override
    @NotNull
    public PsiMethod[] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsBySignature(this, patternMethod, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.findMethodsBySignature must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findMethodsByName(String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = this.myInnersCache.findMethodsByName(name, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.findMethodsByName must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(String name, boolean checkBases) {
        List<Pair<PsiMethod, PsiSubstitutor>> list = PsiClassImplUtil.findMethodsAndTheirSubstitutorsByName(this, name, checkBases);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.findMethodsAndTheirSubstitutorsByName must not return null");
        }
        return list;
    }

    @Override
    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        List<Pair<PsiMethod, PsiSubstitutor>> list = PsiClassImplUtil.getAllWithSubstitutorsByMap(this, PsiClassImplUtil.MemberType.METHOD);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.getAllMethodsAndTheirSubstitutors must not return null");
        }
        return list;
    }

    @Override
    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        return this.myInnersCache.findInnerClassByName(name, checkBases);
    }

    @Override
    public PsiTypeParameterList getTypeParameterList() {
        return this.getRequiredStubOrPsiChild(JavaStubElementTypes.TYPE_PARAMETER_LIST);
    }

    @Override
    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters(this);
    }

    @Override
    public boolean isDeprecated() {
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecated() || stub.hasDeprecatedAnnotation() && PsiImplUtil.isDeprecatedByAnnotation(this);
        }
        return PsiImplUtil.isDeprecatedByDocTag(this) || PsiImplUtil.isDeprecatedByAnnotation(this);
    }

    @Override
    public PsiDocComment getDocComment() {
        return (PsiDocComment)this.getNode().findChildByRoleAsPsiElement(7);
    }

    @Override
    public PsiJavaToken getLBrace() {
        return (PsiJavaToken)this.getNode().findChildByRoleAsPsiElement(18);
    }

    @Override
    public PsiJavaToken getRBrace() {
        return (PsiJavaToken)this.getNode().findChildByRoleAsPsiElement(19);
    }

    @Override
    public boolean isInterface() {
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub != null) {
            return stub.isInterface();
        }
        ASTNode keyword = this.getNode().findChildByRole(11);
        return keyword != null && keyword.getElementType() == JavaTokenType.INTERFACE_KEYWORD;
    }

    @Override
    public boolean isAnnotationType() {
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub != null) {
            return stub.isAnnotationType();
        }
        return this.getNode().findChildByRole(247) != null;
    }

    @Override
    public boolean isEnum() {
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub != null) {
            return stub.isEnum();
        }
        ASTNode keyword = this.getNode().findChildByRole(11);
        return keyword != null && keyword.getElementType() == JavaTokenType.ENUM_KEYWORD;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiClassImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitClass(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiClass:" + this.getName();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        String name;
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiClassImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/PsiClassImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/PsiClassImpl.processDeclarations must not be null");
        }
        if (this.isEnum() && (name = this.getName()) != null) {
            try {
                NameHint nameHint = processor.getHint(NameHint.KEY);
                ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
                if (!(nameHint != null && !"values".equals(nameHint.getName(state)) || classHint != null && !classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD) || processor.execute(this.getValuesMethod(), ResolveState.initial()))) {
                    return false;
                }
                if (!(nameHint != null && !"valueOf".equals(nameHint.getName(state)) || classHint != null && !classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD) || processor.execute(this.getValueOfMethod(), ResolveState.initial()))) {
                    return false;
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
            }
        }
        return PsiClassImplUtil.processDeclarationsInClass(this, processor, state, null, lastParent, place, false);
    }

    @Override
    public PsiElement setName(@NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiClassImpl.setName must not be null");
        }
        String oldName = this.getName();
        boolean isRenameFile = this.isRenameFileOnRenaming();
        PsiImplUtil.setName(this.getNameIdentifier(), newName);
        if (isRenameFile) {
            PsiFile file;
            String fileName = (file = (PsiFile)this.getParent()).getName();
            int dotIndex = fileName.lastIndexOf(46);
            file.setName(dotIndex >= 0 ? newName + "." + fileName.substring(dotIndex + 1) : newName);
        }
        for (PsiMethod method : this.getConstructors()) {
            if (!method.getName().equals(oldName)) continue;
            method.setName(newName);
        }
        return this;
    }

    private boolean isRenameFileOnRenaming() {
        PsiElement parent = this.getParent();
        if (parent instanceof PsiFile) {
            PsiFile file = (PsiFile)parent;
            String fileName = file.getName();
            int dotIndex = fileName.lastIndexOf(46);
            String name = dotIndex >= 0 ? fileName.substring(0, dotIndex) : fileName;
            String oldName = this.getName();
            return name.equals(oldName);
        }
        return false;
    }

    @Nullable
    public PsiElement calcBasesResolveContext(String baseClassName, PsiElement defaultResolveContext) {
        return PsiClassImpl.calcBasesResolveContext(this, baseClassName, true, defaultResolveContext);
    }

    private static boolean isAnonymousOrLocal(PsiClass aClass) {
        if (aClass instanceof PsiAnonymousClass) {
            return true;
        }
        PsiClassStub stub = (PsiClassStub)((PsiClassImpl)aClass).getStub();
        if (stub != null) {
            StubElement parentStub = stub.getParentStub();
            return !(parentStub instanceof PsiClassStub) && !(parentStub instanceof PsiFileStub);
        }
        for (PsiElement parent = aClass.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof PsiMethod || parent instanceof PsiField || parent instanceof PsiClassInitializer) {
                return true;
            }
            if (!(parent instanceof PsiClass) && !(parent instanceof PsiFile)) continue;
            return false;
        }
        return false;
    }

    @Nullable
    private static PsiElement calcBasesResolveContext(PsiClass aClass, String className, boolean isInitialClass, PsiElement defaultResolveContext) {
        PsiClassStub stub = (PsiClassStub)((PsiClassImpl)aClass).getStub();
        if (stub == null || stub.isAnonymousInQualifiedNew()) {
            return aClass.getParent();
        }
        boolean isAnonOrLocal = PsiClassImpl.isAnonymousOrLocal(aClass);
        if (!isAnonOrLocal) {
            return isInitialClass ? defaultResolveContext : aClass;
        }
        if (!isInitialClass && aClass.findInnerClassByName(className, true) != null) {
            return aClass;
        }
        StubElement parentStub = stub.getParentStub();
        StubBasedPsiElementBase context = (StubBasedPsiElementBase)parentStub.getPsi();
        PsiClass[] classesInScope = (PsiClass[])parentStub.getChildrenByType(Constants.CLASS_BIT_SET, PsiClass.ARRAY_FACTORY);
        boolean needPreciseContext = false;
        if (classesInScope.length > 1) {
            for (PsiClass scopeClass : classesInScope) {
                String className1;
                if (scopeClass == aClass || !className.equals(className1 = scopeClass.getName())) continue;
                needPreciseContext = true;
                break;
            }
        } else {
            if (classesInScope.length != 1) {
                LOG.assertTrue(classesInScope.length == 1, "Parent stub: " + parentStub.getStubType() + "; children: " + parentStub.getChildrenStubs() + "; \ntext:" + context.getText());
            }
            LOG.assertTrue(classesInScope[0] == aClass);
        }
        if (needPreciseContext) {
            return aClass.getParent();
        }
        if (context instanceof PsiClass) {
            return PsiClassImpl.calcBasesResolveContext((PsiClass)((Object)context), className, false, defaultResolveContext);
        }
        if (context instanceof PsiMember) {
            return PsiClassImpl.calcBasesResolveContext(((PsiMember)((Object)context)).getContainingClass(), className, false, defaultResolveContext);
        }
        LOG.assertTrue(false);
        return context;
    }

    @Override
    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        if (baseClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiClassImpl.isInheritor must not be null");
        }
        return InheritanceImplUtil.isInheritor(this, baseClass, checkDeep);
    }

    @Override
    public boolean isInheritorDeep(PsiClass baseClass, PsiClass classToByPass) {
        return InheritanceImplUtil.isInheritorDeep(this, baseClass, classToByPass);
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public Icon getElementIcon(int flags) {
        return PsiClassImplUtil.getClassIcon(flags, this);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isClassEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiClassImplUtil.getClassUseScope(this);
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiClassImpl.getUseScope must not return null");
        }
        return searchScope;
    }

    @Override
    @Nullable
    public PsiQualifiedNamedElement getContainer() {
        PsiDirectory dir;
        PsiFile file = this.getContainingFile();
        return file == null ? null : ((dir = file.getContainingDirectory()) == null ? null : JavaDirectoryService.getInstance().getPackage(dir));
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiClassImpl.putInfo must not be null");
        }
        PsiClassImpl.putInfo(this, info);
    }

    public static void putInfo(@NotNull PsiClass psiClass, @NotNull Map<String, String> info) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiClassImpl.putInfo must not be null");
        }
        if (info == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/PsiClassImpl.putInfo must not be null");
        }
        info.put("className", psiClass.getName());
        info.put("qualifiedClassName", psiClass.getQualifiedName());
        PsiFile file = psiClass.getContainingFile();
        if (file instanceof Queryable) {
            ((Queryable)((Object)file)).putInfo(info);
        }
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Nullable
    public PsiMethod getValuesMethod() {
        PsiMethod method = this.myValuesMethod;
        if (method == null && this.isEnum() && this.getName() != null) {
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
            PsiMethod valuesMethod = elementFactory.createMethodFromText("public static " + this.getName() + "[] values() {}", this);
            this.myValuesMethod = method = new LightMethod(this.getManager(), valuesMethod, this);
        }
        return method;
    }

    @Nullable
    public PsiMethod getValueOfMethod() {
        PsiMethod method = this.myValueOfMethod;
        if (method == null && this.isEnum() && this.getName() != null) {
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
            PsiMethod valuesMethod = elementFactory.createMethodFromText("public static " + this.getName() + " valueOf(String name) throws IllegalArgumentException {}", this);
            this.myValueOfMethod = method = new LightMethod(this.getManager(), valuesMethod, this);
        }
        return method;
    }
}

