/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiTypeParameterStub;
import com.intellij.psi.impl.java.stubs.impl.PsiTypeParameterStubImpl;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.java.PsiTypeParameterImpl;
import com.intellij.psi.impl.source.tree.java.TypeParameterElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JavaTypeParameterElementType
extends JavaStubElementType<PsiTypeParameterStub, PsiTypeParameter> {
    public JavaTypeParameterElementType() {
        super("TYPE_PARAMETER");
    }

    @Override
    @NotNull
    public ASTNode createCompositeNode() {
        TypeParameterElement typeParameterElement = new TypeParameterElement();
        if (typeParameterElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/java/stubs/JavaTypeParameterElementType.createCompositeNode must not return null");
        }
        return typeParameterElement;
    }

    @Override
    public PsiTypeParameter createPsi(@NotNull PsiTypeParameterStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaTypeParameterElementType.createPsi must not be null");
        }
        return this.getPsiFactory(stub).createTypeParameter(stub);
    }

    @Override
    public PsiTypeParameter createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaTypeParameterElementType.createPsi must not be null");
        }
        return new PsiTypeParameterImpl(node);
    }

    @Override
    public PsiTypeParameterStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        LighterASTNode id = LightTreeUtil.requiredChildOfType(tree, node, JavaTokenType.IDENTIFIER);
        String name = RecordUtil.intern(tree.getCharTable(), id);
        return new PsiTypeParameterStubImpl(parentStub, StringRef.fromString(name));
    }

    @Override
    public void serialize(PsiTypeParameterStub stub, StubOutputStream dataStream) throws IOException {
        String name = stub.getName();
        dataStream.writeName(name);
    }

    @Override
    public PsiTypeParameterStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        return new PsiTypeParameterStubImpl(parentStub, name);
    }

    @Override
    public void indexStub(PsiTypeParameterStub stub, IndexSink sink) {
    }
}

