/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiType;
import com.intellij.util.ArrayUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiNameHelper {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(?:\\s)|(?:/\\*.*\\*/)|(?://[^\\n]*)");

    public abstract boolean isIdentifier(@Nullable String var1);

    public abstract boolean isIdentifier(@Nullable String var1, LanguageLevel var2);

    public abstract boolean isKeyword(@Nullable String var1);

    public abstract boolean isQualifiedName(@Nullable String var1);

    @NotNull
    public static String getShortClassName(@NotNull String referenceText) {
        String sub;
        int i;
        if (referenceText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiNameHelper.getShortClassName must not be null");
        }
        int lessPos = referenceText.length();
        int bracesBalance = 0;
        block5: for (i = referenceText.length() - 1; i >= 0; --i) {
            char ch = referenceText.charAt(i);
            switch (ch) {
                case ')': 
                case '>': {
                    ++bracesBalance;
                    continue block5;
                }
                case '(': 
                case '<': {
                    --bracesBalance;
                    lessPos = i;
                    continue block5;
                }
                case '.': 
                case '@': {
                    if (bracesBalance > 0) continue block5;
                    break block5;
                }
                default: {
                    if (!Character.isWhitespace(ch) || bracesBalance > 0) continue block5;
                    for (int j = i + 1; j < lessPos; ++j) {
                        if (!Character.isWhitespace(referenceText.charAt(j))) break block5;
                    }
                    lessPos = i;
                }
            }
        }
        String string = (sub = referenceText.substring(i + 1, lessPos).trim()).length() == referenceText.length() ? sub : new String(sub);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiNameHelper.getShortClassName must not return null");
        }
        return string;
    }

    public static String getPresentableText(PsiJavaCodeReferenceElement ref) {
        String referenceName = ref.getReferenceName();
        PsiType[] typeParameters = ref.getTypeParameters();
        return PsiNameHelper.getPresentableText(referenceName, typeParameters);
    }

    public static String getPresentableText(String referenceName, PsiType[] typeParameters) {
        if (typeParameters.length > 0) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(referenceName);
            buffer.append("<");
            for (int i = 0; i < typeParameters.length; ++i) {
                buffer.append(typeParameters[i].getPresentableText());
                if (i >= typeParameters.length - 1) continue;
                buffer.append(", ");
            }
            buffer.append(">");
            return buffer.toString();
        }
        return referenceName != null ? referenceName : "";
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String getQualifiedClassName(String referenceText, boolean removeWhitespace) {
        String string;
        if (removeWhitespace) {
            referenceText = PsiNameHelper.removeWhitespace(referenceText);
        }
        if (referenceText.indexOf(60) < 0) {
            string = referenceText;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/psi/PsiNameHelper.getQualifiedClassName must not return null");
            return string;
        }
        StringBuilder buffer = new StringBuilder(referenceText.length());
        char[] chars = referenceText.toCharArray();
        int gtPos = 0;
        int count = 0;
        block4: for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    if (++count != 1) continue block4;
                    buffer.append(new String(chars, gtPos, i - gtPos));
                    continue block4;
                }
                case '>': {
                    --count;
                    gtPos = i + 1;
                    continue block4;
                }
            }
        }
        if (count == 0) {
            buffer.append(new String(chars, gtPos, chars.length - gtPos));
        }
        if ((string = buffer.toString()) != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/psi/PsiNameHelper.getQualifiedClassName must not return null");
    }

    private static String removeWhitespace(String referenceText) {
        return WHITESPACE_PATTERN.matcher(referenceText).replaceAll("");
    }

    public static String[] getClassParametersText(String referenceText) {
        if (referenceText.indexOf(60) < 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        referenceText = PsiNameHelper.removeWhitespace(referenceText);
        char[] chars = referenceText.toCharArray();
        int afterLastDotIndex = 0;
        int level = 0;
        block15: for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    ++level;
                    continue block15;
                }
                case '.': {
                    if (level != 0) continue block15;
                    afterLastDotIndex = i + 1;
                    continue block15;
                }
                case '>': {
                    --level;
                }
            }
        }
        if (level != 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        int dim = 0;
        block16: for (int i = afterLastDotIndex; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    if (++level != 1) continue block16;
                    ++dim;
                    continue block16;
                }
                case ',': {
                    if (level != 1) continue block16;
                    ++dim;
                    continue block16;
                }
                case '>': {
                    --level;
                }
            }
        }
        if (level != 0 || dim == 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[dim];
        dim = 0;
        int ltPos = 0;
        block17: for (int i = afterLastDotIndex; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    if (++level != 1) continue block17;
                    ltPos = i;
                    continue block17;
                }
                case ',': {
                    if (level != 1) continue block17;
                    result[dim++] = new String(chars, ltPos + 1, i - ltPos - 1);
                    ltPos = i;
                    continue block17;
                }
                case '>': {
                    if (--level != 0) continue block17;
                    result[dim++] = new String(chars, ltPos + 1, i - ltPos - 1);
                }
            }
        }
        return result;
    }
}

