/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.annotations.NotNull;

public class PsiEllipsisType
extends PsiArrayType {
    public PsiEllipsisType(PsiType componentType) {
        super(componentType);
    }

    @Override
    public String getPresentableText() {
        return StringUtil.joinOrNull(this.getComponentType().getPresentableText(), this.getAnnotationsTextPrefix(false, true, true), "...");
    }

    @Override
    public String getCanonicalText() {
        return StringUtil.joinOrNull(this.getComponentType().getCanonicalText(), "...");
    }

    @Override
    public String getInternalCanonicalText() {
        return StringUtil.joinOrNull(this.getComponentType().getInternalCanonicalText(), this.getAnnotationsTextPrefix(true, true, true), "...");
    }

    @Override
    public boolean equalsToText(String text) {
        return text.endsWith("...") && this.getComponentType().equalsToText(text.substring(0, text.length() - 3)) || super.equalsToText(text);
    }

    public PsiType toArrayType() {
        return this.getComponentType().createArrayType();
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiEllipsisType.accept must not be null");
        }
        return visitor.visitEllipsisType(this);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof PsiEllipsisType && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 5;
    }
}

