/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiElementFinder {
    public static final ExtensionPointName<PsiElementFinder> EP_NAME = ExtensionPointName.create("com.intellij.java.elementFinder");

    @Nullable
    public abstract PsiClass findClass(@NotNull String var1, @NotNull GlobalSearchScope var2);

    @NotNull
    public abstract PsiClass[] findClasses(@NotNull String var1, @NotNull GlobalSearchScope var2);

    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiElementFinder.findPackage must not be null");
        }
        return null;
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiElementFinder.getSubPackages must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/PsiElementFinder.getSubPackages must not be null");
        }
        if (PsiPackage.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiElementFinder.getSubPackages must not return null");
        }
        return PsiPackage.EMPTY_ARRAY;
    }

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiElementFinder.getClasses must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/PsiElementFinder.getClasses must not be null");
        }
        if (PsiClass.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiElementFinder.getClasses must not return null");
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiElementFinder.getClassNames must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/PsiElementFinder.getClassNames must not be null");
        }
        Set<String> set = PsiElementFinder.getClassNames(this.getClasses(psiPackage, scope));
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiElementFinder.getClassNames must not return null");
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    protected static Set<String> getClassNames(@NotNull PsiClass[] classes) {
        Set<String> set;
        if (classes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiElementFinder.getClassNames must not be null");
        }
        if (classes.length == 0) {
            set = Collections.emptySet();
            if (set == null) throw new IllegalStateException("@NotNull method com/intellij/psi/PsiElementFinder.getClassNames must not return null");
            return set;
        }
        HashSet<String> names = new HashSet<String>();
        for (PsiClass aClass : classes) {
            ContainerUtil.addIfNotNull(aClass.getName(), names);
        }
        set = names;
        if (set != null) return set;
        throw new IllegalStateException("@NotNull method com/intellij/psi/PsiElementFinder.getClassNames must not return null");
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiDirectory> consumer) {
        if (psiPackage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiElementFinder.processPackageDirectories must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/PsiElementFinder.processPackageDirectories must not be null");
        }
        if (consumer == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/PsiElementFinder.processPackageDirectories must not be null");
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiClass[] getClasses(@Nullable String className, @NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        PsiClass[] psiClassArray;
        if (psiPackage == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/PsiElementFinder.getClasses must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/PsiElementFinder.getClasses must not be null");
        }
        PsiClass[] allClasses = this.getClasses(psiPackage, scope);
        if (className == null) {
            psiClassArray = allClasses;
            if (allClasses == null) throw new IllegalStateException("@NotNull method com/intellij/psi/PsiElementFinder.getClasses must not return null");
            return psiClassArray;
        }
        psiClassArray = PsiElementFinder.filterByName(className, allClasses);
        if (psiClassArray != null) return psiClassArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/PsiElementFinder.getClasses must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiClass[] filterByName(@NotNull String className, @NotNull PsiClass[] classes) {
        PsiClass[] psiClassArray;
        if (className == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiElementFinder.filterByName must not be null");
        }
        if (classes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/PsiElementFinder.filterByName must not be null");
        }
        if (classes.length == 0) {
            psiClassArray = PsiClass.EMPTY_ARRAY;
            if (PsiClass.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/PsiElementFinder.filterByName must not return null");
            return psiClassArray;
        }
        if (classes.length == 1) {
            psiClassArray = className.equals(classes[0].getName()) ? classes : PsiClass.EMPTY_ARRAY;
            if (psiClassArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/PsiElementFinder.filterByName must not return null");
            return psiClassArray;
        }
        SmartList<PsiClass> foundClasses = new SmartList<PsiClass>();
        for (PsiClass psiClass : classes) {
            if (!className.equals(psiClass.getName())) continue;
            foundClasses.add(psiClass);
        }
        psiClassArray = foundClasses.isEmpty() ? PsiClass.EMPTY_ARRAY : foundClasses.toArray(new PsiClass[foundClasses.size()]);
        if (psiClassArray != null) return psiClassArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/PsiElementFinder.filterByName must not return null");
    }
}

