/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.local;

import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalVirtualFile;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreLocalFileSystem
extends DeprecatedVirtualFileSystem {
    @Override
    @NotNull
    public String getProtocol() {
        String string = StandardFileSystems.FILE_PROTOCOL;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/local/CoreLocalFileSystem.getProtocol must not return null");
        }
        return string;
    }

    @Nullable
    public VirtualFile findFileByIoFile(@NotNull File ioFile) {
        if (ioFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/local/CoreLocalFileSystem.findFileByIoFile must not be null");
        }
        return ioFile.exists() ? new CoreLocalVirtualFile(this, ioFile) : null;
    }

    @Override
    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/local/CoreLocalFileSystem.findFileByPath must not be null");
        }
        return this.findFileByIoFile(new File(path));
    }

    @Override
    protected void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/local/CoreLocalFileSystem.deleteFile must not be null");
        }
        throw new UnsupportedOperationException("deleteFile() not supported");
    }

    @Override
    protected void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/local/CoreLocalFileSystem.renameFile must not be null");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/local/CoreLocalFileSystem.renameFile must not be null");
        }
        throw new UnsupportedOperationException("renameFile() not supported");
    }

    @Override
    protected VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/local/CoreLocalFileSystem.createChildFile must not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/local/CoreLocalFileSystem.createChildFile must not be null");
        }
        throw new UnsupportedOperationException("createChildFile() not supported");
    }

    @Override
    @NotNull
    protected VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/local/CoreLocalFileSystem.createChildDirectory must not be null");
        }
        if (dirName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/local/CoreLocalFileSystem.createChildDirectory must not be null");
        }
        throw new UnsupportedOperationException("createChildDirectory() not supported");
    }

    @Override
    protected VirtualFile copyFile(Object requestor, @NotNull VirtualFile virtualFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/local/CoreLocalFileSystem.copyFile must not be null");
        }
        if (newParent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/local/CoreLocalFileSystem.copyFile must not be null");
        }
        if (copyName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/vfs/local/CoreLocalFileSystem.copyFile must not be null");
        }
        throw new UnsupportedOperationException("copyFile() not supported");
    }
}

