/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceReader;
import java.io.BufferedOutputStream;
import java.io.CharArrayReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class JDOMUtil {
    private static final ThreadLocal<SoftReference<SAXBuilder>> ourSaxBuilder = new ThreadLocal();
    private static final EmptyTextFilter CONTENT_FILTER = new EmptyTextFilter();

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<Element> getChildren(@Nullable Element parent) {
        List list;
        if (parent != null) {
            List children = parent.getChildren();
            list = children;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.getChildren must not return null");
            return list;
        }
        list = Collections.emptyList();
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.getChildren must not return null");
    }

    private static Logger getLogger() {
        return LoggerHolder.ourLogger;
    }

    @NotNull
    public static Object[] getChildNodesWithAttrs(@NotNull Element e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/JDOMUtil.getChildNodesWithAttrs must not be null");
        }
        ArrayList result = new ArrayList();
        result.addAll(e.getContent());
        result.addAll(e.getAttributes());
        Object[] objectArray = ArrayUtil.toObjectArray(result);
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.getChildNodesWithAttrs must not return null");
        }
        return objectArray;
    }

    @NotNull
    public static Content[] getContent(Element m) {
        List list = m.getContent();
        Content[] contentArray = list.toArray(new Content[list.size()]);
        if (contentArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.getContent must not return null");
        }
        return contentArray;
    }

    @NotNull
    public static String concatTextNodesValues(Object[] nodes) {
        StringBuilder result = new StringBuilder();
        for (Object node : nodes) {
            result.append(((Content)node).getValue());
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.concatTextNodesValues must not return null");
        }
        return string;
    }

    private static SAXBuilder getSaxBuilder() {
        SAXBuilder saxBuilder;
        SoftReference<SAXBuilder> reference = ourSaxBuilder.get();
        SAXBuilder sAXBuilder = saxBuilder = reference != null ? reference.get() : null;
        if (saxBuilder == null) {
            saxBuilder = new SAXBuilder();
            saxBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    return new InputSource(new CharArrayReader(ArrayUtil.EMPTY_CHAR_ARRAY));
                }
            });
            ourSaxBuilder.set(new SoftReference<SAXBuilder>(saxBuilder));
        }
        return saxBuilder;
    }

    @NotNull
    public static Document loadDocument(CharSequence seq) throws IOException, JDOMException {
        Document document = JDOMUtil.getSaxBuilder().build(new CharSequenceReader(seq));
        if (document == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.loadDocument must not return null");
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(Document document, String filePath, String lineSeparator) throws IOException {
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(filePath));
        try {
            JDOMUtil.writeDocument(document, stream, lineSeparator);
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    public static void writeDocument(Document document, OutputStream stream, String lineSeparator) throws IOException {
        JDOMUtil.writeDocument(document, new OutputStreamWriter(stream, "UTF-8"), lineSeparator);
    }

    public static void writeDocument(Document document, Writer writer, String lineSeparator) throws IOException {
        XMLOutputter xmlOutputter = JDOMUtil.createOutputter(lineSeparator);
        try {
            xmlOutputter.output(document, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(document.getRootElement(), "");
        }
    }

    @NotNull
    public static XMLOutputter createOutputter(String lineSeparator) {
        MyXMLOutputter xmlOutputter = new MyXMLOutputter();
        Format format = Format.getCompactFormat().setIndent("  ").setTextMode(Format.TextMode.TRIM).setEncoding("UTF-8").setOmitEncoding(false).setOmitDeclaration(false).setLineSeparator(lineSeparator);
        xmlOutputter.setFormat(format);
        MyXMLOutputter myXMLOutputter = xmlOutputter;
        if (myXMLOutputter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.createOutputter must not return null");
        }
        return myXMLOutputter;
    }

    @Nullable
    private static String escapeChar(char c, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        switch (c) {
            case '\n': {
                return escapeLineEnds ? "&#10;" : null;
            }
            case '\r': {
                return escapeLineEnds ? "&#13;" : null;
            }
            case '\t': {
                return escapeLineEnds ? "&#9;" : null;
            }
            case ' ': {
                return escapeSpaces ? "&#20" : null;
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return escapeApostrophes ? "&apos;" : null;
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }

    @NotNull
    public static String escapeText(String text, boolean escapeSpaces, boolean escapeLineEnds) {
        String string = JDOMUtil.escapeText(text, false, escapeSpaces, escapeLineEnds);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.escapeText must not return null");
        }
        return string;
    }

    @NotNull
    public static String escapeText(String text, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        StringBuffer buffer = null;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            String quotation = JDOMUtil.escapeChar(ch, escapeApostrophes, escapeSpaces, escapeLineEnds);
            if (buffer == null) {
                if (quotation == null) continue;
                buffer = new StringBuffer(text.length() + 20);
                buffer.append(text.substring(0, i));
                buffer.append(quotation);
                continue;
            }
            if (quotation == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(quotation);
        }
        String string = buffer == null ? text : buffer.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.escapeText must not return null");
        }
        return string;
    }

    private static void printDiagnostics(Element element, String prefix) {
        ElementInfo info = JDOMUtil.getElementInfo(element);
        prefix = prefix + "/" + info.name;
        if (info.hasNullAttributes) {
            System.err.println(prefix);
        }
        List<Element> children = JDOMUtil.getChildren(element);
        for (Element child : children) {
            JDOMUtil.printDiagnostics(child, prefix);
        }
    }

    @NotNull
    private static ElementInfo getElementInfo(Element element) {
        int length;
        ElementInfo info = new ElementInfo();
        StringBuilder buf = new StringBuilder(element.getName());
        List attributes = element.getAttributes();
        if (attributes != null && (length = attributes.size()) > 0) {
            buf.append("[");
            for (int idx = 0; idx < length; ++idx) {
                Attribute attr = (Attribute)attributes.get(idx);
                if (idx != 0) {
                    buf.append(";");
                }
                buf.append(attr.getName());
                buf.append("=");
                buf.append(attr.getValue());
                if (attr.getValue() != null) continue;
                info.hasNullAttributes = true;
            }
            buf.append("]");
        }
        info.name = buf.toString();
        ElementInfo elementInfo = info;
        if (elementInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.getElementInfo must not return null");
        }
        return elementInfo;
    }

    public static String getValue(Object node) {
        if (node instanceof Content) {
            Content content = (Content)node;
            return content.getValue();
        }
        if (node instanceof Attribute) {
            Attribute attribute = (Attribute)node;
            return attribute.getValue();
        }
        throw new IllegalArgumentException("Wrong node: " + node);
    }

    private static class ElementInfo {
        public String name = "";
        public boolean hasNullAttributes = false;

        private ElementInfo() {
        }
    }

    public static class MyXMLOutputter
    extends XMLOutputter {
        @Override
        public String escapeAttributeEntities(String str) {
            return JDOMUtil.escapeText(str, false, true);
        }

        @Override
        public String escapeElementEntities(String str) {
            return JDOMUtil.escapeText(str, false, false);
        }
    }

    private static class EmptyTextFilter
    implements Filter {
        private EmptyTextFilter() {
        }

        @Override
        public boolean matches(Object obj) {
            if (obj instanceof Text) {
                Text t = (Text)obj;
                return !CharArrayUtil.containsOnlyWhiteSpaces(t.getText());
            }
            return true;
        }
    }

    private static class LoggerHolder {
        private static final Logger ourLogger = Logger.getInstance("#com.intellij.openapi.util.JDOMUtil");
    }
}

