/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class JobScheduler {
    private static final ScheduledThreadPoolExecutor ourScheduledExecutorService;

    public static ScheduledExecutorService getScheduler() {
        return ourScheduledExecutorService;
    }

    static {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "Periodic tasks thread");
                thread.setDaemon(true);
                thread.setPriority(5);
                return thread;
            }
        }){
            private final boolean doTiming = true;

            @Override
            protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
                return new ExecutionTimeCheckedTask<V>(task, runnable, 50);
            }

            @Override
            protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
                return new ExecutionTimeCheckedTask<V>(task, callable, 50);
            }
        };
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        ourScheduledExecutorService = executor;
    }

    private static class ExecutionTimeCheckedTask<V>
    implements RunnableScheduledFuture<V> {
        private static final Logger LOG = Logger.getInstance("#" + ExecutionTimeCheckedTask.class.getName());
        private final RunnableScheduledFuture<V> task;
        private final int limit;
        private final Object traceRunnableOrCallable;

        ExecutionTimeCheckedTask(RunnableScheduledFuture<V> _task, Object _traceRunnableOrCallable, int _limit) {
            this.task = _task;
            this.traceRunnableOrCallable = _traceRunnableOrCallable;
            this.limit = _limit;
        }

        @Override
        public boolean isPeriodic() {
            return this.task.isPeriodic();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.task.getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.task.compareTo(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long started = System.currentTimeMillis();
            try {
                this.task.run();
            }
            finally {
                long executionTime = System.currentTimeMillis() - started;
                if (executionTime > (long)this.limit) {
                    String msg = this.limit + " ms execution limit failed for:" + this.traceRunnableOrCallable + "," + executionTime;
                    LOG.info(msg);
                }
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.task.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.task.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.task.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.task.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.task.get(timeout, unit);
        }
    }
}

