/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.reference.AccessTranslator;
import org.jetbrains.k2js.translate.reference.CallExpressionTranslator;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.reference.PropertyAccessTranslator;
import org.jetbrains.k2js.translate.reference.ReferenceTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.ErrorReportingUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;

public final class QualifiedExpressionTranslator {
    private QualifiedExpressionTranslator() {
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull JetQualifiedExpression expression, @NotNull TranslationContext context) {
        JsExpression receiver = QualifiedExpressionTranslator.translateReceiver(expression, context);
        PropertyAccessTranslator result = PropertyAccessTranslator.newInstance(PsiUtils.getNotNullSimpleNameSelector(expression), receiver, CallType.getCallTypeForQualifiedExpression(expression), context);
        result.setCallType(CallType.getCallTypeForQualifiedExpression(expression));
        return result;
    }

    @NotNull
    public static JsExpression translateQualifiedExpression(@NotNull JetQualifiedExpression expression, @NotNull TranslationContext context) {
        JsExpression receiver = QualifiedExpressionTranslator.translateReceiver(expression, context);
        JetExpression selector = PsiUtils.getSelector(expression);
        CallType callType = CallType.getCallTypeForQualifiedExpression(expression);
        return QualifiedExpressionTranslator.dispatchToCorrectTranslator(receiver, selector, callType, context);
    }

    @NotNull
    private static JsExpression dispatchToCorrectTranslator(@Nullable JsExpression receiver, @NotNull JetExpression selector, @NotNull CallType callType, @NotNull TranslationContext context) {
        if (PropertyAccessTranslator.canBePropertyGetterCall(selector, context)) {
            assert (selector instanceof JetSimpleNameExpression) : "Selectors for properties must be simple names.";
            return PropertyAccessTranslator.translateAsPropertyGetterCall((JetSimpleNameExpression)selector, receiver, callType, context);
        }
        if (selector instanceof JetCallExpression) {
            return QualifiedExpressionTranslator.invokeCallExpressionTranslator(receiver, selector, callType, context);
        }
        if (selector instanceof JetSimpleNameExpression) {
            return ReferenceTranslator.translateSimpleName((JetSimpleNameExpression)selector, context);
        }
        throw new AssertionError((Object)("Unexpected qualified expression: " + selector.getText()));
    }

    @NotNull
    private static JsExpression invokeCallExpressionTranslator(@Nullable JsExpression receiver, @NotNull JetExpression selector, @NotNull CallType callType, @NotNull TranslationContext context) {
        try {
            return CallExpressionTranslator.translate((JetCallExpression)selector, receiver, callType, context);
        }
        catch (RuntimeException e) {
            throw ErrorReportingUtils.reportErrorWithLocation(selector, e);
        }
    }

    @Nullable
    private static JsExpression translateReceiver(@NotNull JetQualifiedExpression expression, @NotNull TranslationContext context) {
        JetExpression receiverExpression = expression.getReceiverExpression();
        if (QualifiedExpressionTranslator.isFullQualifierForExpression(receiverExpression, context)) {
            return null;
        }
        return Translation.translateAsExpression(receiverExpression, context);
    }

    private static boolean isFullQualifierForExpression(@Nullable JetExpression receiverExpression, @NotNull TranslationContext context) {
        DeclarationDescriptor descriptorForReferenceExpression;
        if (receiverExpression == null) {
            return false;
        }
        if (receiverExpression instanceof JetReferenceExpression && (descriptorForReferenceExpression = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), (JetReferenceExpression)receiverExpression)) instanceof NamespaceDescriptor) {
            return true;
        }
        if (receiverExpression instanceof JetQualifiedExpression) {
            return QualifiedExpressionTranslator.isFullQualifierForExpression(((JetQualifiedExpression)receiverExpression).getSelectorExpression(), context);
        }
        return false;
    }
}

