/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNew;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.util.ExpressionAsFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.NamePredicate;
import org.jetbrains.k2js.translate.reference.CallParameters;
import org.jetbrains.k2js.translate.reference.CallParametersResolver;
import org.jetbrains.k2js.translate.reference.CallType;
import org.jetbrains.k2js.translate.reference.ReferenceTranslator;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.ErrorReportingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;

public final class CallTranslator
extends AbstractTranslator {
    @NotNull
    private final List<JsExpression> arguments;
    @NotNull
    private final ResolvedCall<?> resolvedCall;
    @NotNull
    private final CallableDescriptor descriptor;
    @NotNull
    private final CallType callType;
    @NotNull
    private final CallParameters callParameters;

    CallTranslator(@Nullable JsExpression receiver, @Nullable JsExpression callee, @NotNull List<JsExpression> arguments, @NotNull ResolvedCall<? extends CallableDescriptor> resolvedCall, @NotNull CallableDescriptor descriptorToCall, @NotNull CallType callType, @NotNull TranslationContext context) {
        super(context);
        this.arguments = arguments;
        this.resolvedCall = resolvedCall;
        this.callType = callType;
        this.descriptor = descriptorToCall;
        this.callParameters = CallParametersResolver.resolveCallParameters(receiver, callee, this.descriptor, resolvedCall, context);
    }

    @NotNull
    JsExpression translate() {
        if (this.isIntrinsic()) {
            return this.intrinsicInvocation();
        }
        if (this.isConstructor()) {
            return this.constructorCall();
        }
        if (this.resolvedCall.getReceiverArgument().exists()) {
            if (AnnotationsUtils.isNativeObject(this.descriptor)) {
                return this.methodCall(this.callParameters.getReceiver());
            }
            return this.extensionFunctionCall(!(this.descriptor instanceof ExpressionAsFunctionDescriptor) && !this.descriptor.getName().asString().equals("invoke"));
        }
        if (this.isExpressionAsFunction()) {
            return this.expressionAsFunctionCall();
        }
        if (this.isInvoke()) {
            return this.invokeCall();
        }
        return this.methodCall(this.getThisObjectOrQualifier());
    }

    private boolean isInvoke() {
        return this.descriptor.getName().asString().equals("invoke");
    }

    @NotNull
    private JsExpression invokeCall() {
        JsExpression thisExpression = this.callParameters.getThisObject();
        if (thisExpression == null) {
            return new JsInvocation(this.callParameters.getFunctionReference(), this.arguments);
        }
        JsInvocation call = new JsInvocation(new JsNameRef("call", this.callParameters.getFunctionReference()));
        call.getArguments().add(thisExpression);
        call.getArguments().addAll(this.arguments);
        return call;
    }

    private boolean isExpressionAsFunction() {
        return this.descriptor instanceof ExpressionAsFunctionDescriptor || this.resolvedCall instanceof VariableAsFunctionResolvedCall;
    }

    @NotNull
    private JsExpression expressionAsFunctionCall() {
        return this.methodCall(null);
    }

    private boolean isIntrinsic() {
        if (this.descriptor instanceof FunctionDescriptor) {
            FunctionIntrinsic intrinsic = this.context().intrinsics().getFunctionIntrinsics().getIntrinsic((FunctionDescriptor)this.descriptor);
            return intrinsic.exists();
        }
        return false;
    }

    @NotNull
    private JsExpression intrinsicInvocation() {
        assert (this.descriptor instanceof FunctionDescriptor);
        try {
            FunctionIntrinsic intrinsic = this.context().intrinsics().getFunctionIntrinsics().getIntrinsic((FunctionDescriptor)this.descriptor);
            assert (intrinsic.exists());
            return intrinsic.apply(this.callParameters.getThisOrReceiverOrNull(), this.arguments, this.context());
        }
        catch (RuntimeException e) {
            throw ErrorReportingUtils.reportErrorWithLocation(e, this.descriptor, this.bindingContext());
        }
    }

    private boolean isConstructor() {
        return JsDescriptorUtils.isConstructorDescriptor(this.descriptor);
    }

    @NotNull
    private JsExpression constructorCall() {
        JsExpression constructorReference;
        ClassDescriptor classDescriptor = (ClassDescriptor)this.descriptor.getContainingDeclaration();
        boolean isSet = false;
        if (AnnotationsUtils.isLibraryObject(classDescriptor) && (classDescriptor.getName().asString().equals("HashMap") || (isSet = classDescriptor.getName().asString().equals("HashSet")))) {
            JetType keyType = this.resolvedCall.getTypeArguments().values().iterator().next();
            Name keyTypeName = JsDescriptorUtils.getNameIfStandardType(keyType);
            String collectionClassName = keyTypeName != null && (NamePredicate.PRIMITIVE_NUMBERS.apply(keyTypeName) || keyTypeName.asString().equals("String")) ? (isSet ? "PrimitiveHashSet" : "PrimitiveHashMap") : (isSet ? "ComplexHashSet" : "ComplexHashMap");
            constructorReference = this.context().namer().kotlin(collectionClassName);
        } else {
            constructorReference = this.translateAsFunctionWithNoThisObject(this.descriptor);
        }
        return this.createConstructorCallExpression(constructorReference);
    }

    @NotNull
    private JsExpression createConstructorCallExpression(@NotNull JsExpression constructorReference) {
        if (this.context().isEcma5() && !AnnotationsUtils.isNativeObject(this.resolvedCall.getCandidateDescriptor())) {
            return new JsInvocation(constructorReference, this.arguments);
        }
        return new JsNew(constructorReference, this.arguments);
    }

    @NotNull
    private JsExpression translateAsFunctionWithNoThisObject(@NotNull DeclarationDescriptor descriptor) {
        return ReferenceTranslator.translateAsFQReference(descriptor, this.context());
    }

    @NotNull
    private JsExpression extensionFunctionCall(final boolean useThis) {
        return this.callType.constructCall(this.callParameters.getReceiver(), new CallType.CallConstructor(){

            @Override
            @NotNull
            public JsExpression construct(@Nullable JsExpression receiver) {
                assert (receiver != null) : "Could not be null for extensions";
                JsExpression functionReference = CallTranslator.this.callParameters.getFunctionReference();
                if (useThis) {
                    JsAstUtils.setQualifier(functionReference, CallTranslator.this.getThisObjectOrQualifier());
                }
                return new JsInvocation(functionReference, CallTranslator.this.generateExtensionCallArgumentList(receiver));
            }
        }, this.context());
    }

    @NotNull
    private List<JsExpression> generateExtensionCallArgumentList(@NotNull JsExpression receiver) {
        ArrayList<JsExpression> argumentList = new ArrayList<JsExpression>();
        argumentList.add(receiver);
        argumentList.addAll(this.arguments);
        return argumentList;
    }

    @NotNull
    private JsExpression methodCall(@Nullable JsExpression receiver) {
        return this.callType.constructCall(receiver, new CallType.CallConstructor(){

            @Override
            @NotNull
            public JsExpression construct(@Nullable JsExpression receiver) {
                JsExpression qualifiedCallee = CallTranslator.this.getQualifiedCallee(receiver);
                if (CallTranslator.this.isDirectPropertyAccess()) {
                    return CallTranslator.this.directPropertyAccess(qualifiedCallee);
                }
                return new JsInvocation(qualifiedCallee, CallTranslator.this.arguments);
            }
        }, this.context());
    }

    @NotNull
    private JsExpression directPropertyAccess(@NotNull JsExpression callee) {
        if (this.descriptor instanceof PropertyGetterDescriptor) {
            assert (this.arguments.isEmpty());
            return callee;
        }
        assert (this.descriptor instanceof PropertySetterDescriptor);
        assert (this.arguments.size() == 1);
        return JsAstUtils.assignment(callee, this.arguments.get(0));
    }

    private boolean isDirectPropertyAccess() {
        return this.descriptor instanceof PropertyAccessorDescriptor && (this.context().isEcma5() || this.isObjectAccessor((PropertyAccessorDescriptor)this.descriptor));
    }

    private boolean isObjectAccessor(@NotNull PropertyAccessorDescriptor propertyAccessorDescriptor) {
        PropertyDescriptor correspondingProperty = propertyAccessorDescriptor.getCorrespondingProperty();
        return BindingUtils.isObjectDeclaration(this.bindingContext(), correspondingProperty);
    }

    @NotNull
    private JsExpression getQualifiedCallee(@Nullable JsExpression receiver) {
        JsExpression callee = this.callParameters.getFunctionReference();
        if (receiver != null) {
            JsAstUtils.setQualifier(callee, receiver);
        }
        return callee;
    }

    @Nullable
    private JsExpression getThisObjectOrQualifier() {
        JsExpression thisObject = this.callParameters.getThisObject();
        if (thisObject != null) {
            return thisObject;
        }
        return this.context().getQualifierForDescriptor(this.descriptor);
    }
}

