/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.initializer;

import com.google.dart.compiler.backend.js.ast.JsBlock;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsStatement;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperCall;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.initializer.InitializerUtils;
import org.jetbrains.k2js.translate.initializer.InitializerVisitor;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class ClassInitializerTranslator
extends AbstractTranslator {
    @NotNull
    private final JetClassOrObject classDeclaration;
    @NotNull
    private final List<JsStatement> initializerStatements = new SmartList<JsStatement>();

    public ClassInitializerTranslator(@NotNull JetClassOrObject classDeclaration, @NotNull TranslationContext context) {
        super(context.newDeclaration(BindingUtils.getConstructor(context.bindingContext(), classDeclaration)));
        this.classDeclaration = classDeclaration;
    }

    @NotNull
    public JsFunction generateInitializeMethod() {
        ConstructorDescriptor primaryConstructor = BindingUtils.getConstructor(this.bindingContext(), this.classDeclaration);
        JsFunction result = this.context().getFunctionObject(primaryConstructor);
        result.getParameters().addAll(this.translatePrimaryConstructorParameters());
        this.mayBeAddCallToSuperMethod(result);
        new InitializerVisitor(this.initializerStatements).traverseContainer(this.classDeclaration, this.context());
        for (JsStatement statement : this.initializerStatements) {
            if (statement instanceof JsBlock) {
                result.getBody().getStatements().addAll(((JsBlock)statement).getStatements());
                continue;
            }
            result.getBody().getStatements().add(statement);
        }
        return result;
    }

    private void mayBeAddCallToSuperMethod(JsFunction initializer) {
        if (BindingUtils.hasAncestorClass(this.bindingContext(), this.classDeclaration)) {
            JetDelegatorToSuperCall superCall = this.getSuperCall();
            if (superCall == null) {
                return;
            }
            this.addCallToSuperMethod(superCall, initializer);
        }
    }

    private void addCallToSuperMethod(@NotNull JetDelegatorToSuperCall superCall, JsFunction initializer) {
        List<JsExpression> arguments = this.translateArguments(superCall);
        if (this.context().isEcma5()) {
            JsName ref = this.context().scope().declareName("$fun");
            initializer.setName(ref);
            JsInvocation call = new JsInvocation(new JsNameRef("call", (JsExpression)new JsNameRef("baseInitializer", (JsExpression)ref.makeRef())));
            call.getArguments().add(JsLiteral.THIS);
            call.getArguments().addAll(arguments);
            this.initializerStatements.add(call.makeStmt());
        } else {
            JsName superMethodName = this.context().scope().declareName(Namer.superMethodName());
            this.initializerStatements.add(JsAstUtils.convertToStatement(new JsInvocation((JsExpression)new JsNameRef(superMethodName, (JsExpression)JsLiteral.THIS), arguments)));
        }
    }

    @NotNull
    private List<JsExpression> translateArguments(@NotNull JetDelegatorToSuperCall superCall) {
        return TranslationUtils.translateArgumentList(this.context(), superCall.getValueArguments());
    }

    @Nullable
    private JetDelegatorToSuperCall getSuperCall() {
        JetDelegatorToSuperCall result = null;
        for (JetDelegationSpecifier specifier : this.classDeclaration.getDelegationSpecifiers()) {
            if (!(specifier instanceof JetDelegatorToSuperCall)) continue;
            result = (JetDelegatorToSuperCall)specifier;
        }
        return result;
    }

    @NotNull
    List<JsParameter> translatePrimaryConstructorParameters() {
        List<JetParameter> parameterList = PsiUtils.getPrimaryConstructorParameters(this.classDeclaration);
        ArrayList<JsParameter> result = new ArrayList<JsParameter>();
        for (JetParameter jetParameter : parameterList) {
            result.add(this.translateParameter(jetParameter));
        }
        return result;
    }

    @NotNull
    private JsParameter translateParameter(@NotNull JetParameter jetParameter) {
        DeclarationDescriptor parameterDescriptor = BindingUtils.getDescriptorForElement(this.bindingContext(), jetParameter);
        JsName parameterName = this.context().getNameForDescriptor(parameterDescriptor);
        JsParameter jsParameter = new JsParameter(parameterName);
        this.mayBeAddInitializerStatementForProperty(jsParameter, jetParameter);
        return jsParameter;
    }

    private void mayBeAddInitializerStatementForProperty(@NotNull JsParameter jsParameter, @NotNull JetParameter jetParameter) {
        PropertyDescriptor propertyDescriptor = BindingUtils.getPropertyDescriptorForConstructorParameter(this.bindingContext(), jetParameter);
        if (propertyDescriptor == null) {
            return;
        }
        JsNameRef initialValueForProperty = jsParameter.getName().makeRef();
        this.addInitializerOrPropertyDefinition(initialValueForProperty, propertyDescriptor);
    }

    private void addInitializerOrPropertyDefinition(@NotNull JsNameRef initialValue, @NotNull PropertyDescriptor propertyDescriptor) {
        this.initializerStatements.add(InitializerUtils.generateInitializerForProperty(this.context(), propertyDescriptor, initialValue));
    }
}

