/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.ErrorReportingUtils;
import org.jetbrains.k2js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class FunctionTranslator
extends AbstractTranslator {
    @NotNull
    private final TranslationContext functionBodyContext;
    @NotNull
    private final JetDeclarationWithBody functionDeclaration;
    @Nullable
    private JsName extensionFunctionReceiverName;
    @NotNull
    private final JsFunction functionObject;
    @NotNull
    private final FunctionDescriptor descriptor;

    @NotNull
    public static FunctionTranslator newInstance(@NotNull JetDeclarationWithBody function, @NotNull TranslationContext context) {
        return new FunctionTranslator(function, context);
    }

    private FunctionTranslator(@NotNull JetDeclarationWithBody functionDeclaration, @NotNull TranslationContext context) {
        super(context);
        this.descriptor = BindingUtils.getFunctionDescriptor(context.bindingContext(), functionDeclaration);
        this.functionDeclaration = functionDeclaration;
        this.functionObject = this.context().getFunctionObject(this.descriptor);
        assert (this.functionObject.getParameters().isEmpty()) : ErrorReportingUtils.message(this.bindingContext(), this.descriptor, "Function " + functionDeclaration.getText() + " processed for the second time.");
        this.functionBodyContext = this.getFunctionBodyContext();
    }

    @NotNull
    private TranslationContext getFunctionBodyContext() {
        if (this.isExtensionFunction()) {
            return this.getFunctionBodyContextForExtensionFunction();
        }
        return this.getContextWithFunctionBodyBlock();
    }

    @NotNull
    private TranslationContext getFunctionBodyContextForExtensionFunction() {
        TranslationContext contextWithFunctionBodyBlock = this.getContextWithFunctionBodyBlock();
        this.extensionFunctionReceiverName = contextWithFunctionBodyBlock.scope().declareName(Namer.getReceiverParameterName());
        DeclarationDescriptor expectedReceiverDescriptor = JsDescriptorUtils.getExpectedReceiverDescriptor(this.descriptor);
        assert (expectedReceiverDescriptor != null);
        return contextWithFunctionBodyBlock.innerContextWithThisAliased(expectedReceiverDescriptor, this.extensionFunctionReceiverName);
    }

    @NotNull
    private TranslationContext getContextWithFunctionBodyBlock() {
        return this.context().contextWithScope(this.functionObject);
    }

    @NotNull
    public JsPropertyInitializer translateAsEcma5PropertyDescriptor() {
        this.generateFunctionObject();
        return TranslationUtils.translateFunctionAsEcma5PropertyDescriptor(this.functionObject, this.descriptor, this.context());
    }

    @NotNull
    public JsPropertyInitializer translateAsMethod() {
        JsName functionName = this.context().getNameForDescriptor(this.descriptor);
        this.generateFunctionObject();
        return new JsPropertyInitializer(functionName.makeRef(), this.functionObject);
    }

    private void generateFunctionObject() {
        JsAstUtils.setParameters(this.functionObject, this.translateParameters());
        this.translateBody();
    }

    private void translateBody() {
        JetExpression jetBodyExpression = this.functionDeclaration.getBodyExpression();
        if (jetBodyExpression == null) {
            assert (this.descriptor.getModality().equals((Object)Modality.ABSTRACT));
            return;
        }
        this.functionObject.getBody().getStatements().addAll(FunctionBodyTranslator.translateFunctionBody(this.descriptor, this.functionDeclaration, this.functionBodyContext).getStatements());
    }

    @NotNull
    private List<JsParameter> translateParameters() {
        ArrayList<JsParameter> jsParameters = new ArrayList<JsParameter>();
        this.mayBeAddThisParameterForExtensionFunction(jsParameters);
        FunctionTranslator.addParameters(jsParameters, this.descriptor, this.context());
        return jsParameters;
    }

    public static void addParameters(List<JsParameter> list, FunctionDescriptor descriptor, TranslationContext context) {
        for (ValueParameterDescriptor valueParameter : descriptor.getValueParameters()) {
            list.add(new JsParameter(context.getNameForDescriptor(valueParameter)));
        }
    }

    private void mayBeAddThisParameterForExtensionFunction(@NotNull List<JsParameter> jsParameters) {
        if (this.isExtensionFunction()) {
            assert (this.extensionFunctionReceiverName != null);
            jsParameters.add(new JsParameter(this.extensionFunctionReceiverName));
        }
    }

    private boolean isExtensionFunction() {
        return JsDescriptorUtils.isExtension(this.descriptor) && !(this.functionDeclaration instanceof JetFunctionLiteral);
    }
}

