/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.Variance;

public class TypeProjection {
    private final Variance projection;
    private final JetType type;

    public TypeProjection(@NotNull Variance projection, @NotNull JetType type) {
        this.projection = projection;
        this.type = type;
    }

    public TypeProjection(JetType type) {
        this(Variance.INVARIANT, type);
    }

    @NotNull
    public Variance getProjectionKind() {
        return this.projection;
    }

    @NotNull
    public JetType getType() {
        return this.type;
    }

    public String toString() {
        if (this.projection == Variance.INVARIANT) {
            return this.type.toString();
        }
        return (Object)((Object)this.projection) + " " + this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeProjection that = (TypeProjection)o;
        if (this.projection != that.projection) {
            return false;
        }
        return !(this.type != null ? !((Object)this.type).equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.projection != null ? this.projection.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }
}

