/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.wrapper;

import com.intellij.psi.PsiClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.java.kt.JetClassAnnotation;
import org.jetbrains.jet.lang.resolve.java.kt.JetPackageClassAnnotation;

public class PsiClassWrapper {
    @NotNull
    private final PsiClass psiClass;
    private JetClassAnnotation jetClass;
    private JetPackageClassAnnotation jetPackageClass;

    public PsiClassWrapper(@NotNull PsiClass psiClass) {
        this.psiClass = psiClass;
    }

    public String getQualifiedName() {
        return this.psiClass.getQualifiedName();
    }

    @NotNull
    public PsiClass getPsiClass() {
        return this.psiClass;
    }

    @NotNull
    public JetClassAnnotation getJetClass() {
        if (this.jetClass == null) {
            this.jetClass = JetClassAnnotation.get(this.psiClass);
        }
        return this.jetClass;
    }

    @NotNull
    public JetPackageClassAnnotation getJetPackageClass() {
        if (this.jetPackageClass == null) {
            this.jetPackageClass = JetPackageClassAnnotation.get(this.psiClass);
        }
        return this.jetPackageClass;
    }
}

