/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.resolver;

import com.google.common.collect.Sets;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.AnnotationUtils;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverrideResolver;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.java.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.JavaBindingContext;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.java.JvmAbi;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolvers;
import org.jetbrains.jet.lang.resolve.java.kotlinSignature.AlternativeFieldSignatureData;
import org.jetbrains.jet.lang.resolve.java.kt.DescriptorKindUtils;
import org.jetbrains.jet.lang.resolve.java.kt.JetMethodAnnotation;
import org.jetbrains.jet.lang.resolve.java.provider.DeclarationOrigin;
import org.jetbrains.jet.lang.resolve.java.provider.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.provider.PsiDeclarationProvider;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaCompileTimeConstResolver;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaSignatureResolver;
import org.jetbrains.jet.lang.resolve.java.wrapper.PropertyPsiData;
import org.jetbrains.jet.lang.resolve.java.wrapper.PropertyPsiDataElement;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiFieldWrapper;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiMethodWrapper;
import org.jetbrains.jet.lang.resolve.java.wrapper.PsiParameterWrapper;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;

public final class JavaPropertyResolver {
    private JavaSemanticServices semanticServices;
    private JavaSignatureResolver javaSignatureResolver;
    private BindingTrace trace;
    private JavaAnnotationResolver annotationResolver;

    public void setSemanticServices(JavaSemanticServices semanticServices) {
        this.semanticServices = semanticServices;
    }

    public void setTrace(BindingTrace trace) {
        this.trace = trace;
    }

    public void setJavaSignatureResolver(JavaSignatureResolver javaSignatureResolver) {
        this.javaSignatureResolver = javaSignatureResolver;
    }

    public void setAnnotationResolver(JavaAnnotationResolver annotationResolver) {
        this.annotationResolver = annotationResolver;
    }

    @NotNull
    public Set<VariableDescriptor> resolveFieldGroupByName(@NotNull Name fieldName, @NotNull PsiDeclarationProvider scopeData, @NotNull ClassOrNamespaceDescriptor ownerDescriptor) {
        NamedMembers namedMembers = scopeData.getMembersCache().get(fieldName);
        if (namedMembers == null) {
            return Collections.emptySet();
        }
        return this.resolveNamedGroupProperties(ownerDescriptor, scopeData, namedMembers, fieldName, "class or namespace " + DescriptorUtils.getFQName(ownerDescriptor));
    }

    @NotNull
    private Set<VariableDescriptor> resolveNamedGroupProperties(@NotNull ClassOrNamespaceDescriptor ownerDescriptor, @NotNull PsiDeclarationProvider scopeData, @NotNull NamedMembers namedMembers, @NotNull Name propertyName, @NotNull String context) {
        Collection<PropertyPsiData> psiDataCollection = PropertyPsiData.assemblePropertyPsiDataFromElements(namedMembers.getPropertyPsiDataElements());
        HashSet<PropertyDescriptor> propertiesFromCurrent = new HashSet<PropertyDescriptor>(1);
        int regularPropertiesCount = JavaPropertyResolver.getNumberOfNonExtensionProperties(psiDataCollection);
        for (PropertyPsiData propertyPsiData : psiDataCollection) {
            if (!propertyPsiData.isExtension() && regularPropertiesCount > 1 || !DescriptorResolverUtils.isCorrectOwnerForEnumMember(ownerDescriptor, propertyPsiData.getCharacteristicPsi())) continue;
            propertiesFromCurrent.add(this.resolveProperty(ownerDescriptor, scopeData, propertyName, context, propertyPsiData));
        }
        Set<PropertyDescriptor> propertiesFromSupertypes = JavaPropertyResolver.getPropertiesFromSupertypes(propertyName, ownerDescriptor);
        HashSet<PropertyDescriptor> properties = Sets.newHashSet();
        JavaPropertyResolver.generateOverrides(ownerDescriptor, propertyName, propertiesFromCurrent, propertiesFromSupertypes, properties);
        OverrideResolver.resolveUnknownVisibilities(properties, this.trace);
        properties.addAll(propertiesFromCurrent);
        return Sets.newHashSet(properties);
    }

    private static void generateOverrides(@NotNull ClassOrNamespaceDescriptor owner, @NotNull Name propertyName, @NotNull Set<PropertyDescriptor> propertiesFromCurrent, @NotNull Set<PropertyDescriptor> propertiesFromSupertypes, final @NotNull Set<PropertyDescriptor> properties) {
        if (!(owner instanceof ClassDescriptor)) {
            return;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)owner;
        OverrideResolver.generateOverridesInFunctionGroup(propertyName, propertiesFromSupertypes, propertiesFromCurrent, classDescriptor, new OverrideResolver.DescriptorSink(){

            @Override
            public void addToScope(@NotNull CallableMemberDescriptor fakeOverride) {
                properties.add((PropertyDescriptor)fakeOverride);
            }

            @Override
            public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
            }
        });
    }

    @NotNull
    private PropertyDescriptor resolveProperty(@NotNull ClassOrNamespaceDescriptor owner, @NotNull PsiDeclarationProvider scopeData, @NotNull Name propertyName, @NotNull String context, @NotNull PropertyPsiData psiData) {
        CompileTimeConstant<?> constant;
        PsiExpression initializer;
        boolean isFinal = JavaPropertyResolver.isPropertyFinal(scopeData, psiData);
        boolean isVar = psiData.isVar();
        PropertyPsiDataElement characteristicMember = psiData.getCharacteristicMember();
        Visibility visibility = DescriptorResolverUtils.resolveVisibility(psiData.getCharacteristicPsi(), null);
        CallableMemberDescriptor.Kind kind = CallableMemberDescriptor.Kind.DECLARATION;
        PropertyPsiDataElement getter = psiData.getGetter();
        if (getter != null) {
            JetMethodAnnotation methodAnnotation = ((PsiMethodWrapper)getter.getMember()).getJetMethodAnnotation();
            visibility = DescriptorResolverUtils.resolveVisibility(psiData.getCharacteristicPsi(), methodAnnotation);
            kind = DescriptorKindUtils.flagsToKind(methodAnnotation.kind());
        }
        boolean isEnumEntry = psiData.getCharacteristicPsi() instanceof PsiEnumConstant;
        PropertyDescriptorImpl propertyDescriptor = new PropertyDescriptorImpl(owner, this.annotationResolver.resolveAnnotations(psiData.getCharacteristicPsi()), DescriptorResolverUtils.resolveModality(characteristicMember.getMember(), isFinal || isEnumEntry || psiData.isPropertyForNamedObject()), visibility, isVar, propertyName, kind);
        if (isEnumEntry) {
            assert (DescriptorUtils.isEnumClassObject(owner)) : "Enum entries should be put into class object of enum only: " + owner;
            ClassDescriptorImpl dummyClassDescriptorForEnumEntryObject = new ClassDescriptorImpl(owner, Collections.<AnnotationDescriptor>emptyList(), Modality.FINAL, propertyName);
            dummyClassDescriptorForEnumEntryObject.initialize(true, Collections.emptyList(), Collections.<JetType>emptyList(), JetScope.EMPTY, Collections.<ConstructorDescriptor>emptySet(), null, false);
            this.trace.record(BindingContext.OBJECT_DECLARATION_CLASS, propertyDescriptor, dummyClassDescriptorForEnumEntryObject);
        }
        PropertyGetterDescriptorImpl getterDescriptor = this.resolveGetter(visibility, kind, getter, propertyDescriptor);
        PropertySetterDescriptorImpl setterDescriptor = this.resolveSetter(psiData, kind, propertyDescriptor);
        propertyDescriptor.initialize(getterDescriptor, setterDescriptor);
        List<TypeParameterDescriptor> typeParameters = this.resolvePropertyTypeParameters(psiData, characteristicMember, propertyDescriptor);
        TypeVariableResolver typeVariableResolverForPropertyInternals = TypeVariableResolvers.typeVariableResolverFromTypeParameters(typeParameters, propertyDescriptor, "property " + propertyName + " in " + context);
        JetType propertyType = this.getPropertyType(psiData, characteristicMember, typeVariableResolverForPropertyInternals);
        JetType receiverType = this.getReceiverType(characteristicMember, typeVariableResolverForPropertyInternals);
        propertyType = this.getAlternativeSignatureData(isVar, characteristicMember, propertyDescriptor, propertyType);
        propertyDescriptor.setType(propertyType, typeParameters, DescriptorUtils.getExpectedThisObjectIfNeeded(owner), receiverType);
        JavaPropertyResolver.initializeSetterAndGetter(propertyDescriptor, getterDescriptor, setterDescriptor, propertyType, psiData);
        if (kind == CallableMemberDescriptor.Kind.DECLARATION) {
            this.trace.record(BindingContext.VARIABLE, psiData.getCharacteristicPsi(), propertyDescriptor);
        }
        this.recordObjectDeclarationClassIfNeeded(psiData, owner, propertyDescriptor, propertyType);
        if (scopeData.getDeclarationOrigin() == DeclarationOrigin.JAVA) {
            this.trace.record(JavaBindingContext.IS_DECLARED_IN_JAVA, propertyDescriptor);
        }
        if (AnnotationUtils.isPropertyAcceptableAsAnnotationParameter(propertyDescriptor) && psiData.getCharacteristicPsi() instanceof PsiField && (initializer = ((PsiField)psiData.getCharacteristicPsi()).getInitializer()) instanceof PsiLiteralExpression && (constant = JavaCompileTimeConstResolver.getCompileTimeConstFromLiteralExpressionWithExpectedType((PsiLiteralExpression)initializer, propertyType)) != null) {
            this.trace.record(BindingContext.COMPILE_TIME_INITIALIZER, propertyDescriptor, constant);
        }
        return propertyDescriptor;
    }

    @NotNull
    private JetType getAlternativeSignatureData(boolean isVar, PropertyPsiDataElement characteristicMember, PropertyDescriptor propertyDescriptor, JetType propertyType) {
        if (!characteristicMember.isField()) {
            return propertyType;
        }
        AlternativeFieldSignatureData signatureData = new AlternativeFieldSignatureData((PsiFieldWrapper)characteristicMember.getMember(), propertyType, isVar);
        if (!signatureData.hasErrors()) {
            if (signatureData.isAnnotated()) {
                return signatureData.getReturnType();
            }
        } else {
            this.trace.record(JavaBindingContext.LOAD_FROM_JAVA_SIGNATURE_ERRORS, propertyDescriptor, Collections.singletonList(signatureData.getError()));
        }
        return propertyType;
    }

    private static void initializeSetterAndGetter(@NotNull PropertyDescriptor propertyDescriptor, @Nullable PropertyGetterDescriptorImpl getterDescriptor, @Nullable PropertySetterDescriptorImpl setterDescriptor, @NotNull JetType propertyType, @NotNull PropertyPsiData data) {
        if (getterDescriptor != null) {
            getterDescriptor.initialize(propertyType);
        }
        if (setterDescriptor != null) {
            PropertyPsiDataElement setter = data.getSetter();
            assert (setter != null);
            List<PsiParameterWrapper> parameters = ((PsiMethodWrapper)setter.getMember()).getParameters();
            assert (parameters.size() != 0);
            int valueIndex = parameters.size() - 1;
            PsiParameterWrapper valueParameter = parameters.get(valueIndex);
            setterDescriptor.initialize(new ValueParameterDescriptorImpl(setterDescriptor, 0, Collections.<AnnotationDescriptor>emptyList(), Name.identifierNoValidate(valueParameter.getJetValueParameter().name()), propertyDescriptor.getType(), false, null));
        }
    }

    private void recordObjectDeclarationClassIfNeeded(PropertyPsiData psiData, DeclarationDescriptor realOwner, PropertyDescriptor propertyDescriptor, JetType propertyType) {
        if (!psiData.isPropertyForNamedObject()) {
            return;
        }
        ClassDescriptor objectDescriptor = (ClassDescriptor)propertyType.getConstructor().getDeclarationDescriptor();
        assert (objectDescriptor != null);
        assert (objectDescriptor.getKind() == ClassKind.OBJECT);
        assert (objectDescriptor.getContainingDeclaration() == realOwner);
        this.trace.record(BindingContext.OBJECT_DECLARATION_CLASS, propertyDescriptor, objectDescriptor);
    }

    @Nullable
    private PropertyGetterDescriptorImpl resolveGetter(Visibility visibility, CallableMemberDescriptor.Kind kind, PropertyPsiDataElement getter, PropertyDescriptor propertyDescriptor) {
        if (getter == null) {
            return null;
        }
        return new PropertyGetterDescriptorImpl(propertyDescriptor, this.annotationResolver.resolveAnnotations(getter.getMember().getPsiMember()), propertyDescriptor.getModality(), visibility, true, false, kind);
    }

    @Nullable
    private PropertySetterDescriptorImpl resolveSetter(PropertyPsiData psiData, CallableMemberDescriptor.Kind kind, PropertyDescriptor propertyDescriptor) {
        PropertyPsiDataElement setter = psiData.getSetter();
        if (setter == null) {
            return null;
        }
        Visibility setterVisibility = DescriptorResolverUtils.resolveVisibility(setter.getMember().getPsiMember(), null);
        if (setter.getMember() instanceof PsiMethodWrapper) {
            setterVisibility = DescriptorResolverUtils.resolveVisibility(setter.getMember().getPsiMember(), ((PsiMethodWrapper)setter.getMember()).getJetMethodAnnotation());
        }
        return new PropertySetterDescriptorImpl(propertyDescriptor, this.annotationResolver.resolveAnnotations(setter.getMember().getPsiMember()), propertyDescriptor.getModality(), setterVisibility, true, false, kind);
    }

    private List<TypeParameterDescriptor> resolvePropertyTypeParameters(@NotNull PropertyPsiData members, @NotNull PropertyPsiDataElement characteristicMember, @NotNull PropertyDescriptor propertyDescriptor) {
        if (characteristicMember == members.getSetter() || characteristicMember == members.getGetter()) {
            PsiMethodWrapper method = (PsiMethodWrapper)characteristicMember.getMember();
            return this.javaSignatureResolver.resolveMethodTypeParameters(method, propertyDescriptor);
        }
        return Collections.emptyList();
    }

    @NotNull
    private JetType getPropertyType(PropertyPsiData members, PropertyPsiDataElement characteristicMember, TypeVariableResolver typeVariableResolverForPropertyInternals) {
        boolean hasNotNullAnnotation;
        if (!characteristicMember.getType().getTypeString().isEmpty()) {
            return this.semanticServices.getTypeTransformer().transformToType(characteristicMember.getType().getTypeString(), typeVariableResolverForPropertyInternals);
        }
        JetType propertyType = this.semanticServices.getTypeTransformer().transformToType(characteristicMember.getType().getPsiType(), typeVariableResolverForPropertyInternals);
        boolean bl = hasNotNullAnnotation = JavaAnnotationResolver.findAnnotationWithExternal(characteristicMember.getType().getPsiNotNullOwner(), JvmAbi.JETBRAINS_NOT_NULL_ANNOTATION.getFqName().asString()) != null;
        if (hasNotNullAnnotation || members.isStaticFinalField()) {
            propertyType = TypeUtils.makeNotNullable(propertyType);
        }
        return propertyType;
    }

    @Nullable
    private JetType getReceiverType(PropertyPsiDataElement characteristicMember, TypeVariableResolver typeVariableResolverForPropertyInternals) {
        if (characteristicMember.getReceiverType() == null) {
            return null;
        }
        if (!characteristicMember.getReceiverType().getTypeString().isEmpty()) {
            return this.semanticServices.getTypeTransformer().transformToType(characteristicMember.getReceiverType().getTypeString(), typeVariableResolverForPropertyInternals);
        }
        return this.semanticServices.getTypeTransformer().transformToType(characteristicMember.getReceiverType().getPsiType(), typeVariableResolverForPropertyInternals);
    }

    private static int getNumberOfNonExtensionProperties(@NotNull Collection<PropertyPsiData> propertyPsiDataCollection) {
        int regularPropertiesCount = 0;
        for (PropertyPsiData members : propertyPsiDataCollection) {
            if (members.isExtension()) continue;
            ++regularPropertiesCount;
        }
        return regularPropertiesCount;
    }

    private static boolean isPropertyFinal(PsiDeclarationProvider scopeData, PropertyPsiData psiData) {
        if (scopeData.getDeclarationOrigin() == DeclarationOrigin.JAVA) {
            return true;
        }
        return psiData.isFinal();
    }

    @NotNull
    private static Set<PropertyDescriptor> getPropertiesFromSupertypes(@NotNull Name propertyName, @NotNull ClassOrNamespaceDescriptor ownerDescriptor) {
        HashSet<PropertyDescriptor> r = new HashSet<PropertyDescriptor>();
        for (JetType supertype : DescriptorResolverUtils.getSupertypes(ownerDescriptor)) {
            for (VariableDescriptor property : supertype.getMemberScope().getProperties(propertyName)) {
                r.add((PropertyDescriptor)property);
            }
        }
        return r;
    }
}

