/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kt;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.JvmStdlibNames;
import org.jetbrains.jet.lang.resolve.java.kt.PsiAnnotationWrapper;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;

public class JetValueParameterAnnotation
extends PsiAnnotationWrapper {
    private static final JetValueParameterAnnotation NULL_ANNOTATION = new JetValueParameterAnnotation(null);
    private String name;
    private String type;
    private boolean receiver;
    private boolean hasDefaultValue;
    private boolean vararg;

    private JetValueParameterAnnotation(@Nullable PsiAnnotation psiAnnotation) {
        super(psiAnnotation);
    }

    @Override
    protected void initialize() {
        this.name = this.getStringAttribute("name", "");
        this.type = this.getStringAttribute("type", "");
        this.receiver = this.getBooleanAttribute("receiver", false);
        this.hasDefaultValue = this.getBooleanAttribute("hasDefaultValue", false);
        this.vararg = this.getBooleanAttribute("vararg", false);
    }

    @NotNull
    public String name() {
        this.checkInitialized();
        return this.name;
    }

    @NotNull
    public String type() {
        this.checkInitialized();
        return this.type;
    }

    public boolean receiver() {
        this.checkInitialized();
        return this.receiver;
    }

    public boolean hasDefaultValue() {
        this.checkInitialized();
        return this.hasDefaultValue;
    }

    public boolean vararg() {
        this.checkInitialized();
        return this.vararg;
    }

    public static JetValueParameterAnnotation get(PsiParameter psiParameter) {
        PsiAnnotation annotation = JavaAnnotationResolver.findOwnAnnotation(psiParameter, JvmStdlibNames.JET_VALUE_PARAMETER.getFqName().asString());
        return annotation != null ? new JetValueParameterAnnotation(annotation) : NULL_ANNOTATION;
    }

    static {
        NULL_ANNOTATION.checkInitialized();
    }
}

