/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.kt;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.JvmStdlibNames;
import org.jetbrains.jet.lang.resolve.java.kt.PsiAnnotationWithAbiVersion;
import org.jetbrains.jet.lang.resolve.java.resolver.JavaAnnotationResolver;

public class JetClassObjectAnnotation
extends PsiAnnotationWithAbiVersion {
    private static final JetClassObjectAnnotation NULL_ANNOTATION = new JetClassObjectAnnotation(null);

    private JetClassObjectAnnotation(@Nullable PsiAnnotation psiAnnotation) {
        super(psiAnnotation);
    }

    @NotNull
    public static JetClassObjectAnnotation get(@NotNull PsiClass psiClass) {
        PsiAnnotation annotation = JavaAnnotationResolver.findOwnAnnotation(psiClass, JvmStdlibNames.JET_CLASS_OBJECT.getFqName().asString());
        return annotation != null ? new JetClassObjectAnnotation(annotation) : NULL_ANNOTATION;
    }

    static {
        NULL_ANNOTATION.checkInitialized();
    }
}

