/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintType;
import org.jetbrains.jet.lang.types.JetType;

public class SubtypingConstraint {
    private final ConstraintType type;
    private final JetType subtype;
    private final JetType supertype;

    public SubtypingConstraint(@NotNull ConstraintType type, @NotNull JetType subtype, @NotNull JetType supertype) {
        this.type = type;
        this.subtype = subtype;
        this.supertype = supertype;
    }

    @NotNull
    public JetType getSubtype() {
        return this.subtype;
    }

    @NotNull
    public JetType getSupertype() {
        return this.supertype;
    }

    @NotNull
    public ConstraintType getType() {
        return this.type;
    }

    @NotNull
    public String getErrorMessage() {
        return this.type.makeErrorMessage(this);
    }

    public String toString() {
        return this.getSubtype() + " :< " + this.getSupertype();
    }
}

