/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.resolve.ExternalOverridabilityCondition;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public class OverridingUtil {
    private static final List<ExternalOverridabilityCondition> EXTERNAL_CONDITIONS = ContainerUtil.collect(ServiceLoader.load(ExternalOverridabilityCondition.class, ExternalOverridabilityCondition.class.getClassLoader()).iterator());

    private OverridingUtil() {
    }

    public static <D extends CallableDescriptor> Set<D> filterOverrides(Set<D> candidateSet) {
        return OverridingUtil.filterOverrides(candidateSet, Function.ID);
    }

    public static <D> Set<D> filterOverrides(Set<D> candidateSet, Function<? super D, ? extends CallableDescriptor> transform) {
        LinkedHashSet<D> candidates = Sets.newLinkedHashSet();
        block0: for (D meD : candidateSet) {
            CallableDescriptor other;
            CallableDescriptor me = transform.fun(meD);
            for (Object otherD : candidateSet) {
                other = transform.fun(otherD);
                if (me == other || !OverridingUtil.overrides(other, me)) continue;
                continue block0;
            }
            for (Object otherD : candidates) {
                other = transform.fun(otherD);
                if (me.getOriginal() != other.getOriginal() || OverridingUtil.isOverridableBy(other, me).getResult() != OverrideCompatibilityInfo.Result.OVERRIDABLE || OverridingUtil.isOverridableBy(me, other).getResult() != OverrideCompatibilityInfo.Result.OVERRIDABLE) continue;
                continue block0;
            }
            candidates.add(meD);
        }
        return candidates;
    }

    public static <Descriptor extends CallableDescriptor> boolean overrides(@NotNull Descriptor f, @NotNull Descriptor g) {
        HashSet<CallableDescriptor> overriddenDescriptors = Sets.newHashSet();
        OverridingUtil.getAllOverriddenDescriptors(f.getOriginal(), overriddenDescriptors);
        CallableDescriptor originalG = g.getOriginal();
        for (CallableDescriptor overriddenFunction : overriddenDescriptors) {
            if (!originalG.equals(overriddenFunction.getOriginal())) continue;
            return true;
        }
        return false;
    }

    private static void getAllOverriddenDescriptors(@NotNull CallableDescriptor current, @NotNull Set<CallableDescriptor> overriddenDescriptors) {
        if (overriddenDescriptors.contains(current)) {
            return;
        }
        for (CallableDescriptor callableDescriptor : current.getOriginal().getOverriddenDescriptors()) {
            OverridingUtil.getAllOverriddenDescriptors(callableDescriptor, overriddenDescriptors);
            overriddenDescriptors.add(callableDescriptor);
        }
    }

    @NotNull
    public static OverrideCompatibilityInfo isOverridableBy(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
        if (superDescriptor instanceof FunctionDescriptor) {
            if (!(subDescriptor instanceof FunctionDescriptor)) {
                return OverrideCompatibilityInfo.memberKindMismatch();
            }
        } else if (superDescriptor instanceof PropertyDescriptor) {
            if (!(subDescriptor instanceof PropertyDescriptor)) {
                return OverrideCompatibilityInfo.memberKindMismatch();
            }
        } else {
            throw new IllegalArgumentException("This type of CallableDescriptor cannot be checked for overridability: " + superDescriptor);
        }
        if (!superDescriptor.getName().equals(subDescriptor.getName())) {
            return OverrideCompatibilityInfo.nameMismatch();
        }
        return OverridingUtil.isOverridableByImpl(superDescriptor, subDescriptor, true);
    }

    private static List<JetType> compiledValueParameters(CallableDescriptor callableDescriptor) {
        ReceiverParameterDescriptor receiverParameter = callableDescriptor.getReceiverParameter();
        ArrayList<JetType> parameters = new ArrayList<JetType>();
        if (receiverParameter != null) {
            parameters.add(receiverParameter.getType());
        }
        for (ValueParameterDescriptor valueParameterDescriptor : callableDescriptor.getValueParameters()) {
            parameters.add(valueParameterDescriptor.getType());
        }
        return parameters;
    }

    static OverrideCompatibilityInfo isOverridableByImpl(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor, boolean forOverride) {
        if (superDescriptor.getReceiverParameter() == null != (subDescriptor.getReceiverParameter() == null)) {
            return OverrideCompatibilityInfo.receiverPresenceMismatch();
        }
        if (superDescriptor.getValueParameters().size() != subDescriptor.getValueParameters().size()) {
            return OverrideCompatibilityInfo.valueParameterNumberMismatch();
        }
        List<JetType> superValueParameters = OverridingUtil.compiledValueParameters(superDescriptor);
        List<JetType> subValueParameters = OverridingUtil.compiledValueParameters(subDescriptor);
        if (forOverride && superDescriptor.getTypeParameters().size() != subDescriptor.getTypeParameters().size()) {
            for (int i = 0; i < superValueParameters.size(); ++i) {
                JetType subValueParameterType;
                JetType superValueParameterType = OverridingUtil.getUpperBound(superValueParameters.get(i));
                if (JetTypeChecker.INSTANCE.equalTypes(superValueParameterType, subValueParameterType = OverridingUtil.getUpperBound(subValueParameters.get(i)))) continue;
                return OverrideCompatibilityInfo.typeParameterNumberMismatch();
            }
            return OverrideCompatibilityInfo.valueParameterTypeMismatch(null, null, OverrideCompatibilityInfo.Result.CONFLICT);
        }
        if (forOverride) {
            TypeParameterDescriptor subTypeParameter;
            TypeParameterDescriptor superTypeParameter;
            int i;
            List<TypeParameterDescriptor> superTypeParameters = superDescriptor.getTypeParameters();
            List<TypeParameterDescriptor> subTypeParameters = subDescriptor.getTypeParameters();
            HashBiMap<TypeConstructor, TypeConstructor> axioms = HashBiMap.create();
            int typeParametersSize = superTypeParameters.size();
            for (i = 0; i < typeParametersSize; ++i) {
                superTypeParameter = superTypeParameters.get(i);
                subTypeParameter = subTypeParameters.get(i);
                axioms.put(superTypeParameter.getTypeConstructor(), subTypeParameter.getTypeConstructor());
            }
            typeParametersSize = superTypeParameters.size();
            for (i = 0; i < typeParametersSize; ++i) {
                superTypeParameter = superTypeParameters.get(i);
                subTypeParameter = subTypeParameters.get(i);
                if (JetTypeChecker.INSTANCE.equalTypes(superTypeParameter.getUpperBoundsAsType(), subTypeParameter.getUpperBoundsAsType(), axioms)) continue;
                return OverrideCompatibilityInfo.boundsMismatch(superTypeParameter, subTypeParameter);
            }
            int unsubstitutedValueParametersSize = superValueParameters.size();
            for (i = 0; i < unsubstitutedValueParametersSize; ++i) {
                boolean bothErrors;
                JetType superValueParameter = superValueParameters.get(i);
                JetType subValueParameter = subValueParameters.get(i);
                boolean bl = bothErrors = ErrorUtils.isErrorType(superValueParameter) && ErrorUtils.isErrorType(subValueParameter);
                if (bothErrors || JetTypeChecker.INSTANCE.equalTypes(superValueParameter, subValueParameter, axioms)) continue;
                return OverrideCompatibilityInfo.valueParameterTypeMismatch(superValueParameter, subValueParameter, OverrideCompatibilityInfo.Result.INCOMPATIBLE);
            }
            for (ExternalOverridabilityCondition externalCondition : EXTERNAL_CONDITIONS) {
                if (externalCondition.isOverridable(superDescriptor, subDescriptor)) continue;
                return OverrideCompatibilityInfo.externalConditionFailed(externalCondition.getClass());
            }
        } else {
            for (int i = 0; i < superValueParameters.size(); ++i) {
                JetType subValueParameterType;
                JetType superValueParameterType = OverridingUtil.getUpperBound(superValueParameters.get(i));
                if (JetTypeChecker.INSTANCE.equalTypes(superValueParameterType, subValueParameterType = OverridingUtil.getUpperBound(subValueParameters.get(i)))) continue;
                return OverrideCompatibilityInfo.valueParameterTypeMismatch(superValueParameterType, subValueParameterType, OverrideCompatibilityInfo.Result.INCOMPATIBLE);
            }
            return OverrideCompatibilityInfo.success();
        }
        return OverrideCompatibilityInfo.success();
    }

    private static JetType getUpperBound(JetType type) {
        if (type.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) {
            return type;
        }
        if (type.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return ((TypeParameterDescriptor)type.getConstructor().getDeclarationDescriptor()).getUpperBoundsAsType();
        }
        throw new IllegalStateException("unknown type constructor: " + type.getConstructor().getClass().getName());
    }

    public static boolean isReturnTypeOkForOverride(@NotNull JetTypeChecker typeChecker, @NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
        TypeSubstitutor typeSubstitutor = OverridingUtil.prepareTypeSubstitutor(superDescriptor, subDescriptor);
        if (typeSubstitutor == null) {
            return false;
        }
        JetType superReturnType = superDescriptor.getReturnType();
        assert (superReturnType != null);
        JetType subReturnType = subDescriptor.getReturnType();
        assert (subReturnType != null);
        JetType substitutedSuperReturnType = typeSubstitutor.substitute(superReturnType, Variance.OUT_VARIANCE);
        assert (substitutedSuperReturnType != null);
        return typeChecker.isSubtypeOf(subReturnType, substitutedSuperReturnType);
    }

    @Nullable
    private static TypeSubstitutor prepareTypeSubstitutor(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
        List<TypeParameterDescriptor> superTypeParameters = superDescriptor.getTypeParameters();
        List<TypeParameterDescriptor> subTypeParameters = subDescriptor.getTypeParameters();
        if (subTypeParameters.size() != superTypeParameters.size()) {
            return null;
        }
        HashMap<TypeConstructor, TypeProjection> substitutionContext = Maps.newHashMap();
        for (int i = 0; i < superTypeParameters.size(); ++i) {
            TypeParameterDescriptor superTypeParameter = superTypeParameters.get(i);
            TypeParameterDescriptor subTypeParameter = subTypeParameters.get(i);
            substitutionContext.put(superTypeParameter.getTypeConstructor(), new TypeProjection(subTypeParameter.getDefaultType()));
        }
        return TypeSubstitutor.create(substitutionContext);
    }

    public static boolean isPropertyTypeOkForOverride(@NotNull JetTypeChecker typeChecker, @NotNull PropertyDescriptor superDescriptor, @NotNull PropertyDescriptor subDescriptor) {
        TypeSubstitutor typeSubstitutor = OverridingUtil.prepareTypeSubstitutor(superDescriptor, subDescriptor);
        JetType substitutedSuperReturnType = typeSubstitutor.substitute(superDescriptor.getReturnType(), Variance.OUT_VARIANCE);
        assert (substitutedSuperReturnType != null);
        return !superDescriptor.isVar() || typeChecker.equalTypes(subDescriptor.getReturnType(), substitutedSuperReturnType);
    }

    public static Collection<CallableMemberDescriptor> getOverriddenDeclarations(CallableMemberDescriptor descriptor) {
        HashMap<ClassDescriptor, CallableMemberDescriptor> result = Maps.newHashMap();
        OverridingUtil.getOverriddenDeclarations(descriptor, result);
        return result.values();
    }

    private static void getOverriddenDeclarations(CallableMemberDescriptor descriptor, Map<ClassDescriptor, CallableMemberDescriptor> r) {
        if (descriptor.getKind().isReal()) {
            r.put((ClassDescriptor)descriptor.getContainingDeclaration(), descriptor);
        } else {
            if (descriptor.getOverriddenDescriptors().isEmpty()) {
                throw new IllegalStateException("No overridden descriptors found for (fake override) " + descriptor);
            }
            for (CallableMemberDescriptor callableMemberDescriptor : descriptor.getOverriddenDescriptors()) {
                OverridingUtil.getOverriddenDeclarations(callableMemberDescriptor, r);
            }
        }
    }

    public static void bindOverride(CallableMemberDescriptor fromCurrent, CallableMemberDescriptor fromSupertype) {
        fromCurrent.addOverriddenDescriptor(fromSupertype);
        for (ValueParameterDescriptor parameterFromCurrent : fromCurrent.getValueParameters()) {
            assert (parameterFromCurrent.getIndex() < fromSupertype.getValueParameters().size()) : "An override relation between functions implies that they have the same number of value parameters";
            ValueParameterDescriptor parameterFromSupertype = fromSupertype.getValueParameters().get(parameterFromCurrent.getIndex());
            parameterFromCurrent.addOverriddenDescriptor(parameterFromSupertype);
        }
    }

    public static class OverrideCompatibilityInfo {
        private static final OverrideCompatibilityInfo SUCCESS = new OverrideCompatibilityInfo(Result.OVERRIDABLE, "SUCCESS");
        private final Result overridable;
        private final String message;

        @NotNull
        public static OverrideCompatibilityInfo success() {
            return SUCCESS;
        }

        @NotNull
        public static OverrideCompatibilityInfo nameMismatch() {
            return new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "nameMismatch");
        }

        @NotNull
        public static OverrideCompatibilityInfo typeParameterNumberMismatch() {
            return new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "typeParameterNumberMismatch");
        }

        @NotNull
        public static OverrideCompatibilityInfo receiverPresenceMismatch() {
            return new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "receiverPresenceMismatch");
        }

        @NotNull
        public static OverrideCompatibilityInfo valueParameterNumberMismatch() {
            return new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "valueParameterNumberMismatch");
        }

        @NotNull
        public static OverrideCompatibilityInfo boundsMismatch(TypeParameterDescriptor superTypeParameter, TypeParameterDescriptor subTypeParameter) {
            return new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "boundsMismatch");
        }

        @NotNull
        public static OverrideCompatibilityInfo valueParameterTypeMismatch(JetType superValueParameter, JetType subValueParameter, Result result) {
            return new OverrideCompatibilityInfo(result, "valueParameterTypeMismatch");
        }

        @NotNull
        public static OverrideCompatibilityInfo memberKindMismatch() {
            return new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "memberKindMismatch");
        }

        @NotNull
        public static OverrideCompatibilityInfo returnTypeMismatch(JetType substitutedSuperReturnType, JetType unsubstitutedSubReturnType) {
            return new OverrideCompatibilityInfo(Result.CONFLICT, "returnTypeMismatch: " + unsubstitutedSubReturnType + " >< " + substitutedSuperReturnType);
        }

        @NotNull
        public static OverrideCompatibilityInfo varOverriddenByVal() {
            return new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "varOverriddenByVal");
        }

        @NotNull
        public static OverrideCompatibilityInfo externalConditionFailed(Class<? extends ExternalOverridabilityCondition> conditionClass) {
            return new OverrideCompatibilityInfo(Result.INCOMPATIBLE, "externalConditionFailed: " + conditionClass.getName());
        }

        public OverrideCompatibilityInfo(Result success, String message) {
            this.overridable = success;
            this.message = message;
        }

        public Result getResult() {
            return this.overridable;
        }

        public String getMessage() {
            return this.message;
        }

        public static enum Result {
            OVERRIDABLE,
            INCOMPATIBLE,
            CONFLICT;

        }
    }
}

