/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public class ModifiersChecker {
    private static final Collection<JetKeywordToken> MODALITY_MODIFIERS = Lists.newArrayList(JetTokens.ABSTRACT_KEYWORD, JetTokens.OPEN_KEYWORD, JetTokens.FINAL_KEYWORD, JetTokens.OVERRIDE_KEYWORD);
    private static final Collection<JetKeywordToken> VISIBILITY_MODIFIERS = Lists.newArrayList(JetTokens.PRIVATE_KEYWORD, JetTokens.PROTECTED_KEYWORD, JetTokens.PUBLIC_KEYWORD, JetTokens.INTERNAL_KEYWORD);
    @NotNull
    private final BindingTrace trace;

    public ModifiersChecker(@NotNull BindingTrace trace) {
        this.trace = trace;
    }

    public static ModifiersChecker create(@NotNull BindingTrace trace) {
        return new ModifiersChecker(trace);
    }

    public void checkModifiersForDeclaration(@NotNull JetModifierListOwner modifierListOwner, @NotNull DeclarationDescriptor descriptor) {
        JetModifierList modifierList = modifierListOwner.getModifierList();
        this.checkModalityModifiers(modifierList);
        this.checkVisibilityModifiers(modifierList, descriptor);
        this.checkInnerModifier(modifierListOwner, descriptor);
    }

    public void checkModifiersForLocalDeclaration(@NotNull JetModifierListOwner modifierListOwner) {
        this.checkIllegalModalityModifiers(modifierListOwner);
        this.checkIllegalVisibilityModifiers(modifierListOwner);
    }

    public void checkIllegalModalityModifiers(@NotNull JetModifierListOwner modifierListOwner) {
        this.checkIllegalInThisContextModifiers(modifierListOwner.getModifierList(), MODALITY_MODIFIERS);
    }

    public void checkIllegalVisibilityModifiers(@NotNull JetModifierListOwner modifierListOwner) {
        this.checkIllegalInThisContextModifiers(modifierListOwner.getModifierList(), VISIBILITY_MODIFIERS);
    }

    private void checkModalityModifiers(@Nullable JetModifierList modifierList) {
        if (modifierList == null) {
            return;
        }
        this.checkRedundantModifier(modifierList, Pair.create(JetTokens.OPEN_KEYWORD, JetTokens.ABSTRACT_KEYWORD), Pair.create(JetTokens.OPEN_KEYWORD, JetTokens.OVERRIDE_KEYWORD));
        this.checkCompatibility(modifierList, Lists.newArrayList(JetTokens.ABSTRACT_KEYWORD, JetTokens.OPEN_KEYWORD, JetTokens.FINAL_KEYWORD), Lists.newArrayList(JetTokens.ABSTRACT_KEYWORD, JetTokens.OPEN_KEYWORD));
    }

    private void checkVisibilityModifiers(@Nullable JetModifierList modifierList, @NotNull DeclarationDescriptor descriptor) {
        if (modifierList == null) {
            return;
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (containingDeclaration instanceof NamespaceDescriptor && modifierList.hasModifier(JetTokens.PROTECTED_KEYWORD)) {
            this.trace.report(Errors.PACKAGE_MEMBER_CANNOT_BE_PROTECTED.on(modifierList.getModifierNode(JetTokens.PROTECTED_KEYWORD).getPsi()));
        }
        this.checkCompatibility(modifierList, VISIBILITY_MODIFIERS, new Collection[0]);
    }

    private void checkInnerModifier(@NotNull JetModifierListOwner modifierListOwner, @NotNull DeclarationDescriptor descriptor) {
        PsiElement name;
        JetModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList != null && modifierList.hasModifier(JetTokens.INNER_KEYWORD)) {
            if (ModifiersChecker.isIllegalInner(descriptor)) {
                this.checkIllegalInThisContextModifiers(modifierList, Collections.singletonList(JetTokens.INNER_KEYWORD));
            }
        } else if (modifierListOwner instanceof JetClass && ModifiersChecker.isIllegalNestedClass(descriptor) && (name = ((JetClass)modifierListOwner).getNameIdentifier()) != null) {
            this.trace.report(Errors.NESTED_CLASS_NOT_ALLOWED.on(name));
        }
    }

    private static boolean isIllegalInner(@NotNull DeclarationDescriptor descriptor) {
        if (!(descriptor instanceof ClassDescriptor)) {
            return true;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)descriptor;
        if (classDescriptor.getKind() != ClassKind.CLASS) {
            return true;
        }
        DeclarationDescriptor containingDeclaration = classDescriptor.getContainingDeclaration();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            return true;
        }
        return ((ClassDescriptor)containingDeclaration).getKind() == ClassKind.TRAIT;
    }

    private static boolean isIllegalNestedClass(@NotNull DeclarationDescriptor descriptor) {
        if (!(descriptor instanceof ClassDescriptor)) {
            return false;
        }
        DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
        if (!(containingDeclaration instanceof ClassDescriptor)) {
            return false;
        }
        ClassDescriptor containingClass = (ClassDescriptor)containingDeclaration;
        return containingClass.isInner() || containingClass.getContainingDeclaration() instanceof FunctionDescriptor;
    }

    private void checkCompatibility(@Nullable JetModifierList modifierList, Collection<JetKeywordToken> availableModifiers, Collection<JetToken> ... availableCombinations) {
        if (modifierList == null) {
            return;
        }
        LinkedHashSet<JetKeywordToken> presentModifiers = Sets.newLinkedHashSet();
        for (JetKeywordToken modifier : availableModifiers) {
            if (!modifierList.hasModifier(modifier)) continue;
            presentModifiers.add(modifier);
        }
        if (presentModifiers.size() == 1) {
            return;
        }
        for (Collection<JetToken> combination : availableCombinations) {
            if (!presentModifiers.containsAll(combination) || !combination.containsAll(presentModifiers)) continue;
            return;
        }
        for (JetKeywordToken token : presentModifiers) {
            this.trace.report(Errors.INCOMPATIBLE_MODIFIERS.on(modifierList.getModifierNode(token).getPsi(), presentModifiers));
        }
    }

    private void checkRedundantModifier(@NotNull JetModifierList modifierList, Pair<JetKeywordToken, JetKeywordToken> ... redundantBundles) {
        for (Pair<JetKeywordToken, JetKeywordToken> tokenPair : redundantBundles) {
            JetKeywordToken redundantModifier = tokenPair.getFirst();
            JetKeywordToken sufficientModifier = tokenPair.getSecond();
            if (!modifierList.hasModifier(redundantModifier) || !modifierList.hasModifier(sufficientModifier)) continue;
            this.trace.report(Errors.REDUNDANT_MODIFIER.on(modifierList.getModifierNode(redundantModifier).getPsi(), redundantModifier, sufficientModifier));
        }
    }

    public void checkIllegalInThisContextModifiers(@Nullable JetModifierList modifierList, @NotNull Collection<JetKeywordToken> illegalModifiers) {
        if (modifierList == null) {
            return;
        }
        for (JetKeywordToken modifier : illegalModifiers) {
            if (!modifierList.hasModifier(modifier)) continue;
            this.trace.report(Errors.ILLEGAL_MODIFIER.on(modifierList.getModifierNode(modifier).getPsi(), modifier));
        }
    }

    @NotNull
    public static Map<JetKeywordToken, ASTNode> getNodesCorrespondingToModifiers(@NotNull JetModifierList modifierList, @NotNull Collection<JetKeywordToken> possibleModifiers) {
        HashMap<JetKeywordToken, ASTNode> nodes = Maps.newHashMap();
        for (JetKeywordToken modifier : possibleModifiers) {
            if (!modifierList.hasModifier(modifier)) continue;
            nodes.put(modifier, modifierList.getModifierNode(modifier));
        }
        return nodes;
    }

    @NotNull
    public static Modality resolveModalityFromModifiers(@NotNull JetModifierListOwner modifierListOwner, @NotNull Modality defaultModality) {
        return ModifiersChecker.resolveModalityFromModifiers(modifierListOwner.getModifierList(), defaultModality);
    }

    public static Modality resolveModalityFromModifiers(@Nullable JetModifierList modifierList, @NotNull Modality defaultModality) {
        if (modifierList == null) {
            return defaultModality;
        }
        boolean hasAbstractModifier = modifierList.hasModifier(JetTokens.ABSTRACT_KEYWORD);
        boolean hasOverrideModifier = modifierList.hasModifier(JetTokens.OVERRIDE_KEYWORD);
        if (modifierList.hasModifier(JetTokens.OPEN_KEYWORD)) {
            if (hasAbstractModifier || defaultModality == Modality.ABSTRACT) {
                return Modality.ABSTRACT;
            }
            return Modality.OPEN;
        }
        if (hasAbstractModifier) {
            return Modality.ABSTRACT;
        }
        boolean hasFinalModifier = modifierList.hasModifier(JetTokens.FINAL_KEYWORD);
        if (hasOverrideModifier && !hasFinalModifier && defaultModality != Modality.ABSTRACT) {
            return Modality.OPEN;
        }
        if (hasFinalModifier) {
            return Modality.FINAL;
        }
        return defaultModality;
    }

    @NotNull
    public static Visibility resolveVisibilityFromModifiers(@NotNull JetModifierListOwner modifierListOwner) {
        return ModifiersChecker.resolveVisibilityFromModifiers(modifierListOwner, Visibilities.INTERNAL);
    }

    @NotNull
    public static Visibility resolveVisibilityFromModifiers(@NotNull JetModifierListOwner modifierListOwner, @NotNull Visibility defaultVisibility) {
        return ModifiersChecker.resolveVisibilityFromModifiers(modifierListOwner.getModifierList(), defaultVisibility);
    }

    public static Visibility resolveVisibilityFromModifiers(@Nullable JetModifierList modifierList, @NotNull Visibility defaultVisibility) {
        if (modifierList == null) {
            return defaultVisibility;
        }
        if (modifierList.hasModifier(JetTokens.PRIVATE_KEYWORD)) {
            return Visibilities.PRIVATE;
        }
        if (modifierList.hasModifier(JetTokens.PUBLIC_KEYWORD)) {
            return Visibilities.PUBLIC;
        }
        if (modifierList.hasModifier(JetTokens.PROTECTED_KEYWORD)) {
            return Visibilities.PROTECTED;
        }
        if (modifierList.hasModifier(JetTokens.INTERNAL_KEYWORD)) {
            return Visibilities.INTERNAL;
        }
        return defaultVisibility;
    }

    public static boolean isInnerClass(@Nullable JetModifierList modifierList) {
        return modifierList != null && modifierList.hasModifier(JetTokens.INNER_KEYWORD);
    }

    @NotNull
    public static Visibility getDefaultClassVisibility(@NotNull ClassDescriptor descriptor) {
        ClassKind kind = descriptor.getKind();
        if (kind == ClassKind.ENUM_ENTRY) {
            return Visibilities.PRIVATE;
        }
        return Visibilities.INTERNAL;
    }

    @NotNull
    public static Visibility getDefaultVisibilityForObjectPropertyDescriptor(@NotNull ClassDescriptor objectClassDescriptor) {
        if (objectClassDescriptor.getKind() == ClassKind.ENUM_ENTRY) {
            return Visibilities.PUBLIC;
        }
        return Visibilities.INTERNAL;
    }
}

