/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.cfg.pseudocode.AbstractJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.JetElementInstruction;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;

public class ReturnValueInstruction
extends AbstractJumpInstruction
implements JetElementInstruction {
    private final JetElement element;

    public ReturnValueInstruction(@NotNull JetExpression returnExpression, @NotNull Label targetLabel) {
        super(targetLabel);
        this.element = returnExpression;
    }

    @Override
    public void accept(InstructionVisitor visitor) {
        visitor.visitReturnValue(this);
    }

    public String toString() {
        return "ret(*) " + this.getTargetLabel();
    }

    @Override
    @NotNull
    public JetElement getElement() {
        return this.element;
    }

    @Override
    protected AbstractJumpInstruction createCopy(@NotNull Label newLabel) {
        return new ReturnValueInstruction((JetExpression)this.element, newLabel);
    }
}

