/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Label;
import org.jetbrains.asm4.MethodVisitor;
import org.jetbrains.asm4.Type;
import org.jetbrains.asm4.commons.InstructionAdapter;
import org.jetbrains.asm4.commons.Method;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.Callable;
import org.jetbrains.jet.codegen.CallableMethod;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClosureCodegen;
import org.jetbrains.jet.codegen.CodegenStatementVisitor;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.codegen.FieldInfo;
import org.jetbrains.jet.codegen.FrameMap;
import org.jetbrains.jet.codegen.FunctionGenerationStrategy;
import org.jetbrains.jet.codegen.FunctionTypesUtil;
import org.jetbrains.jet.codegen.ImplementationBodyCodegen;
import org.jetbrains.jet.codegen.MethodKind;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.RangeCodegenUtil;
import org.jetbrains.jet.codegen.SamCodegenUtil;
import org.jetbrains.jet.codegen.StackValue;
import org.jetbrains.jet.codegen.binding.CalculatedClosure;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.binding.MutableClosure;
import org.jetbrains.jet.codegen.context.ClassContext;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.ConstructorContext;
import org.jetbrains.jet.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.jet.codegen.context.FieldOwnerContext;
import org.jetbrains.jet.codegen.context.LocalLookup;
import org.jetbrains.jet.codegen.context.MethodContext;
import org.jetbrains.jet.codegen.context.ScriptContext;
import org.jetbrains.jet.codegen.intrinsics.IntrinsicMethod;
import org.jetbrains.jet.codegen.signature.JvmMethodSignature;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.codegen.state.JetTypeMapperMode;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetAnnotatedExpression;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetBreakExpression;
import org.jetbrains.jet.lang.psi.JetCallElement;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetCallableReferenceExpression;
import org.jetbrains.jet.lang.psi.JetCatchClause;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetContinueExpression;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperCall;
import org.jetbrains.jet.lang.psi.JetDoWhileExpression;
import org.jetbrains.jet.lang.psi.JetDotQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetEscapeStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFinallySection;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetIsExpression;
import org.jetbrains.jet.lang.psi.JetLiteralStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetMultiDeclaration;
import org.jetbrains.jet.lang.psi.JetMultiDeclarationEntry;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetOperationExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPostfixExpression;
import org.jetbrains.jet.lang.psi.JetPrefixExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSafeQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntry;
import org.jetbrains.jet.lang.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.psi.JetThisExpression;
import org.jetbrains.jet.lang.psi.JetThrowExpression;
import org.jetbrains.jet.lang.psi.JetTryExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVariableDeclaration;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetWhenCondition;
import org.jetbrains.jet.lang.psi.JetWhenConditionInRange;
import org.jetbrains.jet.lang.psi.JetWhenConditionIsPattern;
import org.jetbrains.jet.lang.psi.JetWhenConditionWithExpression;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.psi.JetWhileExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.autocasts.AutoCastReceiver;
import org.jetbrains.jet.lang.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.DelegatingResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.VarargValueArgument;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.calls.util.ExpressionAsFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.java.AsmTypeConstants;
import org.jetbrains.jet.lang.resolve.java.JavaBindingContext;
import org.jetbrains.jet.lang.resolve.java.JvmAbi;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.java.descriptor.ClassDescriptorFromJvmBytecode;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ScriptReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.renderer.DescriptorRenderer;

public class ExpressionCodegen
extends JetVisitor<StackValue, StackValue>
implements LocalLookup {
    public static final Set<DeclarationDescriptor> INTEGRAL_RANGES = KotlinBuiltIns.getInstance().getIntegralRanges();
    private int myLastLineNumber = -1;
    final InstructionAdapter v;
    final MethodVisitor methodVisitor;
    final FrameMap myFrameMap;
    final JetTypeMapper typeMapper;
    private final GenerationState state;
    private final Type returnType;
    private final BindingContext bindingContext;
    final MethodContext context;
    private final CodegenStatementVisitor statementVisitor;
    private final Stack<BlockStackElement> blockStackElements = new Stack();
    private final Collection<String> localVariableNames = new HashSet<String>();
    private final Map<JetElement, StackValue.Local> tempVariables = Maps.newHashMap();

    public CalculatedClosure generateObjectLiteral(GenerationState state, JetObjectLiteralExpression literal) {
        JetObjectDeclaration objectDeclaration = literal.getObjectDeclaration();
        JvmClassName className = CodegenBinding.classNameForAnonymousClass(this.bindingContext, objectDeclaration);
        ClassBuilder classBuilder = state.getFactory().newVisitor(className.getInternalName(), literal.getContainingFile());
        ClassDescriptor classDescriptor = this.bindingContext.get(BindingContext.CLASS, objectDeclaration);
        assert (classDescriptor != null);
        CalculatedClosure closure = this.bindingContext.get(CodegenBinding.CLOSURE, classDescriptor);
        ClassContext objectContext = this.context.intoAnonymousClass(classDescriptor, this);
        ImplementationBodyCodegen implementationBodyCodegen = new ImplementationBodyCodegen(objectDeclaration, objectContext, classBuilder, state, null);
        implementationBodyCodegen.generate();
        return closure;
    }

    public ExpressionCodegen(@NotNull MethodVisitor v, @NotNull FrameMap myMap, @NotNull Type returnType, @NotNull MethodContext context, @NotNull GenerationState state) {
        this.myFrameMap = myMap;
        this.typeMapper = state.getTypeMapper();
        this.returnType = returnType;
        this.state = state;
        this.methodVisitor = v;
        this.v = this.createInstructionAdapter(this.methodVisitor);
        this.bindingContext = state.getBindingContext();
        this.context = context;
        this.statementVisitor = new CodegenStatementVisitor(this);
    }

    protected InstructionAdapter createInstructionAdapter(MethodVisitor mv) {
        return new InstructionAdapter(this.methodVisitor){

            @Override
            public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                super.visitLocalVariable(name, desc, signature, start, end, index);
                ExpressionCodegen.this.localVariableNames.add(name);
            }
        };
    }

    public GenerationState getState() {
        return this.state;
    }

    StackValue castToRequiredTypeOfInterfaceIfNeeded(StackValue inner, DeclarationDescriptor provided, @Nullable ClassDescriptor required) {
        if (required == null) {
            return inner;
        }
        if (provided instanceof CallableDescriptor) {
            ReceiverParameterDescriptor receiverParameter = ((CallableDescriptor)provided).getReceiverParameter();
            assert (receiverParameter != null) : receiverParameter;
            provided = receiverParameter.getType().getConstructor().getDeclarationDescriptor();
        }
        assert (provided instanceof ClassDescriptor);
        if (!CodegenUtil.isInterface(provided) && CodegenUtil.isInterface(required)) {
            inner.put(AsmTypeConstants.OBJECT_TYPE, this.v);
            Type type = this.asmType(required.getDefaultType());
            this.v.checkcast(type);
            return StackValue.onStack(type);
        }
        return inner;
    }

    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    public Collection<String> getLocalVariableNamesForExpression() {
        return this.localVariableNames;
    }

    public StackValue genQualified(StackValue receiver, JetElement selector) {
        return this.genQualified(receiver, selector, this);
    }

    private StackValue genQualified(StackValue receiver, JetElement selector, JetVisitor<StackValue, StackValue> visitor) {
        if (this.tempVariables.containsKey(selector)) {
            throw new IllegalStateException("Inconsistent state: expression saved to a temporary variable is a selector");
        }
        if (!(selector instanceof JetBlockExpression)) {
            this.markLineNumber(selector);
        }
        try {
            if (selector instanceof JetExpression) {
                JetExpression expression = (JetExpression)selector;
                CompileTimeConstant<?> constant = this.bindingContext.get(BindingContext.COMPILE_TIME_VALUE, expression);
                if (constant != null) {
                    return StackValue.constant(constant.getValue(), this.expressionType(expression));
                }
                ClassDescriptorFromJvmBytecode samInterface = this.bindingContext.get(CodegenBinding.SAM_VALUE, expression);
                if (samInterface != null) {
                    return this.genSamInterfaceValue(expression, samInterface, visitor);
                }
            }
            return selector.accept(visitor, receiver);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (Throwable error) {
            String message = error.getMessage();
            throw new CompilationException(message != null ? message : "null", error, selector);
        }
    }

    public StackValue gen(JetElement expr) {
        StackValue tempVar = this.tempVariables.get(expr);
        return tempVar != null ? tempVar : this.genQualified(StackValue.none(), expr);
    }

    public void gen(JetElement expr, Type type) {
        StackValue value = this.gen(expr);
        value.put(type, this.v);
    }

    public void genToJVMStack(JetExpression expr) {
        this.gen(expr, this.expressionType(expr));
    }

    private StackValue genStatement(JetElement statement) {
        return this.genQualified(StackValue.none(), statement, this.statementVisitor);
    }

    @Override
    public StackValue visitClass(JetClass klass, StackValue data) {
        return this.visitClassOrObject(klass);
    }

    private StackValue visitClassOrObject(JetClassOrObject declaration) {
        ClassDescriptor descriptor = this.bindingContext.get(BindingContext.CLASS, declaration);
        assert (descriptor != null);
        JvmClassName className = CodegenBinding.classNameForAnonymousClass(this.bindingContext, declaration);
        ClassBuilder classBuilder = this.state.getFactory().newVisitor(className.getInternalName(), declaration.getContainingFile());
        ClassContext objectContext = this.context.intoAnonymousClass(descriptor, this);
        new ImplementationBodyCodegen(declaration, objectContext, classBuilder, this.state, null).generate();
        return StackValue.none();
    }

    @Override
    public StackValue visitObjectDeclaration(JetObjectDeclaration declaration, StackValue data) {
        return this.visitClassOrObject(declaration);
    }

    @Override
    public StackValue visitExpression(JetExpression expression, StackValue receiver) {
        throw new UnsupportedOperationException("Codegen for " + expression + " is not yet implemented");
    }

    @Override
    public StackValue visitSuperExpression(JetSuperExpression expression, StackValue data) {
        return StackValue.thisOrOuter(this, this.getSuperCallLabelTarget(expression), true);
    }

    private ClassDescriptor getSuperCallLabelTarget(JetSuperExpression expression) {
        return ExpressionCodegen.getSuperCallLabelTarget(expression, this.bindingContext, this.context);
    }

    @NotNull
    private static ClassDescriptor getSuperCallLabelTarget(JetSuperExpression expression, BindingContext bindingContext, CodegenContext context) {
        PsiElement labelPsi = bindingContext.get(BindingContext.LABEL_TARGET, expression.getTargetLabel());
        ClassDescriptor labelTarget = (ClassDescriptor)bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, labelPsi);
        DeclarationDescriptor descriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getInstanceReference());
        if (labelTarget != null) {
            return labelTarget;
        }
        assert (descriptor instanceof ClassDescriptor) : "Don't know how to generate super-call to not a class";
        return ExpressionCodegen.getParentContextSubclassOf((ClassDescriptor)descriptor, context).getThisDescriptor();
    }

    @NotNull
    private Type asmType(@NotNull JetType type) {
        return this.typeMapper.mapType(type);
    }

    @NotNull
    private Type asmTypeOrVoid(@Nullable JetType type) {
        return type == null ? Type.VOID_TYPE : this.asmType(type);
    }

    @Override
    public StackValue visitParenthesizedExpression(JetParenthesizedExpression expression, StackValue receiver) {
        return this.genQualified(receiver, expression.getExpression());
    }

    @Override
    public StackValue visitAnnotatedExpression(JetAnnotatedExpression expression, StackValue receiver) {
        return this.genQualified(receiver, expression.getBaseExpression());
    }

    private static boolean isEmptyExpression(JetElement expr) {
        JetBlockExpression blockExpression;
        List<JetElement> statements;
        if (expr == null) {
            return true;
        }
        return expr instanceof JetBlockExpression && ((statements = (blockExpression = (JetBlockExpression)expr).getStatements()).size() == 0 || statements.size() == 1 && ExpressionCodegen.isEmptyExpression(statements.get(0)));
    }

    @Override
    public StackValue visitIfExpression(JetIfExpression expression, StackValue receiver) {
        return this.generateIfExpression(expression, false);
    }

    StackValue generateIfExpression(JetIfExpression expression, boolean isStatement) {
        Type asmType = isStatement ? Type.VOID_TYPE : this.expressionType(expression);
        StackValue condition = this.gen(expression.getCondition());
        JetExpression thenExpression = expression.getThen();
        JetExpression elseExpression = expression.getElse();
        if (thenExpression == null && elseExpression == null) {
            throw new CompilationException("Both brunches of if/else are null", null, expression);
        }
        if (ExpressionCodegen.isEmptyExpression(thenExpression)) {
            if (ExpressionCodegen.isEmptyExpression(elseExpression)) {
                condition.put(asmType, this.v);
                return StackValue.onStack(asmType);
            }
            return this.generateSingleBranchIf(condition, expression, elseExpression, false, isStatement);
        }
        if (ExpressionCodegen.isEmptyExpression(elseExpression)) {
            return this.generateSingleBranchIf(condition, expression, thenExpression, true, isStatement);
        }
        Label elseLabel = new Label();
        condition.condJump(elseLabel, true, this.v);
        Label end = new Label();
        this.gen(thenExpression, asmType);
        this.v.goTo(end);
        this.v.mark(elseLabel);
        this.gen(elseExpression, asmType);
        this.markLineNumber(expression);
        this.v.mark(end);
        return StackValue.onStack(asmType);
    }

    @Override
    public StackValue visitWhileExpression(JetWhileExpression expression, StackValue receiver) {
        Label condition = new Label();
        this.v.mark(condition);
        Label end = new Label();
        this.blockStackElements.push(new LoopBlockStackElement(end, condition, ExpressionCodegen.targetLabel(expression)));
        StackValue conditionValue = this.gen(expression.getCondition());
        conditionValue.condJump(end, true, this.v);
        this.gen(expression.getBody(), Type.VOID_TYPE);
        this.v.goTo(condition);
        this.v.mark(end);
        this.blockStackElements.pop();
        return StackValue.onStack(Type.VOID_TYPE);
    }

    @Override
    public StackValue visitDoWhileExpression(JetDoWhileExpression expression, StackValue receiver) {
        StackValue conditionValue;
        Label continueLabel = new Label();
        this.v.mark(continueLabel);
        Label breakLabel = new Label();
        this.blockStackElements.push(new LoopBlockStackElement(breakLabel, continueLabel, ExpressionCodegen.targetLabel(expression)));
        JetExpression body = expression.getBody();
        JetExpression condition = expression.getCondition();
        if (body instanceof JetBlockExpression) {
            List<JetElement> doWhileStatements = ((JetBlockExpression)body).getStatements();
            ArrayList<JetElement> statements = new ArrayList<JetElement>(doWhileStatements.size() + 1);
            statements.addAll(doWhileStatements);
            statements.add(condition);
            conditionValue = this.generateBlock(statements, true);
        } else {
            this.gen(body, Type.VOID_TYPE);
            conditionValue = this.gen(condition);
        }
        conditionValue.condJump(continueLabel, false, this.v);
        this.v.mark(breakLabel);
        this.blockStackElements.pop();
        return StackValue.none();
    }

    @Override
    public StackValue visitForExpression(JetForExpression forExpression, StackValue receiver) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall;
        RangeCodegenUtil.BinaryCall binaryCall = RangeCodegenUtil.getRangeAsBinaryCall(forExpression);
        if (binaryCall != null && (resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, binaryCall.op)) != null && RangeCodegenUtil.isOptimizableRangeTo(resolvedCall.getResultingDescriptor())) {
            this.generateForLoop(new ForInRangeLiteralLoopGenerator(forExpression, binaryCall));
            return StackValue.none();
        }
        JetExpression loopRange = forExpression.getLoopRange();
        JetType loopRangeType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, loopRange);
        assert (loopRangeType != null);
        Type asmLoopRangeType = this.asmType(loopRangeType);
        if (asmLoopRangeType.getSort() == 9) {
            this.generateForLoop(new ForInArrayLoopGenerator(forExpression));
            return StackValue.none();
        }
        if (RangeCodegenUtil.isRange(loopRangeType)) {
            this.generateForLoop(new ForInRangeInstanceLoopGenerator(forExpression));
            return StackValue.none();
        }
        if (RangeCodegenUtil.isProgression(loopRangeType)) {
            this.generateForLoop(new ForInProgressionExpressionLoopGenerator(forExpression));
            return StackValue.none();
        }
        this.generateForLoop(new IteratorForLoopGenerator(forExpression));
        return StackValue.none();
    }

    private OwnerKind contextKind() {
        return this.context.getContextKind();
    }

    private void generateForLoop(AbstractForLoopGenerator generator) {
        Label loopExit = new Label();
        Label loopEntry = new Label();
        Label continueLabel = new Label();
        generator.beforeLoop();
        generator.checkEmptyLoop(loopExit);
        this.v.mark(loopEntry);
        generator.checkPreCondition(loopExit);
        generator.beforeBody();
        this.blockStackElements.push(new LoopBlockStackElement(loopExit, continueLabel, ExpressionCodegen.targetLabel(generator.forExpression)));
        generator.body();
        this.blockStackElements.pop();
        this.v.mark(continueLabel);
        generator.afterBody(loopExit);
        this.v.goTo(loopEntry);
        this.v.mark(loopExit);
        generator.afterLoop();
    }

    @Override
    public StackValue visitBreakExpression(JetBreakExpression expression, StackValue receiver) {
        JetSimpleNameExpression labelElement = expression.getTargetLabel();
        for (int i = this.blockStackElements.size() - 1; i >= 0; --i) {
            BlockStackElement stackElement = (BlockStackElement)this.blockStackElements.get(i);
            if (stackElement instanceof FinallyBlockStackElement) {
                FinallyBlockStackElement finallyBlockStackElement = (FinallyBlockStackElement)stackElement;
                JetTryExpression jetTryExpression = finallyBlockStackElement.expression;
                this.gen(jetTryExpression.getFinallyBlock().getFinalExpression(), Type.VOID_TYPE);
                continue;
            }
            if (stackElement instanceof LoopBlockStackElement) {
                LoopBlockStackElement loopBlockStackElement = (LoopBlockStackElement)stackElement;
                if (labelElement != null && (loopBlockStackElement.targetLabel == null || !labelElement.getReferencedName().equals(loopBlockStackElement.targetLabel.getReferencedName()))) continue;
                this.v.goTo(loopBlockStackElement.breakLabel);
                return StackValue.none();
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public StackValue visitContinueExpression(JetContinueExpression expression, StackValue receiver) {
        JetSimpleNameExpression labelElement = expression.getTargetLabel();
        for (int i = this.blockStackElements.size() - 1; i >= 0; --i) {
            BlockStackElement stackElement = (BlockStackElement)this.blockStackElements.get(i);
            if (stackElement instanceof FinallyBlockStackElement) {
                FinallyBlockStackElement finallyBlockStackElement = (FinallyBlockStackElement)stackElement;
                JetTryExpression jetTryExpression = finallyBlockStackElement.expression;
                this.gen(jetTryExpression.getFinallyBlock().getFinalExpression(), Type.VOID_TYPE);
                continue;
            }
            if (stackElement instanceof LoopBlockStackElement) {
                LoopBlockStackElement loopBlockStackElement = (LoopBlockStackElement)stackElement;
                if (labelElement != null && (loopBlockStackElement.targetLabel == null || !labelElement.getReferencedName().equals(loopBlockStackElement.targetLabel.getReferencedName()))) continue;
                this.v.goTo(loopBlockStackElement.continueLabel);
                return StackValue.none();
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    private StackValue generateSingleBranchIf(StackValue condition, JetIfExpression ifExpression, JetExpression expression, boolean inverse, boolean isStatement) {
        Label elseLabel = new Label();
        condition.condJump(elseLabel, inverse, this.v);
        if (isStatement) {
            this.gen(expression, Type.VOID_TYPE);
            this.v.mark(elseLabel);
            return StackValue.none();
        }
        Type type = this.expressionType(expression);
        Type targetType = type.equals(AsmTypeConstants.JET_UNIT_TYPE) ? type : AsmTypeConstants.OBJECT_TYPE;
        this.gen(expression, targetType);
        Label end = new Label();
        this.v.goTo(end);
        this.markLineNumber(ifExpression);
        this.v.mark(elseLabel);
        StackValue.putUnitInstance(this.v);
        this.v.mark(end);
        return StackValue.onStack(targetType);
    }

    @Override
    public StackValue visitConstantExpression(JetConstantExpression expression, StackValue receiver) {
        CompileTimeConstant<?> compileTimeValue = this.bindingContext.get(BindingContext.COMPILE_TIME_VALUE, expression);
        assert (compileTimeValue != null);
        return StackValue.constant(compileTimeValue.getValue(), this.expressionType(expression));
    }

    @Override
    public StackValue visitStringTemplateExpression(JetStringTemplateExpression expression, StackValue receiver) {
        StringBuilder constantValue = new StringBuilder("");
        JetStringTemplateEntry[] entries = expression.getEntries();
        if (entries.length == 1 && entries[0] instanceof JetStringTemplateEntryWithExpression) {
            JetExpression expr = entries[0].getExpression();
            return AsmUtil.genToString(this.v, this.gen(expr), this.expressionType(expr));
        }
        for (JetStringTemplateEntry entry : entries) {
            if (entry instanceof JetLiteralStringTemplateEntry) {
                constantValue.append(entry.getText());
                continue;
            }
            if (entry instanceof JetEscapeStringTemplateEntry) {
                constantValue.append(((JetEscapeStringTemplateEntry)entry).getUnescapedValue());
                continue;
            }
            constantValue = null;
            break;
        }
        if (constantValue != null) {
            Type type = this.expressionType(expression);
            return StackValue.constant(constantValue.toString(), type);
        }
        AsmUtil.genStringBuilderConstructor(this.v);
        for (JetStringTemplateEntry entry : entries) {
            if (entry instanceof JetStringTemplateEntryWithExpression) {
                this.invokeAppend(entry.getExpression());
                continue;
            }
            String text = entry instanceof JetEscapeStringTemplateEntry ? ((JetEscapeStringTemplateEntry)entry).getUnescapedValue() : entry.getText();
            this.v.aconst(text);
            AsmUtil.genInvokeAppendMethod(this.v, AsmTypeConstants.JAVA_STRING_TYPE);
        }
        this.v.invokevirtual("java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
        return StackValue.onStack(AsmTypeConstants.JAVA_STRING_TYPE);
    }

    @Override
    public StackValue visitBlockExpression(JetBlockExpression expression, StackValue receiver) {
        List<JetElement> statements = expression.getStatements();
        JetType unitType = KotlinBuiltIns.getInstance().getUnitType();
        boolean lastStatementIsExpression = !((Object)unitType).equals(this.bindingContext.get(BindingContext.EXPRESSION_TYPE, expression));
        return this.generateBlock(statements, lastStatementIsExpression);
    }

    @Override
    public StackValue visitNamedFunction(JetNamedFunction function, StackValue data) {
        assert (data == StackValue.none());
        if (JetPsiUtil.isScriptDeclaration(function)) {
            return StackValue.none();
        }
        StackValue closure = this.genClosure(function, null);
        DeclarationDescriptor descriptor = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function);
        int index = this.lookupLocalIndex(descriptor);
        closure.put(AsmTypeConstants.OBJECT_TYPE, this.v);
        this.v.store(index, AsmTypeConstants.OBJECT_TYPE);
        return StackValue.none();
    }

    @Override
    public StackValue visitFunctionLiteralExpression(JetFunctionLiteralExpression expression, StackValue receiver) {
        if (this.bindingContext.get(BindingContext.BLOCK, expression).booleanValue()) {
            return this.gen(expression.getFunctionLiteral().getBodyExpression());
        }
        return this.genClosure(expression.getFunctionLiteral(), null);
    }

    private StackValue genClosure(JetDeclarationWithBody declaration, @Nullable ClassDescriptor samInterfaceClass) {
        FunctionDescriptor descriptor = this.bindingContext.get(BindingContext.FUNCTION, declaration);
        assert (descriptor != null) : "Function is not resolved to descriptor: " + declaration.getText();
        JvmClassName closureSuperClass = samInterfaceClass == null ? FunctionTypesUtil.getFunctionImplClassName(descriptor) : JvmClassName.byType(AsmTypeConstants.OBJECT_TYPE);
        ClosureCodegen closureCodegen = new ClosureCodegen(this.state, declaration, descriptor, samInterfaceClass, closureSuperClass, this.context, this, new FunctionGenerationStrategy.FunctionDefault(this.state, descriptor, declaration));
        closureCodegen.gen();
        return closureCodegen.putInstanceOnStack(this.v, this);
    }

    @Override
    public StackValue visitObjectLiteralExpression(JetObjectLiteralExpression expression, StackValue receiver) {
        CalculatedClosure closure = this.generateObjectLiteral(this.state, expression);
        ConstructorDescriptor constructorDescriptor = this.bindingContext.get(BindingContext.CONSTRUCTOR, expression.getObjectDeclaration());
        assert (constructorDescriptor != null);
        CallableMethod constructor = this.typeMapper.mapToCallableMethod(constructorDescriptor, closure);
        JvmClassName name = this.bindingContext.get(CodegenBinding.FQN, constructorDescriptor.getContainingDeclaration());
        assert (name != null);
        Type type = name.getAsmType();
        this.v.anew(type);
        this.v.dup();
        Method cons = constructor.getSignature().getAsmMethod();
        this.pushClosureOnStack(closure, false);
        JetDelegatorToSuperCall superCall = closure.getSuperCall();
        if (superCall != null) {
            ConstructorDescriptor superConstructor = (ConstructorDescriptor)this.bindingContext.get(BindingContext.REFERENCE_TARGET, superCall.getCalleeExpression().getConstructorReferenceExpression());
            assert (superConstructor != null);
            CallableMethod superCallable = this.typeMapper.mapToCallableMethod(superConstructor);
            Type[] argumentTypes = superCallable.getSignature().getAsmMethod().getArgumentTypes();
            ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, superCall.getCalleeExpression());
            assert (resolvedCall != null);
            this.pushMethodArguments(resolvedCall, Arrays.asList(argumentTypes));
        }
        this.v.invokespecial(name.getInternalName(), "<init>", cons.getDescriptor());
        return StackValue.onStack(type);
    }

    protected void pushClosureOnStack(CalculatedClosure closure, boolean ignoreThisAndReceiver) {
        if (closure != null) {
            if (!ignoreThisAndReceiver) {
                ClassifierDescriptor captureReceiver;
                ClassDescriptor captureThis = closure.getCaptureThis();
                if (captureThis != null) {
                    this.generateThisOrOuter(captureThis, false).put(AsmTypeConstants.OBJECT_TYPE, this.v);
                }
                if ((captureReceiver = closure.getCaptureReceiver()) != null) {
                    Type asmType = this.typeMapper.mapType(captureReceiver.getDefaultType(), JetTypeMapperMode.IMPL);
                    this.v.load(this.context.isStatic() ? 0 : 1, asmType);
                }
            }
            for (Map.Entry<DeclarationDescriptor, EnclosedValueDescriptor> entry : closure.getCaptureVariables().entrySet()) {
                Type sharedVarType = this.typeMapper.getSharedVarType(entry.getKey());
                if (sharedVarType == null) {
                    sharedVarType = this.typeMapper.mapType((VariableDescriptor)entry.getKey());
                }
                entry.getValue().getOuterValue(this).put(sharedVarType, this.v);
            }
        }
    }

    private StackValue generateBlock(List<JetElement> statements, boolean lastStatementIsExpression) {
        Label blockEnd = new Label();
        ArrayList<Function<StackValue, Void>> leaveTasks = Lists.newArrayList();
        StackValue answer = StackValue.none();
        Iterator<JetElement> iterator = statements.iterator();
        while (iterator.hasNext()) {
            StackValue result;
            JetNamedDeclaration declaration;
            JetElement statement = iterator.next();
            if (statement instanceof JetNamedDeclaration && JetPsiUtil.isScriptDeclaration(declaration = (JetNamedDeclaration)statement)) continue;
            if (statement instanceof JetMultiDeclaration) {
                JetMultiDeclaration multiDeclaration = (JetMultiDeclaration)statement;
                for (JetMultiDeclarationEntry entry : multiDeclaration.getEntries()) {
                    this.generateLocalVariableDeclaration(entry, blockEnd, leaveTasks);
                }
            }
            if (statement instanceof JetVariableDeclaration) {
                this.generateLocalVariableDeclaration((JetVariableDeclaration)statement, blockEnd, leaveTasks);
            }
            if (statement instanceof JetNamedFunction) {
                this.generateLocalFunctionDeclaration((JetNamedFunction)statement, leaveTasks);
            }
            boolean isExpression = !iterator.hasNext() && lastStatementIsExpression;
            StackValue stackValue = result = isExpression ? this.gen(statement) : this.genStatement(statement);
            if (!iterator.hasNext()) {
                answer = result;
                continue;
            }
            result.put(Type.VOID_TYPE, this.v);
        }
        this.v.mark(blockEnd);
        for (Function task : Lists.reverse(leaveTasks)) {
            task.fun(answer);
        }
        return answer;
    }

    private void generateLocalVariableDeclaration(@NotNull JetVariableDeclaration variableDeclaration, final @NotNull Label blockEnd, @NotNull List<Function<StackValue, Void>> leaveTasks) {
        final VariableDescriptor variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, variableDeclaration);
        assert (variableDescriptor != null);
        final Label scopeStart = new Label();
        this.v.mark(scopeStart);
        final Type sharedVarType = this.typeMapper.getSharedVarType(variableDescriptor);
        final Type type = sharedVarType != null ? sharedVarType : this.asmType(variableDescriptor.getType());
        int index = this.myFrameMap.enter(variableDescriptor, type);
        if (sharedVarType != null) {
            this.v.anew(sharedVarType);
            this.v.dup();
            this.v.invokespecial(sharedVarType.getInternalName(), "<init>", "()V");
            this.v.store(index, AsmTypeConstants.OBJECT_TYPE);
        }
        leaveTasks.add(new Function<StackValue, Void>(){

            @Override
            public Void fun(StackValue answer) {
                int index = ExpressionCodegen.this.myFrameMap.leave(variableDescriptor);
                if (sharedVarType != null) {
                    if (answer instanceof StackValue.Shared && index == ((StackValue.Shared)answer).getIndex()) {
                        ((StackValue.Shared)answer).releaseOnPut();
                    } else {
                        ExpressionCodegen.this.v.aconst(null);
                        ExpressionCodegen.this.v.store(index, AsmTypeConstants.OBJECT_TYPE);
                    }
                }
                ExpressionCodegen.this.v.visitLocalVariable(variableDescriptor.getName().asString(), type.getDescriptor(), null, scopeStart, blockEnd, index);
                return null;
            }
        });
    }

    private void generateLocalFunctionDeclaration(@NotNull JetNamedFunction namedFunction, @NotNull List<Function<StackValue, Void>> leaveTasks) {
        final DeclarationDescriptor descriptor = this.bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, namedFunction);
        this.myFrameMap.enter(descriptor, AsmTypeConstants.OBJECT_TYPE);
        leaveTasks.add(new Function<StackValue, Void>(){

            @Override
            public Void fun(StackValue value) {
                ExpressionCodegen.this.myFrameMap.leave(descriptor);
                return null;
            }
        });
    }

    private void markLineNumber(@NotNull JetElement statement) {
        Document document = statement.getContainingFile().getViewProvider().getDocument();
        if (document != null) {
            int lineNumber = document.getLineNumber(statement.getTextRange().getStartOffset());
            if (lineNumber == this.myLastLineNumber) {
                return;
            }
            this.myLastLineNumber = lineNumber;
            Label label = new Label();
            this.v.visitLabel(label);
            this.v.visitLineNumber(lineNumber + 1, label);
        }
    }

    private void doFinallyOnReturn() {
        BlockStackElement stackElement;
        for (int i = this.blockStackElements.size() - 1; i >= 0 && (stackElement = (BlockStackElement)this.blockStackElements.get(i)) instanceof FinallyBlockStackElement; --i) {
            FinallyBlockStackElement finallyBlockStackElement = (FinallyBlockStackElement)stackElement;
            JetTryExpression jetTryExpression = finallyBlockStackElement.expression;
            this.blockStackElements.pop();
            this.gen(jetTryExpression.getFinallyBlock().getFinalExpression(), Type.VOID_TYPE);
            this.blockStackElements.push(finallyBlockStackElement);
        }
    }

    @Override
    public StackValue visitReturnExpression(JetReturnExpression expression, StackValue receiver) {
        JetExpression returnedExpression = expression.getReturnedExpression();
        if (returnedExpression != null) {
            this.gen(returnedExpression, this.returnType);
            this.doFinallyOnReturn();
            this.v.areturn(this.returnType);
        } else {
            this.doFinallyOnReturn();
            this.v.visitInsn(177);
        }
        return StackValue.none();
    }

    public void returnExpression(JetExpression expr) {
        StackValue lastValue = this.gen(expr);
        if (lastValue.type != Type.VOID_TYPE) {
            lastValue.put(this.returnType, this.v);
            this.v.areturn(this.returnType);
        } else if (!ExpressionCodegen.endsWithReturn(expr)) {
            this.v.areturn(this.returnType);
        }
    }

    private static boolean endsWithReturn(JetElement bodyExpression) {
        if (bodyExpression instanceof JetBlockExpression) {
            List<JetElement> statements = ((JetBlockExpression)bodyExpression).getStatements();
            return statements.size() > 0 && statements.get(statements.size() - 1) instanceof JetReturnExpression;
        }
        return bodyExpression instanceof JetReturnExpression;
    }

    @Override
    public StackValue visitSimpleNameExpression(JetSimpleNameExpression expression, StackValue receiver) {
        int index;
        DeclarationDescriptor descriptor;
        ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, expression);
        if (resolvedCall == null) {
            descriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression);
        } else {
            if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
                VariableAsFunctionResolvedCall call = (VariableAsFunctionResolvedCall)resolvedCall;
                resolvedCall = call.getVariableCall();
            }
            receiver = StackValue.receiver(resolvedCall, receiver, this, null);
            descriptor = resolvedCall.getResultingDescriptor();
        }
        if (descriptor instanceof CallableMemberDescriptor) {
            CallableMemberDescriptor memberDescriptor = (CallableMemberDescriptor)descriptor;
            memberDescriptor = CodegenUtil.unwrapFakeOverride(memberDescriptor);
            IntrinsicMethod intrinsic = this.state.getIntrinsics().getIntrinsic(memberDescriptor);
            if (intrinsic != null) {
                Type expectedType = this.expressionType(expression);
                return intrinsic.generate(this, this.v, expectedType, expression, Collections.<JetExpression>emptyList(), receiver, this.state);
            }
        }
        assert (descriptor != null);
        if (descriptor instanceof VariableDescriptor) {
            VariableDescriptor variableDescriptor = (VariableDescriptor)descriptor;
            ClassDescriptor objectClassDescriptor = this.getBindingContext().get(BindingContext.OBJECT_DECLARATION_CLASS, variableDescriptor);
            if (objectClassDescriptor != null) {
                return this.genObjectClassInstance(variableDescriptor, objectClassDescriptor);
            }
        }
        if ((index = this.lookupLocalIndex(descriptor)) >= 0) {
            return this.stackValueForLocal(descriptor, index);
        }
        if (descriptor instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
            boolean directToField = expression.getReferencedNameElementType() == JetTokens.FIELD_IDENTIFIER && this.contextKind() != OwnerKind.TRAIT_IMPL;
            JetExpression r = ExpressionCodegen.getReceiverForSelector(expression);
            boolean isSuper = r instanceof JetSuperExpression;
            propertyDescriptor = this.accessiblePropertyDescriptor(propertyDescriptor);
            StackValue iValue = this.intermediateValueForProperty(propertyDescriptor, directToField, isSuper ? (JetSuperExpression)r : null);
            if (directToField) {
                receiver = StackValue.receiverWithoutReceiverArgument(receiver);
            }
            receiver.put(receiver.type, this.v);
            return iValue;
        }
        if (descriptor instanceof ClassDescriptor) {
            ClassDescriptor classObjectDescriptor = ((ClassDescriptor)descriptor).getClassObjectDescriptor();
            assert (classObjectDescriptor != null) : "Class object is not found for " + descriptor;
            return StackValue.singleton(classObjectDescriptor, this.typeMapper);
        }
        if (descriptor instanceof TypeParameterDescriptor) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)descriptor;
            this.v.invokevirtual("jet/TypeInfo", "getClassObject", "()Ljava/lang/Object;");
            JetType type = typeParameterDescriptor.getClassObjectType();
            assert (type != null);
            this.v.checkcast(this.asmType(type));
            return StackValue.onStack(AsmTypeConstants.OBJECT_TYPE);
        }
        StackValue value = this.context.lookupInContext(descriptor, StackValue.local(0, AsmTypeConstants.OBJECT_TYPE), this.state, false);
        if (value != null) {
            if (value instanceof StackValue.Composed) {
                StackValue.Composed composed = (StackValue.Composed)value;
                composed.prefix.put(AsmTypeConstants.OBJECT_TYPE, this.v);
                value = composed.suffix;
            }
            if (value instanceof StackValue.FieldForSharedVar) {
                StackValue.FieldForSharedVar fieldForSharedVar = (StackValue.FieldForSharedVar)value;
                Type sharedType = StackValue.sharedTypeForType(value.type);
                this.v.visitFieldInsn(180, fieldForSharedVar.owner.getInternalName(), fieldForSharedVar.name, sharedType.getDescriptor());
            }
            return value;
        }
        if (descriptor instanceof ValueParameterDescriptor && descriptor.getContainingDeclaration() instanceof ScriptDescriptor) {
            ScriptDescriptor scriptDescriptor = (ScriptDescriptor)descriptor.getContainingDeclaration();
            assert (scriptDescriptor != null);
            JvmClassName scriptClassName = CodegenBinding.classNameForScriptDescriptor(this.bindingContext, scriptDescriptor);
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)descriptor;
            ClassDescriptor scriptClass = this.bindingContext.get(CodegenBinding.CLASS_FOR_SCRIPT, scriptDescriptor);
            StackValue script = StackValue.thisOrOuter(this, scriptClass, false);
            script.put(script.type, this.v);
            Type fieldType = this.typeMapper.mapType(valueParameterDescriptor);
            return StackValue.field(fieldType, scriptClassName, valueParameterDescriptor.getName().getIdentifier(), false);
        }
        throw new UnsupportedOperationException("don't know how to generate reference " + descriptor);
    }

    private StackValue genObjectClassInstance(VariableDescriptor variableDescriptor, ClassDescriptor objectClassDescriptor) {
        boolean isEnumEntry = DescriptorUtils.isEnumClassObject(variableDescriptor.getContainingDeclaration());
        if (isEnumEntry) {
            ClassDescriptor containing = (ClassDescriptor)variableDescriptor.getContainingDeclaration().getContainingDeclaration();
            assert (containing != null);
            Type type = this.typeMapper.mapType(containing);
            return StackValue.field(type, JvmClassName.byType(type), variableDescriptor.getName().asString(), true);
        }
        return StackValue.singleton(objectClassDescriptor, this.typeMapper);
    }

    private StackValue stackValueForLocal(DeclarationDescriptor descriptor, int index) {
        if (descriptor instanceof VariableDescriptor) {
            Type sharedVarType = this.typeMapper.getSharedVarType(descriptor);
            JetType outType = ((VariableDescriptor)descriptor).getType();
            if (sharedVarType != null) {
                return StackValue.shared(index, this.asmType(outType));
            }
            return StackValue.local(index, this.asmType(outType));
        }
        return StackValue.local(index, AsmTypeConstants.OBJECT_TYPE);
    }

    @Override
    public boolean lookupLocal(DeclarationDescriptor descriptor) {
        return this.lookupLocalIndex(descriptor) != -1;
    }

    public int lookupLocalIndex(DeclarationDescriptor descriptor) {
        return this.myFrameMap.getIndex(descriptor);
    }

    @Nullable
    private static JetType getPropertyDelegateType(@NotNull PropertyDescriptor descriptor, @NotNull BindingContext bindingContext) {
        PropertyGetterDescriptor getter = descriptor.getGetter();
        if (getter != null) {
            Call call = bindingContext.get(BindingContext.DELEGATED_PROPERTY_CALL, getter);
            return call != null ? call.getExplicitReceiver().getType() : null;
        }
        return null;
    }

    @NotNull
    public StackValue intermediateValueForProperty(@NotNull PropertyDescriptor propertyDescriptor, boolean forceField, @Nullable JetSuperExpression superExpression) {
        return this.intermediateValueForProperty(propertyDescriptor, forceField, superExpression, MethodKind.GENERAL);
    }

    public StackValue.StackValueWithSimpleReceiver intermediateValueForProperty(@NotNull PropertyDescriptor propertyDescriptor, boolean forceField, @Nullable JetSuperExpression superExpression, @NotNull MethodKind methodKind) {
        String name;
        JetTypeMapper typeMapper = this.state.getTypeMapper();
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        boolean isBackingFieldInAnotherClass = AsmUtil.isPropertyWithBackingFieldInOuterClass(propertyDescriptor);
        boolean isStatic = containingDeclaration instanceof NamespaceDescriptor || isBackingFieldInAnotherClass;
        boolean isSuper = superExpression != null;
        boolean isInsideClass = CodegenUtil.isCallInsideSameClassAsDeclared(propertyDescriptor, this.context);
        boolean isInsideModule = CodegenUtil.isCallInsideSameModuleAsDeclared(propertyDescriptor, this.context);
        JetType delegateType = ExpressionCodegen.getPropertyDelegateType(propertyDescriptor, this.state.getBindingContext());
        boolean isDelegatedProperty = delegateType != null;
        CallableMethod callableGetter = null;
        CallableMethod callableSetter = null;
        boolean skipPropertyAccessors = forceField && !isBackingFieldInAnotherClass;
        CodegenContext backingFieldContext = this.context.getParentContext();
        if (isBackingFieldInAnotherClass && forceField) {
            backingFieldContext = this.context.findParentContextWithDescriptor(containingDeclaration.getContainingDeclaration());
            int flags = AsmUtil.getVisibilityForSpecialPropertyBackingField(propertyDescriptor, isDelegatedProperty);
            boolean bl = skipPropertyAccessors = (flags & 2) == 0 || methodKind == MethodKind.SYNTHETIC_ACCESSOR || methodKind == MethodKind.INITIALIZER;
            if (!skipPropertyAccessors) {
                propertyDescriptor = (PropertyDescriptor)backingFieldContext.getAccessor(propertyDescriptor);
            }
        }
        if (!skipPropertyAccessors) {
            PropertySetterDescriptor setter;
            if (CodegenUtil.couldUseDirectAccessToProperty(propertyDescriptor, true, isInsideClass, isDelegatedProperty)) {
                callableGetter = null;
            } else {
                PropertyGetterDescriptor getter;
                if (isSuper && !CodegenUtil.isInterface(containingDeclaration)) {
                    ClassDescriptor owner = ExpressionCodegen.getSuperCallLabelTarget(superExpression, this.state.getBindingContext(), this.context);
                    CodegenContext c = this.context.findParentContextWithDescriptor(owner);
                    assert (c != null) : "Couldn't find a context for a super-call: " + propertyDescriptor;
                    if (c != this.context.getParentContext()) {
                        propertyDescriptor = (PropertyDescriptor)c.getAccessor(propertyDescriptor);
                    }
                }
                if ((getter = (propertyDescriptor = this.accessiblePropertyDescriptor(propertyDescriptor)).getGetter()) != null) {
                    callableGetter = typeMapper.mapToCallableMethod(getter, isSuper || MethodKind.SYNTHETIC_ACCESSOR == methodKind, isInsideClass, isInsideModule, OwnerKind.IMPLEMENTATION);
                }
            }
            if (propertyDescriptor.isVar() && (setter = propertyDescriptor.getSetter()) != null) {
                callableSetter = CodegenUtil.couldUseDirectAccessToProperty(propertyDescriptor, false, isInsideClass, isDelegatedProperty) ? null : typeMapper.mapToCallableMethod(setter, isSuper || MethodKind.SYNTHETIC_ACCESSOR == methodKind, isInsideClass, isInsideModule, OwnerKind.IMPLEMENTATION);
            }
        }
        CallableMethod callableMethod = callableGetter != null ? callableGetter : callableSetter;
        propertyDescriptor = CodegenUtil.unwrapFakeOverride(propertyDescriptor);
        JvmClassName owner = callableMethod == null ? typeMapper.getOwner(isBackingFieldInAnotherClass ? propertyDescriptor.getContainingDeclaration() : propertyDescriptor, this.context.getContextKind(), isInsideModule) : callableMethod.getOwner();
        if (propertyDescriptor.getContainingDeclaration() == backingFieldContext.getContextDescriptor()) {
            assert (backingFieldContext instanceof FieldOwnerContext) : "Actual context is " + backingFieldContext + " but should be instance of FieldOwnerContext";
            name = ((FieldOwnerContext)backingFieldContext).getFieldName(propertyDescriptor, isDelegatedProperty);
        } else {
            name = JvmAbi.getDefaultPropertyName(propertyDescriptor.getName(), isDelegatedProperty, propertyDescriptor.getReceiverParameter() != null);
        }
        return StackValue.property(propertyDescriptor, owner, typeMapper.mapType(isDelegatedProperty && forceField ? delegateType : propertyDescriptor.getOriginal().getType()), isStatic, name, callableGetter, callableSetter, this.state);
    }

    @Override
    public StackValue visitCallExpression(JetCallExpression expression, StackValue receiver) {
        ClassDescriptorFromJvmBytecode samInterface;
        JetExpression callee = expression.getCalleeExpression();
        assert (callee != null);
        ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, callee);
        if (resolvedCall == null) {
            throw new CompilationException("Cannot resolve: " + callee.getText(), null, expression);
        }
        CallableDescriptor funDescriptor = resolvedCall.getResultingDescriptor();
        if (!(funDescriptor instanceof FunctionDescriptor)) {
            throw new UnsupportedOperationException("unknown type of callee descriptor: " + funDescriptor);
        }
        if ((funDescriptor = this.accessibleFunctionDescriptor((FunctionDescriptor)funDescriptor)) instanceof ConstructorDescriptor) {
            return this.generateNewCall(expression, resolvedCall, receiver);
        }
        Call call = this.bindingContext.get(BindingContext.CALL, expression.getCalleeExpression());
        if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
            VariableAsFunctionResolvedCall variableAsFunctionResolvedCall = (VariableAsFunctionResolvedCall)resolvedCall;
            ResolvedCallWithTrace<FunctionDescriptor> functionCall = variableAsFunctionResolvedCall.getFunctionCall();
            return this.invokeFunction(call, receiver, functionCall);
        }
        if (funDescriptor instanceof SimpleFunctionDescriptor && (samInterface = this.bindingContext.get(JavaBindingContext.SAM_CONSTRUCTOR_TO_INTERFACE, ((SimpleFunctionDescriptor)funDescriptor).getOriginal())) != null) {
            return this.invokeSamConstructor(expression, resolvedCall, samInterface);
        }
        return this.invokeFunction(call, receiver, resolvedCall);
    }

    private StackValue invokeSamConstructor(JetCallExpression expression, ResolvedCall<? extends CallableDescriptor> resolvedCall, ClassDescriptorFromJvmBytecode samInterface) {
        ResolvedValueArgument argument = resolvedCall.getValueArgumentsByIndex().get(0);
        if (!(argument instanceof ExpressionValueArgument)) {
            throw new IllegalStateException("argument of SAM constructor is " + argument.getClass().getName() + " " + expression.getText());
        }
        ValueArgument valueArgument = ((ExpressionValueArgument)argument).getValueArgument();
        assert (valueArgument != null) : "getValueArgument() is null for " + expression.getText();
        JetExpression argumentExpression = valueArgument.getArgumentExpression();
        assert (argumentExpression != null) : "getArgumentExpression() is null for " + expression.getText();
        return this.genSamInterfaceValue(argumentExpression, samInterface, this);
    }

    private StackValue genSamInterfaceValue(@NotNull JetExpression expression, @NotNull ClassDescriptorFromJvmBytecode samInterface, @NotNull JetVisitor<StackValue, StackValue> visitor) {
        if (expression instanceof JetFunctionLiteralExpression) {
            return this.genClosure(((JetFunctionLiteralExpression)expression).getFunctionLiteral(), samInterface);
        }
        JvmClassName className = this.state.getSamWrapperClasses().getSamWrapperClass(samInterface, (JetFile)expression.getContainingFile());
        this.v.anew(className.getAsmType());
        this.v.dup();
        Type functionType = this.typeMapper.mapType(samInterface.getFunctionTypeForSamInterface());
        expression.accept(visitor, StackValue.none()).put(functionType, this.v);
        Label ifNonNull = new Label();
        Label afterAll = new Label();
        this.v.dup();
        this.v.ifnonnull(ifNonNull);
        this.v.pop();
        this.v.pop2();
        this.v.aconst(null);
        this.v.goTo(afterAll);
        this.v.mark(ifNonNull);
        this.v.invokespecial(className.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, functionType));
        this.v.mark(afterAll);
        return StackValue.onStack(className.getAsmType());
    }

    @NotNull
    private PropertyDescriptor accessiblePropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        return this.context.accessiblePropertyDescriptor(propertyDescriptor);
    }

    @NotNull
    protected FunctionDescriptor accessibleFunctionDescriptor(FunctionDescriptor fd) {
        return this.context.accessibleFunctionDescriptor(fd);
    }

    @NotNull
    public StackValue invokeFunction(Call call, StackValue receiver, ResolvedCall<? extends CallableDescriptor> resolvedCall) {
        Callable callable;
        FunctionDescriptor fd = (FunctionDescriptor)resolvedCall.getResultingDescriptor();
        boolean superCall = ExpressionCodegen.isSuperCall(call);
        if (superCall && !CodegenUtil.isInterface(fd.getContainingDeclaration())) {
            JetSuperExpression expression = ExpressionCodegen.getSuperCallExpression(call);
            ClassDescriptor owner = this.getSuperCallLabelTarget(expression);
            CodegenContext c = this.context.findParentContextWithDescriptor(owner);
            assert (c != null) : "Couldn't find a context for a super-call: " + fd;
            if (c != this.context.getParentContext()) {
                fd = (FunctionDescriptor)c.getAccessor(fd);
            }
        }
        if ((callable = this.resolveToCallable(fd = this.accessibleFunctionDescriptor(fd), superCall)) instanceof CallableMethod) {
            CallableMethod callableMethod = (CallableMethod)callable;
            this.invokeMethodWithArguments(callableMethod, resolvedCall, call, receiver);
            Type callReturnType = callableMethod.getSignature().getAsmMethod().getReturnType();
            return this.returnValueAsStackValue(fd, callReturnType);
        }
        receiver = StackValue.receiver(resolvedCall, receiver, this, null);
        IntrinsicMethod intrinsic = (IntrinsicMethod)callable;
        ArrayList<JetExpression> args = new ArrayList<JetExpression>();
        for (ValueArgument valueArgument : call.getValueArguments()) {
            args.add(valueArgument.getArgumentExpression());
        }
        JetType type = resolvedCall.getCandidateDescriptor().getReturnType();
        assert (type != null);
        Type type2 = this.typeMapper.mapType(type);
        Type exprType = this.asmTypeOrVoid(type);
        StackValue stackValue = intrinsic.generate(this, this.v, type2, call.getCallElement(), args, receiver, this.state);
        stackValue.put(exprType, this.v);
        return StackValue.onStack(exprType);
    }

    @Nullable
    private static JetSuperExpression getSuperCallExpression(@NotNull Call call) {
        JetExpression receiverExpression;
        ReceiverValue explicitReceiver = call.getExplicitReceiver();
        if (explicitReceiver instanceof ExpressionReceiver && (receiverExpression = ((ExpressionReceiver)explicitReceiver).getExpression()) instanceof JetSuperExpression) {
            return (JetSuperExpression)receiverExpression;
        }
        return null;
    }

    private static boolean isSuperCall(@NotNull Call call) {
        return ExpressionCodegen.getSuperCallExpression(call) != null;
    }

    @NotNull
    private static CodegenContext getParentContextSubclassOf(ClassDescriptor descriptor, CodegenContext context) {
        CodegenContext c = context;
        while (true) {
            if (c instanceof ClassContext && DescriptorUtils.isSubclass(c.getThisDescriptor(), descriptor)) {
                return c;
            }
            c = c.getParentContext();
            assert (c != null);
        }
    }

    @NotNull
    private StackValue returnValueAsStackValue(FunctionDescriptor fd, Type callReturnType) {
        if (callReturnType != Type.VOID_TYPE) {
            JetType type = fd.getReturnType();
            assert (type != null);
            Type retType = this.typeMapper.mapReturnType(type);
            StackValue.coerce(callReturnType, retType, this.v);
            return StackValue.onStack(retType);
        }
        return StackValue.none();
    }

    @NotNull
    Callable resolveToCallable(@NotNull FunctionDescriptor fd, boolean superCall) {
        IntrinsicMethod intrinsic = this.state.getIntrinsics().getIntrinsic(fd);
        if (intrinsic != null) {
            return intrinsic;
        }
        return this.resolveToCallableMethod(fd, superCall, this.context);
    }

    @NotNull
    private CallableMethod resolveToCallableMethod(@NotNull FunctionDescriptor fd, boolean superCall, @NotNull CodegenContext context) {
        if (this.isCallAsFunctionObject(fd)) {
            return this.typeMapper.mapToFunctionInvokeCallableMethod(CodegenUtil.createInvoke(fd));
        }
        SimpleFunctionDescriptor originalOfSamAdapter = (SimpleFunctionDescriptor)SamCodegenUtil.getOriginalIfSamAdapter(this.bindingContext, fd);
        return this.typeMapper.mapToCallableMethod(originalOfSamAdapter != null ? originalOfSamAdapter : fd, superCall, CodegenUtil.isCallInsideSameClassAsDeclared(fd, context), CodegenUtil.isCallInsideSameModuleAsDeclared(fd, context), OwnerKind.IMPLEMENTATION);
    }

    private boolean isCallAsFunctionObject(FunctionDescriptor fd) {
        if (fd.getContainingDeclaration() instanceof ScriptDescriptor) {
            JetNamedFunction psi = (JetNamedFunction)BindingContextUtils.descriptorToDeclaration(this.bindingContext, fd);
            assert (psi != null);
            return !JetPsiUtil.isScriptDeclaration(psi);
        }
        if (fd instanceof ExpressionAsFunctionDescriptor) {
            return true;
        }
        return fd instanceof SimpleFunctionDescriptor && (fd.getContainingDeclaration() instanceof FunctionDescriptor || fd.getContainingDeclaration() instanceof ScriptDescriptor);
    }

    public void invokeMethodWithArguments(@NotNull CallableMethod callableMethod, @NotNull ResolvedCall<? extends CallableDescriptor> resolvedCall, @Nullable Call callToGenerateCallee, @NotNull StackValue receiver) {
        int mask;
        Type calleeType = callableMethod.getGenerateCalleeType();
        if (calleeType != null) {
            assert (!callableMethod.isNeedsThis());
            assert (callToGenerateCallee != null) : "Call can't be null when generating callee: " + resolvedCall.getResultingDescriptor();
            this.gen(callToGenerateCallee.getCalleeExpression(), calleeType);
        }
        if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
            resolvedCall = ((VariableAsFunctionResolvedCall)resolvedCall).getFunctionCall();
        }
        if (!(resolvedCall.getResultingDescriptor() instanceof ConstructorDescriptor)) {
            receiver = StackValue.receiver(resolvedCall, receiver, this, callableMethod);
            receiver.put(receiver.type, this.v);
            if (calleeType != null) {
                StackValue.onStack(receiver.type).put(AsmUtil.boxType(receiver.type), this.v);
            }
        }
        if ((mask = this.pushMethodArguments(resolvedCall, callableMethod.getValueParameterTypes())) == 0) {
            callableMethod.invokeWithNotNullAssertion(this.v, this.state, resolvedCall);
        } else {
            callableMethod.invokeDefaultWithNotNullAssertion(this.v, this.state, resolvedCall, mask);
        }
    }

    private void genThisAndReceiverFromResolvedCall(StackValue receiver, ResolvedCall<? extends CallableDescriptor> resolvedCall, CallableMethod callableMethod) {
        receiver = StackValue.receiver(resolvedCall, receiver, this, callableMethod);
        receiver.put(receiver.type, this.v);
    }

    public void generateFromResolvedCall(@NotNull ReceiverValue descriptor, @NotNull Type type) {
        if (descriptor instanceof ClassReceiver) {
            Type exprType = this.asmType(descriptor.getType());
            ClassReceiver classReceiver = (ClassReceiver)descriptor;
            ClassDescriptor classReceiverDeclarationDescriptor = classReceiver.getDeclarationDescriptor();
            if (DescriptorUtils.isClassObject(classReceiverDeclarationDescriptor)) {
                if (this.context.getContextDescriptor() instanceof FunctionDescriptor && classReceiverDeclarationDescriptor == this.context.getContextDescriptor().getContainingDeclaration()) {
                    this.v.load(0, AsmTypeConstants.OBJECT_TYPE);
                } else {
                    FieldInfo info = FieldInfo.createForSingleton(classReceiverDeclarationDescriptor, this.typeMapper);
                    this.v.getstatic(info.getOwnerInternalName(), info.getFieldName(), info.getFieldType().getDescriptor());
                }
                StackValue.onStack(exprType).put(type, this.v);
            } else {
                StackValue.thisOrOuter(this, classReceiverDeclarationDescriptor, false).put(type, this.v);
            }
        } else if (descriptor instanceof ScriptReceiver) {
            this.generateScript((ScriptReceiver)descriptor);
        } else if (descriptor instanceof ExtensionReceiver) {
            ExtensionReceiver extensionReceiver = (ExtensionReceiver)descriptor;
            this.generateReceiver(extensionReceiver.getDeclarationDescriptor()).put(type, this.v);
        } else if (descriptor instanceof ExpressionReceiver) {
            ExpressionReceiver expressionReceiver = (ExpressionReceiver)descriptor;
            JetExpression expr = expressionReceiver.getExpression();
            this.gen(expr, type);
        } else if (descriptor instanceof AutoCastReceiver) {
            AutoCastReceiver autoCastReceiver = (AutoCastReceiver)descriptor;
            Type originalType = this.asmType(autoCastReceiver.getOriginal().getType());
            this.generateFromResolvedCall(autoCastReceiver.getOriginal(), originalType);
            StackValue.onStack(originalType).put(type, this.v);
        } else {
            throw new UnsupportedOperationException("Unsupported receiver type: " + descriptor);
        }
    }

    @Nullable
    private static JetExpression getReceiverForSelector(PsiElement expression) {
        if (expression.getParent() instanceof JetDotQualifiedExpression && !ExpressionCodegen.isReceiver(expression)) {
            JetDotQualifiedExpression parent = (JetDotQualifiedExpression)expression.getParent();
            return parent.getReceiverExpression();
        }
        return null;
    }

    private StackValue generateReceiver(DeclarationDescriptor provided) {
        if (this.context.getCallableDescriptorWithReceiver() == provided) {
            StackValue result = this.context.getReceiverExpression(this.typeMapper);
            return this.castToRequiredTypeOfInterfaceIfNeeded(result, provided, null);
        }
        StackValue result = this.context.lookupInContext(provided, StackValue.local(0, AsmTypeConstants.OBJECT_TYPE), this.state, false);
        return this.castToRequiredTypeOfInterfaceIfNeeded(result, provided, null);
    }

    private void generateScript(@NotNull ScriptReceiver receiver) {
        StackValue result = StackValue.local(0, AsmTypeConstants.OBJECT_TYPE);
        for (CodegenContext cur = this.context; cur != null; cur = cur.getParentContext()) {
            if (cur instanceof MethodContext && !(cur instanceof ConstructorContext)) {
                cur = cur.getParentContext();
            }
            if (cur instanceof ScriptContext) {
                ScriptContext scriptContext = (ScriptContext)cur;
                JvmClassName currentScriptClassName = CodegenBinding.classNameForScriptDescriptor(this.bindingContext, scriptContext.getScriptDescriptor());
                if (scriptContext.getScriptDescriptor() == receiver.getDeclarationDescriptor()) {
                    result.put(currentScriptClassName.getAsmType(), this.v);
                } else {
                    JvmClassName className = CodegenBinding.classNameForScriptDescriptor(this.bindingContext, receiver.getDeclarationDescriptor());
                    String fieldName = this.state.getScriptCodegen().getScriptFieldName(receiver.getDeclarationDescriptor());
                    result.put(currentScriptClassName.getAsmType(), this.v);
                    StackValue.field(className.getAsmType(), currentScriptClassName, fieldName, false).put(className.getAsmType(), this.v);
                }
                return;
            }
            assert (cur != null);
            result = cur.getOuterExpression(result, false);
            if (cur instanceof ConstructorContext) {
                cur = cur.getParentContext();
            }
            assert (cur != null);
        }
        throw new UnsupportedOperationException();
    }

    public StackValue generateThisOrOuter(@NotNull ClassDescriptor calleeContainingClass, boolean isSuper) {
        boolean isSingleton = CodegenBinding.isSingleton(this.bindingContext, calleeContainingClass);
        if (isSingleton) {
            assert (!isSuper);
            if (this.context.hasThisDescriptor() && this.context.getThisDescriptor().equals(calleeContainingClass)) {
                return StackValue.local(0, this.typeMapper.mapType(calleeContainingClass));
            }
            return StackValue.singleton(calleeContainingClass, this.typeMapper);
        }
        Type type = this.asmType(calleeContainingClass.getDefaultType());
        StackValue result = StackValue.local(0, type);
        for (CodegenContext cur = this.context; cur != null; cur = cur.getParentContext()) {
            if (cur instanceof MethodContext && !(cur instanceof ConstructorContext)) {
                cur = cur.getParentContext();
            }
            assert (cur != null);
            ClassDescriptor thisDescriptor = cur.getThisDescriptor();
            if (!isSuper && thisDescriptor.equals(calleeContainingClass) || isSuper && DescriptorUtils.isSubclass(thisDescriptor, calleeContainingClass)) {
                return this.castToRequiredTypeOfInterfaceIfNeeded(result, thisDescriptor, calleeContainingClass);
            }
            result = cur.getOuterExpression(result, false);
            if (cur instanceof ConstructorContext) {
                cur = cur.getParentContext();
            }
            assert (cur != null);
        }
        throw new UnsupportedOperationException();
    }

    private static boolean isReceiver(PsiElement expression) {
        PsiElement parent = expression.getParent();
        if (parent instanceof JetQualifiedExpression) {
            JetExpression receiverExpression = ((JetQualifiedExpression)parent).getReceiverExpression();
            return expression == receiverExpression;
        }
        return false;
    }

    private int pushMethodArguments(@NotNull ResolvedCall resolvedCall, List<Type> valueParameterTypes) {
        List<ResolvedValueArgument> valueArguments = resolvedCall.getValueArgumentsByIndex();
        Object fd = resolvedCall.getResultingDescriptor();
        if (fd.getValueParameters().size() != valueArguments.size()) {
            throw new IllegalStateException();
        }
        int mask = 0;
        for (ValueParameterDescriptor valueParameter : fd.getValueParameters()) {
            Object valueArgument;
            ResolvedValueArgument resolvedValueArgument = valueArguments.get(valueParameter.getIndex());
            Type parameterType = valueParameterTypes.get(valueParameter.getIndex());
            if (resolvedValueArgument instanceof ExpressionValueArgument) {
                valueArgument = ((ExpressionValueArgument)resolvedValueArgument).getValueArgument();
                assert (valueArgument != null);
                JetExpression argumentExpression = valueArgument.getArgumentExpression();
                assert (argumentExpression != null) : valueArgument.asElement().getText();
                this.gen(argumentExpression, parameterType);
                continue;
            }
            if (resolvedValueArgument instanceof DefaultValueArgument) {
                AsmUtil.pushDefaultValueOnStack(parameterType, this.v);
                mask |= 1 << valueParameter.getIndex();
                continue;
            }
            if (resolvedValueArgument instanceof VarargValueArgument) {
                valueArgument = (VarargValueArgument)resolvedValueArgument;
                this.genVarargs(valueParameter, (VarargValueArgument)valueArgument);
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return mask;
    }

    public void genVarargs(ValueParameterDescriptor valueParameterDescriptor, VarargValueArgument valueArgument) {
        int i;
        JetType outType = valueParameterDescriptor.getType();
        Type type = this.asmType(outType);
        assert (type.getSort() == 9);
        Type elementType = AsmUtil.correctElementType(type);
        List<ValueArgument> arguments = valueArgument.getArguments();
        int size = arguments.size();
        boolean hasSpread = false;
        for (i = 0; i != size; ++i) {
            if (arguments.get(i).getSpreadElement() == null) continue;
            hasSpread = true;
            break;
        }
        if (hasSpread) {
            if (size == 1) {
                this.gen(arguments.get(0).getArgumentExpression(), type);
            } else {
                String owner = "jet/runtime/Intrinsics$SpreadBuilder";
                this.v.anew(Type.getObjectType(owner));
                this.v.dup();
                this.v.invokespecial(owner, "<init>", "()V");
                for (int i2 = 0; i2 != size; ++i2) {
                    this.v.dup();
                    ValueArgument argument = arguments.get(i2);
                    if (argument.getSpreadElement() != null) {
                        this.gen(argument.getArgumentExpression(), AsmTypeConstants.OBJECT_TYPE);
                        this.v.invokevirtual(owner, "addSpread", "(Ljava/lang/Object;)V");
                        continue;
                    }
                    this.gen(argument.getArgumentExpression(), elementType);
                    this.v.invokevirtual(owner, "add", "(Ljava/lang/Object;)Z");
                    this.v.pop();
                }
                this.v.dup();
                this.v.invokevirtual(owner, "size", "()I");
                this.v.newarray(elementType);
                this.v.invokevirtual(owner, "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;");
                this.v.checkcast(type);
            }
        } else {
            this.v.iconst(arguments.size());
            this.v.newarray(elementType);
            for (i = 0; i != size; ++i) {
                this.v.dup();
                this.v.iconst(i);
                this.gen(arguments.get(i).getArgumentExpression(), elementType);
                StackValue.arrayElement(elementType, false).store(elementType, this.v);
            }
        }
    }

    public int pushMethodArguments(JetCallElement expression, List<Type> valueParameterTypes) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, expression.getCalleeExpression());
        if (resolvedCall != null) {
            return this.pushMethodArguments(resolvedCall, valueParameterTypes);
        }
        List<? extends ValueArgument> args = expression.getValueArguments();
        int argsSize = args.size();
        for (int i = 0; i < argsSize; ++i) {
            ValueArgument arg = args.get(i);
            this.gen(arg.getArgumentExpression(), valueParameterTypes.get(i));
        }
        return 0;
    }

    @NotNull
    public Type expressionType(JetExpression expr) {
        return this.typeMapper.expressionType(expr);
    }

    public int indexOfLocal(JetReferenceExpression lhs) {
        DeclarationDescriptor declarationDescriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, lhs);
        if (CodegenBinding.isVarCapturedInClosure(this.bindingContext, declarationDescriptor)) {
            return -1;
        }
        return this.lookupLocalIndex(declarationDescriptor);
    }

    @Override
    public StackValue visitCallableReferenceExpression(JetCallableReferenceExpression expression, StackValue data) {
        final FunctionDescriptor functionDescriptor = this.bindingContext.get(BindingContext.CALLABLE_REFERENCE, expression);
        assert (functionDescriptor != null) : "Callable reference is not resolved to descriptor: " + expression.getText();
        final ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, expression.getCallableReference());
        assert (resolvedCall != null) : "Callable reference is not resolved: " + functionDescriptor + " " + expression.getText();
        JetType kFunctionType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, expression);
        assert (kFunctionType != null) : "Callable reference is not type checked: " + expression.getText();
        ClassDescriptor kFunctionImpl = FunctionTypesUtil.functionTypeToImpl(kFunctionType);
        assert (kFunctionImpl != null) : "Impl type is not found for the function type: " + kFunctionType;
        JvmClassName closureSuperClass = JvmClassName.byType(this.typeMapper.mapType(kFunctionImpl));
        ClosureCodegen closureCodegen = new ClosureCodegen(this.state, expression, functionDescriptor, null, closureSuperClass, this.context, this, new FunctionGenerationStrategy.CodegenBased<CallableDescriptor>(this.state, (CallableDescriptor)functionDescriptor){

            @Override
            @NotNull
            public ExpressionCodegen initializeExpressionCodegen(JvmMethodSignature signature, MethodContext context, MethodVisitor mv, Type returnType) {
                FunctionDescriptor referencedFunction = (FunctionDescriptor)resolvedCall.getResultingDescriptor();
                JetType returnJetType = referencedFunction.getReturnType();
                assert (returnJetType != null) : "Return type can't be null: " + referencedFunction;
                return super.initializeExpressionCodegen(signature, context, mv, ExpressionCodegen.this.typeMapper.mapReturnType(returnJetType));
            }

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature) {
                StackValue result;
                FunctionDescriptor referencedFunction = (FunctionDescriptor)resolvedCall.getResultingDescriptor();
                JetCallExpression fakeExpression = this.constructFakeFunctionCall(referencedFunction);
                final List<? extends ValueArgument> fakeArguments = fakeExpression.getValueArguments();
                final ReceiverValue receiverValue = this.computeAndSaveReceiver(signature, codegen);
                this.computeAndSaveArguments(codegen.myFrameMap, fakeArguments, codegen);
                DelegatingResolvedCall<CallableDescriptor> fakeResolvedCall = new DelegatingResolvedCall<CallableDescriptor>(resolvedCall){

                    @Override
                    @NotNull
                    public ReceiverValue getReceiverArgument() {
                        return resolvedCall.getExplicitReceiverKind() == ExplicitReceiverKind.RECEIVER_ARGUMENT ? receiverValue : ReceiverValue.NO_RECEIVER;
                    }

                    @Override
                    @NotNull
                    public ReceiverValue getThisObject() {
                        return resolvedCall.getExplicitReceiverKind() == ExplicitReceiverKind.THIS_OBJECT ? receiverValue : ReceiverValue.NO_RECEIVER;
                    }

                    @Override
                    @NotNull
                    public List<ResolvedValueArgument> getValueArgumentsByIndex() {
                        ArrayList<ResolvedValueArgument> result = new ArrayList<ResolvedValueArgument>(fakeArguments.size());
                        for (ValueArgument argument : fakeArguments) {
                            result.add(new ExpressionValueArgument(argument));
                        }
                        return result;
                    }
                };
                Type returnType = codegen.returnType;
                if (referencedFunction instanceof ConstructorDescriptor) {
                    if (returnType.getSort() == 9) {
                        JetType returnJetType = referencedFunction.getReturnType();
                        assert (returnJetType != null);
                        codegen.generateNewArray(fakeExpression, returnJetType);
                        result = StackValue.onStack(returnType);
                    } else {
                        result = codegen.generateConstructorCall(fakeResolvedCall, StackValue.none(), returnType);
                    }
                } else {
                    Call call = CallMaker.makeCall(fakeExpression, ReceiverValue.NO_RECEIVER, null, fakeExpression, fakeArguments);
                    result = codegen.invokeFunction(call, StackValue.none(), (ResolvedCall<? extends CallableDescriptor>)fakeResolvedCall);
                }
                InstructionAdapter v = codegen.v;
                result.put(returnType, v);
                v.areturn(returnType);
            }

            @NotNull
            private JetCallExpression constructFakeFunctionCall(@NotNull CallableDescriptor referencedFunction) {
                StringBuilder fakeFunctionCall = new StringBuilder("callableReferenceFakeCall(");
                Iterator<ValueParameterDescriptor> iterator = referencedFunction.getValueParameters().iterator();
                while (iterator.hasNext()) {
                    ValueParameterDescriptor descriptor = iterator.next();
                    fakeFunctionCall.append("p").append(descriptor.getIndex());
                    if (!iterator.hasNext()) continue;
                    fakeFunctionCall.append(", ");
                }
                fakeFunctionCall.append(")");
                return (JetCallExpression)JetPsiFactory.createExpression(this.state.getProject(), fakeFunctionCall.toString());
            }

            private void computeAndSaveArguments(@NotNull FrameMap frameMap, @NotNull List<? extends ValueArgument> fakeArguments, @NotNull ExpressionCodegen codegen) {
                for (ValueParameterDescriptor parameter : functionDescriptor.getValueParameters()) {
                    ValueArgument fakeArgument = fakeArguments.get(parameter.getIndex());
                    Type type = ExpressionCodegen.this.typeMapper.mapType(parameter);
                    int localIndex = frameMap.getIndex(parameter);
                    codegen.tempVariables.put(fakeArgument.getArgumentExpression(), StackValue.local(localIndex, type));
                }
            }

            @NotNull
            private ReceiverValue computeAndSaveReceiver(@NotNull JvmMethodSignature signature, @NotNull ExpressionCodegen codegen) {
                ReceiverParameterDescriptor receiver;
                Object referencedFunction = resolvedCall.getCandidateDescriptor();
                ReceiverParameterDescriptor receiverParameter = referencedFunction.getReceiverParameter();
                ReceiverParameterDescriptor expectedThisObject = referencedFunction.getExpectedThisObject();
                assert (receiverParameter == null || expectedThisObject == null) : "Extensions in classes can't be referenced via callable reference expressions: " + referencedFunction;
                ReceiverParameterDescriptor receiverParameterDescriptor = receiver = receiverParameter != null ? receiverParameter : expectedThisObject;
                if (receiver == null) {
                    return ReceiverValue.NO_RECEIVER;
                }
                JetExpression receiverExpression = JetPsiFactory.createExpression(this.state.getProject(), "callableReferenceFakeReceiver");
                Type firstParameterType = signature.getAsmMethod().getArgumentTypes()[0];
                codegen.tempVariables.put(receiverExpression, StackValue.local(1, firstParameterType));
                return new ExpressionReceiver(receiverExpression, receiver.getType());
            }
        });
        closureCodegen.gen();
        return closureCodegen.putInstanceOnStack(this.v, this);
    }

    @Override
    public StackValue visitDotQualifiedExpression(JetDotQualifiedExpression expression, StackValue receiver) {
        StackValue receiverValue = StackValue.none();
        return this.genQualified(receiverValue, expression.getSelectorExpression());
    }

    @Override
    public StackValue visitSafeQualifiedExpression(JetSafeQualifiedExpression expression, StackValue receiver) {
        JetExpression expr = expression.getReceiverExpression();
        Type receiverType = this.expressionType(expr);
        this.gen(expr, receiverType);
        if (AsmUtil.isPrimitive(receiverType)) {
            StackValue propValue = this.genQualified(StackValue.onStack(receiverType), expression.getSelectorExpression());
            Type type = AsmUtil.boxType(propValue.type);
            propValue.put(type, this.v);
            return StackValue.onStack(type);
        }
        Label ifnull = new Label();
        Label end = new Label();
        this.v.dup();
        this.v.ifnull(ifnull);
        StackValue propValue = this.genQualified(StackValue.onStack(receiverType), expression.getSelectorExpression());
        Type type = AsmUtil.boxType(propValue.type);
        propValue.put(type, this.v);
        this.v.goTo(end);
        this.v.mark(ifnull);
        this.v.pop();
        if (!type.equals(Type.VOID_TYPE)) {
            this.v.aconst(null);
        }
        this.v.mark(end);
        return StackValue.onStack(type);
    }

    @Override
    public StackValue visitBinaryExpression(JetBinaryExpression expression, StackValue receiver) {
        IElementType opToken = expression.getOperationReference().getReferencedNameElementType();
        if (opToken == JetTokens.EQ) {
            return this.generateAssignmentExpression(expression);
        }
        if (JetTokens.AUGMENTED_ASSIGNMENTS.contains(opToken)) {
            return this.generateAugmentedAssignment(expression);
        }
        if (opToken == JetTokens.ANDAND) {
            return this.generateBooleanAnd(expression);
        }
        if (opToken == JetTokens.OROR) {
            return this.generateBooleanOr(expression);
        }
        if (opToken == JetTokens.EQEQ || opToken == JetTokens.EXCLEQ || opToken == JetTokens.EQEQEQ || opToken == JetTokens.EXCLEQEQEQ) {
            return this.generateEquals(expression.getLeft(), expression.getRight(), opToken);
        }
        if (opToken == JetTokens.LT || opToken == JetTokens.LTEQ || opToken == JetTokens.GT || opToken == JetTokens.GTEQ) {
            return this.generateComparison(expression);
        }
        if (opToken == JetTokens.ELVIS) {
            return this.generateElvis(expression);
        }
        if (opToken == JetTokens.IN_KEYWORD || opToken == JetTokens.NOT_IN) {
            return this.generateIn(expression);
        }
        DeclarationDescriptor op = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getOperationReference());
        assert (op instanceof FunctionDescriptor) : String.valueOf(op);
        Callable callable = this.resolveToCallable((FunctionDescriptor)op, false);
        if (callable instanceof IntrinsicMethod) {
            IntrinsicMethod intrinsic = (IntrinsicMethod)callable;
            return intrinsic.generate(this, this.v, this.expressionType(expression), expression, Arrays.asList(expression.getLeft(), expression.getRight()), receiver, this.state);
        }
        return this.invokeOperation(expression, (FunctionDescriptor)op, (CallableMethod)callable);
    }

    private StackValue generateIn(JetBinaryExpression expression) {
        boolean inverted;
        boolean bl = inverted = expression.getOperationReference().getReferencedNameElementType() == JetTokens.NOT_IN;
        if (this.isIntRangeExpr(expression.getRight())) {
            StackValue leftValue = StackValue.expression(Type.INT_TYPE, expression.getLeft(), this);
            JetBinaryExpression rangeExpression = (JetBinaryExpression)expression.getRight();
            this.getInIntRange(leftValue, rangeExpression, inverted);
        } else {
            this.invokeFunctionByReference(expression.getOperationReference());
            if (inverted) {
                AsmUtil.genInvertBoolean(this.v);
            }
        }
        return StackValue.onStack(Type.BOOLEAN_TYPE);
    }

    private void getInIntRange(StackValue leftValue, JetBinaryExpression rangeExpression, boolean inverted) {
        this.v.iconst(1);
        leftValue.put(Type.INT_TYPE, this.v);
        this.v.dup2();
        this.gen(rangeExpression.getLeft(), Type.INT_TYPE);
        Label lok = new Label();
        this.v.ificmpge(lok);
        this.v.pop();
        this.v.iconst(0);
        this.v.mark(lok);
        this.v.dupX2();
        this.v.pop();
        this.gen(rangeExpression.getRight(), Type.INT_TYPE);
        Label rok = new Label();
        this.v.ificmple(rok);
        this.v.pop();
        this.v.iconst(0);
        this.v.mark(rok);
        this.v.and(Type.INT_TYPE);
        if (inverted) {
            AsmUtil.genInvertBoolean(this.v);
        }
    }

    private StackValue generateBooleanAnd(JetBinaryExpression expression) {
        this.gen(expression.getLeft(), Type.BOOLEAN_TYPE);
        Label ifFalse = new Label();
        this.v.ifeq(ifFalse);
        this.gen(expression.getRight(), Type.BOOLEAN_TYPE);
        Label end = new Label();
        this.v.goTo(end);
        this.v.mark(ifFalse);
        this.v.iconst(0);
        this.v.mark(end);
        return StackValue.onStack(Type.BOOLEAN_TYPE);
    }

    private StackValue generateBooleanOr(JetBinaryExpression expression) {
        this.gen(expression.getLeft(), Type.BOOLEAN_TYPE);
        Label ifTrue = new Label();
        this.v.ifne(ifTrue);
        this.gen(expression.getRight(), Type.BOOLEAN_TYPE);
        Label end = new Label();
        this.v.goTo(end);
        this.v.mark(ifTrue);
        this.v.iconst(1);
        this.v.mark(end);
        return StackValue.onStack(Type.BOOLEAN_TYPE);
    }

    private StackValue generateEquals(JetExpression left, JetExpression right, IElementType opToken) {
        Type leftType = this.expressionType(left);
        Type rightType = this.expressionType(right);
        if (JetPsiUtil.isNullConstant(left)) {
            return this.genCmpWithNull(right, rightType, opToken);
        }
        if (JetPsiUtil.isNullConstant(right)) {
            return this.genCmpWithNull(left, leftType, opToken);
        }
        if (this.isIntZero(left, leftType) && AsmUtil.isIntPrimitive(rightType)) {
            return this.genCmpWithZero(right, rightType, opToken);
        }
        if (this.isIntZero(right, rightType) && AsmUtil.isIntPrimitive(leftType)) {
            return this.genCmpWithZero(left, leftType, opToken);
        }
        if (AsmUtil.isPrimitive(leftType) != AsmUtil.isPrimitive(rightType)) {
            leftType = AsmUtil.boxType(leftType);
            this.gen(left, leftType);
            rightType = AsmUtil.boxType(rightType);
            this.gen(right, rightType);
        } else {
            this.gen(left, leftType);
            this.gen(right, rightType);
        }
        return AsmUtil.genEqualsForExpressionsOnStack(this.v, opToken, leftType, rightType);
    }

    private boolean isIntZero(JetExpression expr, Type exprType) {
        CompileTimeConstant<?> exprValue = this.bindingContext.get(BindingContext.COMPILE_TIME_VALUE, expr);
        return AsmUtil.isIntPrimitive(exprType) && exprValue != null && exprValue.getValue().equals(0);
    }

    private StackValue genCmpWithZero(JetExpression exp, Type expType, IElementType opToken) {
        this.v.iconst(1);
        this.gen(exp, expType);
        Label ok = new Label();
        if (JetTokens.EQEQ == opToken || JetTokens.EQEQEQ == opToken) {
            this.v.ifeq(ok);
        } else {
            this.v.ifne(ok);
        }
        this.v.pop();
        this.v.iconst(0);
        this.v.mark(ok);
        return StackValue.onStack(Type.BOOLEAN_TYPE);
    }

    private StackValue genCmpWithNull(JetExpression exp, Type expType, IElementType opToken) {
        this.v.iconst(1);
        this.gen(exp, AsmUtil.boxType(expType));
        Label ok = new Label();
        if (JetTokens.EQEQ == opToken || JetTokens.EQEQEQ == opToken) {
            this.v.ifnull(ok);
        } else {
            this.v.ifnonnull(ok);
        }
        this.v.pop();
        this.v.iconst(0);
        this.v.mark(ok);
        return StackValue.onStack(Type.BOOLEAN_TYPE);
    }

    private StackValue generateElvis(JetBinaryExpression expression) {
        Type exprType = this.expressionType(expression);
        Type leftType = this.expressionType(expression.getLeft());
        this.gen(expression.getLeft(), leftType);
        if (AsmUtil.isPrimitive(leftType)) {
            return StackValue.onStack(leftType);
        }
        this.v.dup();
        Label ifNull = new Label();
        this.v.ifnull(ifNull);
        StackValue.onStack(leftType).put(exprType, this.v);
        Label end = new Label();
        this.v.goTo(end);
        this.v.mark(ifNull);
        this.v.pop();
        this.gen(expression.getRight(), exprType);
        this.v.mark(end);
        return StackValue.onStack(exprType);
    }

    private StackValue generateComparison(JetBinaryExpression expression) {
        Type type;
        DeclarationDescriptor target = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getOperationReference());
        assert (target instanceof FunctionDescriptor) : "compareTo target should be a function: " + target;
        FunctionDescriptor descriptor = (FunctionDescriptor)target;
        JetExpression left = expression.getLeft();
        JetExpression right = expression.getRight();
        Callable callable = this.resolveToCallable(descriptor, false);
        if (callable instanceof IntrinsicMethod) {
            type = AsmUtil.comparisonOperandType(this.expressionType(left), this.expressionType(right));
            StackValue receiver = this.gen(left);
            receiver.put(type, this.v);
            this.gen(right, type);
        } else {
            type = Type.INT_TYPE;
            StackValue result = this.invokeOperation(expression, descriptor, (CallableMethod)callable);
            result.put(type, this.v);
            this.v.iconst(0);
        }
        return StackValue.cmp(expression.getOperationToken(), type);
    }

    private StackValue generateAssignmentExpression(JetBinaryExpression expression) {
        StackValue stackValue = this.gen(expression.getLeft());
        JetExpression right = expression.getRight();
        assert (right != null) : expression.getText();
        this.gen(right, stackValue.type);
        stackValue.store(stackValue.type, this.v);
        return StackValue.none();
    }

    private StackValue generateAugmentedAssignment(JetBinaryExpression expression) {
        DeclarationDescriptor op = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getOperationReference());
        assert (op instanceof FunctionDescriptor) : String.valueOf(op);
        Callable callable = this.resolveToCallable((FunctionDescriptor)op, false);
        JetExpression lhs = expression.getLeft();
        Type lhsType = this.expressionType(lhs);
        if (this.bindingContext.get(BindingContext.VARIABLE_REASSIGNMENT, expression).booleanValue()) {
            if (callable instanceof IntrinsicMethod) {
                StackValue value = this.gen(lhs);
                value.dupReceiver(this.v);
                value.put(lhsType, this.v);
                IntrinsicMethod intrinsic = (IntrinsicMethod)callable;
                JetExpression right = expression.getRight();
                assert (right != null);
                StackValue stackValue = intrinsic.generate(this, this.v, lhsType, expression, Arrays.asList(right), StackValue.onStack(lhsType), this.state);
                value.store(stackValue.type, this.v);
            } else {
                this.callAugAssignMethod(expression, (CallableMethod)callable, lhsType, true);
            }
        } else {
            JetType type = ((FunctionDescriptor)op).getReturnType();
            assert (type != null);
            boolean keepReturnValue = !((Object)type).equals(KotlinBuiltIns.getInstance().getUnitType());
            this.callAugAssignMethod(expression, (CallableMethod)callable, lhsType, keepReturnValue);
        }
        return StackValue.none();
    }

    private void callAugAssignMethod(JetBinaryExpression expression, CallableMethod callable, Type lhsType, boolean keepReturnValue) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, expression.getOperationReference());
        assert (resolvedCall != null);
        StackValue value = this.gen(expression.getLeft());
        if (keepReturnValue) {
            value.dupReceiver(this.v);
        }
        value.put(lhsType, this.v);
        StackValue receiver = StackValue.onStack(lhsType);
        if (!(resolvedCall.getResultingDescriptor() instanceof ConstructorDescriptor)) {
            receiver = StackValue.receiver(resolvedCall, receiver, this, callable);
            receiver.put(receiver.type, this.v);
        }
        this.pushMethodArguments(resolvedCall, callable.getValueParameterTypes());
        callable.invokeWithNotNullAssertion(this.v, this.state, resolvedCall);
        if (keepReturnValue) {
            value.store(callable.getReturnType(), this.v);
        }
    }

    public void invokeAppend(JetExpression expr) {
        JetBinaryExpression binaryExpression;
        if (expr instanceof JetBinaryExpression && (binaryExpression = (JetBinaryExpression)expr).getOperationToken() == JetTokens.PLUS) {
            JetExpression left = binaryExpression.getLeft();
            JetExpression right = binaryExpression.getRight();
            Type leftType = this.expressionType(left);
            Type rightType = this.expressionType(right);
            if (leftType.equals(AsmTypeConstants.JAVA_STRING_TYPE) && rightType.equals(AsmTypeConstants.JAVA_STRING_TYPE)) {
                this.invokeAppend(left);
                this.invokeAppend(right);
                return;
            }
        }
        Type exprType = this.expressionType(expr);
        this.gen(expr, exprType);
        AsmUtil.genInvokeAppendMethod(this.v, exprType.getSort() == 9 ? AsmTypeConstants.OBJECT_TYPE : exprType);
    }

    @Nullable
    private static JetSimpleNameExpression targetLabel(JetExpression expression) {
        JetPrefixExpression parent;
        JetSimpleNameExpression operationSign;
        if (expression.getParent() instanceof JetPrefixExpression && JetTokens.LABELS.contains((operationSign = (parent = (JetPrefixExpression)expression.getParent()).getOperationReference()).getReferencedNameElementType())) {
            return operationSign;
        }
        return null;
    }

    @Override
    public StackValue visitPrefixExpression(JetPrefixExpression expression, StackValue receiver) {
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        if (JetTokens.LABELS.contains(operationSign.getReferencedNameElementType())) {
            return this.genQualified(receiver, expression.getBaseExpression());
        }
        DeclarationDescriptor op = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getOperationReference());
        assert (op instanceof FunctionDescriptor) : String.valueOf(op);
        Callable callable = this.resolveToCallable((FunctionDescriptor)op, false);
        if (callable instanceof IntrinsicMethod) {
            IntrinsicMethod intrinsic = (IntrinsicMethod)callable;
            return intrinsic.generate(this, this.v, this.expressionType(expression), expression, Arrays.asList(expression.getBaseExpression()), receiver, this.state);
        }
        DeclarationDescriptor cls = op.getContainingDeclaration();
        CallableMethod callableMethod = (CallableMethod)callable;
        if (AsmUtil.isPrimitiveNumberClassDescriptor(cls) || !op.getName().asString().equals("inc") && !op.getName().asString().equals("dec")) {
            return this.invokeOperation(expression, (FunctionDescriptor)op, callableMethod);
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, expression.getOperationReference());
        assert (resolvedCall != null);
        StackValue value = this.gen(expression.getBaseExpression());
        value.dupReceiver(this.v);
        value.dupReceiver(this.v);
        Type type = this.expressionType(expression.getBaseExpression());
        value.put(type, this.v);
        callableMethod.invokeWithNotNullAssertion(this.v, this.state, resolvedCall);
        value.store(callableMethod.getReturnType(), this.v);
        value.put(type, this.v);
        return StackValue.onStack(type);
    }

    private StackValue invokeOperation(JetOperationExpression expression, FunctionDescriptor op, CallableMethod callable) {
        int functionLocalIndex = this.lookupLocalIndex(op);
        if (functionLocalIndex >= 0) {
            this.stackValueForLocal(op, functionLocalIndex).put(FunctionTypesUtil.getFunctionImplClassName(op).getAsmType(), this.v);
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, expression.getOperationReference());
        assert (resolvedCall != null);
        this.genThisAndReceiverFromResolvedCall(StackValue.none(), resolvedCall, callable);
        this.pushMethodArguments(resolvedCall, callable.getValueParameterTypes());
        callable.invokeWithNotNullAssertion(this.v, this.state, resolvedCall);
        return this.returnValueAsStackValue(op, callable.getSignature().getAsmMethod().getReturnType());
    }

    @Override
    public StackValue visitPostfixExpression(JetPostfixExpression expression, StackValue receiver) {
        int increment;
        if (expression.getOperationReference().getReferencedNameElementType() == JetTokens.EXCLEXCL) {
            StackValue base = this.genQualified(receiver, expression.getBaseExpression());
            if (AsmUtil.isPrimitive(base.type)) {
                return base;
            }
            base.put(base.type, this.v);
            this.v.dup();
            Label ok = new Label();
            this.v.ifnonnull(ok);
            this.v.invokestatic("jet/runtime/Intrinsics", "throwNpe", "()V");
            this.v.mark(ok);
            return StackValue.onStack(base.type);
        }
        DeclarationDescriptor op = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getOperationReference());
        if (!(op instanceof FunctionDescriptor)) {
            throw new UnsupportedOperationException("Don't know how to generate this postfix expression: " + op);
        }
        Type asmType = this.expressionType(expression);
        DeclarationDescriptor cls = op.getContainingDeclaration();
        if (op.getName().asString().equals("inc")) {
            increment = 1;
        } else if (op.getName().asString().equals("dec")) {
            increment = -1;
        } else {
            throw new UnsupportedOperationException("Unsupported postfix operation: " + op);
        }
        if (AsmUtil.isPrimitiveNumberClassDescriptor(cls)) {
            int index;
            receiver.put(receiver.type, this.v);
            JetExpression operand = expression.getBaseExpression();
            if (operand instanceof JetReferenceExpression && asmType == Type.INT_TYPE && (index = this.indexOfLocal((JetReferenceExpression)operand)) >= 0) {
                return StackValue.postIncrement(index, increment);
            }
            this.gen(operand, asmType);
            this.generateIncrement(increment, asmType, operand, receiver);
            return StackValue.onStack(asmType);
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, expression.getOperationReference());
        assert (resolvedCall != null);
        Callable callable = this.resolveToCallable((FunctionDescriptor)op, false);
        StackValue value = this.gen(expression.getBaseExpression());
        value.dupReceiver(this.v);
        Type type = this.expressionType(expression.getBaseExpression());
        value.put(type, this.v);
        switch (value.receiverSize()) {
            case 0: {
                AsmUtil.dup(this.v, type);
                break;
            }
            case 1: {
                if (type.getSize() == 2) {
                    this.v.dup2X1();
                    break;
                }
                this.v.dupX1();
                break;
            }
            case 2: {
                if (type.getSize() == 2) {
                    this.v.dup2X2();
                    break;
                }
                this.v.dupX2();
                break;
            }
            case -1: {
                throw new UnsupportedOperationException();
            }
        }
        CallableMethod callableMethod = (CallableMethod)callable;
        callableMethod.invokeWithNotNullAssertion(this.v, this.state, resolvedCall);
        value.store(callableMethod.getReturnType(), this.v);
        return StackValue.onStack(type);
    }

    private void generateIncrement(int increment, Type asmType, JetExpression operand, StackValue receiver) {
        StackValue value = this.genQualified(receiver, operand);
        value.dupReceiver(this.v);
        value.put(asmType, this.v);
        AsmUtil.genIncrement(asmType, increment, this.v);
        value.store(asmType, this.v);
    }

    @Override
    public StackValue visitProperty(JetProperty property, StackValue receiver) {
        final JetExpression initializer = property.getInitializer();
        if (initializer == null) {
            return StackValue.none();
        }
        this.initializeLocalVariable(property, new Function<VariableDescriptor, Void>(){

            @Override
            public Void fun(VariableDescriptor descriptor) {
                Type varType = ExpressionCodegen.this.asmType(descriptor.getType());
                ExpressionCodegen.this.gen(initializer, varType);
                return null;
            }
        });
        return StackValue.none();
    }

    @Override
    public StackValue visitMultiDeclaration(JetMultiDeclaration multiDeclaration, StackValue receiver) {
        JetExpression initializer = multiDeclaration.getInitializer();
        if (initializer == null) {
            return StackValue.none();
        }
        JetType initializerType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, initializer);
        assert (initializerType != null);
        Type initializerAsmType = this.asmType(initializerType);
        final TransientReceiver initializerAsReceiver = new TransientReceiver(initializerType);
        int tempVarIndex = this.myFrameMap.enterTemp(initializerAsmType);
        this.gen(initializer, initializerAsmType);
        this.v.store(tempVarIndex, initializerAsmType);
        final StackValue.Local local = StackValue.local(tempVarIndex, initializerAsmType);
        for (final JetMultiDeclarationEntry variableDeclaration : multiDeclaration.getEntries()) {
            this.initializeLocalVariable(variableDeclaration, new Function<VariableDescriptor, Void>(){

                @Override
                public Void fun(VariableDescriptor descriptor) {
                    ResolvedCall<FunctionDescriptor> resolvedCall = ExpressionCodegen.this.bindingContext.get(BindingContext.COMPONENT_RESOLVED_CALL, variableDeclaration);
                    assert (resolvedCall != null) : "Resolved call is null for " + variableDeclaration.getText();
                    Call call = ExpressionCodegen.this.makeFakeCall(initializerAsReceiver);
                    ExpressionCodegen.this.invokeFunction(call, local, resolvedCall);
                    return null;
                }
            });
        }
        if (initializerAsmType.getSort() == 10 || initializerAsmType.getSort() == 9) {
            this.v.aconst(null);
            this.v.store(tempVarIndex, initializerAsmType);
        }
        this.myFrameMap.leaveTemp(initializerAsmType);
        return StackValue.none();
    }

    private void initializeLocalVariable(@NotNull JetVariableDeclaration variableDeclaration, @NotNull Function<VariableDescriptor, Void> generateInitializer) {
        VariableDescriptor variableDescriptor = this.bindingContext.get(BindingContext.VARIABLE, variableDeclaration);
        if (JetPsiUtil.isScriptDeclaration(variableDeclaration)) {
            return;
        }
        int index = this.lookupLocalIndex(variableDescriptor);
        if (index < 0) {
            throw new IllegalStateException("Local variable not found for " + variableDescriptor);
        }
        Type sharedVarType = this.typeMapper.getSharedVarType(variableDescriptor);
        assert (variableDescriptor != null);
        Type varType = this.asmType(variableDescriptor.getType());
        if (JetPsiUtil.isScriptDeclaration(variableDeclaration)) {
            generateInitializer.fun(variableDescriptor);
            JetScript scriptPsi = JetPsiUtil.getScript(variableDeclaration);
            assert (scriptPsi != null);
            JvmClassName scriptClassName = CodegenBinding.classNameForScriptPsi(this.bindingContext, scriptPsi);
            this.v.putfield(scriptClassName.getInternalName(), variableDeclaration.getName(), varType.getDescriptor());
        } else if (sharedVarType == null) {
            generateInitializer.fun(variableDescriptor);
            this.v.store(index, varType);
        } else {
            this.v.load(index, AsmTypeConstants.OBJECT_TYPE);
            generateInitializer.fun(variableDescriptor);
            this.v.putfield(sharedVarType.getInternalName(), "ref", sharedVarType == AsmTypeConstants.JET_SHARED_VAR_TYPE ? "Ljava/lang/Object;" : varType.getDescriptor());
        }
    }

    @NotNull
    private StackValue generateNewCall(@NotNull JetCallExpression expression, @NotNull ResolvedCall<? extends CallableDescriptor> resolvedCall, @NotNull StackValue receiver) {
        Type type = this.expressionType(expression);
        if (type.getSort() == 9) {
            this.generateNewArray(expression);
            return StackValue.onStack(type);
        }
        return this.generateConstructorCall(resolvedCall, receiver, type);
    }

    @NotNull
    private StackValue generateConstructorCall(@NotNull ResolvedCall<? extends CallableDescriptor> resolvedCall, @NotNull StackValue receiver, @NotNull Type type) {
        this.v.anew(type);
        this.v.dup();
        receiver = StackValue.receiver(resolvedCall, receiver, this, null);
        receiver.put(receiver.type, this.v);
        ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)resolvedCall.getResultingDescriptor();
        MutableClosure closure = this.bindingContext.get(CodegenBinding.CLOSURE, constructorDescriptor.getContainingDeclaration());
        if (receiver.type.getSort() != 0 && (closure == null || closure.getCaptureThis() == null)) {
            this.v.pop();
        }
        this.pushClosureOnStack(closure, resolvedCall.getThisObject().exists() || resolvedCall.getReceiverArgument().exists());
        ConstructorDescriptor originalOfSamAdapter = (ConstructorDescriptor)SamCodegenUtil.getOriginalIfSamAdapter(this.bindingContext, constructorDescriptor);
        CallableMethod method = this.typeMapper.mapToCallableMethod(originalOfSamAdapter == null ? constructorDescriptor : originalOfSamAdapter);
        this.invokeMethodWithArguments(method, resolvedCall, null, StackValue.none());
        return StackValue.onStack(type);
    }

    public void generateNewArray(@NotNull JetCallExpression expression) {
        JetType arrayType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, expression);
        assert (arrayType != null) : "Array instantiation isn't type checked: " + expression.getText();
        this.generateNewArray(expression, arrayType);
    }

    private void generateNewArray(@NotNull JetCallExpression expression, @NotNull JetType arrayType) {
        ArrayList<JetExpression> args = new ArrayList<JetExpression>();
        for (ValueArgument valueArgument : expression.getValueArguments()) {
            args.add(valueArgument.getArgumentExpression());
        }
        args.addAll(expression.getFunctionLiteralArguments());
        boolean isArray = KotlinBuiltIns.getInstance().isArray(arrayType);
        if (!isArray && args.size() != 1) {
            throw new CompilationException("primitive array constructor requires one argument", null, expression);
        }
        if (isArray) {
            this.gen((JetElement)args.get(0), Type.INT_TYPE);
            this.v.newarray(AsmUtil.boxType(this.asmType(arrayType.getArguments().get(0).getType())));
        } else {
            Type type = this.typeMapper.mapType(arrayType);
            this.gen((JetElement)args.get(0), Type.INT_TYPE);
            this.v.newarray(AsmUtil.correctElementType(type));
        }
        if (args.size() == 2) {
            int n = this.myFrameMap.enterTemp(Type.INT_TYPE);
            int indexIndex = this.myFrameMap.enterTemp(Type.INT_TYPE);
            this.v.dup();
            this.v.arraylength();
            this.v.store(n, Type.INT_TYPE);
            this.v.iconst(0);
            this.v.store(indexIndex, Type.INT_TYPE);
            this.gen((JetElement)args.get(1), AsmTypeConstants.JET_FUNCTION1_TYPE);
            Label begin = new Label();
            Label end = new Label();
            this.v.visitLabel(begin);
            this.v.load(indexIndex, Type.INT_TYPE);
            this.v.load(n, Type.INT_TYPE);
            this.v.ificmpge(end);
            this.v.dup2();
            this.v.load(indexIndex, Type.INT_TYPE);
            this.v.invokestatic("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            this.v.invokeinterface("jet/Function1", "invoke", "(Ljava/lang/Object;)Ljava/lang/Object;");
            this.v.load(indexIndex, Type.INT_TYPE);
            this.v.iinc(indexIndex, 1);
            this.v.swap();
            this.v.astore(AsmTypeConstants.OBJECT_TYPE);
            this.v.goTo(begin);
            this.v.visitLabel(end);
            this.v.pop();
            this.myFrameMap.leaveTemp(Type.INT_TYPE);
            this.myFrameMap.leaveTemp(Type.INT_TYPE);
        }
    }

    @Override
    public StackValue visitArrayAccessExpression(JetArrayAccessExpression expression, StackValue receiver) {
        ResolvedCall<FunctionDescriptor> resolvedCall;
        JetExpression array = expression.getArrayExpression();
        JetType type = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, array);
        Type arrayType = this.asmTypeOrVoid(type);
        List<JetExpression> indices = expression.getIndexExpressions();
        FunctionDescriptor operationDescriptor = (FunctionDescriptor)this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression);
        assert (operationDescriptor != null);
        if (arrayType.getSort() == 9 && indices.size() == 1 && ((Object)operationDescriptor.getValueParameters().get(0).getType()).equals(KotlinBuiltIns.getInstance().getIntType())) {
            this.gen(array, arrayType);
            for (JetExpression index : indices) {
                this.gen(index, Type.INT_TYPE);
            }
            assert (type != null);
            if (KotlinBuiltIns.getInstance().isArray(type)) {
                JetType elementType = type.getArguments().get(0).getType();
                Type notBoxed = this.asmType(elementType);
                return StackValue.arrayElement(notBoxed, true);
            }
            return StackValue.arrayElement(AsmUtil.correctElementType(arrayType), false);
        }
        ResolvedCall<FunctionDescriptor> resolvedSetCall = this.bindingContext.get(BindingContext.INDEXED_LVALUE_SET, expression);
        ResolvedCall<FunctionDescriptor> resolvedGetCall = this.bindingContext.get(BindingContext.INDEXED_LVALUE_GET, expression);
        boolean isGetter = "get".equals(operationDescriptor.getName().asString());
        ResolvedCall<FunctionDescriptor> resolvedCall2 = resolvedCall = isGetter ? resolvedGetCall : resolvedSetCall;
        assert (resolvedCall != null) : "couldn't find resolved call: " + expression.getText();
        Callable callable = this.resolveToCallable(operationDescriptor, false);
        if (callable instanceof CallableMethod) {
            this.genThisAndReceiverFromResolvedCall(receiver, resolvedCall, (CallableMethod)callable);
        } else {
            this.gen(array, arrayType);
        }
        int index = operationDescriptor.getReceiverParameter() != null ? 1 : 0;
        Method asmMethod = this.resolveToCallableMethod(operationDescriptor, false, this.context).getSignature().getAsmMethod();
        Type[] argumentTypes = asmMethod.getArgumentTypes();
        for (JetExpression jetExpression : expression.getIndexExpressions()) {
            this.gen(jetExpression, argumentTypes[index]);
            ++index;
        }
        Type elementType = isGetter ? asmMethod.getReturnType() : ArrayUtil.getLastElement(argumentTypes);
        return StackValue.collectionElement(elementType, resolvedGetCall, resolvedSetCall, this, this.state);
    }

    @Override
    public StackValue visitThrowExpression(JetThrowExpression expression, StackValue receiver) {
        this.gen(expression.getThrownExpression(), AsmTypeConstants.JAVA_THROWABLE_TYPE);
        this.v.athrow();
        return StackValue.none();
    }

    @Override
    public StackValue visitThisExpression(JetThisExpression expression, StackValue receiver) {
        DeclarationDescriptor descriptor = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getInstanceReference());
        if (descriptor instanceof ClassDescriptor) {
            return StackValue.thisOrOuter(this, (ClassDescriptor)descriptor, false);
        }
        if (descriptor instanceof CallableDescriptor) {
            return this.generateReceiver(descriptor);
        }
        throw new UnsupportedOperationException("neither this nor receiver");
    }

    @Override
    public StackValue visitTryExpression(JetTryExpression expression, StackValue receiver) {
        return this.generateTryExpression(expression, false);
    }

    public StackValue generateTryExpression(JetTryExpression expression, boolean isStatement) {
        JetFinallySection finallyBlock = expression.getFinallyBlock();
        FinallyBlockStackElement finallyBlockStackElement = null;
        if (finallyBlock != null) {
            finallyBlockStackElement = new FinallyBlockStackElement(expression);
            this.blockStackElements.push(finallyBlockStackElement);
        }
        JetType jetType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, expression);
        assert (jetType != null);
        Type expectedAsmType = isStatement ? Type.VOID_TYPE : this.asmType(jetType);
        Label tryStart = new Label();
        this.v.mark(tryStart);
        this.v.nop();
        this.gen(expression.getTryBlock(), expectedAsmType);
        int savedValue = -1;
        if (!isStatement) {
            savedValue = this.myFrameMap.enterTemp(expectedAsmType);
            this.v.store(savedValue, expectedAsmType);
        }
        Label tryEnd = new Label();
        this.v.mark(tryEnd);
        if (finallyBlock != null) {
            this.blockStackElements.pop();
            this.gen(finallyBlock.getFinalExpression(), Type.VOID_TYPE);
            this.blockStackElements.push(finallyBlockStackElement);
        }
        Label end = new Label();
        this.v.goTo(end);
        List<JetCatchClause> clauses = expression.getCatchClauses();
        int size = clauses.size();
        for (int i = 0; i < size; ++i) {
            JetCatchClause clause = clauses.get(i);
            Label clauseStart = new Label();
            this.v.mark(clauseStart);
            VariableDescriptor descriptor = this.bindingContext.get(BindingContext.VALUE_PARAMETER, clause.getCatchParameter());
            assert (descriptor != null);
            Type descriptorType = this.asmType(descriptor.getType());
            this.myFrameMap.enter(descriptor, descriptorType);
            int index = this.lookupLocalIndex(descriptor);
            this.v.store(index, descriptorType);
            this.gen(clause.getCatchBody(), expectedAsmType);
            if (!isStatement) {
                this.v.store(savedValue, expectedAsmType);
            }
            this.myFrameMap.leave(descriptor);
            if (finallyBlock != null) {
                this.blockStackElements.pop();
                this.gen(finallyBlock.getFinalExpression(), Type.VOID_TYPE);
                this.blockStackElements.push(finallyBlockStackElement);
            }
            if (i != size - 1 || finallyBlock != null) {
                this.v.goTo(end);
            }
            this.v.visitTryCatchBlock(tryStart, tryEnd, clauseStart, descriptorType.getInternalName());
        }
        if (finallyBlock != null) {
            Label finallyStart = new Label();
            this.v.mark(finallyStart);
            int savedException = this.myFrameMap.enterTemp(AsmTypeConstants.JAVA_THROWABLE_TYPE);
            this.v.store(savedException, AsmTypeConstants.JAVA_THROWABLE_TYPE);
            this.blockStackElements.pop();
            this.gen(finallyBlock.getFinalExpression(), Type.VOID_TYPE);
            this.blockStackElements.push(finallyBlockStackElement);
            this.v.load(savedException, AsmTypeConstants.JAVA_THROWABLE_TYPE);
            this.myFrameMap.leaveTemp(AsmTypeConstants.JAVA_THROWABLE_TYPE);
            this.v.athrow();
            this.v.visitTryCatchBlock(tryStart, tryEnd, finallyStart, null);
        }
        this.markLineNumber(expression);
        this.v.mark(end);
        if (!isStatement) {
            this.v.load(savedValue, expectedAsmType);
            this.myFrameMap.leaveTemp(expectedAsmType);
        }
        if (finallyBlock != null) {
            this.blockStackElements.pop();
        }
        return StackValue.onStack(expectedAsmType);
    }

    @Override
    public StackValue visitBinaryWithTypeRHSExpression(JetBinaryExpressionWithTypeRHS expression, StackValue receiver) {
        JetSimpleNameExpression operationSign = expression.getOperationReference();
        IElementType opToken = operationSign.getReferencedNameElementType();
        if (opToken == JetTokens.COLON) {
            return this.gen(expression.getLeft());
        }
        JetTypeReference typeReference = expression.getRight();
        JetType rightType = this.bindingContext.get(BindingContext.TYPE, typeReference);
        assert (rightType != null);
        Type rightTypeAsm = AsmUtil.boxType(this.asmType(rightType));
        JetExpression left = expression.getLeft();
        ClassifierDescriptor descriptor = rightType.getConstructor().getDeclarationDescriptor();
        if (descriptor instanceof ClassDescriptor || descriptor instanceof TypeParameterDescriptor) {
            StackValue value = this.genQualified(receiver, left);
            value.put(AsmUtil.boxType(value.type), this.v);
            if (opToken != JetTokens.AS_SAFE) {
                if (!CodegenUtil.isNullableType(rightType)) {
                    this.v.dup();
                    Label nonnull = new Label();
                    this.v.ifnonnull(nonnull);
                    JetType leftType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, left);
                    assert (leftType != null);
                    this.throwNewException("jet/TypeCastException", DescriptorRenderer.TEXT.renderType(leftType) + " cannot be cast to " + DescriptorRenderer.TEXT.renderType(rightType));
                    this.v.mark(nonnull);
                }
            } else {
                this.v.dup();
                this.v.instanceOf(rightTypeAsm);
                Label ok = new Label();
                this.v.ifne(ok);
                this.v.pop();
                this.v.aconst(null);
                this.v.mark(ok);
            }
            this.v.checkcast(rightTypeAsm);
            return StackValue.onStack(rightTypeAsm);
        }
        throw new UnsupportedOperationException("Don't know how to handle non-class types in as/as? : " + descriptor);
    }

    @Override
    public StackValue visitIsExpression(JetIsExpression expression, StackValue receiver) {
        StackValue match = StackValue.expression(AsmTypeConstants.OBJECT_TYPE, expression.getLeftHandSide(), this);
        return this.generateIsCheck(match, expression.getTypeRef(), expression.isNegated());
    }

    private StackValue generateExpressionMatch(StackValue expressionToMatch, JetExpression patternExpression) {
        if (expressionToMatch != null) {
            Type condType;
            Type subjectType = expressionToMatch.type;
            expressionToMatch.dupReceiver(this.v);
            expressionToMatch.put(subjectType, this.v);
            JetType condJetType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, patternExpression);
            if (AsmUtil.isNumberPrimitive(subjectType) || subjectType.getSort() == 1) {
                assert (condJetType != null);
                condType = this.asmType(condJetType);
                if (!AsmUtil.isNumberPrimitive(condType) && condType.getSort() != 1) {
                    subjectType = AsmUtil.boxType(subjectType);
                    expressionToMatch.coerceTo(subjectType, this.v);
                }
            } else {
                condType = AsmTypeConstants.OBJECT_TYPE;
            }
            this.gen(patternExpression, condType);
            return AsmUtil.genEqualsForExpressionsOnStack(this.v, JetTokens.EQEQ, subjectType, condType);
        }
        return this.gen(patternExpression);
    }

    private StackValue generateIsCheck(StackValue expressionToMatch, JetTypeReference typeReference, boolean negated) {
        JetType jetType = this.bindingContext.get(BindingContext.TYPE, typeReference);
        expressionToMatch.dupReceiver(this.v);
        this.generateInstanceOf(expressionToMatch, jetType, false);
        StackValue value = StackValue.onStack(Type.BOOLEAN_TYPE);
        return negated ? StackValue.not(value) : value;
    }

    private void generateInstanceOf(StackValue expressionToGen, JetType jetType, boolean leaveExpressionOnStack) {
        expressionToGen.put(AsmTypeConstants.OBJECT_TYPE, this.v);
        if (leaveExpressionOnStack) {
            this.v.dup();
        }
        Type type = AsmUtil.boxType(this.asmType(jetType));
        if (jetType.isNullable()) {
            Label nope = new Label();
            Label end = new Label();
            this.v.dup();
            this.v.ifnull(nope);
            this.v.instanceOf(type);
            this.v.goTo(end);
            this.v.mark(nope);
            this.v.pop();
            this.v.iconst(1);
            this.v.mark(end);
        } else {
            this.v.instanceOf(type);
        }
    }

    @Override
    public StackValue visitWhenExpression(JetWhenExpression expression, StackValue receiver) {
        return this.generateWhenExpression(expression, false);
    }

    public StackValue generateWhenExpression(JetWhenExpression expression, boolean isStatement) {
        int subjectLocal;
        JetExpression expr = expression.getSubjectExpression();
        JetType subjectJetType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, expr);
        Type subjectType = this.asmTypeOrVoid(subjectJetType);
        Type resultType = isStatement ? Type.VOID_TYPE : this.expressionType(expression);
        int n = subjectLocal = expr != null ? this.myFrameMap.enterTemp(subjectType) : -1;
        if (subjectLocal != -1) {
            this.gen(expr, subjectType);
            this.tempVariables.put(expr, StackValue.local(subjectLocal, subjectType));
            this.v.store(subjectLocal, subjectType);
        }
        Label end = new Label();
        boolean hasElse = JetPsiUtil.checkWhenExpressionHasSingleElse(expression);
        Label nextCondition = null;
        for (JetWhenEntry whenEntry : expression.getEntries()) {
            if (nextCondition != null) {
                this.v.mark(nextCondition);
            }
            nextCondition = new Label();
            FrameMap.Mark mark = this.myFrameMap.mark();
            Label thisEntry = new Label();
            if (!whenEntry.isElse()) {
                JetWhenCondition[] conditions = whenEntry.getConditions();
                for (int i = 0; i < conditions.length; ++i) {
                    StackValue conditionValue = this.generateWhenCondition(subjectType, subjectLocal, conditions[i]);
                    conditionValue.condJump(nextCondition, true, this.v);
                    if (i >= conditions.length - 1) continue;
                    this.v.goTo(thisEntry);
                    this.v.mark(nextCondition);
                    nextCondition = new Label();
                }
            }
            this.v.visitLabel(thisEntry);
            this.gen(whenEntry.getExpression(), resultType);
            mark.dropTo();
            if (whenEntry.isElse()) continue;
            this.v.goTo(end);
        }
        if (!hasElse && nextCondition != null) {
            this.v.mark(nextCondition);
            this.throwNewException("jet/NoPatternMatchedException");
        }
        this.markLineNumber(expression);
        this.v.mark(end);
        this.myFrameMap.leaveTemp(subjectType);
        this.tempVariables.remove(expr);
        return StackValue.onStack(resultType);
    }

    private StackValue generateWhenCondition(Type subjectType, int subjectLocal, JetWhenCondition condition) {
        StackValue.Local match;
        if (condition instanceof JetWhenConditionInRange) {
            boolean inverted;
            JetWhenConditionInRange conditionInRange = (JetWhenConditionInRange)condition;
            JetExpression rangeExpression = conditionInRange.getRangeExpression();
            while (rangeExpression instanceof JetParenthesizedExpression) {
                rangeExpression = ((JetParenthesizedExpression)rangeExpression).getExpression();
            }
            JetSimpleNameExpression operationReference = conditionInRange.getOperationReference();
            boolean bl = inverted = operationReference.getReferencedNameElementType() == JetTokens.NOT_IN;
            if (this.isIntRangeExpr(rangeExpression)) {
                this.getInIntRange(new StackValue.Local(subjectLocal, subjectType), (JetBinaryExpression)rangeExpression, inverted);
            } else {
                this.invokeFunctionByReference(operationReference);
                if (inverted) {
                    AsmUtil.genInvertBoolean(this.v);
                }
            }
            return StackValue.onStack(Type.BOOLEAN_TYPE);
        }
        StackValue.Local local = match = subjectLocal == -1 ? null : StackValue.local(subjectLocal, subjectType);
        if (condition instanceof JetWhenConditionIsPattern) {
            JetWhenConditionIsPattern patternCondition = (JetWhenConditionIsPattern)condition;
            return this.generateIsCheck(match, patternCondition.getTypeRef(), patternCondition.isNegated());
        }
        if (condition instanceof JetWhenConditionWithExpression) {
            JetExpression patternExpression = ((JetWhenConditionWithExpression)condition).getExpression();
            return this.generateExpressionMatch(match, patternExpression);
        }
        throw new UnsupportedOperationException("unsupported kind of when condition");
    }

    private void invokeFunctionByReference(JetSimpleNameExpression operationReference) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall = this.bindingContext.get(BindingContext.RESOLVED_CALL, operationReference);
        Call call = this.bindingContext.get(BindingContext.CALL, operationReference);
        this.invokeFunction(call, StackValue.none(), resolvedCall);
    }

    private boolean isIntRangeExpr(JetExpression rangeExpression) {
        JetBinaryExpression binaryExpression;
        if (rangeExpression instanceof JetBinaryExpression && (binaryExpression = (JetBinaryExpression)rangeExpression).getOperationReference().getReferencedNameElementType() == JetTokens.RANGE) {
            JetType jetType = this.bindingContext.get(BindingContext.EXPRESSION_TYPE, rangeExpression);
            assert (jetType != null);
            ClassifierDescriptor descriptor = jetType.getConstructor().getDeclarationDescriptor();
            return INTEGRAL_RANGES.contains(descriptor);
        }
        return false;
    }

    private void throwNewException(@NotNull String className) {
        this.throwNewException(className, null);
    }

    private void throwNewException(@NotNull String className, @Nullable String message) {
        this.v.anew(Type.getObjectType(className));
        this.v.dup();
        if (message != null) {
            this.v.visitLdcInsn(message);
            this.v.invokespecial(className, "<init>", "(Ljava/lang/String;)V");
        } else {
            this.v.invokespecial(className, "<init>", "()V");
        }
        this.v.athrow();
    }

    private Call makeFakeCall(ReceiverValue initializerAsReceiver) {
        JetSimpleNameExpression fake = JetPsiFactory.createSimpleName(this.state.getProject(), "fake");
        return CallMaker.makeCall(fake, initializerAsReceiver);
    }

    public String toString() {
        return this.context.getContextDescriptor().toString();
    }

    private class ForInProgressionExpressionLoopGenerator
    extends AbstractForInProgressionOrRangeLoopGenerator {
        private int incrementVar;
        private Type incrementType;
        private int finalVar;

        private ForInProgressionExpressionLoopGenerator(@NotNull JetForExpression forExpression) {
            super(forExpression);
        }

        @Override
        protected int getFinalVar() {
            return this.finalVar;
        }

        @Override
        public void beforeLoop() {
            super.beforeLoop();
            this.incrementVar = this.createLoopTempVariable(this.asmElementType);
            JetType loopRangeType = ExpressionCodegen.this.bindingContext.get(BindingContext.EXPRESSION_TYPE, this.forExpression.getLoopRange());
            assert (loopRangeType != null);
            Type asmLoopRangeType = ExpressionCodegen.this.asmType(loopRangeType);
            Collection<VariableDescriptor> incrementProp = loopRangeType.getMemberScope().getProperties(Name.identifier("increment"));
            assert (incrementProp.size() == 1) : loopRangeType + " " + incrementProp.size();
            this.incrementType = ExpressionCodegen.this.asmType(incrementProp.iterator().next().getType());
            ExpressionCodegen.this.gen(this.forExpression.getLoopRange(), asmLoopRangeType);
            ExpressionCodegen.this.v.dup();
            ExpressionCodegen.this.v.dup();
            this.generateRangeOrProgressionProperty(asmLoopRangeType, "getStart", this.asmElementType, this.loopParameterVar);
            this.generateRangeOrProgressionProperty(asmLoopRangeType, "getEnd", this.asmElementType, this.endVar);
            this.generateRangeOrProgressionProperty(asmLoopRangeType, "getIncrement", this.incrementType, this.incrementVar);
            this.storeFinalVar();
        }

        private void storeFinalVar() {
            if (!this.isIntegerProgression) {
                this.finalVar = -1;
                return;
            }
            ExpressionCodegen.this.v.load(this.loopParameterVar, this.asmElementType);
            ExpressionCodegen.this.v.load(this.endVar, this.asmElementType);
            ExpressionCodegen.this.v.load(this.incrementVar, this.incrementType);
            Type methodParamType = this.asmElementType.getSort() == 7 ? Type.LONG_TYPE : Type.INT_TYPE;
            ExpressionCodegen.this.v.invokestatic("jet/runtime/ProgressionUtil", "getProgressionFinalElement", Type.getMethodDescriptor(methodParamType, methodParamType, methodParamType, methodParamType));
            this.finalVar = this.createLoopTempVariable(this.asmElementType);
            ExpressionCodegen.this.v.store(this.finalVar, this.asmElementType);
        }

        @Override
        public void checkPreCondition(@NotNull Label loopExit) {
            if (this.isIntegerProgression) {
                return;
            }
            ExpressionCodegen.this.v.load(this.loopParameterVar, this.asmElementType);
            ExpressionCodegen.this.v.load(this.endVar, this.asmElementType);
            ExpressionCodegen.this.v.load(this.incrementVar, this.incrementType);
            Label negativeIncrement = new Label();
            Label afterIf = new Label();
            if (this.incrementType.getSort() == 8) {
                ExpressionCodegen.this.v.dconst(0.0);
            } else {
                ExpressionCodegen.this.v.fconst(0.0f);
            }
            ExpressionCodegen.this.v.cmpl(this.incrementType);
            ExpressionCodegen.this.v.ifle(negativeIncrement);
            ExpressionCodegen.this.v.cmpg(this.asmElementType);
            ExpressionCodegen.this.v.ifgt(loopExit);
            ExpressionCodegen.this.v.goTo(afterIf);
            ExpressionCodegen.this.v.mark(negativeIncrement);
            ExpressionCodegen.this.v.cmpl(this.asmElementType);
            ExpressionCodegen.this.v.iflt(loopExit);
            ExpressionCodegen.this.v.mark(afterIf);
        }

        @Override
        public void checkEmptyLoop(@NotNull Label loopExit) {
            if (!this.isIntegerProgression) {
                return;
            }
            ExpressionCodegen.this.v.load(this.loopParameterVar, this.asmElementType);
            ExpressionCodegen.this.v.load(this.endVar, this.asmElementType);
            ExpressionCodegen.this.v.load(this.incrementVar, this.incrementType);
            Label negativeIncrement = new Label();
            Label afterIf = new Label();
            if (this.asmElementType.getSort() == 7) {
                ExpressionCodegen.this.v.lconst(0L);
                ExpressionCodegen.this.v.lcmp();
                ExpressionCodegen.this.v.ifle(negativeIncrement);
                ExpressionCodegen.this.v.lcmp();
                ExpressionCodegen.this.v.ifgt(loopExit);
                ExpressionCodegen.this.v.goTo(afterIf);
                ExpressionCodegen.this.v.mark(negativeIncrement);
                ExpressionCodegen.this.v.lcmp();
                ExpressionCodegen.this.v.iflt(loopExit);
                ExpressionCodegen.this.v.mark(afterIf);
            } else {
                ExpressionCodegen.this.v.ifle(negativeIncrement);
                ExpressionCodegen.this.v.ificmpgt(loopExit);
                ExpressionCodegen.this.v.goTo(afterIf);
                ExpressionCodegen.this.v.mark(negativeIncrement);
                ExpressionCodegen.this.v.ificmplt(loopExit);
                ExpressionCodegen.this.v.mark(afterIf);
            }
        }

        @Override
        protected void assignToLoopParameter() {
        }

        @Override
        protected void increment(@NotNull Label loopExit) {
            if (this.isIntegerProgression) {
                this.checkPostCondition(loopExit);
            }
            ExpressionCodegen.this.v.load(this.loopParameterVar, this.asmElementType);
            ExpressionCodegen.this.v.load(this.incrementVar, this.asmElementType);
            ExpressionCodegen.this.v.add(this.asmElementType);
            if (this.asmElementType == Type.BYTE_TYPE || this.asmElementType == Type.SHORT_TYPE || this.asmElementType == Type.CHAR_TYPE) {
                StackValue.coerce(Type.INT_TYPE, this.asmElementType, ExpressionCodegen.this.v);
            }
            ExpressionCodegen.this.v.store(this.loopParameterVar, this.asmElementType);
        }
    }

    private class ForInRangeInstanceLoopGenerator
    extends AbstractForInRangeLoopGenerator {
        private ForInRangeInstanceLoopGenerator(@NotNull JetForExpression forExpression) {
            super(forExpression);
        }

        @Override
        protected void storeRangeStartAndEnd() {
            JetType loopRangeType = ExpressionCodegen.this.bindingContext.get(BindingContext.EXPRESSION_TYPE, this.forExpression.getLoopRange());
            assert (loopRangeType != null);
            Type asmLoopRangeType = ExpressionCodegen.this.asmType(loopRangeType);
            ExpressionCodegen.this.gen(this.forExpression.getLoopRange(), asmLoopRangeType);
            ExpressionCodegen.this.v.dup();
            this.generateRangeOrProgressionProperty(asmLoopRangeType, "getStart", this.asmElementType, this.loopParameterVar);
            this.generateRangeOrProgressionProperty(asmLoopRangeType, "getEnd", this.asmElementType, this.endVar);
        }
    }

    private class ForInRangeLiteralLoopGenerator
    extends AbstractForInRangeLoopGenerator {
        private final RangeCodegenUtil.BinaryCall rangeCall;

        private ForInRangeLiteralLoopGenerator(@NotNull JetForExpression forExpression, @NotNull RangeCodegenUtil.BinaryCall rangeCall) {
            super(forExpression);
            this.rangeCall = rangeCall;
        }

        @Override
        protected void storeRangeStartAndEnd() {
            ExpressionCodegen.this.gen(this.rangeCall.left, this.asmElementType);
            ExpressionCodegen.this.v.store(this.loopParameterVar, this.asmElementType);
            ExpressionCodegen.this.gen(this.rangeCall.right, this.asmElementType);
            ExpressionCodegen.this.v.store(this.endVar, this.asmElementType);
        }
    }

    private abstract class AbstractForInRangeLoopGenerator
    extends AbstractForInProgressionOrRangeLoopGenerator {
        private AbstractForInRangeLoopGenerator(@NotNull JetForExpression forExpression) {
            super(forExpression);
        }

        @Override
        public void beforeLoop() {
            super.beforeLoop();
            this.storeRangeStartAndEnd();
        }

        protected abstract void storeRangeStartAndEnd();

        @Override
        protected int getFinalVar() {
            return this.endVar;
        }

        @Override
        public void checkPreCondition(@NotNull Label loopExit) {
            if (this.isIntegerProgression) {
                return;
            }
            ExpressionCodegen.this.v.load(this.loopParameterVar, this.asmElementType);
            ExpressionCodegen.this.v.load(this.endVar, this.asmElementType);
            ExpressionCodegen.this.v.cmpg(this.asmElementType);
            ExpressionCodegen.this.v.ifgt(loopExit);
        }

        @Override
        public void checkEmptyLoop(@NotNull Label loopExit) {
            if (!this.isIntegerProgression) {
                return;
            }
            ExpressionCodegen.this.v.load(this.loopParameterVar, this.asmElementType);
            ExpressionCodegen.this.v.load(this.endVar, this.asmElementType);
            if (this.asmElementType.getSort() == 7) {
                ExpressionCodegen.this.v.lcmp();
                ExpressionCodegen.this.v.ifgt(loopExit);
            } else {
                ExpressionCodegen.this.v.ificmpgt(loopExit);
            }
        }

        @Override
        protected void assignToLoopParameter() {
        }

        @Override
        protected void increment(@NotNull Label loopExit) {
            if (this.isIntegerProgression) {
                this.checkPostCondition(loopExit);
            }
            if (this.asmElementType == Type.INT_TYPE) {
                ExpressionCodegen.this.v.iinc(this.loopParameterVar, 1);
            } else {
                ExpressionCodegen.this.v.load(this.loopParameterVar, this.asmElementType);
                AsmUtil.genIncrement(this.asmElementType, 1, ExpressionCodegen.this.v);
                ExpressionCodegen.this.v.store(this.loopParameterVar, this.asmElementType);
            }
        }
    }

    private abstract class AbstractForInProgressionOrRangeLoopGenerator
    extends AbstractForLoopGenerator {
        protected int endVar;
        protected final boolean isIntegerProgression;

        private AbstractForInProgressionOrRangeLoopGenerator(@NotNull JetForExpression forExpression) {
            super(forExpression);
            switch (this.asmElementType.getSort()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    this.isIntegerProgression = true;
                    break;
                }
                case 6: 
                case 8: {
                    this.isIntegerProgression = false;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected range element type: " + this.asmElementType);
                }
            }
        }

        @Override
        public void beforeLoop() {
            super.beforeLoop();
            this.endVar = this.createLoopTempVariable(this.asmElementType);
        }

        protected abstract int getFinalVar();

        protected void checkPostCondition(@NotNull Label loopExit) {
            int finalVar = this.getFinalVar();
            assert (this.isIntegerProgression && finalVar != -1) : "Post-condition should be checked only in case of integer progressions, finalVar = " + finalVar;
            ExpressionCodegen.this.v.load(this.loopParameterVar, this.asmElementType);
            ExpressionCodegen.this.v.load(finalVar, this.asmElementType);
            if (this.asmElementType.getSort() == 7) {
                ExpressionCodegen.this.v.lcmp();
                ExpressionCodegen.this.v.ifeq(loopExit);
            } else {
                ExpressionCodegen.this.v.ificmpeq(loopExit);
            }
        }
    }

    private class ForInArrayLoopGenerator
    extends AbstractForLoopGenerator {
        private int indexVar;
        private int arrayVar;
        private final JetType loopRangeType;

        private ForInArrayLoopGenerator(@NotNull JetForExpression forExpression) {
            super(forExpression);
            this.loopRangeType = ExpressionCodegen.this.bindingContext.get(BindingContext.EXPRESSION_TYPE, forExpression.getLoopRange());
        }

        @Override
        public void beforeLoop() {
            super.beforeLoop();
            this.indexVar = this.createLoopTempVariable(Type.INT_TYPE);
            JetExpression loopRange = this.forExpression.getLoopRange();
            StackValue value = ExpressionCodegen.this.gen(loopRange);
            Type asmLoopRangeType = ExpressionCodegen.this.asmType(this.loopRangeType);
            if (value instanceof StackValue.Local && value.type.equals(asmLoopRangeType)) {
                this.arrayVar = ((StackValue.Local)value).index;
            } else {
                this.arrayVar = this.createLoopTempVariable(AsmTypeConstants.OBJECT_TYPE);
                value.put(asmLoopRangeType, ExpressionCodegen.this.v);
                ExpressionCodegen.this.v.store(this.arrayVar, AsmTypeConstants.OBJECT_TYPE);
            }
            ExpressionCodegen.this.v.iconst(0);
            ExpressionCodegen.this.v.store(this.indexVar, Type.INT_TYPE);
        }

        @Override
        public void checkEmptyLoop(@NotNull Label loopExit) {
        }

        @Override
        public void checkPreCondition(@NotNull Label loopExit) {
            ExpressionCodegen.this.v.load(this.indexVar, Type.INT_TYPE);
            ExpressionCodegen.this.v.load(this.arrayVar, AsmTypeConstants.OBJECT_TYPE);
            ExpressionCodegen.this.v.arraylength();
            ExpressionCodegen.this.v.ificmpge(loopExit);
        }

        @Override
        protected void assignToLoopParameter() {
            Type arrayElParamType = KotlinBuiltIns.getInstance().isArray(this.loopRangeType) ? AsmUtil.boxType(this.asmElementType) : this.asmElementType;
            ExpressionCodegen.this.v.load(this.arrayVar, AsmTypeConstants.OBJECT_TYPE);
            ExpressionCodegen.this.v.load(this.indexVar, Type.INT_TYPE);
            ExpressionCodegen.this.v.aload(arrayElParamType);
            StackValue.onStack(arrayElParamType).put(this.asmElementType, ExpressionCodegen.this.v);
            ExpressionCodegen.this.v.store(this.loopParameterVar, this.asmElementType);
        }

        @Override
        protected void increment(@NotNull Label loopExit) {
            ExpressionCodegen.this.v.iinc(this.indexVar, 1);
        }
    }

    private class IteratorForLoopGenerator
    extends AbstractForLoopGenerator {
        private int iteratorVarIndex;
        private final ResolvedCall<FunctionDescriptor> iteratorCall;
        private final ResolvedCall<FunctionDescriptor> nextCall;
        private final Type asmTypeForIterator;

        private IteratorForLoopGenerator(@NotNull JetForExpression forExpression) {
            super(forExpression);
            JetExpression loopRange = forExpression.getLoopRange();
            assert (loopRange != null);
            this.iteratorCall = BindingContextUtils.getNotNull(ExpressionCodegen.this.bindingContext, BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, loopRange, "No .iterator() function " + DiagnosticUtils.atLocation(loopRange));
            JetType iteratorType = this.iteratorCall.getResultingDescriptor().getReturnType();
            assert (iteratorType != null);
            this.asmTypeForIterator = ExpressionCodegen.this.asmType(iteratorType);
            this.nextCall = BindingContextUtils.getNotNull(ExpressionCodegen.this.bindingContext, BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, loopRange, "No next() function " + DiagnosticUtils.atLocation(loopRange));
        }

        @Override
        public void beforeLoop() {
            super.beforeLoop();
            this.iteratorVarIndex = this.createLoopTempVariable(this.asmTypeForIterator);
            Call call = ExpressionCodegen.this.bindingContext.get(BindingContext.LOOP_RANGE_ITERATOR_CALL, this.forExpression.getLoopRange());
            ExpressionCodegen.this.invokeFunction(call, StackValue.none(), this.iteratorCall);
            ExpressionCodegen.this.v.store(this.iteratorVarIndex, this.asmTypeForIterator);
        }

        @Override
        public void checkEmptyLoop(@NotNull Label loopExit) {
        }

        @Override
        public void checkPreCondition(@NotNull Label loopExit) {
            JetExpression loopRange = this.forExpression.getLoopRange();
            ResolvedCall<FunctionDescriptor> hasNextCall = BindingContextUtils.getNotNull(ExpressionCodegen.this.bindingContext, BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, loopRange, "No hasNext() function " + DiagnosticUtils.atLocation(loopRange));
            Call fakeCall = ExpressionCodegen.this.makeFakeCall(new TransientReceiver(this.iteratorCall.getResultingDescriptor().getReturnType()));
            ExpressionCodegen.this.invokeFunction(fakeCall, StackValue.local(this.iteratorVarIndex, this.asmTypeForIterator), hasNextCall);
            JetType type = hasNextCall.getResultingDescriptor().getReturnType();
            assert (type != null && JetTypeChecker.INSTANCE.isSubtypeOf(type, KotlinBuiltIns.getInstance().getBooleanType()));
            Type asmType = ExpressionCodegen.this.asmType(type);
            StackValue.coerce(asmType, Type.BOOLEAN_TYPE, ExpressionCodegen.this.v);
            ExpressionCodegen.this.v.ifeq(loopExit);
        }

        @Override
        protected void assignToLoopParameter() {
            Call fakeCall = ExpressionCodegen.this.makeFakeCall(new TransientReceiver(this.iteratorCall.getResultingDescriptor().getReturnType()));
            ExpressionCodegen.this.invokeFunction(fakeCall, StackValue.local(this.iteratorVarIndex, this.asmTypeForIterator), this.nextCall);
            ExpressionCodegen.this.v.store(this.loopParameterVar, ExpressionCodegen.this.asmType(this.nextCall.getResultingDescriptor().getReturnType()));
        }

        @Override
        protected void increment(@NotNull Label loopExit) {
        }
    }

    private abstract class AbstractForLoopGenerator {
        protected final JetForExpression forExpression;
        private final Label bodyStart = new Label();
        private final Label bodyEnd = new Label();
        private final List<Runnable> leaveVariableTasks = Lists.newArrayList();
        protected final JetType elementType;
        protected final Type asmElementType;
        protected int loopParameterVar;

        private AbstractForLoopGenerator(@NotNull JetForExpression forExpression) {
            this.forExpression = forExpression;
            this.elementType = this.getElementType(forExpression);
            this.asmElementType = ExpressionCodegen.this.asmType(this.elementType);
        }

        @NotNull
        private JetType getElementType(JetForExpression forExpression) {
            JetExpression loopRange = forExpression.getLoopRange();
            assert (loopRange != null);
            ResolvedCall<FunctionDescriptor> nextCall = BindingContextUtils.getNotNull(ExpressionCodegen.this.bindingContext, BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, loopRange, "No next() function " + DiagnosticUtils.atLocation(loopRange));
            return nextCall.getResultingDescriptor().getReturnType();
        }

        public void beforeLoop() {
            JetParameter loopParameter = this.forExpression.getLoopParameter();
            if (loopParameter != null) {
                final VariableDescriptor parameterDescriptor = ExpressionCodegen.this.bindingContext.get(BindingContext.VALUE_PARAMETER, loopParameter);
                final Type asmTypeForParameter = ExpressionCodegen.this.asmType(parameterDescriptor.getType());
                this.loopParameterVar = ExpressionCodegen.this.myFrameMap.enter(parameterDescriptor, asmTypeForParameter);
                this.scheduleLeaveVariable(new Runnable(){

                    @Override
                    public void run() {
                        ExpressionCodegen.this.myFrameMap.leave(parameterDescriptor);
                        ExpressionCodegen.this.v.visitLocalVariable(parameterDescriptor.getName().asString(), asmTypeForParameter.getDescriptor(), null, AbstractForLoopGenerator.this.bodyStart, AbstractForLoopGenerator.this.bodyEnd, AbstractForLoopGenerator.this.loopParameterVar);
                    }
                });
            } else {
                JetMultiDeclaration multiParameter = this.forExpression.getMultiParameter();
                assert (multiParameter != null);
                this.loopParameterVar = this.createLoopTempVariable(this.asmElementType);
            }
        }

        public abstract void checkEmptyLoop(@NotNull Label var1);

        public abstract void checkPreCondition(@NotNull Label var1);

        public void beforeBody() {
            ExpressionCodegen.this.v.mark(this.bodyStart);
            this.assignToLoopParameter();
            if (this.forExpression.getLoopParameter() == null) {
                JetMultiDeclaration multiParameter = this.forExpression.getMultiParameter();
                assert (multiParameter != null);
                this.generateMultiVariables(multiParameter.getEntries());
            }
        }

        private void generateMultiVariables(List<JetMultiDeclarationEntry> entries) {
            for (JetMultiDeclarationEntry variableDeclaration : entries) {
                final VariableDescriptor componentDescriptor = ExpressionCodegen.this.bindingContext.get(BindingContext.VARIABLE, variableDeclaration);
                final Type componentAsmType = ExpressionCodegen.this.asmType(componentDescriptor.getReturnType());
                final int componentVarIndex = ExpressionCodegen.this.myFrameMap.enter(componentDescriptor, componentAsmType);
                this.scheduleLeaveVariable(new Runnable(){

                    @Override
                    public void run() {
                        ExpressionCodegen.this.myFrameMap.leave(componentDescriptor);
                        ExpressionCodegen.this.v.visitLocalVariable(componentDescriptor.getName().asString(), componentAsmType.getDescriptor(), null, AbstractForLoopGenerator.this.bodyStart, AbstractForLoopGenerator.this.bodyEnd, componentVarIndex);
                    }
                });
                ResolvedCall<FunctionDescriptor> resolvedCall = ExpressionCodegen.this.bindingContext.get(BindingContext.COMPONENT_RESOLVED_CALL, variableDeclaration);
                assert (resolvedCall != null) : "Resolved call is null for " + variableDeclaration.getText();
                Call call = ExpressionCodegen.this.makeFakeCall(new TransientReceiver(this.elementType));
                ExpressionCodegen.this.invokeFunction(call, StackValue.local(this.loopParameterVar, this.asmElementType), resolvedCall);
                ExpressionCodegen.this.v.store(componentVarIndex, componentAsmType);
            }
        }

        protected abstract void assignToLoopParameter();

        protected abstract void increment(@NotNull Label var1);

        public void body() {
            ExpressionCodegen.this.gen(this.forExpression.getBody(), Type.VOID_TYPE);
        }

        private void scheduleLeaveVariable(Runnable runnable) {
            this.leaveVariableTasks.add(runnable);
        }

        protected int createLoopTempVariable(final Type type) {
            int varIndex = ExpressionCodegen.this.myFrameMap.enterTemp(type);
            this.scheduleLeaveVariable(new Runnable(){

                @Override
                public void run() {
                    ExpressionCodegen.this.myFrameMap.leaveTemp(type);
                }
            });
            return varIndex;
        }

        public void afterBody(@NotNull Label loopExit) {
            this.increment(loopExit);
            ExpressionCodegen.this.v.mark(this.bodyEnd);
        }

        public void afterLoop() {
            for (Runnable task : Lists.reverse(this.leaveVariableTasks)) {
                task.run();
            }
        }

        protected void generateRangeOrProgressionProperty(Type loopRangeType, String getterName, Type elementType, int varToStore) {
            JvmPrimitiveType primitiveType = JvmPrimitiveType.getByAsmType(elementType);
            assert (primitiveType != null) : elementType;
            Type asmWrapperType = primitiveType.getWrapper().getAsmType();
            ExpressionCodegen.this.v.invokevirtual(loopRangeType.getInternalName(), getterName, "()" + asmWrapperType.getDescriptor());
            StackValue.coerce(asmWrapperType, elementType, ExpressionCodegen.this.v);
            ExpressionCodegen.this.v.store(varToStore, elementType);
        }
    }

    static class FinallyBlockStackElement
    extends BlockStackElement {
        final JetTryExpression expression;

        FinallyBlockStackElement(JetTryExpression expression) {
            this.expression = expression;
        }
    }

    static class LoopBlockStackElement
    extends BlockStackElement {
        final Label continueLabel;
        final Label breakLabel;
        public final JetSimpleNameExpression targetLabel;

        LoopBlockStackElement(Label breakLabel, Label continueLabel, JetSimpleNameExpression targetLabel) {
            this.breakLabel = breakLabel;
            this.continueLabel = continueLabel;
            this.targetLabel = targetLabel;
        }
    }

    static class BlockStackElement {
        BlockStackElement() {
        }
    }
}

