/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharSequenceBackedByArray;
import org.jetbrains.annotations.NotNull;

public class CharArrayCharSequence
implements CharSequenceBackedByArray {
    private final char[] myChars;
    private final int myStart;
    private final int myEnd;

    public CharArrayCharSequence(char ... chars) {
        if (chars == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/CharArrayCharSequence.<init> must not be null");
        }
        this(chars, 0, chars.length);
    }

    public CharArrayCharSequence(@NotNull char[] chars, int start, int end) {
        if (chars == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/CharArrayCharSequence.<init> must not be null");
        }
        if (start < 0 || end > chars.length || start > end) {
            throw new IndexOutOfBoundsException("chars.length:" + chars.length + ", start:" + start + ", end:" + end);
        }
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    @Override
    public final int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public final char charAt(int index) {
        return this.myChars[index + this.myStart];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return start == 0 && end == this.length() ? this : new CharArrayCharSequence(this.myChars, this.myStart + start, this.myStart + end);
    }

    @Override
    @NotNull
    public String toString() {
        String string = new String(this.myChars, this.myStart, this.myEnd - this.myStart);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/text/CharArrayCharSequence.toString must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public char[] getChars() {
        char[] cArray;
        if (this.myStart == 0) {
            cArray = this.myChars;
            if (this.myChars == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/CharArrayCharSequence.getChars must not return null");
            return cArray;
        }
        char[] chars = new char[this.length()];
        System.arraycopy(this.myChars, this.myStart, chars, 0, this.length());
        cArray = chars;
        if (chars != null) return cArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/text/CharArrayCharSequence.getChars must not return null");
    }

    public int hashCode() {
        return StringUtil.stringHashCode(this.myChars, this.myStart, this.myEnd);
    }

    @Override
    public void getChars(@NotNull char[] dst, int dstOffset) {
        if (dst == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/CharArrayCharSequence.getChars must not be null");
        }
        System.arraycopy(this.myChars, this.myStart, dst, dstOffset, this.length());
    }

    public boolean equals(Object anObject) {
        CharSequence anotherString;
        int n;
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof CharSequence && (n = this.myEnd - this.myStart) == (anotherString = (CharSequence)anObject).length()) {
            for (int i = 0; i < n; ++i) {
                if (this.myChars[this.myStart + i] == anotherString.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

