/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentRefHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

public final class ConcurrentWeakHashMap<K, V>
extends ConcurrentRefHashMap<K, V> {
    @Override
    protected ConcurrentRefHashMap.Key<K, V> createKey(@NotNull K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakHashMap.createKey must not be null");
        }
        return new WeakKey(key, value, this.myReferenceQueue);
    }

    public ConcurrentWeakHashMap() {
    }

    public ConcurrentWeakHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakHashMap.<init> must not be null");
        }
        super(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    private static class WeakKey<K, V>
    extends WeakReference<K>
    implements ConcurrentRefHashMap.Key<K, V> {
        private final int myHash;
        private final V value;

        private WeakKey(@NotNull K k, V v, ReferenceQueue<K> q) {
            if (k == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakHashMap$WeakKey.<init> must not be null");
            }
            super(k, q);
            this.value = v;
            this.myHash = k.hashCode();
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConcurrentRefHashMap.Key)) {
                return false;
            }
            Object t = this.get();
            Object u = ((ConcurrentRefHashMap.Key)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return t.equals(u);
        }

        public int hashCode() {
            return this.myHash;
        }
    }
}

