/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ConcurrentRefValueHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NotNull;

public final class ConcurrentSoftValueHashMap<K, V>
extends ConcurrentRefValueHashMap<K, V> {
    public ConcurrentSoftValueHashMap() {
    }

    public ConcurrentSoftValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        super(initialCapacity, loadFactor, concurrencyLevel);
    }

    @Override
    protected ConcurrentRefValueHashMap.MyValueReference<K, V> createRef(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentSoftValueHashMap.createRef must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ConcurrentSoftValueHashMap.createRef must not be null");
        }
        return new MySoftReference(key, value, this.myQueue);
    }

    private static class MySoftReference<K, T>
    extends SoftReference<T>
    implements ConcurrentRefValueHashMap.MyValueReference<K, T> {
        private final K key;

        private MySoftReference(@NotNull K key, @NotNull T referent, @NotNull ReferenceQueue<T> q) {
            if (key == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentSoftValueHashMap$MySoftReference.<init> must not be null");
            }
            if (referent == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ConcurrentSoftValueHashMap$MySoftReference.<init> must not be null");
            }
            if (q == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ConcurrentSoftValueHashMap$MySoftReference.<init> must not be null");
            }
            super(referent, q);
            this.key = key;
        }

        @Override
        @NotNull
        public K getKey() {
            K k = this.key;
            if (k == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/containers/ConcurrentSoftValueHashMap$MySoftReference.getKey must not return null");
            }
            return k;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConcurrentRefValueHashMap.MyValueReference that = (ConcurrentRefValueHashMap.MyValueReference)o;
            return this.key.equals(that.getKey()) && Comparing.equal(this.get(), that.get());
        }

        public final int hashCode() {
            return this.key.hashCode();
        }
    }
}

