/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureBase;
import com.intellij.psi.util.MethodSignatureHandMade;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodSignatureUtil {
    public static final TObjectHashingStrategy<MethodSignatureBackedByPsiMethod> METHOD_BASED_HASHING_STRATEGY = new TObjectHashingStrategy<MethodSignatureBackedByPsiMethod>(){

        @Override
        public int computeHashCode(MethodSignatureBackedByPsiMethod signature) {
            return signature.getMethod().hashCode();
        }

        @Override
        public boolean equals(MethodSignatureBackedByPsiMethod s1, MethodSignatureBackedByPsiMethod s2) {
            return s1.getMethod().equals(s2.getMethod());
        }
    };
    public static final TObjectHashingStrategy<MethodSignature> METHOD_PARAMETERS_ERASURE_EQUALITY = new TObjectHashingStrategy<MethodSignature>(){

        @Override
        public int computeHashCode(MethodSignature signature) {
            return signature.hashCode();
        }

        @Override
        public boolean equals(MethodSignature method1, MethodSignature method2) {
            return MethodSignatureUtil.areSignaturesEqualLightweight(method1, method2) && MethodSignatureUtil.areErasedParametersEqual(method1, method2);
        }
    };

    private MethodSignatureUtil() {
    }

    private static boolean areErasedParametersEqual(@NotNull MethodSignature method1, @NotNull MethodSignature method2) {
        if (method1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.areErasedParametersEqual must not be null");
        }
        if (method2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.areErasedParametersEqual must not be null");
        }
        Object[] erased1 = method1 instanceof MethodSignatureBase ? ((MethodSignatureBase)method1).getErasedParameterTypes() : MethodSignatureUtil.calcErasedParameterTypes(method1);
        Object[] erased2 = method2 instanceof MethodSignatureBase ? ((MethodSignatureBase)method2).getErasedParameterTypes() : MethodSignatureUtil.calcErasedParameterTypes(method2);
        return Arrays.equals(erased1, erased2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiType[] calcErasedParameterTypes(@NotNull MethodSignature signature) {
        PsiType[] psiTypeArray;
        if (signature == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.calcErasedParameterTypes must not be null");
        }
        PsiType[] parameterTypes = signature.getParameterTypes();
        if (parameterTypes.length == 0) {
            psiTypeArray = PsiType.EMPTY_ARRAY;
            if (PsiType.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureUtil.calcErasedParameterTypes must not return null");
            return psiTypeArray;
        }
        PsiSubstitutor substitutor = signature.getSubstitutor();
        PsiType[] erasedTypes = new PsiType[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            erasedTypes[i] = TypeConversionUtil.erasure(substitutor.substitute(parameterTypes[i]), substitutor);
        }
        psiTypeArray = erasedTypes;
        if (erasedTypes != null) return psiTypeArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureUtil.calcErasedParameterTypes must not return null");
    }

    @NotNull
    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @Nullable PsiParameterList parameterTypes, @Nullable PsiTypeParameterList typeParameterList, @NotNull PsiSubstitutor substitutor) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        MethodSignature methodSignature = MethodSignatureUtil.createMethodSignature(name, parameterTypes, typeParameterList, substitutor, false);
        if (methodSignature == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not return null");
        }
        return methodSignature;
    }

    @NotNull
    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @Nullable PsiParameterList parameterTypes, @Nullable PsiTypeParameterList typeParameterList, @NotNull PsiSubstitutor substitutor, boolean isConstructor) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        MethodSignatureHandMade methodSignatureHandMade = new MethodSignatureHandMade(name, parameterTypes, typeParameterList, substitutor, isConstructor);
        if (methodSignatureHandMade == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not return null");
        }
        return methodSignatureHandMade;
    }

    @NotNull
    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @NotNull PsiType[] parameterTypes, @NotNull PsiTypeParameter[] typeParameterList, @NotNull PsiSubstitutor substitutor) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        if (typeParameterList == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        MethodSignature methodSignature = MethodSignatureUtil.createMethodSignature(name, parameterTypes, typeParameterList, substitutor, false);
        if (methodSignature == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not return null");
        }
        return methodSignature;
    }

    @NotNull
    public static MethodSignature createMethodSignature(@NonNls @NotNull String name, @NotNull PsiType[] parameterTypes, @NotNull PsiTypeParameter[] typeParameterList, @NotNull PsiSubstitutor substitutor, boolean isConstructor) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        if (typeParameterList == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not be null");
        }
        MethodSignatureHandMade methodSignatureHandMade = new MethodSignatureHandMade(name, parameterTypes, typeParameterList, substitutor, isConstructor);
        if (methodSignatureHandMade == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureUtil.createMethodSignature must not return null");
        }
        return methodSignatureHandMade;
    }

    public static boolean areSignaturesEqual(@NotNull PsiMethod method1, @NotNull PsiMethod method2) {
        if (method1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.areSignaturesEqual must not be null");
        }
        if (method2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.areSignaturesEqual must not be null");
        }
        return method1.getSignature(PsiSubstitutor.EMPTY).equals(method2.getSignature(PsiSubstitutor.EMPTY));
    }

    public static boolean areSignaturesEqual(@NotNull MethodSignature method1, @NotNull MethodSignature method2) {
        if (method1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.areSignaturesEqual must not be null");
        }
        if (method2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.areSignaturesEqual must not be null");
        }
        if (method2 == method1) {
            return true;
        }
        if (!MethodSignatureUtil.areSignaturesEqualLightweight(method1, method2)) {
            return false;
        }
        return MethodSignatureUtil.checkSignaturesEqualInner(method1, method2, MethodSignatureUtil.getSuperMethodSignatureSubstitutor(method1, method2)) || MethodSignatureUtil.checkSignaturesEqualInner(method2, method1, MethodSignatureUtil.getSuperMethodSignatureSubstitutor(method2, method1));
    }

    private static boolean checkSignaturesEqualInner(@NotNull MethodSignature subSignature, @NotNull MethodSignature superSignature, PsiSubstitutor unifyingSubstitutor) {
        if (subSignature == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.checkSignaturesEqualInner must not be null");
        }
        if (superSignature == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.checkSignaturesEqualInner must not be null");
        }
        if (unifyingSubstitutor == null) {
            return false;
        }
        if (!MethodSignatureUtil.areErasedParametersEqual(subSignature, superSignature)) {
            return false;
        }
        PsiType[] subParameterTypes = subSignature.getParameterTypes();
        PsiType[] superParameterTypes = superSignature.getParameterTypes();
        for (int i = 0; i < subParameterTypes.length; ++i) {
            PsiType type2;
            PsiType type1 = unifyingSubstitutor.substitute(subParameterTypes[i]);
            if (Comparing.equal(type1, type2 = unifyingSubstitutor.substitute(superParameterTypes[i]))) continue;
            return false;
        }
        return true;
    }

    public static boolean areSignaturesEqualLightweight(@NotNull MethodSignature sig1, @NotNull MethodSignature sig2) {
        PsiType[] parameterTypes2;
        String name2;
        String name1;
        boolean isConstructor2;
        if (sig1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.areSignaturesEqualLightweight must not be null");
        }
        if (sig2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.areSignaturesEqualLightweight must not be null");
        }
        boolean isConstructor1 = sig1.isConstructor();
        if (isConstructor1 != (isConstructor2 = sig2.isConstructor())) {
            return false;
        }
        if (!(isConstructor1 && (sig1 instanceof HierarchicalMethodSignature || sig2 instanceof HierarchicalMethodSignature) || (name1 = sig1.getName()).equals(name2 = sig2.getName()))) {
            return false;
        }
        PsiType[] parameterTypes1 = sig1.getParameterTypes();
        if (parameterTypes1.length != (parameterTypes2 = sig2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < parameterTypes1.length; ++i) {
            PsiType type1 = parameterTypes1[i];
            PsiType type2 = parameterTypes2[i];
            if (type1 instanceof PsiPrimitiveType != type2 instanceof PsiPrimitiveType) {
                return false;
            }
            if (!(type1 instanceof PsiPrimitiveType) || type1.equals(type2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSuperMethod(@NotNull PsiMethod superMethodCandidate, @NotNull PsiMethod derivedMethod) {
        if (superMethodCandidate == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.isSuperMethod must not be null");
        }
        if (derivedMethod == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.isSuperMethod must not be null");
        }
        PsiClass superClassCandidate = superMethodCandidate.getContainingClass();
        PsiClass derivedClass = derivedMethod.getContainingClass();
        if (derivedClass == null || superClassCandidate == null) {
            return false;
        }
        if (!derivedClass.isInheritor(superClassCandidate, true)) {
            return false;
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(superClassCandidate, derivedClass, PsiSubstitutor.EMPTY);
        MethodSignature superSignature = superMethodCandidate.getSignature(superSubstitutor);
        MethodSignature derivedSignature = derivedMethod.getSignature(PsiSubstitutor.EMPTY);
        return MethodSignatureUtil.isSubsignature(superSignature, derivedSignature);
    }

    @Nullable
    public static PsiMethod findMethodInSuperClassBySignatureInDerived(@NotNull PsiClass aClass, @NotNull PsiClass superClass, @NotNull MethodSignature signature, boolean checkDeep) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived must not be null");
        }
        if (superClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived must not be null");
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass, PsiSubstitutor.EMPTY);
        return MethodSignatureUtil.doFindMethodInSuperClassBySignatureInDerived(superClass, superSubstitutor, signature, checkDeep);
    }

    @Nullable
    private static PsiMethod doFindMethodInSuperClassBySignatureInDerived(@NotNull PsiClass superClass, @NotNull PsiSubstitutor superSubstitutor, @NotNull MethodSignature signature, boolean checkDeep) {
        PsiClass clazz;
        PsiMethod[] methods;
        if (superClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.doFindMethodInSuperClassBySignatureInDerived must not be null");
        }
        if (superSubstitutor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.doFindMethodInSuperClassBySignatureInDerived must not be null");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.doFindMethodInSuperClassBySignatureInDerived must not be null");
        }
        String name = signature.getName();
        for (PsiMethod method : methods = superClass.findMethodsByName(name, false)) {
            if (!MethodSignatureUtil.isSubsignature(method.getSignature(superSubstitutor), signature)) continue;
            return method;
        }
        if (checkDeep && (clazz = superClass.getSuperClass()) != null && clazz != superClass) {
            PsiSubstitutor substitutor1 = TypeConversionUtil.getSuperClassSubstitutor(clazz, superClass, superSubstitutor);
            return MethodSignatureUtil.doFindMethodInSuperClassBySignatureInDerived(clazz, substitutor1, signature, true);
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodBySignature(@NotNull PsiClass aClass, @NotNull PsiMethod pattenMethod, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.findMethodBySignature must not be null");
        }
        if (pattenMethod == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.findMethodBySignature must not be null");
        }
        return MethodSignatureUtil.findMethodBySignature(aClass, pattenMethod.getSignature(PsiSubstitutor.EMPTY), checkBases);
    }

    @Nullable
    public static PsiMethod findMethodBySignature(@NotNull PsiClass aClass, @NotNull MethodSignature methodSignature, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.findMethodBySignature must not be null");
        }
        if (methodSignature == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.findMethodBySignature must not be null");
        }
        String name = methodSignature.isConstructor() ? aClass.getName() : methodSignature.getName();
        List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass.findMethodsAndTheirSubstitutorsByName(name, checkBases);
        for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
            PsiMethod method = (PsiMethod)pair.first;
            PsiSubstitutor substitutor = (PsiSubstitutor)pair.second;
            MethodSignature foundMethodSignature = method.getSignature(substitutor);
            if (!methodSignature.equals(foundMethodSignature)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodBySuperSignature(@NotNull PsiClass aClass, @NotNull MethodSignature methodSignature, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.findMethodBySuperSignature must not be null");
        }
        if (methodSignature == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.findMethodBySuperSignature must not be null");
        }
        String name = methodSignature.isConstructor() ? aClass.getName() : methodSignature.getName();
        List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass.findMethodsAndTheirSubstitutorsByName(name, checkBases);
        for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
            PsiMethod method = (PsiMethod)pair.first;
            PsiSubstitutor substitutor = (PsiSubstitutor)pair.second;
            MethodSignature foundMethodSignature = method.getSignature(substitutor);
            if (!MethodSignatureUtil.isSubsignature(methodSignature, foundMethodSignature)) continue;
            return method;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodBySuperMethod(@NotNull PsiClass aClass, @NotNull PsiMethod method, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.findMethodBySuperMethod must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.findMethodBySuperMethod must not be null");
        }
        List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass.findMethodsAndTheirSubstitutorsByName(method.getName(), checkBases);
        for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
            MethodSignature superSignature;
            PsiSubstitutor superSubstitutor;
            PsiMethod candidate = (PsiMethod)pair.first;
            PsiSubstitutor substitutor = (PsiSubstitutor)pair.second;
            MethodSignature candidateSignature = candidate.getSignature(substitutor);
            PsiClass methodClass = method.getContainingClass();
            PsiClass candidateClass = candidate.getContainingClass();
            if (methodClass == null || candidateClass == null || (superSubstitutor = TypeConversionUtil.getClassSubstitutor(methodClass, candidateClass, substitutor)) == null || !MethodSignatureUtil.isSubsignature(superSignature = method.getSignature(superSubstitutor), candidateSignature)) continue;
            return candidate;
        }
        return null;
    }

    public static boolean hasOverloads(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.hasOverloads must not be null");
        }
        return MethodSignatureUtil.getOverloads(method).length > 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiMethod[] getOverloads(@NotNull PsiMethod method) {
        PsiMethod[] psiMethodArray;
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.getOverloads must not be null");
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            psiMethodArray = new PsiMethod[]{method};
            if (psiMethodArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureUtil.getOverloads must not return null");
            return psiMethodArray;
        }
        psiMethodArray = aClass.findMethodsByName(method.getName(), false);
        if (psiMethodArray != null) return psiMethodArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureUtil.getOverloads must not return null");
    }

    public static boolean areParametersErasureEqual(@NotNull PsiMethod method1, @NotNull PsiMethod method2) {
        if (method1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.areParametersErasureEqual must not be null");
        }
        if (method2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.areParametersErasureEqual must not be null");
        }
        if (method1.getParameterList().getParametersCount() != method2.getParameterList().getParametersCount()) {
            return false;
        }
        return MethodSignatureUtil.areSignaturesErasureEqual(method1.getSignature(PsiSubstitutor.EMPTY), method2.getSignature(PsiSubstitutor.EMPTY));
    }

    public static boolean areSignaturesErasureEqual(@NotNull MethodSignature signature1, @NotNull MethodSignature signature2) {
        if (signature1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.areSignaturesErasureEqual must not be null");
        }
        if (signature2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.areSignaturesErasureEqual must not be null");
        }
        return METHOD_PARAMETERS_ERASURE_EQUALITY.equals(signature1, signature2);
    }

    @Nullable
    public static PsiSubstitutor getSuperMethodSignatureSubstitutor(@NotNull MethodSignature methodSignature, @NotNull MethodSignature superMethodSignature) {
        if (methodSignature == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.getSuperMethodSignatureSubstitutor must not be null");
        }
        if (superMethodSignature == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.getSuperMethodSignatureSubstitutor must not be null");
        }
        PsiSubstitutor result = MethodSignatureUtil.getSuperMethodSignatureSubstitutorImpl(methodSignature, superMethodSignature);
        if (result == null) {
            return null;
        }
        PsiTypeParameter[] methodTypeParameters = methodSignature.getTypeParameters();
        PsiTypeParameter[] superTypeParameters = superMethodSignature.getTypeParameters();
        PsiSubstitutor methodSubstitutor = methodSignature.getSubstitutor();
        for (int i = 0; i < methodTypeParameters.length; ++i) {
            PsiTypeParameter methodTypeParameter = methodTypeParameters[i];
            PsiTypeParameter superTypeParameter = superTypeParameters[i];
            HashSet<PsiType> methodSupers = new HashSet<PsiType>();
            for (PsiClassType methodSuper : methodTypeParameter.getSuperTypes()) {
                methodSupers.add(methodSubstitutor.substitute(methodSuper));
            }
            HashSet<PsiType> superSupers = new HashSet<PsiType>();
            for (PsiClassType superSuper : superTypeParameter.getSuperTypes()) {
                superSupers.add(methodSubstitutor.substitute(PsiUtil.captureToplevelWildcards(result.substitute(superSuper), methodTypeParameter)));
            }
            methodSupers.remove(PsiType.getJavaLangObject(methodTypeParameter.getManager(), methodTypeParameter.getResolveScope()));
            superSupers.remove(PsiType.getJavaLangObject(superTypeParameter.getManager(), superTypeParameter.getResolveScope()));
            if (((Object)methodSupers).equals(superSupers)) continue;
            return null;
        }
        return result;
    }

    @Nullable
    private static PsiSubstitutor getSuperMethodSignatureSubstitutorImpl(@NotNull MethodSignature methodSignature, @NotNull MethodSignature superSignature) {
        PsiTypeParameter[] superTypeParameters;
        if (methodSignature == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.getSuperMethodSignatureSubstitutorImpl must not be null");
        }
        if (superSignature == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.getSuperMethodSignatureSubstitutorImpl must not be null");
        }
        PsiTypeParameter[] methodTypeParameters = methodSignature.getTypeParameters();
        if (methodTypeParameters.length != (superTypeParameters = superSignature.getTypeParameters()).length) {
            return null;
        }
        PsiSubstitutor result = superSignature.getSubstitutor();
        for (int i = 0; i < methodTypeParameters.length; ++i) {
            PsiTypeParameter methodTypeParameter = methodTypeParameters[i];
            PsiElementFactory factory = JavaPsiFacade.getInstance(methodTypeParameter.getProject()).getElementFactory();
            result = result.put(superTypeParameters[i], factory.createType(methodTypeParameter));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiSubstitutor combineSubstitutors(@NotNull PsiSubstitutor substitutor1, @NotNull PsiSubstitutor substitutor2) {
        PsiType otherSubstituted;
        PsiTypeParameter typeParameter;
        PsiTypeParameter[] typeParameters;
        PsiSubstitutor psiSubstitutor;
        if (substitutor1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.combineSubstitutors must not be null");
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.combineSubstitutors must not be null");
        }
        if (substitutor1 == PsiSubstitutor.EMPTY) {
            psiSubstitutor = substitutor2;
            if (psiSubstitutor == null) throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureUtil.combineSubstitutors must not return null");
            return psiSubstitutor;
        }
        Set<PsiTypeParameter> parameters1 = substitutor1.getSubstitutionMap().keySet();
        PsiTypeParameter[] arr$ = typeParameters = parameters1.toArray(new PsiTypeParameter[parameters1.size()]);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; substitutor1 = substitutor1.put(typeParameter, otherSubstituted), ++i$) {
            PsiClass resolved;
            typeParameter = arr$[i$];
            PsiType type = substitutor1.substitute(typeParameter);
            otherSubstituted = type instanceof PsiClassType ? ((resolved = ((PsiClassType)type).resolve()) instanceof PsiTypeParameter ? substitutor2.substitute((PsiTypeParameter)resolved) : substitutor2.substitute(type)) : substitutor2.substitute(type);
        }
        psiSubstitutor = substitutor1;
        if (psiSubstitutor != null) return psiSubstitutor;
        throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureUtil.combineSubstitutors must not return null");
    }

    @NotNull
    public static PsiMethod[] convertMethodSignaturesToMethods(@NotNull List<? extends MethodSignatureBackedByPsiMethod> sameNameMethodList) {
        if (sameNameMethodList == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.convertMethodSignaturesToMethods must not be null");
        }
        PsiMethod[] methods = new PsiMethod[sameNameMethodList.size()];
        for (int i = 0; i < sameNameMethodList.size(); ++i) {
            methods[i] = sameNameMethodList.get(i).getMethod();
        }
        if (methods == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureUtil.convertMethodSignaturesToMethods must not return null");
        }
        return methods;
    }

    public static boolean isSubsignature(@NotNull MethodSignature superSignature, @NotNull MethodSignature subSignature) {
        if (superSignature == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.isSubsignature must not be null");
        }
        if (subSignature == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureUtil.isSubsignature must not be null");
        }
        if (subSignature == superSignature) {
            return true;
        }
        if (!MethodSignatureUtil.areSignaturesEqualLightweight(superSignature, subSignature)) {
            return false;
        }
        PsiSubstitutor unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor(subSignature, superSignature);
        if (MethodSignatureUtil.checkSignaturesEqualInner(superSignature, subSignature, unifyingSubstitutor)) {
            return true;
        }
        if (subSignature.getTypeParameters().length > 0) {
            return false;
        }
        PsiType[] subParameterTypes = subSignature.getParameterTypes();
        PsiType[] superParameterTypes = superSignature.getParameterTypes();
        for (int i = 0; i < subParameterTypes.length; ++i) {
            PsiType type1 = subParameterTypes[i];
            PsiType type2 = TypeConversionUtil.erasure(superParameterTypes[i], superSignature.getSubstitutor());
            if (Comparing.equal(type1, type2)) continue;
            return false;
        }
        return true;
    }
}

