/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MethodSignatureBase
implements MethodSignature {
    private final PsiSubstitutor mySubstitutor;
    private final PsiType[] myParameterTypes;
    private volatile PsiType[] myErasedParameterTypes;
    protected final PsiTypeParameter[] myTypeParameters;

    protected MethodSignatureBase(@NotNull PsiSubstitutor substitutor, @NotNull PsiType[] parameterTypes, @NotNull PsiTypeParameter[] typeParameters) {
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureBase.<init> must not be null");
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/MethodSignatureBase.<init> must not be null");
        }
        if (typeParameters == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/util/MethodSignatureBase.<init> must not be null");
        }
        this.mySubstitutor = substitutor;
        assert (substitutor.isValid());
        this.myParameterTypes = parameterTypes.length == 0 ? PsiType.EMPTY_ARRAY : new PsiType[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            PsiType type = parameterTypes[i];
            if (type != null) {
                PsiUtil.ensureValidType(type);
            }
            if (type instanceof PsiEllipsisType) {
                type = ((PsiEllipsisType)type).toArrayType();
            }
            this.myParameterTypes[i] = substitutor.substitute(type);
        }
        this.myTypeParameters = typeParameters;
    }

    protected MethodSignatureBase(@NotNull PsiSubstitutor substitutor, @Nullable PsiParameterList parameterList, @Nullable PsiTypeParameterList typeParameterList) {
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/MethodSignatureBase.<init> must not be null");
        }
        this.mySubstitutor = substitutor;
        if (parameterList == null) {
            this.myParameterTypes = PsiType.EMPTY_ARRAY;
        } else {
            PsiParameter[] parameters = parameterList.getParameters();
            this.myParameterTypes = parameters.length == 0 ? PsiType.EMPTY_ARRAY : new PsiType[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                PsiType type = parameters[i].getType();
                if (type instanceof PsiEllipsisType) {
                    type = ((PsiEllipsisType)type).toArrayType();
                }
                this.myParameterTypes[i] = substitutor.substitute(type);
            }
        }
        this.myTypeParameters = typeParameterList == null ? PsiTypeParameter.EMPTY_ARRAY : typeParameterList.getTypeParameters();
    }

    @Override
    @NotNull
    public PsiType[] getParameterTypes() {
        if (this.myParameterTypes == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureBase.getParameterTypes must not return null");
        }
        return this.myParameterTypes;
    }

    @Override
    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        if (this.myTypeParameters == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureBase.getTypeParameters must not return null");
        }
        return this.myTypeParameters;
    }

    public PsiType[] getErasedParameterTypes() {
        PsiType[] result = this.myErasedParameterTypes;
        if (result == null) {
            result = MethodSignatureUtil.calcErasedParameterTypes(this);
            this.myErasedParameterTypes = result;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodSignature)) {
            return false;
        }
        MethodSignature methodSignature = (MethodSignature)o;
        return MethodSignatureUtil.areSignaturesEqual(methodSignature, this);
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        PsiType[] parameterTypes = this.getErasedParameterTypes();
        result = 31 * result + parameterTypes.length;
        int length = Math.min(3, parameterTypes.length);
        for (int i = 0; i < length; ++i) {
            PsiType type = parameterTypes[i];
            if (type == null) continue;
            result = 31 * result + type.hashCode();
        }
        return result;
    }

    public String toString() {
        String s = this.getClass().getSimpleName() + ": ";
        PsiTypeParameter[] typeParameters = this.getTypeParameters();
        if (typeParameters.length != 0) {
            String sep = "<";
            for (PsiTypeParameter typeParameter : typeParameters) {
                s = s + sep + typeParameter.getName();
                sep = ", ";
            }
            s = s + ">";
        }
        s = s + this.getName() + "(" + Arrays.asList(this.getParameterTypes()) + ")";
        return s;
    }

    @Override
    @NotNull
    public PsiSubstitutor getSubstitutor() {
        PsiSubstitutor psiSubstitutor = this.mySubstitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/util/MethodSignatureBase.getSubstitutor must not return null");
        }
        return psiSubstitutor;
    }
}

