/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PsiElementProcessor<T extends PsiElement> {
    public boolean execute(@NotNull T var1);

    public static class FindFilteredElement<T extends PsiElement>
    extends FindElement<T> {
        private final PsiElementFilter myFilter;

        public FindFilteredElement(@NotNull PsiElementFilter filter) {
            if (filter == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/PsiElementProcessor$FindFilteredElement.<init> must not be null");
            }
            this.myFilter = filter;
        }

        @Override
        public boolean execute(@NotNull T element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/PsiElementProcessor$FindFilteredElement.execute must not be null");
            }
            return !this.myFilter.isAccepted((PsiElement)element) || super.execute(element);
        }
    }

    public static class FindElement<T extends PsiElement>
    implements PsiElementProcessor<T> {
        private volatile T myFoundElement = null;

        public boolean isFound() {
            return this.myFoundElement != null;
        }

        @Nullable
        public T getFoundElement() {
            return this.myFoundElement;
        }

        public boolean setFound(T element) {
            this.myFoundElement = element;
            return false;
        }

        @Override
        public boolean execute(@NotNull T element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/PsiElementProcessor$FindElement.execute must not be null");
            }
            return this.setFound(element);
        }
    }

    public static class CollectElementsWithLimit<T extends PsiElement>
    extends CollectElements<T> {
        private final AtomicInteger myCount;
        private volatile boolean myOverflow;
        private final int myLimit;

        public CollectElementsWithLimit(int limit) {
            this.myCount = new AtomicInteger(0);
            this.myOverflow = false;
            this.myLimit = limit;
        }

        public CollectElementsWithLimit(int limit, @NotNull Collection<T> collection) {
            if (collection == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/PsiElementProcessor$CollectElementsWithLimit.<init> must not be null");
            }
            super(collection);
            this.myCount = new AtomicInteger(0);
            this.myOverflow = false;
            this.myLimit = limit;
        }

        @Override
        public boolean execute(@NotNull T element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/PsiElementProcessor$CollectElementsWithLimit.execute must not be null");
            }
            if (this.myCount.get() == this.myLimit) {
                this.myOverflow = true;
                return false;
            }
            this.myCount.incrementAndGet();
            return super.execute(element);
        }

        public boolean isOverflow() {
            return this.myOverflow;
        }
    }

    public static class CollectFilteredElements<T extends PsiElement>
    extends CollectElements<T> {
        private final PsiElementFilter myFilter;

        public CollectFilteredElements(@NotNull PsiElementFilter filter, @NotNull Collection<T> collection) {
            if (filter == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/PsiElementProcessor$CollectFilteredElements.<init> must not be null");
            }
            if (collection == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/PsiElementProcessor$CollectFilteredElements.<init> must not be null");
            }
            super(collection);
            this.myFilter = filter;
        }

        public CollectFilteredElements(@NotNull PsiElementFilter filter) {
            if (filter == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/PsiElementProcessor$CollectFilteredElements.<init> must not be null");
            }
            this.myFilter = filter;
        }

        @Override
        public boolean execute(@NotNull T element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/PsiElementProcessor$CollectFilteredElements.execute must not be null");
            }
            return !this.myFilter.isAccepted((PsiElement)element) || super.execute(element);
        }
    }

    public static class CollectElements<T extends PsiElement>
    implements PsiElementProcessor<T> {
        private final Collection<T> myCollection;

        public CollectElements() {
            this(new ArrayList());
        }

        public CollectElements(@NotNull Collection<T> collection) {
            if (collection == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/PsiElementProcessor$CollectElements.<init> must not be null");
            }
            this.myCollection = Collections.synchronizedCollection(collection);
        }

        @NotNull
        public PsiElement[] toArray() {
            PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(this.myCollection);
            if (psiElementArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/search/PsiElementProcessor$CollectElements.toArray must not return null");
            }
            return psiElementArray;
        }

        @NotNull
        public Collection<T> getCollection() {
            Collection<T> collection = this.myCollection;
            if (collection == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/search/PsiElementProcessor$CollectElements.getCollection must not return null");
            }
            return collection;
        }

        @NotNull
        public T[] toArray(T[] array) {
            PsiElement[] psiElementArray = (PsiElement[])this.myCollection.toArray(array);
            if (psiElementArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/search/PsiElementProcessor$CollectElements.toArray must not return null");
            }
            return psiElementArray;
        }

        @Override
        public boolean execute(@NotNull T element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/PsiElementProcessor$CollectElements.execute must not be null");
            }
            this.myCollection.add(element);
            return true;
        }
    }
}

