/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectAwareFileFilter;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GlobalSearchScope
extends SearchScope
implements ProjectAwareFileFilter {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.search.GlobalSearchScope");
    @Nullable
    private final Project myProject;
    public static final GlobalSearchScope EMPTY_SCOPE = new EmptyScope();

    protected GlobalSearchScope(Project project) {
        this.myProject = project;
    }

    protected GlobalSearchScope() {
        this(null);
    }

    public abstract boolean contains(VirtualFile var1);

    @Override
    public Project getProject() {
        return this.myProject;
    }

    public abstract int compare(VirtualFile var1, VirtualFile var2);

    public abstract boolean isSearchInModuleContent(@NotNull Module var1);

    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        if (aModule == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.isSearchInModuleContent must not be null");
        }
        return this.isSearchInModuleContent(aModule);
    }

    @Override
    public final boolean accept(VirtualFile file) {
        return this.contains(file);
    }

    public abstract boolean isSearchInLibraries();

    public boolean isForceSearchingInLibrarySources() {
        return false;
    }

    public boolean isSearchOutsideRootModel() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        GlobalSearchScope globalSearchScope;
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.intersectWith must not be null");
        }
        if (scope == this) {
            globalSearchScope = this;
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.intersectWith must not return null");
            return globalSearchScope;
        }
        if (scope instanceof IntersectionScope) {
            globalSearchScope = scope.intersectWith(this);
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.intersectWith must not return null");
            return globalSearchScope;
        }
        globalSearchScope = new IntersectionScope(this, scope, null);
        if (globalSearchScope != null) return globalSearchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.intersectWith must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public SearchScope intersectWith(@NotNull SearchScope scope2) {
        SearchScope searchScope;
        if (scope2 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.intersectWith must not be null");
        }
        if (scope2 instanceof LocalSearchScope) {
            LocalSearchScope localScope2 = (LocalSearchScope)scope2;
            searchScope = this.intersectWith(localScope2);
            if (searchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.intersectWith must not return null");
            return searchScope;
        }
        searchScope = this.intersectWith((GlobalSearchScope)scope2);
        if (searchScope != null) return searchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.intersectWith must not return null");
    }

    @NotNull
    public SearchScope intersectWith(@NotNull LocalSearchScope localScope2) {
        if (localScope2 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.intersectWith must not be null");
        }
        PsiElement[] elements2 = localScope2.getScope();
        ArrayList<PsiElement> result = new ArrayList<PsiElement>(elements2.length);
        for (PsiElement element2 : elements2) {
            if (!PsiSearchScopeUtil.isInScope(this, element2)) continue;
            result.add(element2);
        }
        SearchScope searchScope = result.isEmpty() ? EMPTY_SCOPE : new LocalSearchScope(result.toArray(new PsiElement[result.size()]), null, localScope2.isIgnoreInjectedPsi());
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.intersectWith must not return null");
        }
        return searchScope;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public GlobalSearchScope union(@NotNull SearchScope scope) {
        GlobalSearchScope globalSearchScope;
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.union must not be null");
        }
        if (scope instanceof GlobalSearchScope) {
            globalSearchScope = this.uniteWith((GlobalSearchScope)scope);
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.union must not return null");
            return globalSearchScope;
        }
        globalSearchScope = this.union((LocalSearchScope)scope);
        if (globalSearchScope != null) return globalSearchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.union must not return null");
    }

    @NotNull
    public GlobalSearchScope union(final @NotNull LocalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.union must not be null");
        }
        GlobalSearchScope globalSearchScope = new GlobalSearchScope(scope.getScope()[0].getProject()){

            @Override
            public boolean contains(VirtualFile file) {
                return GlobalSearchScope.this.contains(file) || scope.isInScope(file);
            }

            @Override
            public int compare(VirtualFile file1, VirtualFile file2) {
                return GlobalSearchScope.this.contains(file1) && GlobalSearchScope.this.contains(file2) ? GlobalSearchScope.this.compare(file1, file2) : 0;
            }

            @Override
            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$1.isSearchInModuleContent must not be null");
                }
                return GlobalSearchScope.this.isSearchInModuleContent(aModule);
            }

            @Override
            public boolean isSearchOutsideRootModel() {
                return GlobalSearchScope.this.isSearchOutsideRootModel();
            }

            @Override
            public boolean isSearchInLibraries() {
                return GlobalSearchScope.this.isSearchInLibraries();
            }

            @NonNls
            public String toString() {
                return "UnionToLocal: (" + GlobalSearchScope.this.toString() + ", " + scope + ")";
            }
        };
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.union must not return null");
        }
        return globalSearchScope;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        GlobalSearchScope globalSearchScope;
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.uniteWith must not be null");
        }
        if (scope == this) {
            globalSearchScope = scope;
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.uniteWith must not return null");
            return globalSearchScope;
        }
        globalSearchScope = new UnionScope(this, scope, null);
        if (globalSearchScope != null) return globalSearchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.uniteWith must not return null");
    }

    @NotNull
    public static GlobalSearchScope allScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.allScope must not be null");
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getAllScope(project);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.allScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope projectScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.projectScope must not be null");
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getProjectScope(project);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.projectScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope notScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.notScope must not be null");
        }
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(scope){

            @Override
            public boolean contains(VirtualFile file) {
                return !this.myBaseScope.contains(file);
            }

            @Override
            public boolean isSearchOutsideRootModel() {
                return true;
            }
        };
        if (delegatingGlobalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.notScope must not return null");
        }
        return delegatingGlobalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleScope must not be null");
        }
        GlobalSearchScope globalSearchScope = module.getModuleScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.moduleScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleWithLibrariesScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleWithLibrariesScope must not be null");
        }
        GlobalSearchScope globalSearchScope = module.getModuleWithLibrariesScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.moduleWithLibrariesScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleWithDependenciesScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleWithDependenciesScope must not be null");
        }
        GlobalSearchScope globalSearchScope = module.getModuleWithDependenciesScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.moduleWithDependenciesScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleRuntimeScope(@NotNull Module module, boolean includeTests) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleRuntimeScope must not be null");
        }
        GlobalSearchScope globalSearchScope = module.getModuleRuntimeScope(includeTests);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.moduleRuntimeScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleWithDependenciesAndLibrariesScope must not be null");
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module, true);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.moduleWithDependenciesAndLibrariesScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(@NotNull Module module, boolean includeTests) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleWithDependenciesAndLibrariesScope must not be null");
        }
        GlobalSearchScope globalSearchScope = module.getModuleWithDependenciesAndLibrariesScope(includeTests);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.moduleWithDependenciesAndLibrariesScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleWithDependentsScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleWithDependentsScope must not be null");
        }
        GlobalSearchScope globalSearchScope = module.getModuleWithDependentsScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.moduleWithDependentsScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope moduleTestsWithDependentsScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.moduleTestsWithDependentsScope must not be null");
        }
        GlobalSearchScope globalSearchScope = module.getModuleTestsWithDependentsScope();
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.moduleTestsWithDependentsScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope fileScope(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.fileScope must not be null");
        }
        FileScope fileScope = new FileScope(psiFile.getProject(), psiFile.getVirtualFile());
        if (fileScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.fileScope must not return null");
        }
        return fileScope;
    }

    @NotNull
    public static GlobalSearchScope fileScope(@NotNull Project project, VirtualFile virtualFile) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.fileScope must not be null");
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope(project, virtualFile, null);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.fileScope must not return null");
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope fileScope(@NotNull Project project, VirtualFile virtualFile, final @Nullable String displayName) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.fileScope must not be null");
        }
        FileScope fileScope = new FileScope(project, virtualFile){

            @Override
            public String getDisplayName() {
                return displayName == null ? super.getDisplayName() : displayName;
            }
        };
        if (fileScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.fileScope must not return null");
        }
        return fileScope;
    }

    @NotNull
    public static GlobalSearchScope filesScope(@NotNull Project project, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.filesScope must not be null");
        }
        if (files == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.filesScope must not be null");
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope(project, files, null);
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.filesScope must not return null");
        }
        return globalSearchScope;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static GlobalSearchScope filesScope(@NotNull Project project, @NotNull Collection<VirtualFile> files, final @Nullable String displayName) {
        GlobalSearchScope globalSearchScope;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.filesScope must not be null");
        }
        if (files == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.filesScope must not be null");
        }
        if (files.isEmpty()) {
            globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.filesScope must not return null");
            return globalSearchScope;
        }
        globalSearchScope = files.size() == 1 ? GlobalSearchScope.fileScope(project, files.iterator().next(), displayName) : new FilesScope(project, files){

            @Override
            public String getDisplayName() {
                return displayName == null ? super.getDisplayName() : displayName;
            }
        };
        if (globalSearchScope != null) return globalSearchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.filesScope must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static GlobalSearchScope getScopeRestrictedByFileTypes(@NotNull GlobalSearchScope scope, FileType ... fileTypes) {
        GlobalSearchScope globalSearchScope;
        if (scope == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope.getScopeRestrictedByFileTypes must not be null");
        }
        if (scope == EMPTY_SCOPE) {
            globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.getScopeRestrictedByFileTypes must not return null");
            return globalSearchScope;
        }
        LOG.assertTrue(fileTypes.length > 0);
        globalSearchScope = new FileTypeRestrictionScope(scope, fileTypes);
        if (globalSearchScope != null) return globalSearchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope.getScopeRestrictedByFileTypes must not return null");
    }

    public static class FilesScope
    extends GlobalSearchScope {
        private final Collection<VirtualFile> myFiles;

        public FilesScope(Project project, Collection<VirtualFile> files) {
            super(project);
            this.myFiles = files;
        }

        @Override
        public boolean contains(VirtualFile file) {
            return this.myFiles.contains(file);
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$FilesScope.isSearchInModuleContent must not be null");
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof FilesScope && ((Object)this.myFiles).equals(((FilesScope)o).myFiles);
        }

        @Override
        public int hashCode() {
            return ((Object)this.myFiles).hashCode();
        }
    }

    private static class FileScope
    extends GlobalSearchScope {
        private final VirtualFile myVirtualFile;
        private final Module myModule;

        private FileScope(@NotNull Project project, VirtualFile virtualFile) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$FileScope.<init> must not be null");
            }
            super(project);
            this.myVirtualFile = virtualFile;
            FileIndexFacade fileIndex = ServiceManager.getService(project, FileIndexFacade.class);
            this.myModule = this.myVirtualFile != null ? fileIndex.getModuleForFile(this.myVirtualFile) : null;
        }

        @Override
        public boolean contains(VirtualFile file) {
            return Comparing.equal(this.myVirtualFile, file);
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$FileScope.isSearchInModuleContent must not be null");
            }
            return aModule == this.myModule;
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myModule == null;
        }
    }

    private static class EmptyScope
    extends GlobalSearchScope {
        private EmptyScope() {
        }

        @Override
        public boolean contains(VirtualFile file) {
            return false;
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$EmptyScope.isSearchInModuleContent must not be null");
            }
            return false;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$EmptyScope.intersectWith must not be null");
            }
            EmptyScope emptyScope = this;
            if (emptyScope == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope$EmptyScope.intersectWith must not return null");
            }
            return emptyScope;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$EmptyScope.uniteWith must not be null");
            }
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope$EmptyScope.uniteWith must not return null");
            }
            return globalSearchScope;
        }
    }

    private static class FileTypeRestrictionScope
    extends DelegatingGlobalSearchScope {
        private final FileType[] myFileTypes;

        private FileTypeRestrictionScope(@NotNull GlobalSearchScope scope, @NotNull FileType[] fileTypes) {
            if (scope == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope.<init> must not be null");
            }
            if (fileTypes == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope.<init> must not be null");
            }
            super(scope);
            this.myFileTypes = fileTypes;
        }

        @Override
        public boolean contains(VirtualFile file) {
            if (!super.contains(file)) {
                return false;
            }
            FileType fileType = file.getFileType();
            for (FileType otherFileType : this.myFileTypes) {
                if (!fileType.equals(otherFileType)) continue;
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            GlobalSearchScope globalSearchScope;
            if (scope == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope.intersectWith must not be null");
            }
            if (scope instanceof FileTypeRestrictionScope) {
                FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope;
                if (restrict.myBaseScope == this.myBaseScope) {
                    ArrayList<FileType> intersection = new ArrayList<FileType>(Arrays.asList(restrict.myFileTypes));
                    intersection.retainAll(Arrays.asList(this.myFileTypes));
                    globalSearchScope = new FileTypeRestrictionScope(this.myBaseScope, intersection.toArray(new FileType[intersection.size()]));
                    if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope.intersectWith must not return null");
                    return globalSearchScope;
                }
            }
            if ((globalSearchScope = super.intersectWith(scope)) != null) return globalSearchScope;
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope.intersectWith must not return null");
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            GlobalSearchScope globalSearchScope;
            if (scope == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope.uniteWith must not be null");
            }
            if (scope instanceof FileTypeRestrictionScope) {
                FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope;
                if (restrict.myBaseScope == this.myBaseScope) {
                    globalSearchScope = new FileTypeRestrictionScope(this.myBaseScope, ArrayUtil.mergeArrays(this.myFileTypes, restrict.myFileTypes));
                    if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope.uniteWith must not return null");
                    return globalSearchScope;
                }
            }
            if ((globalSearchScope = super.uniteWith(scope)) != null) return globalSearchScope;
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope.uniteWith must not return null");
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileTypeRestrictionScope)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FileTypeRestrictionScope that = (FileTypeRestrictionScope)o;
            return Arrays.equals(this.myFileTypes, that.myFileTypes);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + Arrays.hashCode(this.myFileTypes);
            return result;
        }
    }

    private static class UnionScope
    extends GlobalSearchScope {
        private final GlobalSearchScope myScope1;
        private final GlobalSearchScope myScope2;
        private final String myDisplayName;

        private UnionScope(@NotNull GlobalSearchScope scope1, @NotNull GlobalSearchScope scope2, String displayName) {
            if (scope1 == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$UnionScope.<init> must not be null");
            }
            if (scope2 == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$UnionScope.<init> must not be null");
            }
            super(scope1.getProject() == null ? scope2.getProject() : scope1.getProject());
            this.myScope1 = scope1;
            this.myScope2 = scope2;
            this.myDisplayName = displayName;
        }

        @Override
        public String getDisplayName() {
            if (this.myDisplayName == null) {
                return PsiBundle.message("psi.search.scope.union", this.myScope1.getDisplayName(), this.myScope2.getDisplayName());
            }
            return this.myDisplayName;
        }

        @Override
        public boolean contains(VirtualFile file) {
            return this.myScope1.contains(file) || this.myScope2.contains(file);
        }

        @Override
        public boolean isSearchOutsideRootModel() {
            return this.myScope1.isSearchOutsideRootModel() || this.myScope2.isSearchOutsideRootModel();
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            int res2;
            int res1 = this.myScope1.contains(file1) && this.myScope1.contains(file2) ? this.myScope1.compare(file1, file2) : 0;
            int n = res2 = this.myScope2.contains(file1) && this.myScope2.contains(file2) ? this.myScope2.compare(file1, file2) : 0;
            if (res1 == 0) {
                return res2;
            }
            if (res2 == 0) {
                return res1;
            }
            if ((res1 /= Math.abs(res1)) == (res2 /= Math.abs(res2))) {
                return res1;
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$UnionScope.isSearchInModuleContent must not be null");
            }
            return this.myScope1.isSearchInModuleContent(aModule) || this.myScope2.isSearchInModuleContent(aModule);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$UnionScope.isSearchInModuleContent must not be null");
            }
            return this.myScope1.isSearchInModuleContent(aModule, testSources) || this.myScope2.isSearchInModuleContent(aModule, testSources);
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myScope1.isSearchInLibraries() || this.myScope2.isSearchInLibraries();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnionScope)) {
                return false;
            }
            UnionScope that = (UnionScope)o;
            return this.myScope1.equals(that.myScope1) && this.myScope2.equals(that.myScope2);
        }

        @Override
        public int hashCode() {
            return 31 * this.myScope1.hashCode() + this.myScope2.hashCode();
        }

        @NonNls
        public String toString() {
            return "Union: (" + this.myScope1 + ", " + this.myScope2 + ")";
        }
    }

    static class IntersectionScope
    extends GlobalSearchScope {
        private final GlobalSearchScope myScope1;
        private final GlobalSearchScope myScope2;
        private final String myDisplayName;

        IntersectionScope(@NotNull GlobalSearchScope scope1, @NotNull GlobalSearchScope scope2, String displayName) {
            if (scope1 == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$IntersectionScope.<init> must not be null");
            }
            if (scope2 == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$IntersectionScope.<init> must not be null");
            }
            super(scope1.getProject() == null ? scope2.getProject() : scope1.getProject());
            this.myScope1 = scope1;
            this.myScope2 = scope2;
            this.myDisplayName = displayName;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            IntersectionScope intersectionScope;
            if (scope == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$IntersectionScope.intersectWith must not be null");
            }
            if (this.myScope1.equals(scope) || this.myScope2.equals(scope)) {
                intersectionScope = this;
                if (intersectionScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope$IntersectionScope.intersectWith must not return null");
                return intersectionScope;
            }
            intersectionScope = new IntersectionScope(this, scope, null);
            if (intersectionScope != null) return intersectionScope;
            throw new IllegalStateException("@NotNull method com/intellij/psi/search/GlobalSearchScope$IntersectionScope.intersectWith must not return null");
        }

        @Override
        public String getDisplayName() {
            if (this.myDisplayName == null) {
                return PsiBundle.message("psi.search.scope.intersection", this.myScope1.getDisplayName(), this.myScope2.getDisplayName());
            }
            return this.myDisplayName;
        }

        @Override
        public boolean contains(VirtualFile file) {
            return this.myScope1.contains(file) && this.myScope2.contains(file);
        }

        @Override
        public int compare(VirtualFile file1, VirtualFile file2) {
            int res1 = this.myScope1.compare(file1, file2);
            int res2 = this.myScope2.compare(file1, file2);
            if (res1 == 0) {
                return res2;
            }
            if (res2 == 0) {
                return res1;
            }
            if ((res1 /= Math.abs(res1)) == (res2 /= Math.abs(res2))) {
                return res1;
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$IntersectionScope.isSearchInModuleContent must not be null");
            }
            return this.myScope1.isSearchInModuleContent(aModule) && this.myScope2.isSearchInModuleContent(aModule);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/GlobalSearchScope$IntersectionScope.isSearchInModuleContent must not be null");
            }
            return this.myScope1.isSearchInModuleContent(aModule, testSources) && this.myScope2.isSearchInModuleContent(aModule, testSources);
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myScope1.isSearchInLibraries() && this.myScope2.isSearchInLibraries();
        }

        @Override
        public boolean isSearchOutsideRootModel() {
            return this.myScope1.isSearchOutsideRootModel() && this.myScope2.isSearchOutsideRootModel();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IntersectionScope)) {
                return false;
            }
            IntersectionScope that = (IntersectionScope)o;
            return this.myScope1.equals(that.myScope1) && this.myScope2.equals(that.myScope2);
        }

        @Override
        public int hashCode() {
            return 31 * this.myScope1.hashCode() + this.myScope2.hashCode();
        }

        @NonNls
        public String toString() {
            return "Intersection: (" + this.myScope1 + ", " + this.myScope2 + ")";
        }
    }
}

