/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.LighterLazyParseableNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightTreeUtil {
    private LightTreeUtil() {
    }

    @Nullable
    public static LighterASTNode firstChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull IElementType type) {
        if (tree == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LightTreeUtil.firstChildOfType must not be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/LightTreeUtil.firstChildOfType must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/tree/LightTreeUtil.firstChildOfType must not be null");
        }
        List<LighterASTNode> children = tree.getChildren(node);
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            LighterASTNode child = children.get(i);
            if (child.getTokenType() != type) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public static LighterASTNode firstChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull TokenSet types) {
        if (tree == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LightTreeUtil.firstChildOfType must not be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/LightTreeUtil.firstChildOfType must not be null");
        }
        if (types == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/tree/LightTreeUtil.firstChildOfType must not be null");
        }
        List<LighterASTNode> children = tree.getChildren(node);
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            LighterASTNode child = children.get(i);
            if (!types.contains(child.getTokenType())) continue;
            return child;
        }
        return null;
    }

    @NotNull
    public static LighterASTNode requiredChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull IElementType type) {
        if (tree == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LightTreeUtil.requiredChildOfType must not be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/LightTreeUtil.requiredChildOfType must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/tree/LightTreeUtil.requiredChildOfType must not be null");
        }
        LighterASTNode child = LightTreeUtil.firstChildOfType(tree, node, type);
        assert (child != null) : "Required child " + type + " not found in " + node.getTokenType() + ": " + tree.getChildren(node);
        LighterASTNode lighterASTNode = child;
        if (lighterASTNode == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LightTreeUtil.requiredChildOfType must not return null");
        }
        return lighterASTNode;
    }

    @NotNull
    public static LighterASTNode requiredChildOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull TokenSet types) {
        if (tree == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LightTreeUtil.requiredChildOfType must not be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/LightTreeUtil.requiredChildOfType must not be null");
        }
        if (types == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/tree/LightTreeUtil.requiredChildOfType must not be null");
        }
        LighterASTNode child = LightTreeUtil.firstChildOfType(tree, node, types);
        assert (child != null) : "Required child " + types + " not found in " + node.getTokenType() + ": " + tree.getChildren(node);
        LighterASTNode lighterASTNode = child;
        if (lighterASTNode == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LightTreeUtil.requiredChildOfType must not return null");
        }
        return lighterASTNode;
    }

    @NotNull
    public static List<LighterASTNode> getChildrenOfType(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull IElementType type) {
        if (tree == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LightTreeUtil.getChildrenOfType must not be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/LightTreeUtil.getChildrenOfType must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/tree/LightTreeUtil.getChildrenOfType must not be null");
        }
        List<LighterASTNode> result = null;
        List<LighterASTNode> children = tree.getChildren(node);
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            LighterASTNode child = children.get(i);
            if (child.getTokenType() != type) continue;
            if (result == null) {
                result = new SmartList<LighterASTNode>();
            }
            result.add(child);
        }
        List<LighterASTNode> list = result != null ? result : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LightTreeUtil.getChildrenOfType must not return null");
        }
        return list;
    }

    @NotNull
    public static String toFilteredString(@NotNull LighterAST tree, @NotNull LighterASTNode node, @Nullable TokenSet skipTypes) {
        if (tree == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LightTreeUtil.toFilteredString must not be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/LightTreeUtil.toFilteredString must not be null");
        }
        StringBuilder buffer = new StringBuilder(node.getEndOffset() - node.getStartOffset());
        LightTreeUtil.toBuffer(tree, node, buffer, skipTypes);
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LightTreeUtil.toFilteredString must not return null");
        }
        return string;
    }

    public static void toBuffer(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StringBuilder buffer, @Nullable TokenSet skipTypes) {
        if (tree == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LightTreeUtil.toBuffer must not be null");
        }
        if (node == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/LightTreeUtil.toBuffer must not be null");
        }
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/tree/LightTreeUtil.toBuffer must not be null");
        }
        if (skipTypes != null && skipTypes.contains(node.getTokenType())) {
            return;
        }
        if (node instanceof LighterASTTokenNode) {
            buffer.append(((LighterASTTokenNode)node).getText());
            return;
        }
        if (node instanceof LighterLazyParseableNode) {
            buffer.append(((LighterLazyParseableNode)node).getText());
            return;
        }
        List<LighterASTNode> children = tree.getChildren(node);
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            LightTreeUtil.toBuffer(tree, children.get(i), buffer, skipTypes);
        }
    }
}

