/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.text;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentBulkUpdateListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.impl.source.tree.ASTShallowComparator;
import com.intellij.psi.impl.source.tree.ASTStructure;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.ITemplateDataElementType;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IReparseableElementType;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.diff.DiffTree;
import com.intellij.util.diff.DiffTreeChangeBuilder;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.diff.ShallowNodeComparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockSupportImpl
extends BlockSupport {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.text.BlockSupportImpl");

    public BlockSupportImpl(Project project) {
        project.getMessageBus().connect().subscribe(DocumentBulkUpdateListener.TOPIC, new DocumentBulkUpdateListener.Adapter(){

            @Override
            public void updateStarted(@NotNull Document doc) {
                if (doc == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl$1.updateStarted must not be null");
                }
                doc.putUserData(BlockSupport.DO_NOT_REPARSE_INCREMENTALLY, Boolean.TRUE);
            }
        });
    }

    @Override
    public void reparseRange(PsiFile file, int startOffset, int endOffset, CharSequence newTextS) throws IncorrectOperationException {
        LOG.assertTrue(file.isValid());
        PsiFileImpl psiFile = (PsiFileImpl)file;
        Document document = psiFile.getViewProvider().getDocument();
        assert (document != null);
        document.replaceString(startOffset, endOffset, newTextS);
        PsiDocumentManager.getInstance(psiFile.getProject()).commitDocument(document);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public DiffLog reparseRange(@NotNull PsiFile file, TextRange changedPsiRange, @NotNull CharSequence newFileText, @NotNull ProgressIndicator indicator) {
        ASTNode node;
        DiffLog diffLog;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.reparseRange must not be null");
        }
        if (newFileText == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.reparseRange must not be null");
        }
        if (indicator == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.reparseRange must not be null");
        }
        PsiFileImpl fileImpl = (PsiFileImpl)file;
        Project project = fileImpl.getProject();
        FileElement treeFileElement = fileImpl.getTreeElement();
        CharTable charTable = treeFileElement.getCharTable();
        int textLength = newFileText.length();
        int lengthShift = textLength - treeFileElement.getTextLength();
        if (treeFileElement.getElementType() instanceof ITemplateDataElementType || BlockSupportImpl.isTooDeep(file)) {
            diffLog = BlockSupportImpl.makeFullParse(treeFileElement, newFileText, textLength, fileImpl, indicator);
            if (diffLog == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/text/BlockSupportImpl.reparseRange must not return null");
            return diffLog;
        }
        LeafElement leafAtStart = treeFileElement.findLeafElementAt(Math.max(0, changedPsiRange.getStartOffset() - 1));
        LeafElement leafAtEnd = treeFileElement.findLeafElementAt(changedPsiRange.getEndOffset());
        Language baseLanguage = file.getViewProvider().getBaseLanguage();
        for (node = leafAtStart != null && leafAtEnd != null ? TreeUtil.findCommonParent(leafAtStart, leafAtEnd) : treeFileElement; node != null && !(node instanceof FileElement); node = node.getTreeParent()) {
            ASTNode chameleon;
            IElementType elementType = node.getElementType();
            if (!(elementType instanceof IReparseableElementType)) continue;
            TextRange textRange = node.getTextRange();
            IReparseableElementType reparseable = (IReparseableElementType)elementType;
            if (!baseLanguage.isKindOf(reparseable.getLanguage())) continue;
            int start = textRange.getStartOffset();
            int end = start + textRange.getLength() + lengthShift;
            BlockSupportImpl.assertFileLength(file, newFileText, node, elementType, start, end);
            CharSequence newTextStr = newFileText.subSequence(start, end);
            if (!reparseable.isParsable(newTextStr, baseLanguage, project) || (chameleon = reparseable.createNode(newTextStr)) == null) continue;
            DummyHolder holder = DummyHolderFactory.createHolder(fileImpl.getManager(), null, node.getPsi(), charTable);
            holder.getTreeElement().rawAddChildren((TreeElement)chameleon);
            if (holder.getTextLength() != newTextStr.length()) {
                String details = ApplicationManager.getApplication().isInternal() ? "text=" + newTextStr + "; treeText=" + holder.getText() + ";" : "";
                LOG.error("Inconsistent reparse: " + details + " type=" + elementType);
            }
            if ((diffLog = BlockSupportImpl.mergeTrees(fileImpl, node, chameleon, indicator)) == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/text/BlockSupportImpl.reparseRange must not return null");
            return diffLog;
        }
        diffLog = BlockSupportImpl.makeFullParse(node, newFileText, textLength, fileImpl, indicator);
        if (diffLog != null) return diffLog;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/text/BlockSupportImpl.reparseRange must not return null");
    }

    private static void assertFileLength(PsiFile file, CharSequence newFileText, ASTNode node, IElementType elementType, int start, int end) {
        if (end > newFileText.length() && ApplicationManager.getApplication().isInternal()) {
            String newTextBefore = ((Object)newFileText.subSequence(0, start)).toString();
            String oldTextBefore = ((Object)file.getText().subSequence(0, start)).toString();
            String message = "IOOBE: type=" + elementType + "; oldText=" + node.getText() + "; newText=" + newFileText.subSequence(start, newFileText.length()) + "; length=" + node.getTextLength();
            message = oldTextBefore.equals(newTextBefore) ? message + "; oldTextBefore==newTextBefore" : message + "; oldTextBefore=" + oldTextBefore + "; newTextBefore=" + newTextBefore;
            throw new AssertionError((Object)message);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static DiffLog makeFullParse(ASTNode parent, @NotNull CharSequence newFileText, int textLength, @NotNull PsiFileImpl fileImpl, @NotNull ProgressIndicator indicator) {
        DiffLog diffLog;
        if (newFileText == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.makeFullParse must not be null");
        }
        if (fileImpl == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.makeFullParse must not be null");
        }
        if (indicator == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.makeFullParse must not be null");
        }
        if (fileImpl instanceof PsiCodeFragment) {
            FileElement holderElement = new DummyHolder(fileImpl.getManager(), null).getTreeElement();
            holderElement.rawAddChildren(fileImpl.createContentLeafElement(holderElement.getCharTable().intern(newFileText, 0, textLength)));
            DiffLog diffLog2 = new DiffLog();
            diffLog2.appendReplaceFileElement((FileElement)parent, (FileElement)holderElement.getFirstChildNode());
            diffLog = diffLog2;
            if (diffLog == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/text/BlockSupportImpl.makeFullParse must not return null");
            return diffLog;
        }
        FileViewProvider viewProvider = fileImpl.getViewProvider();
        viewProvider.getLanguages();
        FileType fileType = viewProvider.getVirtualFile().getFileType();
        String fileName = fileImpl.getName();
        LightVirtualFile lightFile = new LightVirtualFile(fileName, fileType, newFileText, viewProvider.getVirtualFile().getCharset(), fileImpl.getViewProvider().getModificationStamp());
        lightFile.setOriginalFile(viewProvider.getVirtualFile());
        FileViewProvider copy = viewProvider.createCopy(lightFile);
        copy.getLanguages();
        SingleRootFileViewProvider.doNotCheckFileSizeLimit(lightFile);
        PsiFileImpl newFile = BlockSupportImpl.getFileCopy(fileImpl, copy);
        newFile.setOriginalFile(fileImpl);
        FileElement newFileElement = (FileElement)newFile.getNode();
        FileElement oldFileElement = (FileElement)fileImpl.getNode();
        assert (oldFileElement != null && newFileElement != null);
        DiffLog diffLog3 = BlockSupportImpl.mergeTrees(fileImpl, oldFileElement, newFileElement, indicator);
        ((PsiManagerEx)fileImpl.getManager()).getFileManager().setViewProvider(lightFile, null);
        diffLog = diffLog3;
        if (diffLog != null) return diffLog;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/text/BlockSupportImpl.makeFullParse must not return null");
    }

    @NotNull
    public static PsiFileImpl getFileCopy(PsiFileImpl originalFile, FileViewProvider providerCopy) {
        FileViewProvider viewProvider = originalFile.getViewProvider();
        Language language = originalFile.getLanguage();
        PsiFileImpl newFile = (PsiFileImpl)providerCopy.getPsi(language);
        if (newFile == null && language == PlainTextLanguage.INSTANCE && originalFile == viewProvider.getPsi(viewProvider.getBaseLanguage())) {
            newFile = (PsiFileImpl)providerCopy.getPsi(providerCopy.getBaseLanguage());
        }
        if (newFile == null) {
            throw new RuntimeException("View provider " + viewProvider + " refused to parse text with " + language + "; languages: " + viewProvider.getLanguages() + "; base: " + viewProvider.getBaseLanguage() + "; copy: " + providerCopy + "; copy.base: " + providerCopy.getBaseLanguage() + "; vFile: " + viewProvider.getVirtualFile() + "; copy.vFile: " + providerCopy.getVirtualFile() + "; fileType: " + viewProvider.getVirtualFile().getFileType() + "; copy.original(): " + (providerCopy.getVirtualFile() instanceof LightVirtualFile ? ((LightVirtualFile)providerCopy.getVirtualFile()).getOriginalFile() : null));
        }
        PsiFileImpl psiFileImpl = newFile;
        if (psiFileImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/text/BlockSupportImpl.getFileCopy must not return null");
        }
        return psiFileImpl;
    }

    @NotNull
    private static DiffLog replaceElementWithEvents(CompositeElement oldRoot, CompositeElement newRoot) {
        DiffLog diffLog = new DiffLog();
        diffLog.appendReplaceElementWithEvents(oldRoot, newRoot);
        DiffLog diffLog2 = diffLog;
        if (diffLog2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/text/BlockSupportImpl.replaceElementWithEvents must not return null");
        }
        return diffLog2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static DiffLog mergeTrees(@NotNull PsiFileImpl fileImpl, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot, @NotNull ProgressIndicator indicator) {
        DiffLog diffLog;
        block18: {
            DiffLog diffLog2;
            block17: {
                if (fileImpl == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.mergeTrees must not be null");
                }
                if (oldRoot == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.mergeTrees must not be null");
                }
                if (newRoot == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.mergeTrees must not be null");
                }
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.mergeTrees must not be null");
                }
                if (newRoot instanceof FileElement) {
                    ((FileElement)newRoot).setCharTable(fileImpl.getTreeElement().getCharTable());
                }
                try {
                    newRoot.putUserData(TREE_TO_BE_REPARSED, oldRoot);
                    if (BlockSupportImpl.isReplaceWholeNode(fileImpl, newRoot)) {
                        DiffLog treeChangeEvent = BlockSupportImpl.replaceElementWithEvents((CompositeElement)oldRoot, (CompositeElement)newRoot);
                        fileImpl.putUserData(TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
                        DiffLog diffLog3 = treeChangeEvent;
                        diffLog2 = diffLog3;
                        break block17;
                    }
                    newRoot.getFirstChildNode();
                    break block18;
                }
                catch (BlockSupport.ReparsedSuccessfullyException e) {
                    DiffLog diffLog4 = e.getDiffLog();
                    diffLog = diffLog4;
                    if (diffLog == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/text/BlockSupportImpl.mergeTrees must not return null");
                    return diffLog;
                }
            }
            diffLog = diffLog2;
            if (diffLog2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/text/BlockSupportImpl.mergeTrees must not return null");
            return diffLog;
            finally {
                newRoot.putUserData(TREE_TO_BE_REPARSED, null);
            }
        }
        ASTShallowComparator comparator = new ASTShallowComparator(indicator);
        ASTStructure treeStructure = BlockSupportImpl.createInterruptibleASTStructure(newRoot, indicator);
        DiffLog diffLog5 = new DiffLog();
        BlockSupportImpl.diffTrees(oldRoot, diffLog5, comparator, treeStructure, indicator);
        diffLog = diffLog5;
        if (diffLog != null) return diffLog;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/text/BlockSupportImpl.mergeTrees must not return null");
    }

    public static <T> void diffTrees(@NotNull ASTNode oldRoot, @NotNull DiffTreeChangeBuilder<ASTNode, T> builder, @NotNull ShallowNodeComparator<ASTNode, T> comparator, @NotNull FlyweightCapableTreeStructure<T> newTreeStructure, ProgressIndicator indicator) {
        if (oldRoot == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.diffTrees must not be null");
        }
        if (builder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.diffTrees must not be null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.diffTrees must not be null");
        }
        if (newTreeStructure == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.diffTrees must not be null");
        }
        TreeUtil.ensureParsedRecursivelyCheckingProgress(oldRoot, indicator);
        DiffTree.diff(BlockSupportImpl.createInterruptibleASTStructure(oldRoot, indicator), newTreeStructure, comparator, builder);
    }

    private static ASTStructure createInterruptibleASTStructure(@NotNull ASTNode oldRoot, final @Nullable ProgressIndicator indicator) {
        if (oldRoot == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.createInterruptibleASTStructure must not be null");
        }
        return new ASTStructure(oldRoot){

            @Override
            public int getChildren(@NotNull ASTNode astNode, @NotNull Ref<ASTNode[]> into) {
                if (astNode == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl$2.getChildren must not be null");
                }
                if (into == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl$2.getChildren must not be null");
                }
                if (indicator != null) {
                    indicator.checkCanceled();
                }
                return super.getChildren(astNode, into);
            }
        };
    }

    private static boolean isReplaceWholeNode(@NotNull PsiFileImpl fileImpl, @NotNull ASTNode newRoot) throws BlockSupport.ReparsedSuccessfullyException {
        boolean explicitlyMarkedDeep;
        if (fileImpl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.isReplaceWholeNode must not be null");
        }
        if (newRoot == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.isReplaceWholeNode must not be null");
        }
        Boolean data = (Boolean)fileImpl.getUserData(DO_NOT_REPARSE_INCREMENTALLY);
        if (data != null) {
            fileImpl.putUserData(DO_NOT_REPARSE_INCREMENTALLY, null);
        }
        if ((explicitlyMarkedDeep = Boolean.TRUE.equals(data)) || BlockSupportImpl.isTooDeep(fileImpl)) {
            return true;
        }
        ASTNode childNode = newRoot.getFirstChildNode();
        boolean childTooDeep = BlockSupportImpl.isTooDeep(childNode);
        if (childTooDeep) {
            childNode.putUserData(TREE_DEPTH_LIMIT_EXCEEDED, null);
            fileImpl.putUserData(TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
        }
        return childTooDeep;
    }

    public static void sendBeforeChildrenChangeEvent(@NotNull PsiManagerImpl manager, @NotNull PsiElement scope, boolean isGenericChange) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.sendBeforeChildrenChangeEvent must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.sendBeforeChildrenChangeEvent must not be null");
        }
        if (!scope.isPhysical()) {
            manager.beforeChange(false);
            return;
        }
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(manager);
        event.setParent(scope);
        event.setFile(scope.getContainingFile());
        event.setOffset(scope.getTextRange().getStartOffset());
        event.setOldLength(scope.getTextLength());
        event.setGeneric(isGenericChange);
        manager.beforeChildrenChange(event);
    }

    public static void sendAfterChildrenChangedEvent(@NotNull PsiManagerImpl manager, @NotNull PsiFileImpl scope, int oldLength, boolean isGenericChange) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.sendAfterChildrenChangedEvent must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/text/BlockSupportImpl.sendAfterChildrenChangedEvent must not be null");
        }
        if (!scope.isPhysical()) {
            manager.afterChange(false);
            return;
        }
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(manager);
        event.setParent(scope);
        event.setFile(scope);
        event.setOffset(0);
        event.setOldLength(oldLength);
        event.setGeneric(isGenericChange);
        manager.childrenChanged(event);
    }
}

