/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiParameterImpl
extends JavaStubPsiElement<PsiParameterStub>
implements PsiParameter {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiParameterImpl");
    private volatile SoftReference<PsiType> myCachedType;

    public PsiParameterImpl(@NotNull PsiParameterStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiParameterImpl.<init> must not be null");
        }
        this(stub, (IStubElementType)JavaStubElementTypes.PARAMETER);
    }

    protected PsiParameterImpl(@NotNull PsiParameterStub stub, @NotNull IStubElementType type) {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiParameterImpl.<init> must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/PsiParameterImpl.<init> must not be null");
        }
        super(stub, type);
        this.myCachedType = null;
    }

    public PsiParameterImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiParameterImpl.<init> must not be null");
        }
        super(node);
        this.myCachedType = null;
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedType = null;
    }

    @Override
    protected Object clone() {
        PsiParameterImpl clone = (PsiParameterImpl)super.clone();
        clone.myCachedType = null;
        return clone;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public final String getName() {
        String string;
        PsiParameterStub stub = (PsiParameterStub)this.getStub();
        if (stub != null) {
            string = stub.getName();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiParameterImpl.getName must not return null");
            return string;
        }
        string = this.getParameterIdentifier().getText();
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiParameterImpl.getName must not return null");
    }

    @Override
    public final PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiParameterImpl.setName must not be null");
        }
        if (this instanceof PsiReceiverParameter) {
            throw new IncorrectOperationException("Cannot rename receiver parameter");
        }
        PsiImplUtil.setName(this.getParameterIdentifier(), name);
        return this;
    }

    @Override
    public final PsiIdentifier getNameIdentifier() {
        return PsiTreeUtil.getChildOfType(this, PsiIdentifier.class);
    }

    @NotNull
    private PsiElement getParameterIdentifier() {
        PsiJavaToken identifier = (PsiJavaToken)PsiTreeUtil.getChildOfAnyType(this, PsiIdentifier.class, PsiKeyword.class);
        assert (identifier != null) : this;
        PsiJavaToken psiJavaToken = identifier;
        if (psiJavaToken == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiParameterImpl.getParameterIdentifier must not return null");
        }
        return psiJavaToken;
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiParameterImpl.getNode must not return null");
        }
        return compositeElement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType;
        PsiParameterStub stub = (PsiParameterStub)this.getStub();
        if (stub != null) {
            PsiType psiType2;
            PsiType type;
            SoftReference<PsiType> cachedType = this.myCachedType;
            if (cachedType != null && (type = (PsiType)cachedType.get()) != null) {
                PsiType psiType3 = type;
                psiType = psiType3;
                if (psiType3 != null) return psiType;
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiParameterImpl.getType must not return null");
            }
            String typeText = TypeInfo.createTypeText(stub.getType(true));
            assert (typeText != null) : stub;
            try {
                PsiType type2 = JavaPsiFacade.getInstance(this.getProject()).getParserFacade().createTypeFromText(typeText, this);
                this.myCachedType = new SoftReference<PsiType>(type2);
                psiType2 = type2;
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
                psiType = null;
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiParameterImpl.getType must not return null");
            }
            psiType = psiType2;
            if (psiType2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiParameterImpl.getType must not return null");
            return psiType;
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getTypeElement();
        if (typeElement != null) {
            PsiType psiType4 = JavaSharedImplUtil.getType(typeElement, this.getParameterIdentifier());
            psiType = psiType4;
            if (psiType4 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiParameterImpl.getType must not return null");
            return psiType;
        }
        assert (this.isLambdaParameter()) : this;
        PsiType psiType5 = LambdaUtil.getLambdaParameterType(this);
        psiType = psiType5;
        if (psiType5 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiParameterImpl.getType must not return null");
        return psiType;
    }

    @Override
    public PsiType getTypeNoResolve() {
        return this.getType();
    }

    private boolean isLambdaParameter() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiParameterList && parent.getParent() instanceof PsiLambdaExpression;
    }

    @Override
    public PsiTypeElement getTypeElement() {
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiTypeElement)) continue;
            return (PsiTypeElement)child;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList modifierList = this.getStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
        assert (modifierList != null) : this;
        PsiModifierList psiModifierList = modifierList;
        if (psiModifierList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiParameterImpl.getModifierList must not return null");
        }
        return psiModifierList;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiParameterImpl.hasModifierProperty must not be null");
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    public PsiExpression getInitializer() {
        return null;
    }

    @Override
    public boolean hasInitializer() {
        return false;
    }

    @Override
    public Object computeConstantValue() {
        return null;
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        JavaSharedImplUtil.normalizeBrackets(this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiParameterImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitParameter(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiParameter:" + this.getName();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiElement getDeclarationScope() {
        PsiElement psiElement;
        PsiElement parent = this.getParent();
        if (parent == null) {
            PsiParameterImpl psiParameterImpl = this;
            psiElement = psiParameterImpl;
            if (psiParameterImpl != null) return psiElement;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiParameterImpl.getDeclarationScope must not return null");
        }
        if (parent instanceof PsiParameterList) {
            PsiElement psiElement = parent.getParent();
            psiElement = psiElement;
            if (psiElement2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiParameterImpl.getDeclarationScope must not return null");
            return psiElement;
        }
        if (parent instanceof PsiForeachStatement) {
            PsiElement psiElement = parent;
            psiElement = psiElement;
            if (psiElement3 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiParameterImpl.getDeclarationScope must not return null");
            return psiElement;
        }
        if (parent instanceof PsiCatchSection) {
            PsiElement psiElement = parent;
            psiElement = psiElement;
            if (psiElement4 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiParameterImpl.getDeclarationScope must not return null");
            return psiElement;
        }
        PsiElement[] children = parent.getChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                if (!children[i].equals(this)) continue;
                for (int j = i + 1; j < children.length; ++j) {
                    if (!(children[j] instanceof PsiCodeBlock)) continue;
                    PsiElement psiElement = children[j];
                    psiElement = psiElement;
                    if (psiElement5 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiParameterImpl.getDeclarationScope must not return null");
                    return psiElement;
                }
            }
        }
        LOG.error("Code block not found among parameter' (" + this + ") parent' (" + parent + ") children: " + Arrays.asList(children));
        psiElement = null;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiParameterImpl.getDeclarationScope must not return null");
    }

    @Override
    public boolean isVarArgs() {
        PsiParameterStub stub = (PsiParameterStub)this.getStub();
        if (stub != null) {
            return stub.isParameterTypeEllipsis();
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getTypeElement();
        return typeElement != null && SourceTreeToPsiMap.psiToTreeNotNull(typeElement).findChildByType(JavaTokenType.ELLIPSIS) != null;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = PsiParameterImpl.createLayeredIcon(this, PlatformIcons.PARAMETER_ICON, 0);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        PsiElement declarationScope = this.getDeclarationScope();
        LocalSearchScope localSearchScope = new LocalSearchScope(declarationScope);
        if (localSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiParameterImpl.getUseScope must not return null");
        }
        return localSearchScope;
    }
}

