/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.impl.source.JavaLightStubBuilder;
import com.intellij.psi.impl.source.tree.java.JavaFileElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.LightStubBuilder;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JavaFileElementType
extends ILightStubFileElementType<PsiJavaFileStub> {
    public static final int STUB_VERSION = 17;

    public JavaFileElementType() {
        super("java.FILE", JavaLanguage.INSTANCE);
    }

    @Override
    public LightStubBuilder getBuilder() {
        return new JavaLightStubBuilder();
    }

    @Override
    public int getStubVersion() {
        return 17;
    }

    @Override
    public boolean shouldBuildStubFor(VirtualFile file) {
        VirtualFile dir = file.getParent();
        return dir == null || dir.getUserData(LanguageLevel.KEY) != null;
    }

    @Override
    public ASTNode createNode(CharSequence text) {
        return new JavaFileElement(text);
    }

    @Override
    public FlyweightCapableTreeStructure<LighterASTNode> parseContentsLight(ASTNode chameleon) {
        PsiBuilder builder = JavaParserUtil.createBuilder(chameleon);
        this.doParse(builder);
        return builder.getLightTree();
    }

    @Override
    public ASTNode parseContents(ASTNode chameleon) {
        PsiBuilder builder = JavaParserUtil.createBuilder(chameleon);
        this.doParse(builder);
        return builder.getTreeBuilt().getFirstChildNode();
    }

    private void doParse(PsiBuilder builder) {
        PsiBuilder.Marker root = builder.mark();
        JavaParser.INSTANCE.getFileParser().parse(builder);
        root.done(this);
    }

    @Override
    @NotNull
    public String getExternalId() {
        if ("java.FILE" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/JavaFileElementType.getExternalId must not return null");
        }
        return "java.FILE";
    }

    @Override
    public void serialize(@NotNull PsiJavaFileStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/JavaFileElementType.serialize must not be null");
        }
        if (dataStream == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/JavaFileElementType.serialize must not be null");
        }
        dataStream.writeBoolean(stub.isCompiled());
        dataStream.writeName(stub.getPackageName());
    }

    @Override
    @NotNull
    public PsiJavaFileStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/JavaFileElementType.deserialize must not be null");
        }
        boolean compiled = dataStream.readBoolean();
        StringRef packName = dataStream.readName();
        PsiJavaFileStubImpl psiJavaFileStubImpl = new PsiJavaFileStubImpl(null, packName, compiled);
        if (psiJavaFileStubImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/JavaFileElementType.deserialize must not return null");
        }
        return psiJavaFileStubImpl;
    }

    @Override
    public void indexStub(@NotNull PsiJavaFileStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/JavaFileElementType.indexStub must not be null");
        }
        if (sink == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/JavaFileElementType.indexStub must not be null");
        }
    }
}

