/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.psi.CommonClassNames;
import com.intellij.util.CharTable;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceHashingStrategy;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.StringFactory;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharTableImpl
implements CharTable {
    private static final CharSequenceHashingStrategy HASHER = new CharSequenceHashingStrategy();
    private static final OpenTHashSet<CharSequence> STATIC_ENTRIES = CharTableImpl.newStaticSet();
    private final OpenTHashSet<CharSequence> entries = new OpenTHashSet<CharSequence>(10, 0.9f, HASHER);

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public CharSequence intern(@NotNull CharSequence text) {
        CharSequence charSequence;
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/CharTableImpl.intern must not be null");
        }
        if (text.length() > 40) {
            charSequence = CharTableImpl.createSequence(text);
            if (charSequence == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/CharTableImpl.intern must not return null");
            return charSequence;
        }
        charSequence = this.doIntern(text);
        if (charSequence != null) return charSequence;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/CharTableImpl.intern must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public CharSequence doIntern(@NotNull CharSequence text) {
        String string;
        CharSequence charSequence;
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/CharTableImpl.doIntern must not be null");
        }
        CharSequence interned = CharTableImpl.getStaticInterned(((Object)text).toString());
        if (interned != null) {
            charSequence = interned;
            if (charSequence == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/CharTableImpl.doIntern must not return null");
            return charSequence;
        }
        OpenTHashSet<CharSequence> openTHashSet = this.entries;
        synchronized (openTHashSet) {
            interned = this.entries.get(text);
            if (interned != null) {
                CharSequence charSequence2 = interned;
                // MONITOREXIT @DISABLED, blocks:[2, 10] lbl13 : MonitorExitStatement: MONITOREXIT : var3_3
                charSequence = charSequence2;
                if (charSequence2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/CharTableImpl.doIntern must not return null");
                return charSequence;
            }
            String entry = CharTableImpl.createSequence(text);
            boolean added = this.entries.add(entry);
            assert (added);
            string = entry;
        }
        charSequence = string;
        if (string != null) return charSequence;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/CharTableImpl.doIntern must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public CharSequence intern(@NotNull CharSequence baseText, int startOffset, int endOffset) {
        CharSequence charSequence;
        if (baseText == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/CharTableImpl.intern must not be null");
        }
        if (endOffset - startOffset == baseText.length()) {
            charSequence = baseText;
            if (charSequence == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/CharTableImpl.intern must not return null");
            return charSequence;
        }
        charSequence = this.intern(new CharSequenceSubSequence(baseText, startOffset, endOffset));
        if (charSequence != null) return charSequence;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/CharTableImpl.intern must not return null");
    }

    @NotNull
    private static String createSequence(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/CharTableImpl.createSequence must not be null");
        }
        char[] buf = new char[text.length()];
        CharArrayUtil.getChars(text, buf, 0);
        String string = StringFactory.createShared(buf);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/CharTableImpl.createSequence must not return null");
        }
        return string;
    }

    @Nullable
    public static CharSequence getStaticInterned(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/CharTableImpl.getStaticInterned must not be null");
        }
        return STATIC_ENTRIES.get(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void staticIntern(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/CharTableImpl.staticIntern must not be null");
        }
        OpenTHashSet<CharSequence> openTHashSet = STATIC_ENTRIES;
        synchronized (openTHashSet) {
            STATIC_ENTRIES.add(text);
        }
    }

    private static OpenTHashSet<CharSequence> newStaticSet() {
        OpenTHashSet<CharSequence> r = new OpenTHashSet<CharSequence>(10, 0.9f, HASHER);
        r.add("==");
        r.add("!=");
        r.add("||");
        r.add("++");
        r.add("--");
        r.add("<");
        r.add("<=");
        r.add("<<=");
        r.add("<<");
        r.add(">");
        r.add("&");
        r.add("&&");
        r.add("+=");
        r.add("-=");
        r.add("*=");
        r.add("/=");
        r.add("&=");
        r.add("|=");
        r.add("^=");
        r.add("%=");
        r.add("(");
        r.add(")");
        r.add("{");
        r.add("}");
        r.add("[");
        r.add("]");
        r.add(";");
        r.add(",");
        r.add("...");
        r.add(".");
        r.add("=");
        r.add("!");
        r.add("~");
        r.add("?");
        r.add(":");
        r.add("+");
        r.add("-");
        r.add("*");
        r.add("/");
        r.add("|");
        r.add("^");
        r.add("%");
        r.add("@");
        r.add(" ");
        r.add("  ");
        r.add("   ");
        r.add("    ");
        r.add("     ");
        r.add("      ");
        r.add("       ");
        r.add("        ");
        r.add("         ");
        r.add("          ");
        r.add("           ");
        r.add("            ");
        r.add("             ");
        r.add("              ");
        r.add("               ");
        r.add("\n");
        r.add("\n  ");
        r.add("\n    ");
        r.add("\n      ");
        r.add("\n        ");
        r.add("\n          ");
        r.add("\n            ");
        r.add("\n              ");
        r.add("\n                ");
        r.add("<");
        r.add(">");
        r.add("</");
        r.add("/>");
        r.add("\"");
        r.add("'");
        r.add("<![CDATA[");
        r.add("]]>");
        r.add("<!--");
        r.add("-->");
        r.add("<!DOCTYPE");
        r.add("SYSTEM");
        r.add("PUBLIC");
        r.add("<?");
        r.add("?>");
        r.add("<%");
        r.add("%>");
        r.add("<%=");
        r.add("<%@");
        r.add("${");
        r.add("");
        return r;
    }

    public static void addStringsFromClassToStatics(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/CharTableImpl.addStringsFromClassToStatics must not be null");
        }
        for (Field field : aClass.getDeclaredFields()) {
            String typeName;
            if ((field.getModifiers() & 8) == 0 || (field.getModifiers() & 1) == 0) continue;
            try {
                typeName = (String)field.get(null);
            }
            catch (Exception e) {
                continue;
            }
            CharTableImpl.staticIntern(typeName);
        }
    }

    static {
        CharTableImpl.addStringsFromClassToStatics(CommonClassNames.class);
    }
}

