/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.smartPointers.ClsElementInfo;
import com.intellij.psi.impl.smartPointers.DirElementInfo;
import com.intellij.psi.impl.smartPointers.FileElementInfo;
import com.intellij.psi.impl.smartPointers.HardElementInfo;
import com.intellij.psi.impl.smartPointers.InjectedSelfElementInfo;
import com.intellij.psi.impl.smartPointers.MultiRootSelfElementInfo;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfoFactory;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SmartPsiElementPointerImpl<E extends PsiElement>
implements SmartPointerEx<E> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl");
    private Reference<E> myElement;
    private final SmartPointerElementInfo myElementInfo;
    private final Class<? extends PsiElement> myElementClass;

    public SmartPsiElementPointerImpl(@NotNull Project project, @NotNull E element, @Nullable PsiFile containingFile) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.<init> must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.<init> must not be null");
        }
        this(element, SmartPsiElementPointerImpl.createElementInfo(project, element, containingFile), element.getClass());
    }

    public SmartPsiElementPointerImpl(@NotNull E element, @NotNull SmartPointerElementInfo elementInfo, @NotNull Class<? extends PsiElement> elementClass) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.<init> must not be null");
        }
        if (elementInfo == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.<init> must not be null");
        }
        if (elementClass == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.<init> must not be null");
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.cacheElement(element);
        this.myElementClass = elementClass;
        this.myElementInfo = elementInfo;
    }

    public boolean equals(Object obj) {
        return obj instanceof SmartPsiElementPointer && SmartPsiElementPointerImpl.pointsToTheSameElementAs(this, (SmartPsiElementPointer)obj);
    }

    public int hashCode() {
        return this.myElementInfo.elementHashCode();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myElementInfo.getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.getProject must not return null");
        }
        return project;
    }

    @Override
    @Nullable
    public E getElement() {
        Object element = this.getCachedElement();
        if (element != null && !element.isValid()) {
            element = null;
        }
        if (element == null) {
            element = this.myElementInfo.restoreElement();
            if (!(element == null || element.getClass().equals(this.myElementClass) && element.isValid())) {
                element = null;
            }
            this.cacheElement(element);
        }
        return element;
    }

    private void cacheElement(E element) {
        this.myElement = element == null ? null : new SoftReference<E>(element);
    }

    public E getCachedElement() {
        Reference<E> ref = this.myElement;
        return (E)(ref == null ? null : (PsiElement)ref.get());
    }

    @Override
    public PsiFile getContainingFile() {
        PsiFile psiFile;
        VirtualFile virtualFile = this.myElementInfo.getVirtualFile();
        if (virtualFile != null && virtualFile.isValid() && (psiFile = PsiManager.getInstance(this.getProject()).findFile(virtualFile)) != null) {
            return psiFile;
        }
        Document doc = this.myElementInfo.getDocumentToSynchronize();
        if (doc == null) {
            E resolved = this.getElement();
            return resolved != null ? resolved.getContainingFile() : null;
        }
        return PsiDocumentManager.getInstance(this.getProject()).getPsiFile(doc);
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myElementInfo.getVirtualFile();
    }

    @Override
    public Segment getRange() {
        return this.myElementInfo.getRange();
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    @NotNull
    private static <E extends PsiElement> SmartPointerElementInfo createElementInfo(@NotNull Project project, @NotNull E element, PsiFile containingFile) {
        boolean isElementInMainRoot;
        PsiLanguageInjectionHost hostContext;
        SmartPointerElementInfo smartPointerElementInfo;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.createElementInfo must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.createElementInfo must not be null");
        }
        if (element instanceof PsiCompiledElement || containingFile == null || !containingFile.isPhysical() || !element.isPhysical()) {
            if (element instanceof StubBasedPsiElement && element instanceof PsiCompiledElement) {
                if (element instanceof PsiFile) {
                    FileElementInfo fileElementInfo = new FileElementInfo((PsiFile)element);
                    smartPointerElementInfo = fileElementInfo;
                    if (fileElementInfo != null) return smartPointerElementInfo;
                    throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.createElementInfo must not return null");
                }
                PsiAnchor.StubIndexReference stubReference = PsiAnchor.createStubReference(element, containingFile);
                if (stubReference != null) {
                    ClsElementInfo clsElementInfo = new ClsElementInfo(stubReference);
                    smartPointerElementInfo = clsElementInfo;
                    if (clsElementInfo == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.createElementInfo must not return null");
                    return smartPointerElementInfo;
                }
            }
            HardElementInfo hardElementInfo = new HardElementInfo(project, element);
            smartPointerElementInfo = hardElementInfo;
            if (hardElementInfo == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.createElementInfo must not return null");
            return smartPointerElementInfo;
        }
        if (element instanceof PsiDirectory) {
            DirElementInfo dirElementInfo = new DirElementInfo((PsiDirectory)element);
            smartPointerElementInfo = dirElementInfo;
            if (dirElementInfo == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.createElementInfo must not return null");
            return smartPointerElementInfo;
        }
        for (SmartPointerElementInfoFactory factory : Extensions.getExtensions(SmartPointerElementInfoFactory.EP_NAME)) {
            SmartPointerElementInfo result = factory.createElementInfo(element);
            if (result == null) continue;
            SmartPointerElementInfo smartPointerElementInfo = result;
            smartPointerElementInfo = smartPointerElementInfo;
            if (smartPointerElementInfo2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.createElementInfo must not return null");
            return smartPointerElementInfo;
        }
        FileViewProvider viewProvider = containingFile.getViewProvider();
        if (viewProvider instanceof FreeThreadedFileViewProvider && (hostContext = InjectedLanguageManager.getInstance(containingFile.getProject()).getInjectionHost(containingFile)) != null) {
            InjectedSelfElementInfo injectedSelfElementInfo = new InjectedSelfElementInfo(project, element, hostContext);
            smartPointerElementInfo = injectedSelfElementInfo;
            if (injectedSelfElementInfo == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.createElementInfo must not return null");
            return smartPointerElementInfo;
        }
        if (element instanceof PsiFile) {
            FileElementInfo fileElementInfo = new FileElementInfo((PsiFile)element);
            smartPointerElementInfo = fileElementInfo;
            if (fileElementInfo == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.createElementInfo must not return null");
            return smartPointerElementInfo;
        }
        TextRange elementRange = element.getTextRange();
        if (elementRange == null) {
            HardElementInfo hardElementInfo = new HardElementInfo(project, element);
            smartPointerElementInfo = hardElementInfo;
            if (hardElementInfo == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.createElementInfo must not return null");
            return smartPointerElementInfo;
        }
        ProperTextRange proper = ProperTextRange.create(elementRange);
        LOG.assertTrue(element.isPhysical());
        LOG.assertTrue(element.isValid());
        boolean isMultiRoot = viewProvider.getAllFiles().size() > 1;
        VirtualFile virtualFile = containingFile.getVirtualFile();
        boolean bl = isElementInMainRoot = virtualFile == null || containingFile.getManager().findFile(virtualFile) == containingFile;
        if (isMultiRoot && !isElementInMainRoot) {
            MultiRootSelfElementInfo multiRootSelfElementInfo = new MultiRootSelfElementInfo(project, proper, element.getClass(), containingFile, containingFile.getLanguage());
            smartPointerElementInfo = multiRootSelfElementInfo;
            if (multiRootSelfElementInfo == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.createElementInfo must not return null");
            return smartPointerElementInfo;
        }
        SelfElementInfo selfElementInfo = new SelfElementInfo(project, proper, element.getClass(), containingFile, containingFile.getLanguage());
        smartPointerElementInfo = selfElementInfo;
        if (selfElementInfo == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.createElementInfo must not return null");
        return smartPointerElementInfo;
    }

    @Override
    public void unfastenBelt(int offset) {
        this.myElementInfo.unfastenBelt(offset);
    }

    @Override
    public void fastenBelt(int offset, @Nullable RangeMarker[] cachedRangeMarkers) {
        this.myElementInfo.fastenBelt(offset, cachedRangeMarkers);
    }

    @NotNull
    public SmartPointerElementInfo getElementInfo() {
        SmartPointerElementInfo smartPointerElementInfo = this.myElementInfo;
        if (smartPointerElementInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.getElementInfo must not return null");
        }
        return smartPointerElementInfo;
    }

    protected static boolean pointsToTheSameElementAs(@NotNull SmartPsiElementPointer pointer1, @NotNull SmartPsiElementPointer pointer2) {
        if (pointer1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.pointsToTheSameElementAs must not be null");
        }
        if (pointer2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl.pointsToTheSameElementAs must not be null");
        }
        if (pointer1 == pointer2) {
            return true;
        }
        if (pointer1 instanceof SmartPsiElementPointerImpl && pointer2 instanceof SmartPsiElementPointerImpl) {
            SmartPointerElementInfo elementInfo2;
            SmartPsiElementPointerImpl impl1 = (SmartPsiElementPointerImpl)pointer1;
            SmartPsiElementPointerImpl impl2 = (SmartPsiElementPointerImpl)pointer2;
            SmartPointerElementInfo elementInfo1 = impl1.getElementInfo();
            if (!elementInfo1.pointsToTheSameElementAs(elementInfo2 = impl2.getElementInfo())) {
                return false;
            }
            Object cachedElement1 = impl1.getCachedElement();
            Object cachedElement2 = impl2.getCachedElement();
            return cachedElement1 == null || cachedElement2 == null || cachedElement1 == cachedElement2;
        }
        return Comparing.equal(pointer1.getElement(), pointer2.getElement());
    }
}

