/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.psi.impl.smartPointers.SmartPsiFileRangePointerImpl;
import com.intellij.psi.impl.source.tree.MarkersHolderFileViewProvider;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.UnsafeWeakList;
import java.lang.ref.Reference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartPointerManagerImpl
extends SmartPointerManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl");
    private static final Key<List<SmartPointerEx>> SMART_POINTERS_IN_PSI_FILE_KEY = Key.create("SMART_POINTERS_IN_PSI_FILE_KEY");
    private static final Key<Boolean> BELTS_ARE_FASTEN_KEY = Key.create("BELTS_ARE_FASTEN_KEY");
    private final Project myProject;
    private final Object lock = new Object();
    private static final Key<Reference<SmartPsiElementPointer>> CACHED_SMART_POINTER_KEY = Key.create("CACHED_SMART_POINTER_KEY");

    public SmartPointerManagerImpl(Project project) {
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fastenBelts(@NotNull PsiFile file, int offset, @Nullable RangeMarker[] cachedRangeMarkers) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.fastenBelts must not be null");
        }
        Object object = this.lock;
        synchronized (object) {
            if (SmartPointerManagerImpl.areBeltsFastened(file)) {
                return;
            }
            file.putUserData(BELTS_ARE_FASTEN_KEY, Boolean.TRUE);
            List<SmartPointerEx> pointers = SmartPointerManagerImpl.getPointers(file);
            if (pointers == null) {
                return;
            }
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(file.getProject());
            for (int i = 0; i < pointers.size(); ++i) {
                SmartPointerEx pointer = pointers.get(i);
                if (pointer == null) continue;
                pointer.fastenBelt(offset, cachedRangeMarkers);
            }
            for (DocumentWindow injectedDoc : InjectedLanguageManager.getInstance(this.myProject).getCachedInjectedDocuments(file)) {
                PsiFile injectedFile = psiDocumentManager.getPsiFile(injectedDoc);
                if (injectedFile == null) continue;
                RangeMarker[] cachedMarkers = SmartPointerManagerImpl.getCachedRangeMarkerToInjectedFragment(injectedFile);
                this.fastenBelts(injectedFile, 0, cachedMarkers);
            }
        }
    }

    @NotNull
    private static RangeMarker[] getCachedRangeMarkerToInjectedFragment(@NotNull PsiFile injectedFile) {
        if (injectedFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.getCachedRangeMarkerToInjectedFragment must not be null");
        }
        MarkersHolderFileViewProvider provider = (MarkersHolderFileViewProvider)((Object)injectedFile.getViewProvider());
        RangeMarker[] rangeMarkerArray = provider.getCachedMarkers();
        if (rangeMarkerArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.getCachedRangeMarkerToInjectedFragment must not return null");
        }
        return rangeMarkerArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unfastenBelts(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.unfastenBelts must not be null");
        }
        Object object = this.lock;
        synchronized (object) {
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(file.getProject());
            file.putUserData(BELTS_ARE_FASTEN_KEY, null);
            List<SmartPointerEx> pointers = SmartPointerManagerImpl.getPointers(file);
            if (pointers == null) {
                return;
            }
            for (int i = 0; i < pointers.size(); ++i) {
                SmartPointerEx pointer = pointers.get(i);
                if (pointer == null) continue;
                pointer.unfastenBelt(offset);
            }
            for (DocumentWindow injectedDoc : InjectedLanguageManager.getInstance(this.myProject).getCachedInjectedDocuments(file)) {
                PsiFile injectedFile = psiDocumentManager.getPsiFile(injectedDoc);
                if (injectedFile == null) continue;
                this.unfastenBelts(injectedFile, 0);
            }
        }
    }

    @Override
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.createSmartPsiElementPointer must not be null");
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile containingFile = element.getContainingFile();
        SmartPsiElementPointer<E> smartPsiElementPointer = this.createSmartPsiElementPointer(element, containingFile);
        if (smartPsiElementPointer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.createSmartPsiElementPointer must not return null");
        }
        return smartPsiElementPointer;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public <E extends PsiElement> SmartPsiElementPointer<E> createSmartPsiElementPointer(@NotNull E element, PsiFile containingFile) {
        SmartPsiElementPointer<E> smartPsiElementPointer;
        SmartPsiElementPointer<E> cachedPointer;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.createSmartPsiElementPointer must not be null");
        }
        if (containingFile != null && !containingFile.isValid() || containingFile == null && !element.isValid()) {
            LOG.error("Invalid element:" + element);
        }
        if ((cachedPointer = SmartPointerManagerImpl.getCachedPointer(element)) != null) {
            smartPsiElementPointer = cachedPointer;
            if (smartPsiElementPointer == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.createSmartPsiElementPointer must not return null");
            return smartPsiElementPointer;
        }
        SmartPsiElementPointerImpl<E> pointer = new SmartPsiElementPointerImpl<E>(this.myProject, element, containingFile);
        this.initPointer(pointer, containingFile);
        element.putUserData(CACHED_SMART_POINTER_KEY, new SoftReference<SmartPsiElementPointerImpl<E>>(pointer));
        smartPsiElementPointer = pointer;
        if (smartPsiElementPointer != null) return smartPsiElementPointer;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.createSmartPsiElementPointer must not return null");
    }

    private static <E extends PsiElement> SmartPsiElementPointer<E> getCachedPointer(@NotNull E element) {
        PsiElement cachedElement;
        SmartPsiElementPointer cachedPointer;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.getCachedPointer must not be null");
        }
        Reference<SmartPsiElementPointer> data = element.getUserData(CACHED_SMART_POINTER_KEY);
        SmartPsiElementPointer smartPsiElementPointer = cachedPointer = data == null ? null : data.get();
        if (cachedPointer instanceof SmartPointerEx && (cachedElement = ((SmartPointerEx)cachedPointer).getCachedElement()) != null && cachedElement != element) {
            return null;
        }
        return cachedPointer;
    }

    @Override
    @NotNull
    public SmartPsiFileRange createSmartPsiFileRangePointer(@NotNull PsiFile file, @NotNull TextRange range) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.createSmartPsiFileRangePointer must not be null");
        }
        if (range == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.createSmartPsiFileRangePointer must not be null");
        }
        if (!file.isValid()) {
            LOG.error("Invalid element:" + file);
        }
        SmartPsiFileRangePointerImpl pointer = new SmartPsiFileRangePointerImpl(file, ProperTextRange.create(range));
        this.initPointer(pointer, file);
        SmartPsiFileRangePointerImpl smartPsiFileRangePointerImpl = pointer;
        if (smartPsiFileRangePointerImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.createSmartPsiFileRangePointer must not return null");
        }
        return smartPsiFileRangePointerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends PsiElement> void initPointer(@NotNull SmartPointerEx<E> pointer, PsiFile containingFile) {
        if (pointer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.initPointer must not be null");
        }
        if (containingFile == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            List<SmartPointerEx> pointers = SmartPointerManagerImpl.getPointers(containingFile);
            if (pointers == null) {
                pointers = new UnsafeWeakList<SmartPointerEx>();
                containingFile.putUserData(SMART_POINTERS_IN_PSI_FILE_KEY, pointers);
            }
            pointers.add(pointer);
            if (SmartPointerManagerImpl.areBeltsFastened(containingFile)) {
                pointer.fastenBelt(0, null);
            }
        }
    }

    private static List<SmartPointerEx> getPointers(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.getPointers must not be null");
        }
        return containingFile.getUserData(SMART_POINTERS_IN_PSI_FILE_KEY);
    }

    public int getPointersNumber(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.getPointersNumber must not be null");
        }
        List<SmartPointerEx> pointers = SmartPointerManagerImpl.getPointers(containingFile);
        return pointers == null ? 0 : pointers.size();
    }

    private static boolean areBeltsFastened(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.areBeltsFastened must not be null");
        }
        return file.getUserData(BELTS_ARE_FASTEN_KEY) == Boolean.TRUE;
    }

    @Override
    public boolean pointToTheSameElement(@NotNull SmartPsiElementPointer pointer1, @NotNull SmartPsiElementPointer pointer2) {
        if (pointer1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.pointToTheSameElement must not be null");
        }
        if (pointer2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartPointerManagerImpl.pointToTheSameElement must not be null");
        }
        return SmartPsiElementPointerImpl.pointsToTheSameElementAs(pointer1, pointer2);
    }
}

